/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.task.util.UserUtil;

@Deprecated
public class InvoiceMaintainUtil {
    private static final String FIELD_INVOICEMAINTAIN_SELECTED = "billno,taskbill,imagenumber,number,name,status,creator,enable,createtime,systemorignal,invoiceno,invoicecode,errorcode,errordescno,modifytime,failcount";
    private static final String FIELD_IMAGEQUEUE_SELECTED = "billid,imagenumber,state,creatime,imageseq";
    private static final Log log = LogFactory.getLog(InvoiceMaintainUtil.class);

    public static boolean saveInvoiceMaintain(String systemorignal, String billid, String invoiceno, String invoicecode, String imagenumber, String errorcode) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HHmmssSSS");
            Date currentDate = new Date();
            String number = formatter.format(currentDate);
            DynamicObject invoiceMaintain = InvoiceMaintainUtil.queryInvoiceMaintain(systemorignal, billid, imagenumber);
            if (invoiceMaintain == null) {
                invoiceMaintain = BusinessDataServiceHelper.newDynamicObject((String)"task_invoicemaintain");
                Object creator = UserUtil.getUserID();
                DynamicObject billMap = InvoiceMaintainUtil.getBillNoFromBillImageMap(billid, imagenumber);
                String billno = billMap.getString("billnumber");
                invoiceMaintain.set("billid", (Object)Long.parseLong(billid));
                invoiceMaintain.set("billno", (Object)billno);
                invoiceMaintain.set("imagenumber", (Object)imagenumber);
                invoiceMaintain.set("number", (Object)number);
                invoiceMaintain.set("name", (Object)number);
                invoiceMaintain.set("status", (Object)"C");
                invoiceMaintain.set("creator", creator);
                invoiceMaintain.set("enable", (Object)1);
                invoiceMaintain.set("createtime", (Object)currentDate);
                invoiceMaintain.set("failcount", (Object)1);
            } else {
                int failcount = invoiceMaintain.getInt("failcount");
                invoiceMaintain.set("failcount", (Object)(failcount + 1));
            }
            invoiceMaintain.set("systemorignal", (Object)systemorignal);
            invoiceMaintain.set("invoiceno", (Object)invoiceno);
            invoiceMaintain.set("invoicecode", (Object)invoicecode);
            invoiceMaintain.set("errorcode", (Object)errorcode);
            invoiceMaintain.set("errordescno", (Object)errorcode);
            invoiceMaintain.set("modifytime", (Object)currentDate);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoiceMaintain});
            return true;
        }
        catch (Exception e) {
            log.error("kd.ssc.task.util.InvoiceMaintainUtil:\u65b0\u589e\u53d1\u7968\u7ef4\u62a4\u8bb0\u5f55\u51fa\u9519", (Throwable)e);
            return false;
        }
    }

    public static DynamicObject queryInvoiceMaintain(Object id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"task_invoicemaintain");
    }

    public static DynamicObject[] queryInvoiceMaintainCol(Object[] pkArray) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"task_invoicemaintain");
        return BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)type);
    }

    public static DynamicObject queryInvoiceMaintain(String systemorignal, String billid, String imagenumber) {
        QFilter filterSysOrignal = new QFilter("systemorignal", "=", (Object)systemorignal);
        QFilter filterBillNo = new QFilter("billid", "=", (Object)Long.parseLong(billid));
        QFilter filterImageNumber = new QFilter("imagenumber", "=", (Object)imagenumber);
        return BusinessDataServiceHelper.loadSingle((String)"task_invoicemaintain", (String)FIELD_INVOICEMAINTAIN_SELECTED, (QFilter[])new QFilter[]{filterSysOrignal, filterBillNo, filterImageNumber});
    }

    public static boolean deleteInvoiceMaintain(String systemorignal, String billid, String imagenumber) {
        QFilter filterSysOrignal = new QFilter("systemorignal", "=", (Object)systemorignal);
        QFilter filterBillNo = new QFilter("billid", "=", (Object)Long.parseLong(billid));
        QFilter filterImageNumber = new QFilter("imagenumber", "=", (Object)imagenumber);
        int ret = DeleteServiceHelper.delete((String)"task_invoicemaintain", (QFilter[])new QFilter[]{filterSysOrignal, filterBillNo, filterImageNumber});
        return ret > 0;
    }

    public static boolean saveImageQueue(String billId, String imagenumber, String state) {
        QFilter filterImage = new QFilter("imagenumber", "=", (Object)imagenumber);
        DynamicObject imageQueue = BusinessDataServiceHelper.loadSingle((String)"task_imagequeue", (String)FIELD_IMAGEQUEUE_SELECTED, (QFilter[])new QFilter[]{filterImage});
        Object[] ret = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{imageQueue = InvoiceMaintainUtil.createImageQueue(billId, imagenumber, imageQueue)});
        return ret != null && ret.length > 0;
    }

    public static DynamicObject[] saveImageQueueBatch(DynamicObject[] invoiceMaintainArr) {
        if (invoiceMaintainArr == null || invoiceMaintainArr.length == 0) {
            return null;
        }
        String billId = null;
        String imagenumber = null;
        DynamicObject imageQueue = null;
        QFilter filterImage = null;
        ArrayList<DynamicObject> imageList = new ArrayList<DynamicObject>(10);
        for (DynamicObject item : invoiceMaintainArr) {
            billId = item.getString("billid");
            imagenumber = item.getString("imagenumber");
            filterImage = new QFilter("imagenumber", "=", (Object)imagenumber);
            imageQueue = BusinessDataServiceHelper.loadSingle((String)"task_imagequeue", (String)FIELD_IMAGEQUEUE_SELECTED, (QFilter[])new QFilter[]{filterImage});
            imageQueue = InvoiceMaintainUtil.createImageQueue(billId, imagenumber, imageQueue);
            imageList.add(imageQueue);
        }
        DynamicObject[] imageArray = new DynamicObject[imageList.size()];
        imageList.toArray(imageArray);
        DynamicObject[] ret = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])imageArray);
        return ret;
    }

    private static DynamicObject createImageQueue(String billId, String imagenumber, DynamicObject imageQueue) {
        if (imageQueue == null) {
            imageQueue = BusinessDataServiceHelper.newDynamicObject((String)"task_imagequeue");
            imageQueue.set("billid", (Object)billId);
            imageQueue.set("imagenumber", (Object)imagenumber);
            imageQueue.set("state", (Object)"recognizing");
            imageQueue.set("creatime", (Object)new Date());
        } else {
            imageQueue.set("state", (Object)"recognizing");
        }
        return imageQueue;
    }

    public static DynamicObject getBillNoFromBillImageMap(String billId, String imagenumber) {
        QFilter filterBillId = new QFilter("billid", "=", (Object)billId);
        QFilter filterImageNumber = new QFilter("imagenumber", "=", (Object)imagenumber);
        DynamicObject billMap = BusinessDataServiceHelper.loadSingle((String)"task_billimagemap", (String)"id,billnumber,billtype", (QFilter[])new QFilter[]{filterBillId, filterImageNumber});
        return billMap;
    }
}

