/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.ssc.task.dto.SynBailedOrgDTO;
import kd.ssc.task.util.BizBillValidateUtil;

public class OrganizationSynchronizeUtil {
    private static final Log log = LogFactory.getLog(OrganizationSynchronizeUtil.class);
    private Map<Long, List<Long>> bizBillOrgMap;
    private List<SynBailedOrgDTO> synBailedDtos;

    public OrganizationSynchronizeUtil() {
        this.synBailedDtos = new ArrayList<SynBailedOrgDTO>();
        this.bizBillOrgMap = new HashMap<Long, List<Long>>(16);
    }

    public OrganizationSynchronizeUtil(List<SynBailedOrgDTO> synBailedDtos) {
        if (synBailedDtos == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\u503c\u3002", (String)"OrganizationSynchronizeUtil_14", (String)"ssc-task-common", (Object[])new Object[0]));
        }
        this.synBailedDtos = synBailedDtos;
        this.bizBillOrgMap = this.dataPrepared(synBailedDtos);
    }

    public int synBailedOrganizationForList() {
        int successDataSize = 0;
        if (this.synBailedDtos.isEmpty()) {
            return successDataSize;
        }
        try {
            Map<Long, String> failedMap = this.dataValidate();
            Set<Long> failedKeySet = failedMap.keySet();
            List<DynamicObject> successData = this.constructBizDataWithBailedOrg(failedKeySet);
            List<DynamicObject> logData = this.getAllLogInfo(failedMap);
            try (TXHandle h = TX.required((String)(this.getClass().getName() + "synBailedOrganizationForList"));){
                try {
                    SaveServiceHelper.save((DynamicObject[])successData.toArray(new DynamicObject[0]));
                    SaveServiceHelper.save((DynamicObject[])logData.toArray(new DynamicObject[0]));
                }
                catch (Exception e) {
                    h.markRollback();
                    throw e;
                }
            }
            successDataSize = successData.size();
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u5355\u636e\u6279\u91cf\u540c\u6b65\u9002\u7528\u7ec4\u7ec7\u5931\u8d25\uff0c\u672c\u6b21\u540c\u6b65\u6570\u636eId\uff1a" + this.synBailedDtos.stream().map(SynBailedOrgDTO::getBizBillId).collect(Collectors.toList()), (Throwable)e);
        }
        return successDataSize;
    }

    public int synBailedOrganizationWithoutValidate() {
        int successDataSize = 0;
        if (this.synBailedDtos.isEmpty()) {
            return successDataSize;
        }
        try {
            List<DynamicObject> successData = this.constructBizDataWithBailedOrg(new HashSet<Long>(0));
            List<DynamicObject> logData = this.getAllLogInfo(new HashMap<Long, String>());
            try (TXHandle h = TX.required((String)(this.getClass().getName() + "synBailedOrganizationWithoutValidate"));){
                try {
                    SaveServiceHelper.save((DynamicObject[])successData.toArray(new DynamicObject[0]));
                    SaveServiceHelper.save((DynamicObject[])logData.toArray(new DynamicObject[0]));
                }
                catch (Exception e) {
                    h.markRollback();
                    throw e;
                }
            }
            successDataSize = successData.size();
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u5355\u636e\u6279\u91cf\u540c\u6b65\u9002\u7528\u7ec4\u7ec7\u5931\u8d25\uff0c\u672c\u6b21\u540c\u6b65\u6570\u636eId\uff1a" + this.synBailedDtos.stream().map(SynBailedOrgDTO::getBizBillId).collect(Collectors.toList()), (Throwable)e);
        }
        return successDataSize;
    }

    private Map<Long, List<Long>> dataPrepared(List<SynBailedOrgDTO> synBailedDtos) {
        HashMap<Long, List<Long>> bizBillOrgMap = new HashMap<Long, List<Long>>(synBailedDtos.size());
        HashMap<Long, List> orgEntrustMap = new HashMap<Long, List>(16);
        for (SynBailedOrgDTO dto : synBailedDtos) {
            List bailedOrg;
            Long bizBillId = dto.getBizBillId();
            Long sscId = dto.getSscid();
            if (sscId == 0L) continue;
            if (!orgEntrustMap.containsKey(sscId)) {
                bailedOrg = this.getAllBailedOrganization(sscId);
                orgEntrustMap.put(sscId, bailedOrg);
                bizBillOrgMap.put(bizBillId, bailedOrg);
                continue;
            }
            bailedOrg = (List)orgEntrustMap.get(sscId);
            bizBillOrgMap.put(bizBillId, bailedOrg);
        }
        return bizBillOrgMap;
    }

    private List<DynamicObject> getAllLogInfo(Map<Long, String> failedMap) {
        ArrayList<DynamicObject> logData = new ArrayList<DynamicObject>(this.synBailedDtos.size());
        for (SynBailedOrgDTO dto : this.synBailedDtos) {
            Long bizBillId = dto.getBizBillId();
            Set<Long> failedIdSet = failedMap.keySet();
            if (failedIdSet.contains(bizBillId)) {
                String failedMsg = failedMap.get(bizBillId);
                this.saveSynErrorLog(dto, failedMsg);
                continue;
            }
            List<Long> bailedOrg = this.bizBillOrgMap.get(bizBillId);
            if (bailedOrg.isEmpty()) {
                this.saveSynWarnLog(dto);
                continue;
            }
            this.saveSynSuccessLog(dto);
        }
        return logData;
    }

    private List<DynamicObject> constructBizDataWithBailedOrg(Set<Long> failedKeySet) {
        ArrayList<DynamicObject> successData = new ArrayList<DynamicObject>(this.synBailedDtos.size());
        for (SynBailedOrgDTO dto : this.synBailedDtos) {
            DynamicObject update;
            List bailedOrg;
            Long bizBillId = dto.getBizBillId();
            if (failedKeySet.contains(bizBillId) || (bailedOrg = this.bizBillOrgMap.computeIfAbsent(bizBillId, k -> new ArrayList(0))).isEmpty() || (update = this.updateBizData(bizBillId, bailedOrg)) == null) continue;
            successData.add(update);
        }
        return successData;
    }

    public Map<Long, String> dataValidate() {
        HashMap<Long, String> failed = new HashMap<Long, String>(this.synBailedDtos.size());
        for (SynBailedOrgDTO eachDto : this.synBailedDtos) {
            Map.Entry<Boolean, String> validateResult = this.validate(eachDto);
            if (validateResult.getKey().booleanValue()) continue;
            failed.put(eachDto.getBizBillId(), validateResult.getValue());
        }
        return failed;
    }

    private Map.Entry<Boolean, String> validate(SynBailedOrgDTO dto) {
        Long bizBillId = dto.getBizBillId();
        Long sscid = dto.getSscid();
        String bindBill = dto.getBindBill();
        if (sscid == 0L || StringUtils.isBlank((CharSequence)bindBill)) {
            return new AbstractMap.SimpleEntry<Boolean, String>(Boolean.FALSE, this.getErrorLogCausedByData(dto));
        }
        List bailedOrg = this.bizBillOrgMap.computeIfAbsent(bizBillId, k -> new ArrayList(0));
        if (bailedOrg.isEmpty()) {
            return new AbstractMap.SimpleEntry<Boolean, String>(Boolean.TRUE, "");
        }
        return this.validateOrgUsed(bailedOrg, dto);
    }

    private String getErrorLogCausedByData(SynBailedOrgDTO dto) {
        String failedMsg = dto.getSscid() == 0L ? ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u5171\u4eab\u4e2d\u5fc3\u201d\u7f3a\u5931\uff0c\u540c\u6b65\u5931\u8d25\u3002", (String)"OrganizationSynchronizeUtil_1", (String)"ssc-task-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u6765\u6e90\u5355\u636e\u201d\u7f3a\u5931\uff0c\u540c\u6b65\u5931\u8d25\u3002", (String)"OrganizationSynchronizeUtil_2", (String)"ssc-task-common", (Object[])new Object[0]);
        return failedMsg;
    }

    private void saveSynErrorLog(SynBailedOrgDTO dto, String failedMsg) {
        this.saveSynLog(dto, false, failedMsg);
    }

    private void saveSynSuccessLog(SynBailedOrgDTO dto) {
        this.saveSynLog(dto, true, "");
    }

    private void saveSynWarnLog(SynBailedOrgDTO dto) {
        String msg = ResManager.loadKDString((String)"\u5171\u4eab\u4e2d\u5fc3\u59d4\u6258\u5173\u7cfb\u672a\u8bbe\u7f6e\uff0c\u540c\u6b65\u5931\u8d25\u3002", (String)"OrganizationSynchronizeUtil_8", (String)"ssc-task-common", (Object[])new Object[0]);
        this.saveSynLog(dto, false, msg);
    }

    private void saveSynLog(SynBailedOrgDTO dto, boolean synSuccess, String failedMsg) {
        DynamicObject opLogDyo = BusinessDataServiceHelper.newDynamicObject((String)"task_synorglog");
        Long bizBillId = dto.getBizBillId();
        Long sscid = dto.getSscid();
        opLogDyo.set("bizbill", (Object)bizBillId);
        opLogDyo.set("sscid", (Object)sscid);
        opLogDyo.set("syntime", (Object)new Date());
        if (synSuccess) {
            opLogDyo.set("synstatus", (Object)"0");
        } else {
            opLogDyo.set("synstatus", (Object)"1");
        }
        if (failedMsg.length() > 150) {
            failedMsg = failedMsg.substring(0, 150);
        }
        opLogDyo.set("failurereason", (Object)failedMsg);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{opLogDyo});
    }

    private List<Long> getAllBailedOrganization(Long sscid) {
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(sscid.longValue());
        param.setToViewType("12");
        param.setDirectViewType("fromorg");
        param.setIncludeSelf(false);
        return OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
    }

    private DynamicObject updateBizData(Long bizBillId, List<Long> bailedOrg) {
        DynamicObject bizBillDyo = null;
        try {
            bizBillDyo = BusinessDataServiceHelper.loadSingle((Object)bizBillId, (String)"task_taskbill");
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u5355\u636e\u4e0d\u5b58\u5728", (Throwable)e);
            return null;
        }
        if (bizBillDyo != null) {
            DynamicObjectCollection orgs = bizBillDyo.getDynamicObjectCollection("sscbillorgpar");
            orgs.clear();
            for (Long orgId : bailedOrg) {
                DynamicObject newOrg = orgs.addNew();
                newOrg.set("fbasedataid", (Object)orgId);
            }
            bizBillDyo.set("sscbillorgpar", (Object)orgs);
        }
        return bizBillDyo;
    }

    public Map<Long, List<Long>> getBizBillOrgMap() {
        return this.bizBillOrgMap;
    }

    public void setBizBillOrgMap(Map<Long, List<Long>> bizBillOrgMap) {
        this.bizBillOrgMap = bizBillOrgMap;
    }

    private Map.Entry<Boolean, String> validateOrgUsed(List<Long> bailedOrg, SynBailedOrgDTO dto) {
        if (bailedOrg.isEmpty()) {
            return new AbstractMap.SimpleEntry<Boolean, String>(Boolean.TRUE, "");
        }
        String bindbill = dto.getBindBill();
        Long bizBillId = dto.getBizBillId();
        Long applyCondId = dto.getAppCondId();
        return BizBillValidateUtil.validateOrgUsed(bailedOrg, bizBillId, bindbill, applyCondId);
    }
}

