/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.impl.persistence.entity.task.component.ApprovalRecordItem;
import kd.sdk.annotation.SdkDeprecated;
import kd.ssc.enums.AuditStateEnum;
import kd.ssc.task.dto.AuditRecordDTO;
import kd.ssc.task.partask.enums.InstNodeEnum;
import kd.ssc.task.partask.service.impl.ParTaskNodeServiceImpl;
import kd.ssc.task.util.TaskWorkFlowUtil;

public class ParTaskAuditMsgUpdateUtil {
    private static final Log log = LogFactory.getLog(ParTaskAuditMsgUpdateUtil.class);
    private static final String CALL_SUCCEED = "callSucceed";
    private static final String CALL_RESULT = "callResult";
    private static String COMMON_URL = "/images/pc/emotion/default_person_82_82.png";

    public static void updateNodeInfoAfterDist(DynamicObject[] distTask) {
        ParTaskAuditMsgUpdateUtil.batchUpdateNodeInfo(distTask, AuditStateEnum.INPROCESS);
        Arrays.stream(distTask).forEach(s -> TaskWorkFlowUtil.updateWfMsg(s, false));
    }

    private static void batchUpdateNodeInfo(DynamicObject[] distTask, AuditStateEnum state) {
        if (distTask == null || distTask.length == 0) {
            return;
        }
        int iniLength = distTask.length;
        HashMap<Long, DynamicObject> distTaskMap = new HashMap<Long, DynamicObject>(iniLength);
        for (DynamicObject dyo : distTask) {
            if (dyo == null) continue;
            distTaskMap.put((Long)dyo.getPkValue(), dyo);
        }
        ArrayList<DynamicObject> nodeTaskList = new ArrayList<DynamicObject>(iniLength);
        Set idset = distTaskMap.keySet();
        DynamicObject[] nodeTasks = BusinessDataServiceHelper.load((String)"task_partaskinstnode", (String)ParTaskAuditMsgUpdateUtil.getInstNodeSelectField(), (QFilter[])new QFilter[]{new QFilter("taskid", "in", idset)});
        if (nodeTasks != null) {
            ParTaskNodeServiceImpl service = new ParTaskNodeServiceImpl();
            for (DynamicObject node : nodeTasks) {
                Long taskId = node.getLong("taskid");
                DynamicObject task = (DynamicObject)distTaskMap.get(taskId);
                node = service.updateNodeInfo(node, task, state);
                nodeTaskList.add(node);
            }
        }
        if (nodeTaskList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])nodeTaskList.toArray(new DynamicObject[0]));
        }
    }

    public static void updateNodeInfoAfterDisTask(DynamicObject taskDynObj) {
        ParTaskAuditMsgUpdateUtil.updateNodeInfoAfterDisTask(Collections.singletonList(taskDynObj));
    }

    public static void updateNodeInfoAfterDisTask(List<DynamicObject> taskDyos) {
        DynamicObject[] updateRecords = ParTaskAuditMsgUpdateUtil.updateNodeInfoAfterDisTask_(taskDyos);
        if (updateRecords != null && updateRecords.length > 0) {
            SaveServiceHelper.save((DynamicObject[])updateRecords);
        }
    }

    public static DynamicObject[] updateNodeInfoAfterDisTask_(List<DynamicObject> taskDyos) {
        if (CollectionUtils.isEmpty(taskDyos)) {
            return new DynamicObject[0];
        }
        Map<Long, DynamicObject> taskDyos_ = taskDyos.stream().filter(p -> {
            try {
                return "0".equals(p.getString("billtype.createtaskmodel"));
            }
            catch (ORMDesignException e) {
                return true;
            }
        }).collect(Collectors.toMap(k -> (Long)k.getPkValue(), v -> v));
        if (taskDyos_.isEmpty()) {
            return new DynamicObject[0];
        }
        QFilter taskIdFil = new QFilter("taskid", "in", taskDyos_.keySet());
        DynamicObject[] instNodes = BusinessDataServiceHelper.load((String)"task_partaskinstnode", (String)"taskid,personid,dealdate,taskstate", (QFilter[])new QFilter[]{taskIdFil});
        Date now = new Date();
        for (DynamicObject instNode : instNodes) {
            DynamicObject taskDyo = taskDyos_.get(instNode.getLong("taskid"));
            instNode.set("personid", (Object)taskDyo.getLong("personid"));
            instNode.set("dealdate", (Object)now);
            instNode.set("taskstate", (Object)AuditStateEnum.INPROCESS.getState());
        }
        return instNodes;
    }

    public static void updateNodeInfoAfterApproval(Long taskid, Long hisId, String auditMsg, AuditStateEnum state) {
        DynamicObject[] nodeTasks = BusinessDataServiceHelper.load((String)"task_partaskinstnode", (String)"auditmsg,taskstate,dealdate", (QFilter[])new QFilter[]{new QFilter("taskid", "=", (Object)taskid)});
        ArrayList<DynamicObject> updateNodes = new ArrayList<DynamicObject>(2);
        if (nodeTasks != null) {
            for (DynamicObject node : nodeTasks) {
                node.set("auditmsg", (Object)auditMsg.substring(0, auditMsg.length() > 1020 ? 1020 : auditMsg.length()));
                node.set("taskstate", (Object)state.getState());
                node.set("dealdate", (Object)new Date());
                updateNodes.add(node);
            }
        }
        if (updateNodes.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])updateNodes.toArray(new DynamicObject[0]));
        }
    }

    @SdkDeprecated
    public static void updateNodeInfoAfterRtnBack(Long taskId, String auditMsg) {
        ParTaskAuditMsgUpdateUtil.updateNodeInfoAfterRtnBack(taskId, auditMsg, new HashMap<String, Object>(0));
    }

    public static void updateNodeInfoAfterRtnBack(Long taskId, String auditMsg, Map<String, Object> paramMap) {
        if (taskId == null || taskId <= 0L) {
            return;
        }
        ParTaskNodeServiceImpl nodeService = new ParTaskNodeServiceImpl();
        long instId = nodeService.getInstIdByTaskId(taskId);
        QFilter instIdFilter = new QFilter("instantid", "=", (Object)instId);
        QFilter nodeStateFilter = new QFilter("state", "=", (Object)InstNodeEnum.PROCESSING.getValue());
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)"task_partaskinstnode", (String)"taskid,dealdate,taskstate,auditmsg", (QFilter[])new QFilter[]{instIdFilter, nodeStateFilter});
        try (TXHandle h = TX.required((String)(ParTaskAuditMsgUpdateUtil.class + "updateNodeInfoAfterRtnBack"));){
            try {
                for (DynamicObject task : tasks) {
                    if (taskId.equals(task.getLong("taskid"))) {
                        task.set("taskstate", (Object)AuditStateEnum.RETURN.getState());
                        task.set("auditmsg", (Object)auditMsg.substring(0, auditMsg.length() > 1020 ? 1020 : auditMsg.length()));
                    } else {
                        task.set("taskstate", (Object)AuditStateEnum.CANCEL.getState());
                    }
                    task.set("dealdate", (Object)new Date());
                }
                SaveServiceHelper.save((DynamicObject[])tasks);
                DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"task_task", (String)"assignid,personid.id,tasktypeid.name");
                Long assignId = task.getLong("assignid");
                Long userId = task.getLong("personid.id");
                String subactivityName = task.getString("tasktypeid.name");
                if (StringUtils.isEmpty((CharSequence)subactivityName)) {
                    subactivityName = ResManager.loadKDString((String)"\u4e00\u7ea7\u5ba1\u6279", (String)"CreateTaskByWorkflow_1", (String)"ssc-task-common", (Object[])new Object[0]);
                }
                HashMap<Long, ILocaleString> attMap = paramMap != null ? (Map)paramMap.get("attachment") : new HashMap(0);
                TaskWorkFlowUtil.completeWfMsg(taskId, assignId, userId, AuditStateEnum.RETURN.getValue(), auditMsg, subactivityName, attMap);
            }
            catch (Exception e) {
                log.error("updateNodeInfoAfterRtnBack: \u66f4\u6539\u8282\u70b9\u5ba1\u6279\u4fe1\u606f\u5f02\u5e38\uff1a", (Throwable)e);
                h.markRollback();
            }
        }
    }

    private static String getInstNodeSelectField() {
        return "id,instantid,nodedefid,taskid,type,state,billid,workflowid,personid,createdate,dealdate,auditmsg,taskstate";
    }

    public static List<AuditRecordDTO> constructAuditRecord(Long billId, Long workflowId) throws Exception {
        ArrayList<AuditRecordDTO> auditRecords = new ArrayList<AuditRecordDTO>(4);
        if (billId == null || workflowId == null) {
            return auditRecords;
        }
        List<QFilter> filters = ParTaskAuditMsgUpdateUtil.getFilter(billId, workflowId);
        DynamicObjectCollection qryResults = QueryServiceHelper.query((String)"task_partaskinstnode", (String)ParTaskAuditMsgUpdateUtil.getSelectField(), (QFilter[])filters.toArray(new QFilter[0]), (String)ParTaskAuditMsgUpdateUtil.getOrderBy());
        if (qryResults == null || qryResults.isEmpty()) {
            return auditRecords;
        }
        for (DynamicObject dyo : qryResults) {
            AuditRecordDTO dto = ParTaskAuditMsgUpdateUtil.getAuditRecord(dyo);
            auditRecords.add(dto);
        }
        return auditRecords;
    }

    private static AuditRecordDTO getAuditRecord(DynamicObject dyo) throws Exception {
        AuditRecordDTO auditRecord = new AuditRecordDTO();
        auditRecord.setBillId(dyo.getLong("billid"));
        auditRecord.setTaskId(dyo.getLong("taskid"));
        auditRecord.setWorkflowId(dyo.getLong("workflowid"));
        auditRecord.setAuditMsg(dyo.getString("auditmsg"));
        auditRecord.setDealDate(dyo.getDate("dealdate"));
        auditRecord.setPerson(dyo.getLong("personid"));
        Long taskTypeId = (Long)dyo.get("type");
        String taskType = ParTaskAuditMsgUpdateUtil.getTaskType(taskTypeId);
        auditRecord.setTaskType(taskType);
        String taskStateId = dyo.getString("taskstate");
        String taskState = ParTaskAuditMsgUpdateUtil.getTaskState(taskStateId);
        auditRecord.setTaskState(taskState);
        return auditRecord;
    }

    private static String getTaskType(Long taskTypeId) {
        QFilter idFilter;
        DynamicObject dyo;
        String tasktype = "";
        if (taskTypeId > 0L && (dyo = QueryServiceHelper.queryOne((String)"task_tasktype", (String)"id, number, name", (QFilter[])(idFilter = new QFilter("id", "=", (Object)taskTypeId)).toArray())) != null) {
            tasktype = dyo.getString("name");
        }
        return tasktype;
    }

    private static String getTaskState(String taskState) {
        return AuditStateEnum.getValueByState(taskState);
    }

    private static List<QFilter> getFilter(Long billId, Long workflowId) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(3);
        QFilter billFilter = new QFilter("billid", "=", (Object)billId);
        QFilter wfFilter = new QFilter("workflowid", "=", (Object)workflowId);
        QFilter stateFilter = new QFilter("state", "!=", (Object)InstNodeEnum.TERMINATION.getValue());
        qFilterList.add(billFilter);
        qFilterList.add(wfFilter);
        qFilterList.add(stateFilter);
        return qFilterList;
    }

    public static void trans2ApprovalRecordItem(List<AuditRecordDTO> auditRecords, boolean hideUser, String activityId, List<IApprovalRecordItem> items) throws Exception {
        ApprovalRecordItem item = new ApprovalRecordItem();
        item.setActivityId(activityId);
        item.setActivityName(ResManager.loadKDString((String)"\u5171\u4eab\u5ba1\u6279", (String)"ParTaskAuditMsgUpdateUtil_1", (String)"ssc-task-common", (Object[])new Object[0]));
        item.setTime(ParTaskAuditMsgUpdateUtil.formatDate(auditRecords.get(auditRecords.size() - 1).getDealDate()));
        item.setNodeType("SSCApprove");
        item.setResult("");
        items.add((IApprovalRecordItem)item);
        for (AuditRecordDTO record : auditRecords) {
            IApprovalRecordItem sitem = ParTaskAuditMsgUpdateUtil.singleTrans(record, hideUser, activityId);
            items.add(sitem);
        }
    }

    private static IApprovalRecordItem singleTrans(AuditRecordDTO record, boolean hideUser, String activityId) {
        ApprovalRecordItem item = new ApprovalRecordItem();
        item.setTaskId(String.valueOf(record.getWorkflowId()));
        item.setActivityId(activityId);
        item.setNodeType("SSCApprove");
        String taskType = record.getTaskType();
        if (StringUtils.isBlank((CharSequence)taskType)) {
            throw new KDException("taskType can not empty");
        }
        item.setActivityName(taskType + " ");
        Long userId = record.getPerson();
        if (!hideUser && userId > 0L) {
            item.setCurrentUserId(String.valueOf(userId));
            DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user", (String)"id, number, name");
            String name = user.getString("name");
            String position = ParTaskAuditMsgUpdateUtil.getPosition(userId);
            item.setAssignee(name + "|" + position + " ");
            Map userAvatarPathMap = UserServiceHelper.getUserAvatarPath(Collections.singletonList(userId), (boolean)true);
            String imgURL = (String)userAvatarPathMap.get(userId);
            log.info("\u5de5\u4f5c\u6d41\u5ba1\u6279\u8bb0\u5f55\u5934\u50cfurl\uff1a" + imgURL);
            if (StringUtils.isBlank((CharSequence)imgURL)) {
                item.setAvatar(COMMON_URL);
            } else {
                item.setAvatar(imgURL);
            }
        }
        String auditMsg = record.getAuditMsg();
        item.setMessage(auditMsg);
        String taskState = record.getTaskState();
        if (StringUtils.isBlank((CharSequence)taskState)) {
            throw new KDException("Task state can not empty");
        }
        item.setResult(taskState);
        Date dealDate = record.getDealDate();
        if (dealDate == null) {
            throw new KDException("Dealing date can not empty");
        }
        String date = ParTaskAuditMsgUpdateUtil.formatDate(dealDate);
        item.setTime(date);
        return item;
    }

    private static String getPosition(Long useId) {
        ArrayList<Long> userIds = new ArrayList<Long>(1);
        userIds.add(useId);
        return ((OrmLocaleValue)((Map)((List)((Map)UserServiceHelper.getPosition(userIds).get(0)).get("entryentity")).get(0)).get("position")).getLocaleValue();
    }

    private static String formatDate(Date dealDate) {
        return new SimpleDateFormat("yyyy/MM/dd HH:mm").format(dealDate);
    }

    private static String getSelectField() {
        return "id,instantid,taskid,type,billid,workflowid,personid,dealdate,auditmsg,taskstate";
    }

    private static String getOrderBy() {
        return "createdate";
    }

    public static boolean modifyWfAuditMsg(Long billId, Long workflowId, String activityId, List<IApprovalRecordItem> items) throws Exception {
        Map<String, Object> result = ParTaskAuditMsgUpdateUtil.modifyWfAuditMsgNew(billId, workflowId, activityId);
        return (Boolean)result.getOrDefault(CALL_SUCCEED, Boolean.FALSE);
    }

    public static Map<String, Object> modifyWfAuditMsgNew(Long billId, Long workflowId, String activityId) throws Exception {
        if (billId <= 0L || workflowId <= 0L || StringUtils.isBlank((CharSequence)activityId)) {
            log.error(String.format("\u591a\u7ea7\u4efb\u52a1\u66f4\u65b0\u5ba1\u6279\u8bb0\u5f55\u51fa\u9519\uff0c\u53c2\u6570\u5f02\u5e38=>billId:%d,workflowId:%d,activityId:%s", billId, workflowId, activityId));
            throw new KDBizException(ResManager.loadKDString((String)"\u591a\u7ea7\u4efb\u52a1\u66f4\u65b0\u5ba1\u6279\u8bb0\u5f55\u51fa\u9519\uff0c\u53c2\u6570\u5f02\u5e38\u3002", (String)"ParTaskAuditMsgUpdateUtil_0", (String)"ssc-task-common", (Object[])new Object[0]));
        }
        Map<String, Object> result = ParTaskAuditMsgUpdateUtil.iniResult();
        boolean isParTask = ParTaskAuditMsgUpdateUtil.isParTask(billId, workflowId);
        if (!isParTask) {
            result.put(CALL_SUCCEED, Boolean.FALSE);
            return result;
        }
        boolean hideUser = ParTaskAuditMsgUpdateUtil.getSystemShareParamter(billId, workflowId);
        ParTaskAuditMsgUpdateUtil.modifyWfAuditMsg(billId, workflowId, hideUser, activityId, result);
        return result;
    }

    private static Map<String, Object> iniResult() {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put(CALL_SUCCEED, Boolean.FALSE);
        result.put(CALL_RESULT, new LinkedList());
        return result;
    }

    public static boolean isParTask(Long billId, Long workflowId) {
        QFilter[] qFilters = ParTaskAuditMsgUpdateUtil.getGeneralFilters(billId, workflowId);
        return QueryServiceHelper.exists((String)"task_partaskinstnode", (QFilter[])qFilters);
    }

    private static QFilter[] getGeneralFilters(Long billId, Long workflowId) {
        return new QFilter[]{new QFilter("billid", "=", (Object)billId), new QFilter("workflowid", "=", (Object)workflowId)};
    }

    private static void modifyWfAuditMsg(Long billId, Long workflowId, boolean hideUser, String activityId, Map<String, Object> result) throws Exception {
        List<AuditRecordDTO> auditRecords = ParTaskAuditMsgUpdateUtil.constructAuditRecord(billId, workflowId);
        if (auditRecords.isEmpty()) {
            result.put(CALL_SUCCEED, Boolean.FALSE);
            return;
        }
        List items = result.getOrDefault(CALL_RESULT, new LinkedList());
        ParTaskAuditMsgUpdateUtil.trans2ApprovalRecordItem(auditRecords, hideUser, activityId, items);
        result.put(CALL_SUCCEED, Boolean.TRUE);
        result.put(CALL_RESULT, items);
    }

    private static boolean getSystemShareParamter(Long billId, Long workflowId) throws Exception {
        Long sscid = ParTaskAuditMsgUpdateUtil.getSscId(billId, workflowId);
        return ParTaskAuditMsgUpdateUtil.isHideUser(sscid);
    }

    public static boolean isHideUser(Long sscid) {
        if (sscid == null || sscid <= 0L) {
            return false;
        }
        AppParam param = new AppParam("83bfebc8000020ac", "12", sscid, Long.valueOf(0L));
        Object paramValue = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)"hideuser");
        if (paramValue instanceof Boolean) {
            return (Boolean)paramValue;
        }
        return false;
    }

    private static Long getSscId(Long billId, Long workflowId) throws Exception {
        QFilter[] qFilters = ParTaskAuditMsgUpdateUtil.getGeneralFilters(billId, workflowId);
        DynamicObject node = QueryServiceHelper.queryOne((String)"task_partaskinstnode", (String)"instantid", (QFilter[])qFilters);
        if (node == null || node.get("instantid") == null) {
            throw new KDException("do not exist instance");
        }
        QFilter[] instFilters = new QFilter[]{new QFilter("id", "=", node.get("instantid"))};
        DynamicObject inst = QueryServiceHelper.queryOne((String)"task_partaskinst", (String)"sscid", (QFilter[])instFilters);
        if (inst == null || inst.get("sscid") == null) {
            throw new KDException("do not exist sscid");
        }
        return (Long)inst.get("sscid");
    }
}

