/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.util;

import java.util.Date;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sdk.annotation.SdkDeprecated;
import kd.ssc.task.domain.RecordExceptionDO;
import kd.ssc.task.util.ConverterUtil;
import kd.ssc.task.util.UUIDUtil;
import kd.ssc.task.util.UserUtil;

public class RecordExceptionUtil {
    private static final Log log = LogFactory.getLog(RecordExceptionUtil.class);
    private static final String FORM_TASKSHOWDETAIL = "task_showdetail";

    @SdkDeprecated
    public static boolean saveRecordExcept(String appid, String exceptMethod, Map<String, Object> param, String errorMsg, String errorStack) {
        try {
            String number = UUIDUtil.generateUuid();
            DynamicObject recordExcept = BusinessDataServiceHelper.newDynamicObject((String)"task_recordexcept");
            Object creator = UserUtil.getUserID();
            if (StringUtils.isNotEmpty((CharSequence)appid)) {
                appid = appid.toLowerCase();
            }
            recordExcept.set("number", (Object)number);
            recordExcept.set("status", (Object)"C");
            recordExcept.set("creator", creator);
            recordExcept.set("enable", (Object)1);
            recordExcept.set("createtime", (Object)new Date());
            recordExcept.set("appid", (Object)appid);
            recordExcept.set("exceptmethod", (Object)exceptMethod);
            recordExcept.set("exceptparam", (Object)ConverterUtil.mapConvertToString(param));
            recordExcept.set("exceptdes", (Object)errorMsg);
            recordExcept.set("exceptstack_tag", (Object)errorStack);
            Object[] ret = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recordExcept});
            if (ret != null && ret.length > 0) {
                return true;
            }
        }
        catch (Exception e) {
            log.error("kd.ssc.task.util.saveRecordExcept:\u65b0\u589e\u5f02\u5e38\u8bb0\u5f55\u51fa\u9519", (Throwable)e);
        }
        return false;
    }

    public static boolean saveRecordExcept(RecordExceptionDO recordExceptionDO) {
        try {
            String number = UUIDUtil.generateUuid();
            DynamicObject recordExcept = BusinessDataServiceHelper.newDynamicObject((String)"task_recordexcept");
            Object creator = UserUtil.getUserID();
            if (StringUtils.isNotEmpty((CharSequence)recordExceptionDO.getAppId())) {
                recordExceptionDO.setAppId(recordExceptionDO.getAppId().toLowerCase());
            }
            recordExcept.set("number", (Object)number);
            recordExcept.set("status", (Object)"C");
            recordExcept.set("creator", creator);
            recordExcept.set("enable", (Object)1);
            recordExcept.set("createtime", (Object)new Date());
            recordExcept.set("appid", (Object)recordExceptionDO.getAppId());
            recordExcept.set("exceptmethod", (Object)recordExceptionDO.getMethod());
            recordExcept.set("exceptdes", (Object)recordExceptionDO.getErrorMsg());
            recordExcept.set("exceptstack_tag", (Object)recordExceptionDO.getErrorStack());
            recordExcept.set("type", (Object)recordExceptionDO.getType());
            recordExcept.set("businessvoucher", (Object)recordExceptionDO.getVoucher());
            recordExcept.set("businessid", (Object)recordExceptionDO.getVoucherId());
            recordExcept.set("businessparam_tag", (Object)SerializationUtils.toJsonString(recordExceptionDO.getParam()));
            recordExcept.set("statuscode", (Object)recordExceptionDO.getRespCode());
            recordExcept.set("duration", (Object)recordExceptionDO.getDuration());
            recordExcept.set("ipaddress", (Object)recordExceptionDO.getIp());
            recordExcept.set("retry", (Object)(recordExceptionDO.getRetry() != null && recordExceptionDO.getRetry() != false ? 1 : 0));
            Object[] ret = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recordExcept});
            if (ret != null && ret.length > 0) {
                return true;
            }
        }
        catch (Exception e) {
            log.error("kd.ssc.task.util.saveRecordExcept:\u65b0\u589e\u5f02\u5e38\u8bb0\u5f55\u51fa\u9519", (Throwable)e);
        }
        return false;
    }

    public static void openShowDetailDialog(IFormView view, String txtTip, String messageContent) {
        FormShowParameter parameEdit = new FormShowParameter();
        parameEdit.setFormId(FORM_TASKSHOWDETAIL);
        parameEdit.getOpenStyle().setShowType(ShowType.Modal);
        parameEdit.setStatus(OperationStatus.VIEW);
        parameEdit.setCustomParam("txttip", (Object)txtTip);
        parameEdit.setCustomParam("msgcontent", (Object)RecordExceptionUtil.getSubString(messageContent, 2000));
        view.showForm(parameEdit);
    }

    public static String getSubString(String content, int length) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return "";
        }
        if (content.length() > length) {
            return StringUtils.substring((String)content, (int)0, (int)length);
        }
        return content;
    }

    public static void deleteAll(Date date) {
        try {
            DeleteServiceHelper.delete((String)"task_recordexcept", (QFilter[])new QFilter[]{RecordExceptionUtil.getTimeQFilter("createtime", date)});
            DeleteServiceHelper.delete((String)"task_exceptionplatform", (QFilter[])new QFilter[]{RecordExceptionUtil.getTimeQFilter("time", date)});
        }
        catch (Exception e) {
            log.error("kd.ssc.task.util.deleteAll:\u6e05\u9664\u6570\u636e\u51fa\u9519", (Throwable)e);
            throw e;
        }
    }

    private static QFilter getTimeQFilter(String propName, Date date) {
        return new QFilter(propName, "<", (Object)date);
    }
}

