/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class SSCBosUtil {
    private static final Log log = LogFactory.getLog((String)"SSCBosUtil");

    public static String getSscSettingInfo(String key) {
        return (String)SSCBosUtil.getSscSettingInfo(key, true);
    }

    public static Object getSscSettingInfo(String key, boolean useTaskParam) {
        OrgTreeParam orgTreeParam = new OrgTreeParam();
        orgTreeParam.setOrgViewNumber("12");
        Map rootInfoMap = OrgUnitServiceHelper.getTreeRootNodeMapById((OrgTreeParam)orgTreeParam);
        long orgId = rootInfoMap != null && rootInfoMap.get("id") != null ? (Long)rootInfoMap.get("id") : 0L;
        return SSCBosUtil.getSscSettingInfo(key, orgId, useTaskParam);
    }

    public static Object getSscSettingInfo(String key, long orgId, boolean useTaskParam) {
        Object result = null;
        if (orgId != 0L) {
            AppParam param = new AppParam("83bfebc8000020ac", "12", Long.valueOf(orgId), Long.valueOf(0L));
            result = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)key);
        }
        if (useTaskParam) {
            String settingInfo;
            String string = settingInfo = result != null ? result.toString() : null;
            if (StringUtils.isEmpty((CharSequence)settingInfo)) {
                settingInfo = SSCBosUtil.getCtrlParam(key);
            }
            result = settingInfo;
        }
        return result;
    }

    public static Set<String> queryFormDesignByNumber(List<String> numbers) {
        HashSet<String> entityMainIds = new HashSet<String>(16);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_formmeta", (String)"id", (QFilter[])new QFilter("number", "in", numbers).toArray());
        entityMainIds.addAll(dynamicObjects.stream().map(d -> d.getString("id")).collect(Collectors.toList()));
        return entityMainIds;
    }

    public static Set<String> queryFormDesignByEntity(Collection<String> entityIds) {
        HashSet<String> entityMainIds = new HashSet<String>(16);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_formmeta", (String)"id", (QFilter[])new QFilter("basedatafield", "in", entityIds).toArray());
        entityMainIds.addAll(dynamicObjects.stream().map(d -> d.getString("id")).collect(Collectors.toList()));
        return entityMainIds;
    }

    public static Set<String> queryEntityByTable(String tableName) {
        String algo = "queryEntityByTable";
        HashSet<String> entityMainIds = new HashSet<String>(16);
        try (DataSet dataSet = DB.queryDataSet((String)algo, (DBRoute)DBRoute.meta, (String)"SELECT fmainentityid FROM t_meta_entityinfo WHERE ftablename = ?;", (Object[])new Object[]{tableName});){
            for (Row row : dataSet) {
                entityMainIds.add(row.getString("fmainentityid"));
            }
        }
        return entityMainIds;
    }

    public static String getCtrlParam(String key) {
        String ctrlParam = null;
        try {
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"task_paramcontrol", (String)"paramvalue", (QFilter[])new QFilter[]{new QFilter("paramname", "=", (Object)key)});
            ctrlParam = dynamicObject.getString("paramvalue");
        }
        catch (Exception e) {
            log.error("\u53c2\u6570-" + key + "\u7684\u53c2\u6570\u503c\u4e3a\u7a7a\u3002");
        }
        return ctrlParam;
    }
}

