/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.workbill.util;

import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TreeEntryProp;

public class DataModelChangeUtil {
    public static void setBizChanged(DynamicObject dataEntity, boolean isChanged, String ... propKeys) {
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        for (String propKey : propKeys) {
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)propKey);
            if (property == null) continue;
            dataEntityState.setBizChanged(property.getOrdinal(), isChanged);
            if (!(property instanceof BasedataProp)) continue;
            property = (IDataEntityProperty)properties.get((Object)(propKey + "_id"));
            Optional.ofNullable(property).ifPresent(p -> dataEntityState.setBizChanged(p.getOrdinal(), isChanged));
        }
        List collectionProperties = properties.getCollectionProperties(false);
        for (ICollectionProperty collectionPropertie : collectionProperties) {
            if (!(collectionPropertie instanceof TreeEntryProp)) continue;
            DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection(collectionPropertie.getName());
            DataEntityPropertyCollection treeEntryProperties = entryColl.getDynamicObjectType().getProperties();
            for (String propKey : propKeys) {
                IDataEntityProperty property = (IDataEntityProperty)treeEntryProperties.get((Object)propKey);
                if (property == null) continue;
                for (DynamicObject entry : entryColl) {
                    String baseDataIdPropKey;
                    IDataEntityProperty baseDataIdProperty;
                    if (property instanceof BasedataProp && (baseDataIdProperty = (IDataEntityProperty)treeEntryProperties.get((Object)(baseDataIdPropKey = propKey + "_id"))) != null) {
                        entry.getDataEntityState().setBizChanged(baseDataIdProperty.getOrdinal(), isChanged);
                    }
                    entry.getDataEntityState().setBizChanged(property.getOrdinal(), isChanged);
                }
            }
        }
    }

    public static boolean isBizChanged(DynamicObject dataEntity) {
        IDataEntityType dt = dataEntity.getDataEntityType();
        boolean bizChanged = dataEntity.getDataEntityState().isBizChanged();
        if (bizChanged) {
            return true;
        }
        for (ICollectionProperty property : dt.getProperties().getCollectionProperties(false)) {
            Object propValue;
            if (property instanceof MulBasedataProp) {
                if (!DataModelChangeUtil.isMulBaseDataChanged(dataEntity, (MulBasedataProp)property)) break;
                bizChanged = true;
                break;
            }
            if (property instanceof LinkEntryProp || property instanceof DynamicLocaleProperty || (propValue = dataEntity.getDataStorage().getLocalValue((IDataEntityProperty)property)) == null) continue;
            DynamicObjectCollection entrys = (DynamicObjectCollection)propValue;
            for (DynamicObject item : entrys) {
                if (!DataModelChangeUtil.isBizChanged(item)) continue;
                bizChanged = true;
                break;
            }
            if (!bizChanged) continue;
            break;
        }
        return bizChanged;
    }

    private static boolean isMulBaseDataChanged(DynamicObject obj, MulBasedataProp prop) {
        Object localValue = obj.getDataStorage().getLocalValue((IDataEntityProperty)prop);
        if (localValue == null) {
            return false;
        }
        DynamicObjectCollection cols = (DynamicObjectCollection)localValue;
        boolean changed = false;
        for (DynamicObject col : cols) {
            if (!col.getDataEntityState().isBizChanged()) continue;
            changed = true;
            break;
        }
        return changed;
    }
}

