/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.workbill.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kd.bos.cache.CacheFactory;
import org.apache.commons.io.IOUtils;

public class XmlUtil {
    public static String bean2Xml(Object bean) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
        return xstream.toXML(bean);
    }

    public static <T> T xml2Bean(String xml, Class<T> clazz) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
        xstream.allowTypes(new Class[]{clazz});
        return (T)xstream.fromXML(xml);
    }

    public static String getDownloadUrl(String fileName, Object bean) {
        String xmlContent = XmlUtil.bean2Xml(bean);
        InputStream in = IOUtils.toInputStream((String)xmlContent, (Charset)StandardCharsets.UTF_8);
        return CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xml", in, 5000);
    }

    public static <T> T importXmlFile(InputStream in, Class<T> clazz) throws IOException {
        String xmlContent = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
        return XmlUtil.xml2Bean(xmlContent, clazz);
    }
}

