/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.achieve.helper;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class QueryDataHelper {
    private static final String ALGO_KEY_PRE = "ssc.achieve.QueryDataHelper";

    public static DynamicObject queryIndicatorCtrl(Long indicatorId) {
        QFilter idFilter = new QFilter("id", "=", (Object)indicatorId);
        DynamicObject indicatorObj = QueryServiceHelper.queryOne((String)"ssc_achievetarget", (String)"createorg,ctrlstrategy", (QFilter[])idFilter.toArray());
        if (indicatorObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u7ee9\u6548\u6307\u6807\u4e0d\u5b58\u5728\u3002", (String)"QueryDataHelper_0", (String)"ssc-task-business", (Object[])new Object[0]));
        }
        return indicatorObj;
    }

    public static Set<Long> queryIndicatorCtrlOrgSet(Long indicator) {
        DynamicObject indicatorObj = QueryDataHelper.queryIndicatorCtrl(indicator);
        String ctrl = indicatorObj.getString("ctrlstrategy");
        Long createOrg = indicatorObj.getLong("createorg");
        if ("7".equals(ctrl)) {
            return Collections.singleton(createOrg);
        }
        if ("5".equals(ctrl)) {
            return null;
        }
        String sql = "select fuseorgid from t_tk_achievetarget_u where fdataid = ?";
        SqlParameter parameter = new SqlParameter("fdataid", -5, (Object)indicator);
        return (Set)DB.query((DBRoute)DBRoute.of((String)"ssc"), (String)"select fuseorgid from t_tk_achievetarget_u where fdataid = ?", (Object[])new Object[]{parameter}, rs -> {
            HashSet<Long> set = new HashSet<Long>(16);
            while (rs.next()) {
                set.add(rs.getLong("fuseorgid"));
            }
            return set;
        });
    }

    public static Set<Long> queryIndicatorCtrlWorkgroupSet(Long indicator) {
        DynamicObject indicatorObj = QueryDataHelper.queryIndicatorCtrl(indicator);
        String ctrl = indicatorObj.getString("ctrlstrategy");
        Long createOrg = indicatorObj.getLong("createorg");
        if ("7".equals(ctrl)) {
            return QueryDataHelper.queryWorkgroupBySSC(createOrg);
        }
        if ("5".equals(ctrl)) {
            return null;
        }
        String sql = "SELECT fid FROM t_tk_workgroup M INNER JOIN t_tk_achievetarget_u U ON (U.fdataid = ? AND M.fcreateorgid = U.fuseorgid)";
        SqlParameter parameter = new SqlParameter("fdataid", -5, (Object)indicator);
        return (Set)DB.query((DBRoute)DBRoute.of((String)"ssc"), (String)"SELECT fid FROM t_tk_workgroup M INNER JOIN t_tk_achievetarget_u U ON (U.fdataid = ? AND M.fcreateorgid = U.fuseorgid)", (Object[])new Object[]{parameter}, rs -> {
            HashSet<Long> set = new HashSet<Long>(16);
            while (rs.next()) {
                set.add(rs.getLong("fid"));
            }
            return set;
        });
    }

    public static Set<Long> queryIndicatorCtrlUserSet(Long indicator) {
        DynamicObject indicatorObj = QueryDataHelper.queryIndicatorCtrl(indicator);
        String ctrl = indicatorObj.getString("ctrlstrategy");
        Long createOrg = indicatorObj.getLong("createorg");
        if ("7".equals(ctrl)) {
            return QueryDataHelper.querySSCUsers(createOrg);
        }
        if ("5".equals(ctrl)) {
            return QueryDataHelper.querySSCUsers(null);
        }
        String sql = "SELECT MS.fuserid userId FROM t_tk_usergroup M INNER JOIN t_tk_achievetarget_u U ON (U.fdataid = ? AND M.fcreateorgid = U.fuseorgid) INNER JOIN t_tk_usergroupentry MS ON M.fid = MS.fid";
        SqlParameter parameter = new SqlParameter("fdataid", -5, (Object)indicator);
        return (Set)DB.query((DBRoute)DBRoute.of((String)"ssc"), (String)"SELECT MS.fuserid userId FROM t_tk_usergroup M INNER JOIN t_tk_achievetarget_u U ON (U.fdataid = ? AND M.fcreateorgid = U.fuseorgid) INNER JOIN t_tk_usergroupentry MS ON M.fid = MS.fid", (Object[])new Object[]{parameter}, rs -> {
            HashSet<Long> set = new HashSet<Long>(32);
            while (rs.next()) {
                set.add(rs.getLong("userId"));
            }
            return set;
        });
    }

    public static Set<Long> queryWorkgroupBySSC(Long sscId) {
        HashSet<Long> results = new HashSet<Long>(8);
        if (sscId == null) {
            return results;
        }
        QFilter filter = new QFilter("createorg", "=", (Object)sscId).and("enable", "=", (Object)Character.valueOf('1'));
        try (DataSet ds = ORM.create().queryDataSet("ssc.achieve.QueryDataHelper.getWorkgroupBySSC", "task_workgroup", "id", filter.toArray());){
            ds.forEach(row -> results.add(row.getLong("id")));
        }
        return results;
    }

    public static Set<Long> querySSCUsers(Long sscId) {
        HashSet<Long> results = new HashSet<Long>(8);
        QFilter[] filters = new QFilter[1];
        if (sscId != null) {
            filters[0] = new QFilter("createorg", "=", (Object)sscId);
        }
        try (DataSet ds = ORM.create().queryDataSet("ssc.achieve.QueryDataHelper.getWorkgroupBySSC", "task_usergroup", "entryentity.userfield userId", filters);){
            ds.forEach(row -> results.add(row.getLong("userId")));
        }
        return results;
    }

    public static List<Long> getUserGroupByWorkgroup(List<Long> workgroupIds) {
        QFilter filter = new QFilter("id", "in", workgroupIds);
        DynamicObjectCollection taskWorkgroup = QueryServiceHelper.query((String)"task_workgroup", (String)"entryentity.usergroup", (QFilter[])filter.toArray());
        return taskWorkgroup.stream().map(d -> d.getLong("entryentity.usergroup")).collect(Collectors.toList());
    }
}

