/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.achieve.score;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.ssc.task.business.achieve.score.IScoreComputeEngine;

public class LinearInterpolationScoreCompute
implements IScoreComputeEngine {
    private LinearInterpolationScoreCompute() {
    }

    @Override
    public BigDecimal computeIndicatorScore(Long indicatorId, BigDecimal standScore, BigDecimal targetScore, BigDecimal actualScore, BigDecimal checkScore) {
        BigDecimal extStandScore = new BigDecimal("40");
        BigDecimal baseStandScore = new BigDecimal("60");
        BigDecimal score = null;
        if (standScore.compareTo(targetScore) != 0) {
            BigDecimal extRate = checkScore.subtract(standScore).divide(targetScore.subtract(standScore), 16, RoundingMode.HALF_UP);
            BigDecimal extScore = extRate.multiply(extStandScore);
            score = extScore.add(baseStandScore);
        }
        return score;
    }

    public static IScoreComputeEngine getInstance() {
        return LIScoreComputeInstance.INSTANCE;
    }

    private static class LIScoreComputeInstance {
        private static final IScoreComputeEngine INSTANCE = new LinearInterpolationScoreCompute();

        private LIScoreComputeInstance() {
        }
    }
}

