/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.board.credit;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.task.business.board.credit.CreditBoardConfigUtil;
import kd.ssc.task.util.DateUtil;
import kd.ssc.task.util.TaskParamControlUtil;

public class CreditBoardDataCalculateTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(CreditBoardDataCalculateTask.class);
    private static final String BASEINFO = CreditBoardDataCalculateTask.class + ".execute():";
    private static final String SSC_CREDITBOARDDATA = "ssc_creditboarddata";
    private static final String SSC_CREDITBOARDAVGSCORE = "ssc_creditboardavgscore";
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        this.calOrgAvgCreditScore();
        try {
            this.calCreditBoardDataSource();
        }
        catch (ParseException e) {
            log.error(BASEINFO + " cannot to parse date");
            return;
        }
    }

    private void calCreditBoardDataSource() throws ParseException {
        Date now = new Date();
        if (this.isNeedInitCreditBoardData()) {
            Date start = this.dateFormat.parse("2015-01-01 00:00:00");
            while (start.before(now)) {
                Date end = DateUtil.addDay((Date)start, (long)30L);
                this.calCreditBoardDataSource(start, end);
                start = end;
            }
            this.writeBackParamOfNeedInit();
        } else {
            int dateRange = this.getDateRange();
            Date start = DateUtil.getCurDateForm((Date)DateUtil.addDay((Date)now, (long)(-dateRange)), (boolean)true);
            Object[] dataObjs = this.calCreditBoardDataSource(start, now);
            if (dataObjs.length > 0) {
                CreditBoardConfigUtil.updateCreditBoardData((DynamicObject[])dataObjs);
            }
        }
    }

    private Object[] calCreditBoardDataSource(Date start, Date end) {
        int startNum = DateUtil.convertIntFormate((Date)start);
        int endNum = DateUtil.convertIntFormate((Date)end);
        QFilter bizDateFil = QFilter.of((String)"bizdate >= ? and bizdate <= ?", (Object[])new Object[]{startNum, endNum});
        DeleteServiceHelper.delete((String)SSC_CREDITBOARDDATA, (QFilter[])new QFilter[]{bizDateFil});
        HashMap<String, DynamicObject> boardDataMap = new HashMap<String, DynamicObject>(8);
        this.calCompletedTask(start, end, boardDataMap);
        this.calSubScoreDetail(start, end, boardDataMap);
        Collection boardDataColl = boardDataMap.values();
        if (!CollectionUtils.isEmpty(boardDataColl)) {
            return SaveServiceHelper.save((DynamicObject[])boardDataColl.toArray(new DynamicObject[boardDataColl.size()]));
        }
        return new Object[0];
    }

    private boolean isNeedInitCreditBoardData() {
        String isNeed = TaskParamControlUtil.querySscParam((String)"isNeedInitCreditBoardData");
        if (StringUtils.isEmpty((String)isNeed)) {
            log.error(BASEINFO + " parameter \"isNeedInitCreditBoardData\" not exist or is empty");
            return false;
        }
        return Boolean.parseBoolean(isNeed);
    }

    private void writeBackParamOfNeedInit() {
        boolean result = TaskParamControlUtil.writeBackParam((String)"isNeedInitCreditBoardData", (String)"false");
        if (result) {
            log.info(BASEINFO + " success_writeBackParamOfNeedInit()");
        } else {
            log.error(BASEINFO + " write back parameter failed_writeBackParamOfNeedInit()");
        }
    }

    private void calOrgAvgCreditScore() {
        String algoKey = BASEINFO + "calOrgAvgCreditScore()";
        String selFields = "company,creditvalue";
        QFilter statusFilter = new QFilter("status", "!=", (Object)Character.valueOf('D'));
        QFilter companyFilter = new QFilter("company.id", ">", (Object)0L);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"task_creditfiles", (String)selFields, (QFilter[])new QFilter[]{statusFilter, companyFilter}, null);
             DataSet dataSet1 = dataSet.groupBy(new String[]{"company"}).avg("creditvalue", "avgscore").finish();){
            ArrayList<DynamicObject> dynObjs = new ArrayList<DynamicObject>(10);
            Date date = new Date();
            for (Row row : dataSet1) {
                DynamicObject dynObj = BusinessDataServiceHelper.newDynamicObject((String)SSC_CREDITBOARDAVGSCORE);
                dynObj.set("company", (Object)row.getLong("company"));
                dynObj.set("avgscore", (Object)row.getBigDecimal("avgscore"));
                dynObj.set("modifytime", (Object)date);
                dynObjs.add(dynObj);
            }
            DeleteServiceHelper.delete((String)SSC_CREDITBOARDAVGSCORE, null);
            SaveServiceHelper.save((DynamicObject[])dynObjs.toArray(new DynamicObject[0]));
        }
    }

    private void calCompletedTask(Date start, Date end, Map<String, DynamicObject> boardDataMap) {
        String algoKey = BASEINFO + "calCreditBoardCompletedTask()";
        QFilter timeFil = QFilter.of((String)"completetime >= ? and completetime < ?", (Object[])new Object[]{start, end});
        String selFields = "sscid,completetime ctime";
        try (DataSet taskHisData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"task_taskhistory", (String)selFields, (QFilter[])new QFilter[]{timeFil}, null);
             DataSet resultData = taskHisData.select(new String[]{"sscid", "year(ctime)*10000+month(ctime)*100+day(ctime) bizdate"}).groupBy(new String[]{"sscid", "bizdate"}).count("tasknum").finish();){
            for (Row row : resultData) {
                Long sscid = row.getLong("sscid");
                Integer bizDate = row.getInteger("bizdate");
                Integer taskNum = row.getInteger("tasknum");
                DynamicObject boardData = boardDataMap.get(sscid + "-" + bizDate);
                if (boardData == null) {
                    boardData = BusinessDataServiceHelper.newDynamicObject((String)SSC_CREDITBOARDDATA);
                    boardDataMap.put(sscid + "-" + bizDate, boardData);
                    boardData.set("sscid", (Object)sscid);
                    boardData.set("bizdate", (Object)bizDate);
                }
                boardData.set("taskcompletednum", (Object)taskNum);
            }
        }
    }

    private int getDateRange() {
        int dateRange;
        String dateRangeStr = TaskParamControlUtil.querySscParam((String)"creditBoardDataCalDate");
        if (StringUtils.isEmpty((String)dateRangeStr)) {
            log.info(BASEINFO + " parameter \"creditBoardDataCalDate\" not exist or is empty");
            return 1;
        }
        try {
            dateRange = Integer.parseInt(dateRangeStr);
        }
        catch (NumberFormatException e) {
            log.error(BASEINFO + " exception is parameter \"creditBoardDataCalDate\" to parse integer", (Throwable)e);
            return 1;
        }
        return dateRange;
    }

    private void calSubScoreDetail(Date start, Date end, Map<String, DynamicObject> boardDataMap) {
        String algoKey = BASEINFO + "calCreditBoardSubScoreDetail()";
        String selFields = "raiser,company,modifysource source,changedscore,modifydate,taskid";
        QFilter[] filters = new QFilter[]{QFilter.of((String)"modifydate >= ? and modifydate < ?", (Object[])new Object[]{start, end}), new QFilter("modifytype", "in", Arrays.asList(Character.valueOf('2'), Character.valueOf('4'))), new QFilter("modifysource", "in", Arrays.asList(Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'))), new QFilter("taskid", ">", (Object)0)};
        String selhisTaskFields = "id,sscid,billtype.bindbill.number billentity,billtype.externalerp bizsys,billid";
        Set<Long> taskIds = this.getTaskIdsByCreditModifyLog(filters);
        if (taskIds.isEmpty()) {
            log.info("calSubScoreDetail().taskIds is empty");
            return;
        }
        QFilter taskIdFil = new QFilter("id", "in", taskIds);
        try (DataSet creditLogs = QueryServiceHelper.queryDataSet((String)(algoKey + "_0"), (String)"task_creditmodifylog", (String)selFields, (QFilter[])filters, null);
             DataSet creditLogs1 = creditLogs.select(new String[]{"raiser", "company", "source", "-changedscore score", "year(modifydate)*10000+month(modifydate)*100+day(modifydate) date", "taskid"});
             DataSet taskHisData = QueryServiceHelper.queryDataSet((String)(algoKey + "_1"), (String)"task_taskhistory", (String)selhisTaskFields, (QFilter[])new QFilter[]{taskIdFil}, null);
             DataSet resultData = creditLogs1.join(taskHisData, JoinType.INNER).on("taskid", "id").select(new String[]{"date", "raiser", "company", "source", "score", "taskid"}, new String[]{"sscid", "billentity", "bizsys", "billid"}).finish().orderBy(new String[]{"sscid", "date"});){
            String cacheKey = null;
            DynamicObjectCollection cacheEntryColl = null;
            for (Row row : resultData) {
                Long sscid = row.getLong("sscid");
                Integer bizDate = row.getInteger("date");
                String key = sscid + "-" + bizDate;
                DynamicObjectCollection entryColl = null;
                if (key.equals(cacheKey)) {
                    entryColl = cacheEntryColl;
                } else {
                    DynamicObject boardData = boardDataMap.get(key);
                    if (boardData == null) {
                        boardData = BusinessDataServiceHelper.newDynamicObject((String)SSC_CREDITBOARDDATA);
                        boardDataMap.put(key, boardData);
                        boardData.set("sscid", (Object)sscid);
                        boardData.set("bizdate", (Object)bizDate);
                    }
                    entryColl = boardData.getDynamicObjectCollection("entry");
                    cacheKey = key;
                    cacheEntryColl = entryColl;
                }
                if (entryColl == null) continue;
                DynamicObject entry = entryColl.addNew();
                entry.set("user", (Object)row.getLong("raiser"));
                entry.set("company", (Object)row.getLong("company"));
                entry.set("subscore", (Object)row.getBigDecimal("score"));
                entry.set("subscoretype", (Object)row.getString("source"));
                entry.set("taskid", (Object)row.getLong("taskid"));
                entry.set("bizsys", (Object)row.getLong("bizsys"));
                String billId = row.getString("billid");
                String billEntity = row.getString("billentity");
                entry.set("bizbill", (Object)billEntity);
                try {
                    Long billId_ = Long.parseLong(billId);
                    entry.set("billid", (Object)billId_);
                }
                catch (NumberFormatException e) {
                    log.warn(String.format("can't cast to Long, billentity = %s, billid = %s", billEntity, billId));
                }
                OrmLocaleValue mulLang = (OrmLocaleValue)entry.get("biztypename");
                mulLang.setLocaleValue(ResManager.loadKDString((String)"\u5176\u4ed6", (String)"CreditBoardDataCalculateTask_0", (String)"ssc-task-business", (Object[])new Object[0]));
            }
        }
    }

    private Set<Long> getTaskIdsByCreditModifyLog(QFilter[] filters) {
        HashSet<Long> taskIds = new HashSet<Long>(32);
        String algoKey = ((Object)((Object)this)).getClass() + ".getTaskIdsByCreditModifyLog()";
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"task_creditmodifylog", (String)"taskid", (QFilter[])filters, null);){
            for (Row row : dSet) {
                taskIds.add(row.getLong("taskid"));
            }
        }
        return taskIds;
    }
}

