/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.boardv2.job;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import kd.ssc.task.business.boardv2.query.FircmDataProcessor;
import kd.ssc.task.business.boardv2.query.TaskHistoryDataProcessor;
import kd.ssc.task.business.boardv2.query.TaskStateProcessor;
import kd.ssc.task.business.boardv2.query.WFDataProcessor;
import kd.ssc.task.util.DateUtil;
import kd.ssc.task.util.TaskParamControlUtil;

public class BoardDataLoader
extends AbstractTask {
    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        this.currentMonthOnly(context, params);
        this.lastYearToLastMonth(context, params);
    }

    private void lastYearToLastMonth(RequestContext context, Map<String, Object> params) {
        String exit = TaskParamControlUtil.querySscParam((String)"som_board_last_year");
        if (!StringUtils.isBlank((CharSequence)exit)) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(6, 1);
        calendar.set(calendar.get(1) - 1, calendar.get(2), 1, 0, 0, 0);
        calendar.set(14, 0);
        Date lastYear = calendar.getTime();
        FircmDataProcessor fircmDataProcessor = new FircmDataProcessor();
        fircmDataProcessor.query(lastYear);
    }

    private void currentMonthOnly(RequestContext context, Map<String, Object> params) {
        WFDataProcessor wfDataProcessor = new WFDataProcessor();
        Date start = DateUtil.getCurMonthStartTime();
        wfDataProcessor.query(start);
        FircmDataProcessor fircmDataProcessor = new FircmDataProcessor();
        fircmDataProcessor.query(start);
        TaskHistoryDataProcessor taskHistoryDataProcessor = new TaskHistoryDataProcessor();
        taskHistoryDataProcessor.processData();
        TaskStateProcessor taskStateProcessor = new TaskStateProcessor();
        taskStateProcessor.processData();
    }
}

