/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.condition;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ConditionDataQueryHelper {
    public static DynamicObjectCollection queryAllConditionField() {
        String selectFields = "number,name,fieldtype,basedatatype,comboitemjson_tag";
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        return QueryServiceHelper.query((String)"ssc_condition_field", (String)selectFields, (QFilter[])filter.toArray());
    }

    public static DynamicObjectCollection queryConFields() {
        String selectFields = "number,name,fieldtype,basedatatype,comboitemjson_tag";
        QFilter statusF = new QFilter("status", "=", (Object)"C");
        QFilter enableF = new QFilter("enable", "=", (Object)"1");
        return QueryServiceHelper.query((String)"ssc_condition_field", (String)selectFields, (QFilter[])new QFilter[]{statusF, enableF});
    }

    public static Map<String, Long> queryFieldIdByNumber(Set<String> fieldNumbers) {
        if (fieldNumbers == null) {
            return new HashMap<String, Long>(0);
        }
        QFilter filter = new QFilter("number", "in", fieldNumbers);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"ssc_condition_field", (String)"id,number", (QFilter[])filter.toArray());
        return col.stream().collect(Collectors.toMap(c -> c.getString("number"), c -> c.getLong("id")));
    }

    public static DynamicObject queryConditionInfoById(Long conditionId) {
        if (conditionId < 1L) {
            return null;
        }
        QFilter filter = new QFilter("id", "=", (Object)conditionId);
        String selectFields = "id,conditionjson,conditionjson_tag";
        return QueryServiceHelper.queryOne((String)"ssc_apply_condition", (String)selectFields, (QFilter[])filter.toArray());
    }

    public static DynamicObjectCollection queryConditionInfoById(Long[] conditionIds) {
        if (conditionIds == null || conditionIds.length < 1) {
            return null;
        }
        QFilter filter = new QFilter("id", "in", (Object)conditionIds);
        String selectFields = "id,orgssc,conditionjson,conditionjson_tag";
        return QueryServiceHelper.query((String)"ssc_apply_condition", (String)selectFields, (QFilter[])filter.toArray());
    }

    public static Set<String> queryBindBillNumByApplyCondId(Long applyCondId) {
        if (applyCondId == null || applyCondId == 0L) {
            return new HashSet<String>(0);
        }
        QFilter applyCondFilter = new QFilter("applycond", "=", (Object)applyCondId);
        DynamicObjectCollection taskbills = QueryServiceHelper.query((String)"task_taskbill", (String)"id,bindbill.number", (QFilter[])applyCondFilter.toArray());
        return taskbills.stream().map(v -> v.getString("bindbill.number")).collect(Collectors.toSet());
    }
}

