/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class TaskBillClassifyHelper {
    private static final Log log = LogFactory.getLog(TaskBillClassifyHelper.class);

    public static DynamicObjectCollection getAllDownTaskBillByClassify(Long sscId, String number, boolean firstLevel) {
        if (sscId == null || StringUtils.isEmpty((String)number)) {
            return null;
        }
        ArrayList<Long> groupIdList = new ArrayList<Long>();
        QFilter qFilter1 = new QFilter("ssccenter", "=", (Object)sscId);
        QFilter qFilter2 = new QFilter("longnumber", "like", (Object)("%." + number + ".%"));
        if (firstLevel) {
            qFilter2 = new QFilter("longnumber", "like", (Object)(number + ".%"));
        }
        QFilter qFilter3 = new QFilter("number", "=", (Object)number);
        qFilter2.or(qFilter3);
        DynamicObjectCollection classifyDos = QueryServiceHelper.query((String)"task_billclassify", (String)"id,number", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        if (CollectionUtils.isNotEmpty((Collection)classifyDos)) {
            for (DynamicObject classifyDo : classifyDos) {
                groupIdList.add(classifyDo.getLong("id"));
            }
        }
        QFilter sscFilter = new QFilter("ssccenter", "=", (Object)sscId);
        QFilter groupFilter = new QFilter("group", "in", groupIdList);
        DynamicObjectCollection taskBillDos = QueryServiceHelper.query((String)"task_taskbill", (String)"id,number,bindbill,bindbill_new", (QFilter[])new QFilter[]{sscFilter, groupFilter});
        return taskBillDos;
    }

    public static List<String> getAllUpBindBillByClassify(Long sscId, String longNumber) {
        ArrayList<String> bindBillList = new ArrayList<String>(8);
        if (sscId == null || StringUtils.isEmpty((String)longNumber)) {
            return bindBillList;
        }
        String[] numbers = longNumber.split("\\.");
        for (int i = numbers.length - 1; i >= 0; --i) {
            QFilter qFilter1 = new QFilter("ssccenter", "=", (Object)sscId);
            String number = numbers[i];
            QFilter qFilter2 = new QFilter("number", "=", (Object)number);
            DynamicObjectCollection classifyDos = QueryServiceHelper.query((String)"task_billclassify", (String)"id,number,taskpool.bill_new.FBasedataId", (QFilter[])new QFilter[]{qFilter1, qFilter2});
            if (!CollectionUtils.isNotEmpty((Collection)classifyDos)) continue;
            for (DynamicObject classifyDo : classifyDos) {
                String bindBill = classifyDo.getString("taskpool.bill_new.FBasedataId");
                if (bindBill == null) continue;
                bindBillList.add(bindBill);
            }
            if (CollectionUtils.isNotEmpty(bindBillList)) break;
        }
        return bindBillList;
    }

    public static boolean validateBindBill(String bindBill, Long groupId) {
        if (StringUtils.isEmpty((String)bindBill) || groupId == null || groupId == 0L) {
            return false;
        }
        boolean validate = true;
        QFilter qFilter1 = new QFilter("id", "=", (Object)groupId);
        QFilter qFilter2 = new QFilter("enabletaskpool", "=", (Object)"1");
        DynamicObjectCollection classifyDos = QueryServiceHelper.query((String)"task_billclassify", (String)"id,number,taskpool.bill_new.FBasedataId", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        if (CollectionUtils.isNotEmpty((Collection)classifyDos)) {
            ArrayList<String> bindBillList = new ArrayList<String>(8);
            for (DynamicObject classifyDo : classifyDos) {
                String bindBillItem = classifyDo.getString("taskpool.bill_new.FBasedataId");
                if (bindBillItem == null) continue;
                bindBillList.add(bindBillItem);
            }
            if (!bindBillList.contains(bindBill)) {
                validate = false;
            }
        }
        return validate;
    }

    public static Map<Long, List<String>> getAllUpBindBillMapByClassify(Long curParentId) {
        HashMap<Long, List<String>> bindBillListMap = new HashMap<Long, List<String>>(8);
        while (curParentId != null && curParentId != 0L) {
            QFilter qFilter1 = new QFilter("id", "=", (Object)curParentId);
            DynamicObjectCollection classifyDos = QueryServiceHelper.query((String)"task_billclassify", (String)"id,number,parent,enabletaskpool,taskpool.bill_new.FBasedataId", (QFilter[])new QFilter[]{qFilter1});
            if (CollectionUtils.isNotEmpty((Collection)classifyDos)) {
                Long parentId = ((DynamicObject)classifyDos.get(0)).getLong("parent");
                List bindBillList = bindBillListMap.getOrDefault(curParentId, new ArrayList(8));
                for (DynamicObject classifyDo : classifyDos) {
                    String bindBillItem = classifyDo.getString("taskpool.bill_new.FBasedataId");
                    if (bindBillItem == null) continue;
                    bindBillList.add(bindBillItem);
                }
                bindBillListMap.put(curParentId, bindBillList);
                curParentId = parentId;
                continue;
            }
            curParentId = null;
        }
        return bindBillListMap;
    }

    public static void clearBindBillByClassify(Set<Long> clearGroupIdSet) {
        QFilter qFilter;
        DynamicObject[] classifyDos;
        if (CollectionUtils.isNotEmpty(clearGroupIdSet) && (classifyDos = BusinessDataServiceHelper.load((String)"task_billclassify", (String)"id,number,enabletaskpool,taskpool", (QFilter[])new QFilter[]{qFilter = new QFilter("id", "in", clearGroupIdSet)})) != null && classifyDos.length > 0) {
            for (DynamicObject classifyDo : classifyDos) {
                classifyDo.set("enabletaskpool", (Object)"0");
                classifyDo.set("taskpool", null);
            }
            SaveServiceHelper.update((DynamicObject[])classifyDos);
            log.info("TaskBillClassifyHelper.clearBindBillByClassify end: clearGroupIdSet = {}", clearGroupIdSet);
        }
    }
}

