/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.task;

import java.util.List;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.ssc.task.business.helper.OrgRelationQueryHelper;

public class OrgF7ViewShowHelper {
    public static ListShowParameter buildOrgShowFormParameter(boolean isMultiSelect, List<QFilter> dataFilters) {
        return OrgF7ViewShowHelper.buildOrgShowFormParameter(isMultiSelect, dataFilters, null, false);
    }

    public static ListShowParameter buildOrgShowFormParameter(boolean isMultiSelect, List<QFilter> extDataFilters, Long sscId) {
        return OrgF7ViewShowHelper.buildOrgShowFormParameter(isMultiSelect, extDataFilters, sscId, true);
    }

    public static ListShowParameter buildOrgShowFormParameter(boolean isMultiSelect, List<QFilter> extDataFilters, Long sscId, boolean isNeedRelationFilter) {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bos_org", (boolean)true);
        lsp.setFormId("ssc_orgtreelistf7");
        lsp.setMultiSelect(isMultiSelect);
        lsp.setCustomParam("ServiceAppId", (Object)"ssc");
        List filters = lsp.getListFilterParameter().getQFilters();
        if (sscId != null) {
            QFilter relationFilter;
            lsp.setCustomParam("sscId", (Object)sscId.toString());
            if (isNeedRelationFilter && (relationFilter = OrgF7ViewShowHelper.buildDataFilter(sscId)) != null) {
                filters.add(relationFilter);
            }
        }
        if (!ObjectUtils.isEmpty(extDataFilters)) {
            filters.addAll(extDataFilters);
        }
        return lsp;
    }

    public static void beforeFilterContainerF7(BeforeFilterF7SelectEvent args, Long sscId) {
        args.setFormId("ssc_orgtreelistf7");
        args.addCustomParam("sscId", (Object)sscId.toString());
        args.addCustomParam("ServiceAppId", (Object)"ssc");
        QFilter filter = OrgF7ViewShowHelper.buildDataFilter(sscId);
        if (filter != null) {
            args.addCustomQFilter(filter);
        }
    }

    public static void beforeF7Select(BeforeF7SelectEvent e, Long sscId) {
        ListShowParameter lsp = (ListShowParameter)e.getFormShowParameter();
        lsp.setFormId("ssc_orgtreelistf7");
        lsp.setCustomParam("ServiceAppId", (Object)"ssc");
        lsp.setCustomParam("sscId", (Object)sscId.toString());
        QFilter filter = OrgF7ViewShowHelper.buildDataFilter(sscId);
        if (filter != null) {
            lsp.getListFilterParameter().getQFilters().add(filter);
        }
    }

    private static QFilter buildDataFilter(Long sscId) {
        List<Long> relationOfUnit2SSC = OrgRelationQueryHelper.getFromOrgList(sscId);
        if (!ObjectUtils.isEmpty(relationOfUnit2SSC)) {
            return new QFilter("id", "in", relationOfUnit2SSC);
        }
        return null;
    }

    private static QFilter buildDataFilterByDutyScope(Long sscId) {
        List<Long> relationOfUnit2SSC = OrgRelationQueryHelper.getFromOrgListFilterDutyScope(sscId, true);
        if (!ObjectUtils.isEmpty(relationOfUnit2SSC)) {
            return new QFilter("id", "in", relationOfUnit2SSC);
        }
        return null;
    }
}

