/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.extendplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.ssc.task.util.ObjectCloneUtil;

public class TaskTripPlanePlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    public void initialize() {
        super.initialize();
        EntryGrid planeEntryGrid = (EntryGrid)this.getControl("planeentry");
        planeEntryGrid.addCellClickListener(new CellClickListener(){

            public void cellClick(CellClickEvent e) {
                String field = e.getFieldKey();
                int currentRow = e.getRow();
                if ("subordernum".equalsIgnoreCase(field)) {
                    TaskTripPlanePlugin.this.showPlaneOrderForm(currentRow);
                }
            }

            public void cellDoubleClick(CellClickEvent e) {
            }
        });
    }

    private void initListData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String ordernums = (String)formShowParameter.getCustomParams().get("ordernums");
        if (StringUtils.isNotBlank((CharSequence)ordernums) && StringUtils.contains((CharSequence)ordernums, (CharSequence)",")) {
            String[] orderIds = StringUtils.split((String)ordernums, (String)",");
            if (orderIds == null || orderIds.length <= 0) {
                return;
            }
            IDataModel model = this.getModel();
            DynamicObjectCollection cols = model.getEntryEntity("planeentry");
            model.batchCreateNewEntryRow("planeentry", orderIds.length);
            for (int i = 0; i < orderIds.length; ++i) {
                model.setValue("subordernum", (Object)orderIds[i], i);
                this.setFieldEditEnable(false, i, "subordernum");
            }
        }
    }

    private void initEntitiesData() {
        int i;
        String hotelOrders;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map map = formShowParameter.getCustomParams();
        String planeOrders = map.get("plane") == null ? null : (String)map.get("plane");
        String string = hotelOrders = map.get("hotel") == null ? null : (String)map.get("hotel");
        if (StringUtils.isEmpty((CharSequence)planeOrders) && StringUtils.isEmpty((CharSequence)hotelOrders)) {
            return;
        }
        IDataModel model = this.getModel();
        ArrayList<String> planeOrderList = new ArrayList<String>();
        ArrayList<String> hotelOrderList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)planeOrders) && StringUtils.contains((CharSequence)planeOrders, (CharSequence)",")) {
            String[] planeOrderIds = StringUtils.split((String)planeOrders, (String)",");
            planeOrderList.addAll(Arrays.asList(planeOrderIds));
        } else if (StringUtils.isNotEmpty((CharSequence)planeOrders)) {
            planeOrderList.add(planeOrders);
        }
        if (StringUtils.isNotEmpty((CharSequence)hotelOrders) && StringUtils.contains((CharSequence)hotelOrders, (CharSequence)",")) {
            String[] hotelOrderIds = StringUtils.split((String)hotelOrders, (String)",");
            hotelOrderList.addAll(Arrays.asList(hotelOrderIds));
        } else if (StringUtils.isNotEmpty((CharSequence)hotelOrders)) {
            hotelOrderList.add(hotelOrders);
        }
        int size = planeOrderList.size() + hotelOrderList.size();
        model.batchCreateNewEntryRow("planeentry", size);
        int planeIndex = 0;
        int hotelIndex = 0;
        for (i = 0; i < planeOrderList.size(); ++i) {
            planeIndex = i;
            model.setValue("subordernum", planeOrderList.get(i), planeIndex);
            model.setValue("billcategory", (Object)ResManager.loadKDString((String)"\u673a\u7968\u8ba2\u5355", (String)"TaskTripPlanePlugin_0", (String)"ssc-task-ext", (Object[])new Object[0]), planeIndex);
            this.setFieldEditEnable(false, planeIndex, "subordernum");
        }
        hotelIndex = planeIndex > 0 ? ++planeIndex : 0;
        for (i = 0; i < hotelOrderList.size(); ++i) {
            model.setValue("subordernum", hotelOrderList.get(i), hotelIndex += i);
            model.setValue("billcategory", (Object)ResManager.loadKDString((String)"\u9152\u5e97\u8ba2\u5355", (String)"TaskTripPlanePlugin_1", (String)"ssc-task-ext", (Object[])new Object[0]), hotelIndex);
            this.setFieldEditEnable(false, hotelIndex, "subordernum");
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initEntitiesData();
        this.deleteBankEntryRow();
    }

    private void showPlaneOrderForm(int rowIndex) {
        IDataModel model = this.getModel();
        String ordernum = (String)model.getValue("subordernum", rowIndex);
        String category = (String)model.getValue("billcategory", rowIndex);
        String entityName = "er_staffplanebill";
        String caption = ResManager.loadKDString((String)"\u5458\u5de5\u673a\u7968\u8ba2\u5355", (String)"TaskTripPlanePlugin_2", (String)"ssc-task-ext", (Object[])new Object[0]);
        if (ResManager.loadKDString((String)"\u9152\u5e97\u8ba2\u5355", (String)"TaskTripPlanePlugin_1", (String)"ssc-task-ext", (Object[])new Object[0]).equals(category)) {
            entityName = "er_staffhotelbill";
            caption = ResManager.loadKDString((String)"\u5458\u5de5\u9152\u5e97\u8ba2\u5355", (String)"TaskTripPlanePlugin_3", (String)"ssc-task-ext", (Object[])new Object[0]);
        }
        ORM orm = ORM.create();
        QFilter qFilter = new QFilter("ordernum", "=", (Object)ordernum);
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObject planeOrder = orm.queryOne(entityName, "id", qFilters);
        if (planeOrder != null) {
            String id = planeOrder.getString("id");
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId(entityName);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCaption(caption);
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setPkId((Object)id);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void showPlaneOrderForm(IFormView view, String ordernum) {
        ORM orm = ORM.create();
        QFilter qFilter = new QFilter("ordernum", "=", (Object)ordernum);
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObject planeOrder = orm.queryOne("er_staffplanebill", "id", qFilters);
        if (planeOrder != null) {
            String id = planeOrder.getString("id");
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId("er_staffplanebill");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCaption(ResManager.loadKDString((String)"\u5458\u5de5\u673a\u7968\u8ba2\u5355", (String)"TaskTripPlanePlugin_2", (String)"ssc-task-ext", (Object[])new Object[0]));
            parameter.setStatus(OperationStatus.EDIT);
            parameter.setPkId((Object)id);
            view.showForm((FormShowParameter)parameter);
        }
    }

    public void showPlaneOrderForm(IFormView view, String ordernum, String entityName, String caption) {
        ORM orm = ORM.create();
        QFilter qFilter = new QFilter("ordernum", "=", (Object)ordernum);
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObject planeOrder = orm.queryOne(entityName, "id", qFilters);
        if (planeOrder != null) {
            String id = planeOrder.getString("id");
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId(entityName);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCaption(caption);
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setPkId((Object)id);
            view.showForm((FormShowParameter)parameter);
        }
    }

    private void deleteBankEntryRow() {
        int lastRowIndex;
        String orderNum;
        IDataModel model = this.getModel();
        DynamicObjectCollection entries = model.getEntryEntity("planeentry");
        if (entries != null && entries.size() > 0 && StringUtils.isBlank((CharSequence)(orderNum = ((DynamicObject)entries.get(lastRowIndex = entries.size() - 1)).getString("subordernum")))) {
            model.deleteEntryRow("planeentry", lastRowIndex);
        }
    }

    protected void setFieldEditEnable(boolean enable, int rowindex, String ... keys) {
        String[] arg2 = (String[])ObjectCloneUtil.cloneObject((Object)keys);
        int arg3 = keys.length;
        for (int arg4 = 0; arg4 < arg3; ++arg4) {
            String key = arg2[arg4];
            FieldEdit field = (FieldEdit)this.getControl(key);
            field.setEnable(key, enable, rowindex);
        }
    }
}

