/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.extendplugin;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.bill.OperationStatus;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.eas.bill.EASTaskTripReimbursebillHandler;
import kd.ssc.task.extendplugin.TaskSumAmountBill;
import kd.ssc.task.extendplugin.TaskTripPlanePlugin;
import kd.ssc.task.extendplugin.base.TaskExtendBill;
import kd.ssc.task.util.EasTaskExpenseHelper;
import kd.ssc.task.util.ExchangeRateService;

public class TaskTripReimburseBill
extends TaskExtendBill
implements BeforeF7SelectListener,
HyperLinkClickListener,
ClickListener {
    private boolean hasLocalapprovedCalled = false;
    private boolean hasOriapprovedCalled = false;
    private boolean hasAmtoriCalled = false;
    private boolean hasAmtCalled = false;
    private String orderNums = null;
    private static final String ORDER_ER_PLANEBILL = "ORDER_ER_PLANEBILL";
    private static final String ORDER_ER_HOTELBILL = "ORDER_ER_HOTELBILL";
    private static final String PROPERTYCHANGEDEEP = "propertyChangeDeep";
    private static final String CHCHE_TASKTRIPREIMBURSEBILL_APPLAYID_VALUE = "CHCHE_TASKTRIPREIMBURSEBILL_APPLAYID_VALUE";
    private static final Log logger = LogFactory.getLog(TaskTripReimburseBill.class);
    private int add = 0;
    private int sub = 0;

    @Override
    public void initialize() {
        super.initialize();
        BasedataEdit loanbill = (BasedataEdit)this.getControl("loanbill");
        BasedataEdit expensetype = (BasedataEdit)this.getControl("expensetype");
        BasedataEdit paymode1 = (BasedataEdit)this.getControl("paymode1");
        EntryGrid entriesGrid = (EntryGrid)this.getControl("entries");
        loanbill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        expensetype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        paymode1.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        entriesGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{"txttasklevel"});
    }

    private void showPlaneForm(int rowIndex) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String ordernum = (String)model.getValue("ordernum", rowIndex);
        if (kd.bos.util.StringUtils.isBlank((String)ordernum)) {
            return;
        }
        String planeOrders = this.getPageCache().get(ORDER_ER_PLANEBILL);
        String hotelOrders = this.getPageCache().get(ORDER_ER_HOTELBILL);
        if (StringUtils.contains((CharSequence)ordernum, (CharSequence)",")) {
            FormShowParameter parameEdit = new FormShowParameter();
            parameEdit.setFormId("task_tripplaneinfo");
            parameEdit.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("plane", planeOrders);
            map.put("hotel", hotelOrders);
            parameEdit.setCustomParams(map);
            this.getView().showForm(parameEdit);
        } else {
            TaskTripPlanePlugin plg = new TaskTripPlanePlugin();
            if (kd.bos.util.StringUtils.isNotEmpty((String)planeOrders)) {
                plg.showPlaneOrderForm(view, ordernum, "er_staffplanebill", ResManager.loadKDString((String)"\u5458\u5de5\u673a\u7968\u8ba2\u5355", (String)"TaskTripReimburseBill_0", (String)"ssc-task-ext", (Object[])new Object[0]));
            } else {
                plg.showPlaneOrderForm(view, ordernum, "er_staffhotelbill", ResManager.loadKDString((String)"\u5458\u5de5\u9152\u5e97\u8ba2\u5355", (String)"TaskTripReimburseBill_1", (String)"ssc-task-ext", (Object[])new Object[0]));
            }
        }
    }

    private void setFloatAmountValues(DynamicObjectCollection entries, String keyCol, String entryName, String signColName) {
        BigDecimal valueSum = TaskSumAmountBill.setSumAmountValue(entries, keyCol);
        DecimalFormat dFormat = new DecimalFormat("###,###.00");
        String sign = "\uffe5";
        if (entries.size() > 0) {
            DynamicObject currency = (DynamicObject)((DynamicObject)entries.get(0)).get(signColName);
            sign = currency.get("sign").toString();
        }
        HashMap<String, String> floatButtomData = new HashMap<String, String>();
        floatButtomData.put(keyCol, sign + dFormat.format(valueSum));
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryName);
        entryGrid.setFloatButtomData(floatButtomData);
    }

    @Override
    public void afterBindData(EventObject e) {
        String taskID;
        DynamicObject task;
        DynamicObjectCollection collectionentries;
        super.afterBindData(e);
        DynamicObject data = this.getModel().getDataEntity();
        DynamicObjectCollection entries = data.getDynamicObjectCollection("entries");
        this.setSumAmountValues(entries, "ori", "entries", "currency");
        boolean hideOriAmt = true;
        for (DynamicObject ey : entries) {
            BigDecimal exg = (BigDecimal)ey.get("rate");
            if (exg.compareTo(new BigDecimal("1")) == 0) continue;
            hideOriAmt = false;
            break;
        }
        this.amountUpdateDCtr();
        this.disEnableFieldByIsMonthlyBalance();
        if (hideOriAmt) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"oriapprovedwithouttax", "oriapproved"});
        }
        this.setFieldEditEnable((collectionentries = data.getDynamicObjectCollection("collectionentries")).size() > 1, "pamountori");
        this.setSumAmountValues(collectionentries, "pamountori", "collectionentries", "pcurrency");
        EASTaskTripReimbursebillHandler handler = new EASTaskTripReimbursebillHandler();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (OperationStatus.VIEW != formShowParameter.getStatus() && (task = BusinessDataReader.loadSingle((Object)(taskID = (String)formShowParameter.getCustomParams().get("taskID")), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"task_task"))) != null) {
            DynamicObject applier = task.getDynamicObject("creator");
            this.getPageCache().put("applierid", Long.valueOf(applier.getLong("id")).toString());
            try {
                handler.importLoanbill(applier.getLong("id"), "TravelAccountBill", "evectionLoan");
            }
            catch (Exception e1) {
                logger.error("\u540c\u6b65\u501f\u6b3e\u5355\u51fa\u9519", (Throwable)e1);
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u501f\u6b3e\u5355\u51fa\u9519\uff1a%s", (String)"TaskTripReimburseBill_2", (String)"ssc-task-ext", (Object[])new Object[0]), e1.getMessage()));
            }
        }
        this.setFloatAmountValues(entries, "oriapproved", "entries", "currency");
    }

    private void amountUpdateDCtr() {
        boolean moreCurrency = this.isMoreCurrency();
        if (moreCurrency) {
            this.setFieldEditEnable(false, "locapproved");
        } else {
            this.setFieldEditEnable(false, "oriapproved");
        }
    }

    private void setSumAmountValues(DynamicObjectCollection collectionentries, String keyValues, String keyEntry, String currencySign) {
        BigDecimal valueSum = TaskSumAmountBill.setSumAmountValue(collectionentries, keyValues);
        DecimalFormat dFormat = new DecimalFormat("###,###.00");
        String sign = "\uffe5";
        if (collectionentries.size() > 0) {
            DynamicObject currency = (DynamicObject)((DynamicObject)collectionentries.get(0)).get(currencySign);
            sign = currency.get("sign").toString();
        }
        HashMap<String, String> floatButtomData = new HashMap<String, String>();
        floatButtomData.put(keyValues, sign + dFormat.format(valueSum));
        EntryGrid entryGrid = (EntryGrid)this.getControl(keyEntry);
        entryGrid.setFloatButtomData(floatButtomData);
    }

    private boolean isMoreCurrency() {
        boolean moreCurrency = false;
        DynamicObjectCollection entries = this.getModel().getDataEntity().getDynamicObjectCollection("entries");
        long loccurID = this.getModel().getValue("loccur") == null ? 0L : ((DynamicObject)this.getModel().getValue("loccur")).getLong("id");
        for (DynamicObject ey : entries) {
            long entryCurID = ey.getDynamicObject("currency").getLong("id");
            if (loccurID == entryCurID) continue;
            moreCurrency = true;
            break;
        }
        return moreCurrency;
    }

    private void disEnableFieldByIsMonthlyBalance() {
        int entrysSize = this.getModel().getEntryRowCount("entries");
        if (entrysSize > 0) {
            IDataModel model = this.getModel();
            for (int rowIndex = 0; rowIndex < entrysSize; ++rowIndex) {
                Boolean isMothlyBalance = Boolean.valueOf(model.getValue("monthlybalance", rowIndex).toString());
                if (isMothlyBalance.booleanValue()) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"locapproved"});
                    this.setFieldEditEnable(false, rowIndex, "locapproved", "expensetype", "taxrate", "tax", "voucherdesc", "rate", "oriapproved");
                    model.setValue("ordernum", (Object)this.orderNums, rowIndex);
                }
                this.setFieldEditEnable(false, rowIndex, "ordernum");
            }
        }
    }

    @Override
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        int payModeSize = this.getModel().getEntryRowCount("collectionentries");
        if (payModeSize > 0) {
            for (int i = 0; i < payModeSize; ++i) {
                if (kd.bos.util.StringUtils.isNotEmpty((String)((String)this.getModel().getValue("paymode", i)))) {
                    this.setFieldEditVisible(false, "paymode1");
                    continue;
                }
                this.setFieldEditVisible(false, "paymode");
            }
        }
        if (this.isMoreCurrency()) {
            this.setFieldEditVisible(true, "checkamountori");
            this.setFieldEditEnable(false, "checkamount");
        } else {
            this.setFieldEditVisible(false, "checkamountori");
        }
        this.initPositionAndCostCompany();
    }

    public void initPositionAndCostCompany() {
        DynamicObject firstrow;
        DynamicObject data = this.getModel().getDataEntity();
        DynamicObjectCollection entries = data.getDynamicObjectCollection("entries");
        String costcompany = "";
        String costdept = "";
        if (entries.size() > 0) {
            DynamicObject companycurrency = (DynamicObject)((DynamicObject)entries.get(0)).get("costcompany");
            if (companycurrency != null) {
                costcompany = companycurrency.getString("name");
            }
            costdept = ((DynamicObject)entries.get(0)).getString("costdept");
        }
        Label costcompanyv = (Label)this.getControl("costcompanyv");
        Label costdeptv = (Label)this.getControl("costdeptv");
        costcompanyv.setText(costcompany);
        costdeptv.setText(costdept);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String taskID = (String)formShowParameter.getCustomParams().get("taskID");
        FormShowParameter parFormShowPara = this.getView().getParentView().getFormShowParameter();
        String pooltype = (String)parFormShowPara.getCustomParams().get("pooltype");
        String sourcebillnumber = (String)parFormShowPara.getCustomParams().get("sourcebillnumber");
        if (kd.bos.util.StringUtils.isNull((String)pooltype)) {
            pooltype = (String)parFormShowPara.getCustomParams().get("pooltype-mytask");
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)sourcebillnumber)) {
            this.orderNums = this.getOrderNumByBillNumber(sourcebillnumber);
        }
        DynamicObject task = null;
        task = !pooltype.equals("2") ? BusinessDataReader.loadSingle((Object)taskID, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"task_task")) : BusinessDataReader.loadSingle((Object)taskID, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"task_taskhistory"));
        DynamicObject applier = task.getDynamicObject("creator");
        String applierid = String.valueOf(applier.getLong("id"));
        String picturefield = (String)applier.get("picturefield");
        String position = "";
        DynamicObject userObject = BusinessDataServiceHelper.loadSingle((Object)applierid, (String)"bos_user");
        if (userObject != null && (firstrow = (DynamicObject)userObject.getDynamicObjectCollection("entryentity").get(0)) != null) {
            position = firstrow.getString("position");
        }
        Label positionLabel = (Label)this.getControl("position");
        positionLabel.setText(position);
        this.getPageCache().put(CHCHE_TASKTRIPREIMBURSEBILL_APPLAYID_VALUE, applierid);
        EasTaskExpenseHelper.showCreditInfoForm(this.getView(), applier.getLong("id"));
        Image picture = (Image)this.getControl("imageap");
        picture.setUrl(picturefield);
        String product = (String)this.getModel().getValue("producttypeid");
        if (product.equals(" ")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"producttypeid"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("txttasklevel".equals(key)) {
            String userId = this.getPageCache().get(CHCHE_TASKTRIPREIMBURSEBILL_APPLAYID_VALUE);
            IFormView view = this.getView();
            EasTaskExpenseHelper.showCreditFilesForm(view, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOrderNumByBillNumber(String billnumber) {
        String orderNums = null;
        if (kd.bos.util.StringUtils.isEmpty((String)billnumber)) {
            return orderNums;
        }
        ORM orm = ORM.create();
        DynamicObject tripreimbursebill = orm.queryOne("er_tripreimbursebill", "id,sourcebillid", new QFilter[]{new QFilter("billno", "=", (Object)billnumber)});
        if (null == tripreimbursebill) {
            return orderNums;
        }
        String sourcebillid = (String)tripreimbursebill.get("sourcebillid");
        if (kd.bos.util.StringUtils.isBlank((String)sourcebillid)) {
            return orderNums;
        }
        DynamicObject tripreqbill = orm.queryOne("er_tripreqbill", "id, billno", new QFilter[]{new QFilter("id", "=", (Object)sourcebillid)});
        String oabillno = (String)tripreqbill.get("billno");
        if (kd.bos.util.StringUtils.isBlank((String)oabillno)) {
            return orderNums;
        }
        DataSet planDataSet = orm.queryDataSet("kd.ssc.task.extendplugin.TaskTripReimburseBill.getOrderNumByBillNumber.plan", "er_planebill", "id,ordernum", new QFilter[]{new QFilter("oabillnum", "=", (Object)oabillno)});
        DataSet hotelDataSet = orm.queryDataSet("kd.ssc.task.extendplugin.TaskTripReimburseBill.getOrderNumByBillNumber.hotel", "er_hotelbill", "id,ordernum", new QFilter[]{new QFilter("oabillnum", "=", (Object)oabillno)});
        StringBuilder sbOrdernum = new StringBuilder();
        StringBuilder sbPlaneOrder = new StringBuilder();
        StringBuilder sbHotelOrder = new StringBuilder();
        try {
            DynamicObjectCollection planCollection = ORMUtil.toDynamicObjectCollection((DataSet)planDataSet, (String)"er_planebill");
            for (DynamicObject dynamicObject : planCollection) {
                sbOrdernum.append(dynamicObject.getString("ordernum"));
                sbOrdernum.append(',');
                sbPlaneOrder.append(dynamicObject.getString("ordernum"));
                sbPlaneOrder.append(',');
            }
            DynamicObjectCollection hotelcollection = ORMUtil.toDynamicObjectCollection((DataSet)hotelDataSet, (String)"er_hotelbill");
            for (DynamicObject dynamicObject : hotelcollection) {
                sbOrdernum.append(dynamicObject.getString("ordernum"));
                sbOrdernum.append(',');
                sbHotelOrder.append(dynamicObject.getString("ordernum"));
                sbHotelOrder.append(',');
            }
        }
        finally {
            if (planDataSet != null) {
                planDataSet.close();
            }
            if (hotelDataSet != null) {
                hotelDataSet.close();
            }
        }
        if (sbOrdernum.length() > 0) {
            orderNums = sbOrdernum.substring(0, sbOrdernum.length() - 1);
        }
        if (sbPlaneOrder.length() > 0) {
            String planeOrders = sbPlaneOrder.substring(0, sbPlaneOrder.length() - 1);
            this.getPageCache().put(ORDER_ER_PLANEBILL, planeOrders);
        }
        if (sbHotelOrder.length() > 0) {
            String hotelOrders = sbHotelOrder.substring(0, sbHotelOrder.length() - 1);
            this.getPageCache().put(ORDER_ER_HOTELBILL, hotelOrders);
        }
        return orderNums;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        int pamoutSize;
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        if ("locapproved".equals(propertyName)) {
            if (this.hasLocalapprovedCalled) {
                return;
            }
            this.hasLocalapprovedCalled = true;
            BigDecimal amtloc = (BigDecimal)changeData.getNewValue();
            BigDecimal exchangerate = (BigDecimal)model.getValue("rate", changeData.getRowIndex());
            BigDecimal oriAmt = (BigDecimal)model.getValue("oriapproved", changeData.getRowIndex());
            int oriPrec = ((DynamicObject)model.getValue("currency", changeData.getRowIndex())).getInt("amtprecision");
            oriAmt = amtloc.divide(exchangerate, oriPrec, 4);
            model.setValue("oriapproved", (Object)oriAmt, changeData.getRowIndex());
            BigDecimal amtloc_old = (BigDecimal)changeData.getOldValue();
            BigDecimal addLocAmt = amtloc.subtract(amtloc_old);
            this.addRecAmt(model, addLocAmt);
        } else if ("oriapproved".equals(propertyName)) {
            if (this.hasOriapprovedCalled) {
                return;
            }
            this.hasOriapprovedCalled = true;
            BigDecimal oriAmt = (BigDecimal)changeData.getNewValue();
            BigDecimal exchangerate = (BigDecimal)model.getValue("rate", changeData.getRowIndex());
            BigDecimal amtloc = oriAmt.multiply(exchangerate);
            int oriPrec = ((DynamicObject)model.getValue("loccur")).getInt("amtprecision");
            amtloc = amtloc.setScale(oriPrec, 4);
            model.setValue("locapproved", (Object)amtloc, changeData.getRowIndex());
            this.setSumAmountValues2("oriapproved", "entries", "currency");
        } else if ("tax".equals(propertyName)) {
            BigDecimal hotelexpense = (BigDecimal)model.getValue("hotelexpense", changeData.getRowIndex());
            BigDecimal tax = (BigDecimal)changeData.getNewValue();
            BigDecimal hotelexpensewithouttax = hotelexpense.subtract(tax);
            model.setValue("hotelexpensewithouttax", (Object)hotelexpensewithouttax, changeData.getRowIndex());
        } else if ("pamountori".equals(propertyName)) {
            BigDecimal amtOri = (BigDecimal)changeData.getNewValue();
            BigDecimal payrate = (BigDecimal)model.getValue("payrate", changeData.getRowIndex());
            BigDecimal pamount = (BigDecimal)model.getValue("pamount", changeData.getRowIndex());
            int locPrec = ((DynamicObject)model.getValue("loccur")).getInt("amtprecision");
            BigDecimal amtLoc = amtOri.multiply(payrate).setScale(locPrec, 4);
            int lastCollectionentryIndex = this.getModel().getEntryRowCount("collectionentries") - 1;
            if (lastCollectionentryIndex != changeData.getRowIndex()) {
                model.setValue("pamount", (Object)amtLoc, changeData.getRowIndex());
            }
            BigDecimal oriapprovedSum = new BigDecimal("0");
            BigDecimal locapprovedSum = new BigDecimal("0");
            int entrySize = this.getModel().getEntryRowCount("entries");
            if (entrySize > 0) {
                for (int i = 0; i < entrySize; ++i) {
                    BigDecimal oriapproved = (BigDecimal)this.getModel().getValue("oriapproved", i);
                    BigDecimal locapproved = (BigDecimal)this.getModel().getValue("locapproved", i);
                    oriapprovedSum = oriapprovedSum.add(oriapproved);
                    locapprovedSum = locapprovedSum.add(locapproved);
                }
            }
            BigDecimal checkamountoriSum = new BigDecimal("0");
            BigDecimal checkamountSum = new BigDecimal("0");
            int loancheckSize = this.getModel().getEntryRowCount("loancheckentries");
            if (loancheckSize > 0) {
                for (int i = 0; i < loancheckSize; ++i) {
                    BigDecimal checkamountori = (BigDecimal)this.getModel().getValue("checkamountori", i);
                    BigDecimal checkamount = (BigDecimal)this.getModel().getValue("checkamount", i);
                    checkamountoriSum = checkamountoriSum.add(checkamountori);
                    checkamountSum = checkamountSum.add(checkamount);
                }
            }
            BigDecimal pamountoriSum = new BigDecimal("0");
            BigDecimal pamountSum = new BigDecimal("0");
            BigDecimal pamountSumNotLast = new BigDecimal("0");
            int collectionentrySize = this.getModel().getEntryRowCount("collectionentries");
            if (collectionentrySize > 0) {
                for (int i = 0; i < collectionentrySize; ++i) {
                    BigDecimal pamountori = (BigDecimal)this.getModel().getValue("pamountori", i);
                    BigDecimal pamountForSum = (BigDecimal)this.getModel().getValue("pamount", i);
                    if (i != collectionentrySize - 1) {
                        pamountSumNotLast = pamountSumNotLast.add(pamountForSum);
                    }
                    pamountoriSum = pamountoriSum.add(pamountori);
                    pamountSum = pamountSum.add(pamountForSum);
                }
            }
            if (pamountoriSum.add(checkamountoriSum).compareTo(oriapprovedSum) == 0) {
                BigDecimal approvedAndCheckDiff = locapprovedSum.subtract(checkamountSum);
                BigDecimal locapprovedDiff = approvedAndCheckDiff.subtract(pamountSumNotLast);
                model.setValue("pamount", (Object)locapprovedDiff, lastCollectionentryIndex);
            } else {
                model.setValue("pamount", (Object)amtLoc, changeData.getRowIndex());
            }
            this.setPamountOriSum();
        } else if ("checkamount".equals(propertyName)) {
            if ("1".equals(this.getPageCache().get("loanChange"))) {
                return;
            }
            if (this.hasAmtCalled) {
                return;
            }
            this.hasAmtCalled = true;
            BigDecimal amtloc_old = (BigDecimal)changeData.getOldValue();
            if (amtloc_old == null) {
                amtloc_old = BigDecimal.ZERO;
            }
            BigDecimal amtloc = (BigDecimal)changeData.getNewValue();
            DynamicObject currency = (DynamicObject)model.getValue("currency", changeData.getRowIndex());
            int oriPrec = 2;
            if (currency != null) {
                currency = BusinessDataServiceHelper.loadSingle((Object)currency.get("id"), (String)"bd_currency", (String)"id,number,name,amtprecision");
                oriPrec = currency.getInt("amtprecision");
            }
            BigDecimal oriAmt = amtloc.divide((BigDecimal)model.getValue("rate", 0), oriPrec, 4);
            if (!this.hasAmtoriCalled) {
                model.setValue("checkamountori", (Object)oriAmt, changeData.getRowIndex());
            }
            this.addRecAmt(model, BigDecimal.ZERO);
            if ("0".equals(this.getPageCache().get("loanChange"))) {
                this.getPageCache().put("loanChange", "1");
            }
        } else if ("checkamountori".equals(propertyName)) {
            if (this.hasAmtoriCalled) {
                return;
            }
            this.hasAmtoriCalled = true;
            BigDecimal rate = (BigDecimal)model.getValue("rate", 0);
            BigDecimal amtori_old = (BigDecimal)changeData.getOldValue();
            BigDecimal amtori = (BigDecimal)changeData.getNewValue();
            BigDecimal amtloc = amtori.multiply(rate).setScale(2, 4);
            if (!this.hasAmtCalled) {
                model.setValue("checkamount", (Object)amtloc, changeData.getRowIndex());
            }
            this.addRecAmt(model, BigDecimal.ZERO);
        } else if ("loanbill".equals(propertyName)) {
            this.getPageCache().put("loanChange", "0");
            DynamicObject loanbill = (DynamicObject)changeData.getNewValue();
            if (loanbill == null) {
                return;
            }
            DynamicObject loanbillOld = (DynamicObject)changeData.getOldValue();
            boolean isExist = this.isExist(Long.parseLong(loanbill.get("id").toString()), changeData.getRowIndex());
            if (isExist) {
                Object amountBalance = loanbill.get("amountbalance");
                BigDecimal rate = (BigDecimal)model.getValue("rate", 0);
                BigDecimal amtori = ((BigDecimal)amountBalance).divide(rate, 2, 4);
                model.setValue("sourcebillexpensetype", loanbill.get("expensetype"), changeData.getRowIndex());
                model.setValue("sourcebillcause", loanbill.get("cause"), changeData.getRowIndex());
                model.setValue("sourcebillamountbalance", amountBalance, changeData.getRowIndex());
                model.setValue("checkamountori", (Object)amtori, changeData.getRowIndex());
                model.setValue("checkamount", amountBalance, changeData.getRowIndex());
                model.setValue("sourcebillid", loanbill.get("easid"), changeData.getRowIndex());
                model.setValue("sourcebillentryid", loanbill.get("entryid"), changeData.getRowIndex());
            } else {
                this.getModel().setValue("loanbill", (Object)loanbillOld, changeData.getRowIndex());
            }
            this.getPageCache().put("loanChange", null);
        } else if ("pcurrency".equals(propertyName)) {
            DynamicObject currency = (DynamicObject)changeData.getNewValue();
            DynamicObject loccur = (DynamicObject)model.getValue("loccur");
            List tablePks = QueryServiceHelper.queryPrimaryKeys((String)"ssc.TaskTripReimburseBill.bd_exratetable", (String)"bd_exratetable", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"er_exchangeratetable")}, null, (int)1);
            if (tablePks != null && tablePks.size() > 0) {
                ExchangeRateService service = new ExchangeRateService();
                BigDecimal excg = service.getExchangeRate((Long)tablePks.get(0), (Long)currency.getPkValue(), (Long)loccur.getPkValue(), new Date());
                if (excg == null) {
                    excg = new BigDecimal("1.0000");
                }
                model.setValue("payrate", (Object)excg, changeData.getRowIndex());
                BigDecimal pamount = (BigDecimal)model.getValue("pamount", changeData.getRowIndex());
                int oriPrecRec = currency.getInt("amtprecision");
                BigDecimal recOriAmt = pamount.divide(excg, oriPrecRec, 4);
                model.setValue("pamountori", (Object)recOriAmt, changeData.getRowIndex());
            }
        } else if ("pamount".equals(propertyName) && (pamoutSize = this.getModel().getEntryRowCount("collectionentries")) > 0) {
            BigDecimal pamountSum = new BigDecimal("0");
            for (int i = 0; i < pamoutSize; ++i) {
                BigDecimal curPamount = (BigDecimal)this.getModel().getValue("pamount", i);
                pamountSum = pamountSum.add(curPamount);
            }
            model.setValue("amountencashed", (Object)pamountSum);
        }
    }

    protected void calcTax(IDataModel model, int rowIndex, BigDecimal amountAppproved, BigDecimal tax) {
        int oriPrec = ((DynamicObject)model.getValue("currency", rowIndex)).getInt("amtprecision");
        BigDecimal exchangerate = (BigDecimal)model.getValue("rate", rowIndex);
        BigDecimal amountwithouttax = amountAppproved.subtract(tax);
        model.setValue("hotelexpensewithouttax", (Object)amountwithouttax, rowIndex);
    }

    private void setPamountOriSum() {
        BigDecimal pamountoriForSum = this.getSKPamontoriSum();
        String sign = this.getCurrentcyTag();
        Map<String, String> floatButtomData = this.buildGradeSumData(pamountoriForSum, sign);
        this.setSumValue(floatButtomData);
    }

    private void setSumValue(Map<String, String> floatButtomData) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("collectionentries");
        entryGrid.setFloatButtomData(floatButtomData);
    }

    private Map<String, String> buildGradeSumData(BigDecimal pamountoriForSum, String sign) {
        HashMap<String, String> floatButtomData = new HashMap<String, String>();
        DecimalFormat dFormat = new DecimalFormat("###,###.00");
        floatButtomData.put("pamountori", sign + dFormat.format(pamountoriForSum));
        return floatButtomData;
    }

    private String getCurrentcyTag() {
        DynamicObject currencyDyObj = (DynamicObject)this.getModel().getValue("currency");
        String sign = currencyDyObj.get("sign").toString();
        return sign;
    }

    private BigDecimal getSKPamontoriSum() {
        BigDecimal pamountoriForSum = new BigDecimal("0");
        int collectionentrySizeForSum = this.getModel().getEntryRowCount("collectionentries");
        if (collectionentrySizeForSum > 0) {
            for (int i = 0; i < collectionentrySizeForSum; ++i) {
                BigDecimal pamountori = (BigDecimal)this.getModel().getValue("pamountori", i);
                pamountoriForSum = pamountoriForSum.add(pamountori);
            }
        }
        return pamountoriForSum;
    }

    private boolean isExist(long loanbillID, int index) {
        int loancheckentriesCount = this.getModel().getEntryRowCount("loancheckentries");
        for (int i = 0; i < loancheckentriesCount; ++i) {
            long id;
            DynamicObject obj = (DynamicObject)this.getModel().getValue("loanbill", i);
            if (index == i || obj == null || loanbillID != (id = ((Long)obj.get("id")).longValue())) continue;
            this.getView().showMessage(ResManager.loadKDString((String)"\u501f\u6b3e\u5355\u53f7\u5df2\u5f55\u5165\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"TaskTripReimburseBill_3", (String)"ssc-task-ext", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void autoAddPropertyChangeDeep() {
        String propertyChangeDeepObj = this.getPageCache().get("PROPERTYCHANGEDEEP");
        Integer propertyChangeDeepInt = 0;
        if (propertyChangeDeepObj == null) {
            Integer n = propertyChangeDeepInt;
            Integer n2 = propertyChangeDeepInt = Integer.valueOf(propertyChangeDeepInt + 1);
        } else {
            Integer n = propertyChangeDeepInt = Integer.valueOf(propertyChangeDeepObj);
            Integer n3 = propertyChangeDeepInt = Integer.valueOf(propertyChangeDeepInt + 1);
        }
        this.getPageCache().put("PROPERTYCHANGEDEEP", propertyChangeDeepInt.toString());
        ++this.add;
    }

    private void autosubPropertyChangeDeep(IDataModel model) {
        Integer propertyChangeDeepInt;
        String propertyChangeDeepObj = this.getPageCache().get("PROPERTYCHANGEDEEP");
        Integer n = propertyChangeDeepInt = Integer.valueOf(propertyChangeDeepObj);
        Integer n2 = propertyChangeDeepInt = Integer.valueOf(propertyChangeDeepInt - 1);
        if (propertyChangeDeepInt == 0) {
            this.calAmountencashed(model);
        }
        this.getPageCache().put("PROPERTYCHANGEDEEP", propertyChangeDeepInt.toString());
        ++this.sub;
    }

    private void calAmountencashed(IDataModel model) {
        int pamoutSize = this.getModel().getEntryRowCount("collectionentries");
        if (pamoutSize > 0) {
            BigDecimal pamountSum = new BigDecimal("0");
            for (int i = 0; i < pamoutSize; ++i) {
                BigDecimal curPamount = (BigDecimal)this.getModel().getValue("pamount", i);
                pamountSum = pamountSum.add(curPamount);
            }
            model.setValue("amountencashed", (Object)pamountSum);
        }
    }

    private void addRecAmt(IDataModel model, BigDecimal addLocAmt) {
        if (this.getModel().getEntryRowCount("collectionentries") == 1) {
            BigDecimal amountapprovedoriSum = this.getAmountapprovedoriSum();
            BigDecimal checkamountoriSum = this.getCheckamountori();
            BigDecimal pamountoriSum = amountapprovedoriSum.subtract(checkamountoriSum);
            model.setValue("pamountori", (Object)pamountoriSum, 0);
        }
    }

    private BigDecimal getAmountapprovedoriSum() {
        int entriesSize = this.getModel().getEntryRowCount("entries");
        BigDecimal amountapprovedoriSum = BigDecimal.ZERO;
        if (entriesSize > 0) {
            for (int i = 0; i < entriesSize; ++i) {
                if (!this.getModel().getValue("monthlybalance", i).toString().equals("false")) continue;
                BigDecimal amountapprovedori = (BigDecimal)this.getModel().getValue("oriapproved", i);
                amountapprovedoriSum = amountapprovedoriSum.add(amountapprovedori);
            }
        }
        return amountapprovedoriSum;
    }

    private BigDecimal getCheckamountori() {
        int loancheckentriesSize = this.getModel().getEntryRowCount("loancheckentries");
        BigDecimal checkamountoriSum = BigDecimal.ZERO;
        if (loancheckentriesSize > 0) {
            for (int i = 0; i < loancheckentriesSize; ++i) {
                BigDecimal checkamountori = (BigDecimal)this.getModel().getValue("checkamountori", i);
                checkamountoriSum = checkamountoriSum.add(checkamountori);
            }
        }
        return checkamountoriSum;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit edit = (BasedataEdit)e.getSource();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject oldValue = (DynamicObject)e.getOriginalValue();
        if ("loanbill".equals(edit.getKey())) {
            showParameter.getListFilterParameter().setFilter(new QFilter("billtype", "=", (Object)ResManager.loadKDString((String)"\u51fa\u5dee\u501f\u6b3e\u5355", (String)"TaskTripReimburseBill_4", (String)"ssc-task-ext", (Object[])new Object[0])).and(new QFilter("sourcetype", "=", (Object)"1").and(new QFilter("applier", "=", (Object)this.getPageCache().get("applierid")))));
        } else if ("expensetype".equals(edit.getKey())) {
            showParameter.setMultiSelect(false);
        } else if ("paymode1".equals(edit.getKey())) {
            showParameter.setMultiSelect(false);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        EntryProp p = e.getEntryProp();
        if ("loancheckentries".equals(p.getName())) {
            IDataModel model = this.getModel();
            int entriesCnt = model.getEntryRowCount("entries");
            BigDecimal total = BigDecimal.ZERO;
            for (int i = 0; i < entriesCnt; ++i) {
                BigDecimal amountapproved = (BigDecimal)model.getValue("locapproved", i);
                total = total.add(amountapproved);
            }
            int loancheckentriesCnt = model.getEntryRowCount("loancheckentries");
            BigDecimal totalLoan = BigDecimal.ZERO;
            for (int i = 0; i < loancheckentriesCnt; ++i) {
                BigDecimal checkamount = (BigDecimal)model.getValue("checkamount", i);
                totalLoan = totalLoan.add(checkamount);
            }
            BigDecimal recAmt = total.subtract(totalLoan);
            int collectionentriesCnt = model.getEntryRowCount("collectionentries");
            if (collectionentriesCnt > 0) {
                for (int i = 1; i < collectionentriesCnt; ++i) {
                    BigDecimal pamount = (BigDecimal)model.getValue("pamount", i);
                    recAmt = recAmt.subtract(pamount);
                }
            }
            BigDecimal payrate = (BigDecimal)model.getValue("payrate", 0);
            int oriPrecRec = ((DynamicObject)model.getValue("currency", 0)).getInt("amtprecision");
            BigDecimal recOriAmt = recAmt.divide(payrate, oriPrecRec, 4);
            model.setValue("pamountori", (Object)recOriAmt, 0);
            BigDecimal totalrec = BigDecimal.ZERO;
            for (int i = 0; i < collectionentriesCnt; ++i) {
                BigDecimal pamount = (BigDecimal)model.getValue("pamount", i);
                totalrec = totalrec.add(pamount);
            }
            this.addRecAmt(model, BigDecimal.ZERO);
        }
    }

    private void setSumAmountValues2(String keyValues, String keyEntry, String currencySign) {
        BigDecimal valueSum = new BigDecimal("0.00");
        DecimalFormat dFormat = new DecimalFormat("###,###.00");
        int sizeForSum = this.getModel().getEntryRowCount(keyEntry);
        String sign = "\uffe5";
        if (sizeForSum > 0) {
            for (int i = 0; i < sizeForSum; ++i) {
                BigDecimal tmp = (BigDecimal)this.getModel().getValue(keyValues, i);
                valueSum = valueSum.add(tmp);
            }
            sign = ((DynamicObject)this.getModel().getValue(currencySign, 0)).get("sign").toString();
        }
        HashMap<String, String> floatButtomData = new HashMap<String, String>();
        floatButtomData.put(keyValues, sign + dFormat.format(valueSum));
        EntryGrid entryGrid = (EntryGrid)this.getControl(keyEntry);
        entryGrid.setFloatButtomData(floatButtomData);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperlinkclickevent) {
        String fieldName = hyperlinkclickevent.getFieldName();
        if ("ordernum".equalsIgnoreCase(fieldName)) {
            this.showPlaneForm(hyperlinkclickevent.getRowIndex());
        }
    }
}

