/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.extendplugin.base;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.ssc.task.ErpFactory;
import kd.ssc.task.util.ObjectCloneUtil;

public abstract class TaskExtendBill
extends AbstractBillPlugIn
implements UploadListener {
    private static final Log log = LogFactory.getLog(TaskExtendBill.class);

    public void initialize() {
        super.initialize();
        AttachmentPanel atth = (AttachmentPanel)this.getControl(this.getAttachmentPanelKey());
        atth.addUploadListener((UploadListener)this);
    }

    public void loadData(LoadDataEventArgs e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String bizdata = (String)formShowParameter.getCustomParams().get("bizdata");
        if (bizdata != null) {
            DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)this.getModel().getDataEntityType());
            binder.setIgnoreCase(true);
            DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
            DynamicObject dataEntity = (DynamicObject)jser.deserializeFromString(bizdata, null);
            dataEntity.set("id", formShowParameter.getCustomParams().get("billID"));
            e.setDataEntity(dataEntity);
        }
    }

    public void createNewData(BizDataEventArgs e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String bizdata = (String)formShowParameter.getCustomParams().get("bizdata");
        if (bizdata != null) {
            DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)this.getModel().getDataEntityType());
            binder.setIgnoreCase(true);
            DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
            DynamicObject dataEntity = (DynamicObject)jser.deserializeFromString(bizdata, null);
            dataEntity.set("id", formShowParameter.getCustomParams().get("billID"));
            e.setDataEntity((Object)dataEntity);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.getModel().createNewData();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String billid = (String)formShowParameter.getCustomParams().get("billID");
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        List data = AttachmentServiceHelper.getAttachments((String)dataEntityType.getName(), (Object)billid, (String)"attachmentpanel");
        if (data != null) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.setEntryProperty(this.getAttachmentPanelKey(), "data", (Object)data);
            this.getView().setVisible(Boolean.TRUE, new String[]{this.getAttachmentPanelKey()});
        }
    }

    protected void setFieldEditEnable(boolean enable, int rowindex, String ... keys) {
        String[] arg2 = (String[])ObjectCloneUtil.cloneObject((Object)keys);
        int arg3 = keys.length;
        for (int arg4 = 0; arg4 < arg3; ++arg4) {
            String key = arg2[arg4];
            FieldEdit field = (FieldEdit)this.getControl(key);
            field.setEnable(key, enable, rowindex);
        }
    }

    protected String getAttachmentPanelKey() {
        return "attachmentpanel";
    }

    public void upload(UploadEvent arg0) {
    }

    public void remove(UploadEvent arg0) {
        Object[] urls = arg0.getUrls();
        ORM orm = ORM.create();
        for (Object obj : urls) {
            Map map = (Map)obj;
            String formID = this.getView().getEntityId();
            Object pkObj = this.getModel().getDataEntity().getPkValue();
            String attachmentName = (String)map.get("name");
            DynamicObject atth = orm.queryOne("bos_attachment", new QFilter[]{new QFilter("fattachmentname", "=", (Object)attachmentName).or(new QFilter("FInterID", "=", pkObj)), new QFilter("FBillType", "=", (Object)formID)});
            if (atth == null) continue;
            try {
                HashMap syncParam = new HashMap();
                log.info("kd.ssc.task.extendplugin.base.TaskExtendBill.remove attachmentID:" + (Long)atth.getPkValue() + ";externalBillID:" + (String)this.getView().getFormShowParameter().getCustomParams().get("billID") + ";syncParam" + syncParam);
                ErpFactory.getTaskFacade((String)"eas").synAttachmentToExternal("delete", ((Long)atth.getPkValue()).longValue(), (String)this.getView().getFormShowParameter().getCustomParams().get("billID"), syncParam);
                log.info("kd.ssc.task.extendplugin.base.TaskExtendBill.remove end");
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u5220\u9664\u9644\u4ef6\u51fa\u9519", (Throwable)e);
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u5220\u9664\u9644\u4ef6\u51fa\u9519\uff1a%s\u3002", (String)"TaskExtendBill_0", (String)"ssc-task-ext", (Object[])new Object[0]), e.getMessage()));
            }
        }
    }

    public void afterUpload(UploadEvent arg0) {
        Set<String> set = this.buildUploadingFilte(arg0);
        DynamicObjectCollection attchColl = this.uploadAttchment();
        this.synchronizdToEAS(set, attchColl);
    }

    private void synchronizdToEAS(Set<String> set, DynamicObjectCollection attchColl) {
        for (DynamicObject obj : attchColl) {
            String attachmentName = (String)obj.get("fattachmentname");
            if (!set.contains(attachmentName)) continue;
            HashMap syncParam = new HashMap();
            try {
                log.info("kd.ssc.task.extendplugin.base.TaskExtendBill.synchronizdToEAS attachmentID :" + (Long)obj.getPkValue() + ";externalBillID:" + (String)this.getView().getFormShowParameter().getCustomParams().get("billID") + ";syncParam" + syncParam);
                ErpFactory.getTaskFacade((String)"eas").synAttachmentToExternal("add", ((Long)obj.getPkValue()).longValue(), (String)this.getView().getFormShowParameter().getCustomParams().get("billID"), syncParam);
                log.info("kd.ssc.task.extendplugin.base.TaskExtendBill.synchronizdToEAS end");
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u9644\u4ef6\u51fa\u9519", (Throwable)e);
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u9644\u4ef6\u51fa\u9519\uff1a%s", (String)"TaskExtendBill_1", (String)"ssc-task-ext", (Object[])new Object[0]), e.getMessage()));
            }
        }
    }

    private Set<String> buildUploadingFilte(UploadEvent arg0) {
        Object[] urls = arg0.getUrls();
        if (urls == null) {
            return new HashSet<String>();
        }
        HashSet<String> set = new HashSet<String>(urls.length);
        for (Object obj : urls) {
            Map map = (Map)obj;
            set.add(map.get("name").toString());
        }
        return set;
    }

    private DynamicObjectCollection uploadAttchment() {
        IFormView iView = this.getView();
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        String attInfoString = cache.get("TampAttCache" + iView.getPageId());
        Map attInfo = (Map)SerializationUtils.fromJsonString((String)attInfoString, Map.class);
        String formId = iView.getFormShowParameter().getFormId();
        Object pkValue = iView.getModel().getDataEntity().getPkValue();
        String appId = iView.getFormShowParameter().getFormConfig().getAppId();
        DynamicObjectCollection attchColl = AttachmentServiceHelper.saveTempAttachments((String)formId, (Object)pkValue, (String)appId, (Map)attInfo);
        cache.remove("TampAttCache" + iView.getPageId());
        return attchColl;
    }

    public void afterRemove(UploadEvent arg0) {
    }

    protected void setFieldEditVisible(boolean visible, String ... keys) {
        for (String key : keys) {
            FieldEdit field = (FieldEdit)this.getControl(key);
            field.setVisible(key, visible);
        }
    }

    protected void setFieldEditEnable(boolean enable, String ... keys) {
        for (String key : keys) {
            FieldEdit field = (FieldEdit)this.getControl(key);
            field.setEnable(key, enable, -1);
        }
    }
}

