/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.common.util;

import java.io.ByteArrayOutputStream;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import kd.sdk.annotation.SdkDeprecated;
import kd.sys.ricc.common.util.setter.D;
import kd.sys.ricc.exception.RiccBizException;

@SdkDeprecated
public class StringUtils {
    private static final Pattern BLANK_PATTERN = Pattern.compile("\\s*|\t|\r|\n");
    public static final String EMPTY = "";

    private StringUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isNotEmpty(String value) {
        return !StringUtils.isEmpty(value);
    }

    public static String trim(String s, String defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        return (s = s.trim()).length() == 0 ? defaultValue : s;
    }

    public static String join(Collection<?> c, String seperator) {
        StringBuilder sb = new StringBuilder(c.size() * 8);
        for (Object o : c) {
            if (sb.length() > 0) {
                sb.append(seperator);
            }
            sb.append(o);
        }
        return sb.toString();
    }

    public static String join(Object[] c, String seperator) {
        StringBuilder sb = new StringBuilder(c.length * 8);
        for (Object o : c) {
            if (sb.length() > 0) {
                sb.append(seperator);
            }
            sb.append(o);
        }
        return sb.toString();
    }

    public static boolean equals(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }

    public static String toString(Object key) {
        return key == null ? "null" : key.toString();
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs != null && (strLen = cs.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(cs.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean isBlank(Object cs) {
        if (!(cs instanceof Iterable) && !(cs instanceof Map)) {
            if (cs == null) {
                return true;
            }
            return StringUtils.isBlank(cs.toString());
        }
        return false;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }

    public static boolean isNotBlank(Object cs) {
        return !StringUtils.isBlank(cs);
    }

    public static String getMessage(Throwable e) {
        String s = D.s(e.getMessage());
        if (s == null) {
            s = e.getClass().getName();
        }
        return s;
    }

    public static String replaceBlank(String str) {
        String dest = EMPTY;
        if (str != null) {
            Matcher m = BLANK_PATTERN.matcher(str);
            dest = m.replaceAll(EMPTY);
        }
        return dest;
    }

    public static boolean isUrl(String url) {
        if (StringUtils.isEmpty(url) || url.trim().contains(" ")) {
            return false;
        }
        String str = "https?://(www\\.)?[-a-zA-Z0-9@:%._+~#=]{1,256}\\.[a-zA-Z0-9()]{1,6}\\b([-a-zA-Z0-9()@:%_+.~#?&/=]*)";
        Pattern p = Pattern.compile(str);
        Matcher m = p.matcher(url.toLowerCase().trim());
        return m.matches();
    }

    public static boolean isNumeric(CharSequence cs) {
        if (cs == null || EMPTY.equals(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isPhone(String phoneStr) {
        if (StringUtils.isEmpty(phoneStr)) {
            return false;
        }
        String expression = "(^[+](\\d{1,3})?\\-s?(13|14|15|16|17|18|19)[0-9]{9}$)|((^(13|14|15|16|17|18|19)[0-9]{9}$)|(^0[1,2]{1}\\d{1}-?\\d{8}$)|(^0[3-9] {1}\\d{2}-?\\d{7,8}$)|(^0[1,2]{1}\\d{1}-?\\d{8}-(\\d{1,4})$)|(^0[3-9]{1}\\d{2}-? \\d{7,8}-(\\d{1,4})$))";
        Pattern pattern = Pattern.compile(expression);
        Matcher matcher = pattern.matcher(phoneStr.trim());
        return matcher.matches();
    }

    public static String limitStringLength(int filterDescLimit, String inputExpression) {
        if (inputExpression.length() > filterDescLimit) {
            inputExpression = inputExpression.substring(0, filterDescLimit);
        }
        return inputExpression;
    }

    public static String compressString(String str) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
            gzipOutputStream.write(str.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new RiccBizException(e.getMessage());
        }
        String codeParam = Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
        return codeParam;
    }
}

