/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.common.util.setter;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.setter.D;
import kd.sys.ricc.common.util.setter.PropSetterFactory;
import kd.sys.ricc.common.util.setter.Setter;
import kd.sys.ricc.exception.RiccBizException;

public class SQLUtil {
    private SQLUtil() {
    }

    public static String toPlainRequires(String entity, String parent, Map<String, Object> requires) {
        HashMap<String, Object> dbRequires = new HashMap<String, Object>();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
        SQLUtil.filterRequires((IDataEntityType)entityType, dbRequires, requires);
        Set<String> set = SQLUtil.innerPlainRequires((DynamicObjectType)entityType, parent, dbRequires);
        return StringUtils.join(set, ",");
    }

    public static void filterRequires(IDataEntityType type, Map<String, Object> dbRequires, Map<String, Object> requires) {
        DataEntityPropertyCollection properties = type.getProperties();
        Iterator<String> iterator = requires.keySet().iterator();
        while (iterator.hasNext()) {
            String name = iterator.next();
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)name);
            if (property == null || !SQLUtil.isEntryProp(property) && D.s(property.getAlias()) == null) continue;
            try {
                Setter setter = PropSetterFactory.createSetter(property);
                setter.setRequiresMap(name, dbRequires, requires);
            }
            catch (Exception e) {
                String text = String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u7684\u53d6\u6570\u8bbe\u7f6e\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u539f\u56e0\uff1a%2$s", (String)"SQLUtil_5", (String)"sys-ricc-common", (Object[])new Object[0]), name, CommonUtil.getExceptionDetailInfo(e));
                throw new RiccBizException(text, e);
            }
        }
        return;
    }

    private static boolean isEntryProp(IDataEntityProperty property) {
        return property instanceof EntryProp && D.s(((EntryProp)property).getDynamicCollectionItemPropertyType().getAlias()) != null;
    }

    private static Set<String> innerPlainRequires(DynamicObjectType entityType, String parent, Map<String, Object> requires) {
        HashSet<String> set = new HashSet<String>();
        Iterator<Map.Entry<String, Object>> iterator = requires.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String field = entry.getKey();
            String fullField = parent == null ? field : parent + "." + field;
            Object value = entry.getValue();
            DynamicProperty property = entityType.getProperty(field);
            if (property == null) continue;
            if (property instanceof MulBasedataProp) {
                SQLUtil.setMulBaseDataRequires(property, set, fullField, value);
                continue;
            }
            if (value instanceof Map && !(property instanceof MuliLangTextProp)) {
                Map childRequires = (Map)value;
                childRequires.put("id", 1);
                DynamicObjectType type = null;
                if (property instanceof EntryProp) {
                    type = ((EntryProp)property).getDynamicCollectionItemPropertyType();
                } else if (property instanceof BasedataProp) {
                    String name = ((BasedataProp)property).getDynamicComplexPropertyType().getName();
                    type = MetadataServiceHelper.getDataEntityType((String)name);
                } else {
                    type = entityType;
                }
                set.addAll(SQLUtil.innerPlainRequires(type, fullField, childRequires));
                continue;
            }
            set.add(fullField);
        }
        return set;
    }

    private static void setMulBaseDataRequires(DynamicProperty property, Set<String> set, String fullField, Object value) {
        if (value instanceof Map) {
            throw new RiccBizException(ResManager.loadKDString((String)"\u591a\u9009\u57fa\u7840\u8d44\u6599\u4e3a\u591a\u503c\uff0c\u4e0d\u652f\u6301\u53d6\u5f15\u7528\u5c5e\u6027\u3002", (String)"SQLUtil_6", (String)"sys-ricc-common", (Object[])new Object[0]));
        }
        if (property instanceof AttachmentProp) {
            set.add(fullField + ".fpkid");
            set.add(fullField + ".fbasedataid");
        } else {
            set.add(fullField + ".pkid");
            set.add(fullField + ".fbasedataid.id");
        }
    }
}

