/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.core.impl.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.print.business.metedata.service.migrate.PrintTplImpExp;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.sys.ricc.business.datapacket.core.ISubDataPacket;
import kd.sys.ricc.business.datapacket.core.helper.DataPacketHelper;
import kd.sys.ricc.business.datapacket.core.model.SdpInputParams;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;
import kd.sys.ricc.business.datapacket.schedule.AddPacketProgress;
import kd.sys.ricc.business.schedule.ScheduleUtil;
import kd.sys.ricc.common.constant.CommonConstant;
import kd.sys.ricc.common.util.StringUtils;

public class PrintTplImpl
implements ISubDataPacket {
    private static final Log logger = LogFactory.getLog(PrintTplImpl.class);
    private static final String BOS_MANAGE_PRINT_TPL = "bos_manageprinttpl";
    private static final String PRINT_TPL_ID_ID = "printtplid_id";
    private final PrintTplImpExp tplImpExp = new PrintTplImpExp();
    private static final String PRINT_EXPORT_PERM = "2/B5HI/S4MOW";
    private static final String PRINT_IMPORT_PERM = "2/B541DS7VZW";

    /*
     * WARNING - void declaration
     */
    public SdpOutputParams exportPacket(SdpInputParams sdpInputParams) {
        void var16_20;
        Map printDatas;
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        Map customParam = sdpInputParams.getParam();
        String entityName = (String)customParam.get("entityname");
        String appId = (String)customParam.get("bizappid");
        boolean hashPermissions = DataPacketHelper.checkPermissions(UserServiceHelper.getCurrentUserId(), appId, BOS_MANAGE_PRINT_TPL, entityName, sdpOutputParams, PRINT_EXPORT_PERM);
        if (!hashPermissions) {
            sdpOutputParams.setSuccess(false);
            return sdpOutputParams;
        }
        ArrayList<String> tplidList = new ArrayList<String>(10);
        Object[] primaryKeyValues = sdpInputParams.getSelectRows().getPrimaryKeyValues();
        AddPacketProgress addPacketProgress = sdpInputParams.getAddPacketProgress();
        boolean isFullExport = false;
        if (primaryKeyValues.length <= 0) {
            isFullExport = true;
        }
        QFilter newTplFilter = new QFilter("type", "=", (Object)"B");
        if (isFullExport) {
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(1);
            String filter = DataPacketHelper.getFilters(customParam);
            if (filter != null) {
                QFilter qFilter = QFilter.fromSerializedString((String)filter);
                qFilterList.add(qFilter);
            }
            printDatas = BusinessDataServiceHelper.loadFromCache((String)BOS_MANAGE_PRINT_TPL, (String)"printtplid.id, printtplid.number, printtplid.name", (QFilter[])qFilterList.toArray(new QFilter[0]));
        } else {
            printDatas = BusinessDataServiceHelper.loadFromCache((String)BOS_MANAGE_PRINT_TPL, (String)"printtplid.id, printtplid.number, printtplid.name", (QFilter[])newTplFilter.and("id", "in", (Object)primaryKeyValues).toArray());
            if (primaryKeyValues.length > printDatas.size()) {
                logger.error("\u52fe\u9009\u6570\u636e\u5b58\u5728\u65e7\u6a21\u677f\uff0c\u65e7\u6a21\u677f\u4e0d\u652f\u6301\u5bfc\u51fa\u3002");
                sdpOutputParams.append(ResManager.loadKDString((String)"\u52fe\u9009\u6570\u636e\u5b58\u5728\u65e7\u6a21\u677f\uff0c\u65e7\u6a21\u677f\u4e0d\u652f\u6301\u5bfc\u51fa\u3002", (String)"PrintTplImpl_0", (String)"sys-ricc-business", (Object[])new Object[0]));
                return sdpOutputParams;
            }
        }
        StringBuilder selectedInfo = new StringBuilder(String.format(CommonConstant.getSelectedTitle(), entityName, entityName));
        int i = 1;
        for (Map.Entry entry : printDatas.entrySet()) {
            DynamicObject entryValue = (DynamicObject)entry.getValue();
            tplidList.add(entryValue.getString(PRINT_TPL_ID_ID));
            DynamicObject printtplInfo = entryValue.getDynamicObject("printtplid");
            if (printtplInfo == null) continue;
            selectedInfo.append(String.format("%1$s\t\t%2$s\t\t%3$s %n", i++, printtplInfo.getString("number"), printtplInfo.getString("name")));
        }
        sdpOutputParams.setSelectedInfo(selectedInfo.toString());
        String locafile = sdpInputParams.getLocalPath() + File.separator + System.currentTimeMillis() + ".zip";
        Object var16_18 = null;
        try {
            String url = this.tplImpExp.doExport(tplidList, 5000);
            URI urlY = new URI(url);
            String queryStr = urlY.getQuery();
            String taskId = this.parseQueryParameter(queryStr, "taskId");
            PrtAttach attach = BosPrintServiceHelper.getPrtAttach((String)taskId);
            List attachDetails = attach.getAttachDetail();
            if (!CollectionUtils.isEmpty((Collection)attachDetails)) {
                String string = ((PrtAttach.AttachDetail)attachDetails.get(0)).getFilePath();
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            sdpOutputParams.append(ResManager.loadKDString((String)"\u6253\u5370\u6a21\u677f\u5bfc\u51fa\u5f02\u5e38\u3002", (String)"PrintTplImpl_1", (String)"sys-ricc-business", (Object[])new Object[0]), (Throwable)e);
        }
        if (StringUtils.isBlank((CharSequence)var16_20)) {
            sdpOutputParams.setSuccess(false);
            return sdpOutputParams;
        }
        try (InputStream inStream = BosPrintServiceHelper.getFileInputStream((String)var16_20);
             FileOutputStream fileOutputStream = new FileOutputStream(locafile);){
            int read;
            byte[] bytes = new byte[1024];
            while ((read = inStream.read(bytes)) != -1) {
                fileOutputStream.write(bytes, 0, read);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            sdpOutputParams.append(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6253\u5370\u6a21\u677f\u51fa\u73b0\u5f02\u5e38\u3002", (String)"PrintTplImpl_2", (String)"sys-ricc-business", (Object[])new Object[0]), (Throwable)e);
        }
        boolean success = sdpOutputParams.getError().length() <= 0;
        sdpOutputParams.setSuccess(success);
        sdpOutputParams.setExportFilePath(locafile);
        ScheduleUtil.addPacketFeedbackProgress((AddPacketProgress)addPacketProgress, (int)sdpInputParams.getSelectRows().size(), (int)sdpInputParams.getSelectRows().size());
        return sdpOutputParams;
    }

    private String parseQueryParameter(String query, String paramName) {
        String[] pairs;
        if (query == null || paramName == null) {
            return null;
        }
        for (String pair : pairs = query.split("&")) {
            String name;
            int idx = pair.indexOf("=");
            if (idx <= 0 || !(name = pair.substring(0, idx)).equals(paramName)) continue;
            return pair.substring(idx + 1);
        }
        return null;
    }

    public SdpOutputParams importPacket(SdpInputParams sdpInputParams) {
        Map inputParam = sdpInputParams.getParam();
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        DynamicObject guide = (DynamicObject)inputParam.get("guideInfo");
        String entityName = guide.getString("name");
        String appId = guide.getString("page.bizappid");
        boolean hashPermissions = DataPacketHelper.checkPermissions(UserServiceHelper.getCurrentUserId(), appId, BOS_MANAGE_PRINT_TPL, entityName, sdpOutputParams, "47150e89000000ac", PRINT_IMPORT_PERM);
        if (!hashPermissions) {
            sdpOutputParams.setSuccess(false);
            return sdpOutputParams;
        }
        String fileUrl = (String)inputParam.get("fileUrl");
        PrintTplImpExp impExpService = new PrintTplImpExp();
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        try (InputStream inputStream = fileService.getInputStream(fileUrl);){
            String showMsg;
            Map result = impExpService.doImport(inputStream);
            int success = (Integer)result.get("success");
            int count = (Integer)result.get("count");
            List errMsg = (List)result.get("message");
            if (count == 0) {
                showMsg = ResManager.loadKDString((String)"\u6253\u5370\u6a21\u677f\u89e3\u6790\u5931\u8d25\uff01%s", (String)"PrintTplImpl_3", (String)"sys-ricc-business", (Object[])new Object[0]);
                showMsg = String.format(showMsg, StringUtils.join((Object[])errMsg.toArray(), (String)"\n"));
                sdpOutputParams.append(showMsg);
            }
            if (success != count) {
                showMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u5b8c\u6210\uff0c\u5171%1$s\u4e2a\u6a21\u677f\uff0c\u5bfc\u5165\u6210\u529f%2$s\u4e2a\u3002\u5931\u8d25\u539f\u56e0\uff1a\n%3$s", (String)"PrintTplImpl_6", (String)"sys-ricc-business", (Object[])new Object[0]);
                showMsg = String.format(showMsg, count, success, StringUtils.join((Object[])errMsg.toArray(), (String)"\n"));
                sdpOutputParams.append(showMsg);
            }
            HashMap<String, Integer> param = new HashMap<String, Integer>(2);
            param.put("successCount", success);
            param.put("failedCount", count - success);
            sdpOutputParams.setParam(param);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            sdpOutputParams.append(ResManager.loadKDString((String)"\u6253\u5370\u6a21\u677f\u5bfc\u5165\u51fa\u73b0\u5f02\u5e38\u3002", (String)"PrintTplImpl_5", (String)"sys-ricc-business", (Object[])new Object[0]), (Throwable)e);
        }
        boolean success = sdpOutputParams.getError().length() <= 0;
        sdpOutputParams.setSuccess(success);
        return sdpOutputParams;
    }
}

