/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.api.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.lang.Lang;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sys.ricc.api.IRiccObtainDataService;
import kd.sys.ricc.common.helper.DataCompareHelper;
import kd.sys.ricc.common.util.DynamicObjectUtil;
import kd.sys.ricc.common.util.PermissionUtil;
import kd.sys.ricc.common.util.StringUtils;

public class CompareGetDataApiServiceImpl
implements IRiccObtainDataService {
    @Override
    public CustomApiResult<Object> obtainData(Map<String, Object> params) {
        RequestContext.getOrCreate().setLang(Lang.from((String)((String)params.get("lang"))));
        String filter = (String)params.get("filter");
        String itemEntityNumber = (String)params.get("itemEntityNumber");
        if (StringUtils.isBlank((CharSequence)filter) || StringUtils.isBlank((CharSequence)itemEntityNumber)) {
            String errorMsg = ResManager.loadKDString((String)"\u6570\u636e\u5bf9\u6bd4\u67e5\u8be2\u76ee\u6807\u73af\u5883\u5931\u8d25\uff0c\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CompareGetDataApiServiceImpl_0", (String)"sys-ricc-platform", (Object[])new Object[0]);
            return CustomApiResult.fail((String)"ParamError", (String)errorMsg);
        }
        DynamicObject runtimeMetaInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)itemEntityNumber)});
        if (runtimeMetaInfo == null) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u5bf9\u6bd4\u67e5\u8be2\u76ee\u6807\u73af\u5883\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u7f16\u7801\u4e3a%s\u7684\u5143\u6570\u636e\u3002", (String)"CompareGetDataApiServiceImpl_1", (String)"sys-ricc-platform", (Object[])new Object[0]), itemEntityNumber);
            return CustomApiResult.fail((String)"FormNotFound", (String)errorMsg);
        }
        boolean hasQueryPer = PermissionUtil.checkPagePermission((String)itemEntityNumber, (String)"47150e89000000ac");
        if (!hasQueryPer) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u5bf9\u6bd4\u67e5\u8be2\u76ee\u6807\u73af\u5883\u5931\u8d25\uff0c\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u7528\u6237\u6ca1\u6709%s\u7684\u67e5\u8be2\u6743\u9650\uff0c\u65e0\u6cd5\u6267\u884c\u5bf9\u6bd4\u3002", (String)"CompareGetDataApiServiceImpl_2", (String)"sys-ricc-platform", (Object[])new Object[0]), itemEntityNumber);
            return CustomApiResult.fail((String)"NoQueryPerm", (String)errorMsg);
        }
        QFilter qFilter = null;
        try {
            qFilter = QFilter.fromSerializedString((String)filter);
        }
        catch (Exception e) {
            String errorMsg = ResManager.loadKDString((String)"\u6570\u636e\u5bf9\u6bd4\u67e5\u8be2\u76ee\u6807\u73af\u5883\u5931\u8d25\uff0c\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CompareGetDataApiServiceImpl_0", (String)"sys-ricc-platform", (Object[])new Object[0]);
            return CustomApiResult.fail((String)"NoQueryPerm", (String)errorMsg);
        }
        Map targetDataMap = BusinessDataServiceHelper.loadFromCache((String)itemEntityNumber, (QFilter[])qFilter.toArray());
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)itemEntityNumber);
        DataEntityPropertyCollection properties = entityType.getProperties();
        Map<String, Object> compareRequiresPropMap = DataCompareHelper.getCompareRequiresPropMap(properties);
        List data = targetDataMap.values().stream().map(dyo -> DynamicObjectUtil.object2Map((DynamicObject)dyo, (Map)compareRequiresPropMap)).collect(Collectors.toList());
        String result = JSON.toJSONStringWithDateFormat(data, (String)"yyyy-MM-dd HH:mm:ss.SSS", (SerializerFeature[])new SerializerFeature[0]);
        return CustomApiResult.success((Object)result);
    }
}

