/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sys.ricc.business.configitem.ConfigItemHelper;
import kd.sys.ricc.business.datapacket.core.ISubDataPacket;
import kd.sys.ricc.business.datapacket.core.impl.impt.ExcelDataPacketImpl;
import kd.sys.ricc.business.datapacket.core.impl.json.JsonDataPacketImpl;
import kd.sys.ricc.business.datapacket.core.impl.microservice.MicroServiceImpl;
import kd.sys.ricc.business.datapacket.core.model.SdpInputParams;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;
import kd.sys.ricc.business.datapacket.helper.DataPacketHelper;
import kd.sys.ricc.business.datapacket.schedule.AddPacketProgress;
import kd.sys.ricc.business.impt.ImportParamAdapter;
import kd.sys.ricc.common.constant.CommonConstant;
import kd.sys.ricc.common.enums.DataPacketTypeEnum;
import kd.sys.ricc.common.enums.PacketEntryStatusEnum;
import kd.sys.ricc.common.query.CommonQuery;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.SysParaUtil;
import kd.sys.ricc.exception.RiccBizException;

public class SubDataPacketDispatch {
    private static final Log logger = LogFactory.getLog(SubDataPacketDispatch.class);
    private static final String SERIALIZED_PLUGIN = JsonDataPacketImpl.class.getName();
    private static final String STANDARD_PLUGIN = ExcelDataPacketImpl.class.getName();
    private static final String MICROSERVICE_PLUGIN = MicroServiceImpl.class.getName();
    private static final String IMPORT_TYPE = "importtype";
    private static final String ENTITY_NUMBER = "entity_number";
    private static final String ID_LIST = "id_list";

    private SubDataPacketDispatch() {
        throw new IllegalStateException("Utility class");
    }

    public static String getNotFoundGuideData() {
        return ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u57fa\u7840\u914d\u7f6e\u4e2d\u5fc3\u6570\u636e\u3002", (String)"SubDataPacketDispatch_0", (String)"sys-ricc-platform", (Object[])new Object[0]);
    }

    public static SdpOutputParams exportPacket(String packetType, Object guideId, ListSelectedRow selectPacket, ListSelectedRowCollection selectRows, String pageId, Map<String, Object> custParam, AddPacketProgress addPacketProgress) {
        String exportPlugin;
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        DynamicObject guide = ConfigItemHelper.queryGuideById(guideId, packetType);
        if (guide == null) {
            sdpOutputParams.append(String.format(ResManager.loadKDString((String)"%1$s\uff0c\u914d\u7f6e\u9879id\uff1a%2$s", (String)"SubDataPacketDispatch_1", (String)"sys-ricc-platform", (Object[])new Object[0]), SubDataPacketDispatch.getNotFoundGuideData(), guideId), "");
            sdpOutputParams.setSuccess(false);
            return sdpOutputParams;
        }
        try {
            exportPlugin = SubDataPacketDispatch.getPluginByImportType(packetType, guide);
        }
        catch (Exception e) {
            logger.error(String.format("\u83b7\u53d6\u914d\u7f6e\u9879\u6253\u5305\u5b9e\u73b0\u65f6\u51fa\u73b0\u5f02\u5e38\uff0cguideId: %s", guideId), (Throwable)e);
            sdpOutputParams.append(e.getMessage(), e);
            sdpOutputParams.setSuccess(false);
            return sdpOutputParams;
        }
        String localPath = FileUtils.generateLocalPath();
        File localFile = FileUtils.checkAndCreateDir((String)localPath);
        String guideNumber = guide.getString("number");
        String importTemplateId = guide.getString("importtemplateid");
        String formid = guide.getString("formid");
        String bizAppId = guide.getString("bizappid");
        String pageEnterParams = guide.getString("pageenterparam");
        String entityId = guide.getString("entityid");
        SdpInputParams sdpInputParams = new SdpInputParams();
        sdpInputParams.setLocalPath(localPath);
        sdpInputParams.setSelectRows(selectRows);
        sdpInputParams.setAddPacketProgress(addPacketProgress);
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("pageId", pageId);
        param.put("guidenumber", guideNumber);
        param.put("entitynumber", formid);
        if (DataPacketTypeEnum.CONFIG.getVal().equals(packetType) && !StringUtils.isEmpty((String)entityId) && !StringUtils.equals((String)formid, (String)entityId)) {
            param.put("entitynumber", entityId);
        }
        if (StringUtils.equals((String)formid, (String)"ai_vchtemplate_configs")) {
            param.put("entitynumber", "ai_vchtemplate");
        }
        param.put("guideId", guide);
        param.put("entityname", guide.getString("name"));
        param.put("importtemplateid", importTemplateId);
        param.put("pageenterparam", pageEnterParams);
        param.put("bizappid", bizAppId);
        if (exportPlugin.equals(MICROSERVICE_PLUGIN)) {
            param.put("serviceconfig", guide.getString("plugin"));
        }
        param.put("custparam", custParam);
        SubDataPacketDispatch.setSortFieldAndSortWay(guide, entityId, param);
        sdpInputParams.setParam(param);
        try {
            ISubDataPacket service = (ISubDataPacket)TypesContainer.getOrRegisterSingletonInstance((String)exportPlugin);
            sdpOutputParams = service.exportPacket(sdpInputParams);
        }
        catch (Exception e) {
            logger.error("exportPacket \u5bfc\u51fa\u4f20\u8f93\u5305\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            String message = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u63d2\u4ef6 %s \u5931\u8d25\uff01%n", (String)"SubDataPacketDispatch_2", (String)"sys-ricc-platform", (Object[])new Object[0]), exportPlugin);
            sdpOutputParams.append(e.getMessage() + message, CommonUtil.getExceptionDetailInfo((Throwable)e));
            sdpOutputParams.setSuccess(false);
        }
        if (!sdpOutputParams.isSuccess()) {
            if (localFile.exists()) {
                AppUtils.deleteKd((File)localFile);
            }
            return sdpOutputParams;
        }
        SubDataPacketDispatch.afterExportPacket(sdpOutputParams, selectPacket, packetType);
        if (!sdpOutputParams.isSuccess()) {
            if (localFile.exists()) {
                AppUtils.deleteKd((File)localFile);
            }
            return sdpOutputParams;
        }
        int lastIndexOf = sdpOutputParams.getExportFilePath().lastIndexOf(46);
        String suffix = sdpOutputParams.getExportFilePath().substring(lastIndexOf);
        String fileName = guideNumber + "_" + System.currentTimeMillis() + suffix;
        String uploadPath = SysParaUtil.getSavePath() + selectPacket.getNumber();
        List listFile = null;
        try {
            listFile = CommonUtil.uploadDataPacket((Object)selectPacket.getPrimaryKeyValue(), (String)localPath, (String)sdpOutputParams.getExportFilePath(), (String)uploadPath, (String)fileName);
        }
        catch (Exception e) {
            logger.error("exportPacket \u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
            sdpOutputParams.append(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"SubDataPacketDispatch_4", (String)"sys-ricc-platform", (Object[])new Object[]{e.getMessage()}), e).append("\n");
            sdpOutputParams.setSuccess(false);
            return sdpOutputParams;
        }
        if (listFile == null || listFile.isEmpty()) {
            sdpOutputParams.append(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"SubDataPacketDispatch_4", (String)"sys-ricc-platform", (Object[])new Object[0]), "").append("\n");
            sdpOutputParams.setSuccess(false);
            return sdpOutputParams;
        }
        long fileId = ((DynamicObject)listFile.get(0)).getLong("id");
        int relyLevel = DataPacketTypeEnum.BASEDATA.getVal().equals(packetType) ? -1 : guide.getInt("relylevel");
        int size = selectRows.size();
        if (size == 0) {
            Map<String, Object> params = sdpInputParams.getParam();
            Map customerParam = (Map)params.get("custparam");
            String filters = (String)customerParam.get("filters");
            String entitynumber = (String)params.get("entitynumber");
            size = CommonQuery.getAllSelectData((String)entitynumber, (String)filters).size();
        }
        Map<String, Object> outputParam = sdpOutputParams.getParam();
        List previewData = (List)outputParam.get("previewData");
        Set keyFieldSet = (Set)outputParam.get("keyFields");
        if (previewData != null) {
            if (custParam == null) {
                custParam = new HashMap<String, Object>(4);
            }
            custParam.put("previewData", previewData);
            custParam.put("keyFields", keyFieldSet);
        }
        DynamicObject subDataPacket = SubDataPacketDispatch.createEntryRow(packetType, guideId, relyLevel, fileId, fileName, custParam, sdpOutputParams.getSelectedInfo(), size);
        sdpOutputParams.getParam().put("subDataPacket", subDataPacket);
        return sdpOutputParams;
    }

    private static void afterExportPacket(SdpOutputParams sdpOutputParams, ListSelectedRow selectPacket, String packetType) {
        Map<String, Object> outputParams = sdpOutputParams.getParam();
        try {
            List<Map<String, Object>> relybdList = outputParams.getOrDefault("relybd_list", Collections.emptyList());
            List<DynamicObject> relyPacketList = SubDataPacketDispatch.getSubPacketByRelyBdList(relybdList, selectPacket, packetType, sdpOutputParams);
            outputParams.put("relyBdPacketList", relyPacketList);
            List<Map<String, Object>> multiDataList = outputParams.getOrDefault("multidata_list", Collections.emptyList());
            List<DynamicObject> multiPacketList = SubDataPacketDispatch.getSubPacketByMultiDataList(multiDataList, selectPacket, packetType, sdpOutputParams);
            outputParams.put("multiDataPacketList", multiPacketList);
        }
        catch (RiccBizException e) {
            logger.error("afterExportPacket \u5bfc\u5165\u4f20\u8f93\u5305\u53d1\u751fRiccBizException\u5f02\u5e38", (Throwable)e);
            sdpOutputParams.setSuccess(false);
        }
        catch (Exception e) {
            logger.error("afterExportPacket \u5bfc\u5165\u4f20\u8f93\u5305\u53d1\u751f\u672a\u77e5\u5f02\u5e38", (Throwable)e);
            sdpOutputParams.append(e.getMessage(), e);
            sdpOutputParams.setSuccess(false);
        }
    }

    public static List<DynamicObject> getSubPacketByRelyBdList(List<Map<String, Object>> relyBdList, ListSelectedRow selectPacket, String packetType, SdpOutputParams sdpOutputParams) {
        if (relyBdList == null || relyBdList.isEmpty()) {
            return Collections.emptyList();
        }
        boolean isExistEmptyEntityNumber = relyBdList.stream().anyMatch(p -> StringUtils.isEmpty((String)((String)p.get(ENTITY_NUMBER))));
        if (isExistEmptyEntityNumber) {
            String tpl = ResManager.loadKDString((String)"\u6253\u5305\u4f9d\u8d56\u914d\u7f6e\u6570\u636e\u53d1\u751f\u9519\u8bef\uff0c\u5b58\u5728\u4f9d\u8d56\u914d\u7f6e\u5b9e\u4f53\u6807\u8bc6(entity_number)\u53c2\u6570\u672a\u586b\u5199\u7684\u6570\u636e\uff0c\u8bf7\u786e\u8ba4", (String)"SubDataPacketDispatch_14", (String)"sys-ricc-platform", (Object[])new Object[0]);
            sdpOutputParams.append(tpl);
            throw new RiccBizException();
        }
        boolean isExistEmptyIdList = relyBdList.stream().anyMatch(p -> p.get(ID_LIST) == null || p.getOrDefault(ID_LIST, Collections.emptyList()).isEmpty());
        if (isExistEmptyIdList) {
            String tpl = ResManager.loadKDString((String)"\u6253\u5305\u4f9d\u8d56\u914d\u7f6e\u6570\u636e\u53d1\u751f\u9519\u8bef\uff0c\u5b58\u5728\u4f9d\u8d56\u914d\u7f6e\u52fe\u9009\u6570\u636e(id_list)\u53c2\u6570\u672a\u586b\u5199\u7684\u6570\u636e\uff0c\u8bf7\u786e\u8ba4", (String)"SubDataPacketDispatch_15", (String)"sys-ricc-platform", (Object[])new Object[0]);
            sdpOutputParams.append(tpl);
            throw new RiccBizException();
        }
        List<String> entityNumberList = relyBdList.stream().map(p -> (String)p.get(ENTITY_NUMBER)).collect(Collectors.toList());
        Map<String, List<DynamicObject>> entityNumberConfigItemMap = SubDataPacketDispatch.getConfigInfoGroupByEntityNumber(entityNumberList);
        ArrayList<DynamicObject> subPacketList = new ArrayList<DynamicObject>(relyBdList.size());
        String typeNameTpl = ResManager.loadKDString((String)"\u4f9d\u8d56\u914d\u7f6e", (String)"SubDataPacketDispatch_19", (String)"sys-ricc-platform", (Object[])new Object[0]);
        for (Map<String, Object> relyBdMap : relyBdList) {
            String entityNumber = (String)relyBdMap.get(ENTITY_NUMBER);
            DynamicObject configItem = SubDataPacketDispatch.getConfigItemByEntityNumber(entityNumberConfigItemMap, entityNumber, typeNameTpl, sdpOutputParams);
            String entityName = configItem.getString("entityname");
            ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
            HashMap<String, Object> customMap = new HashMap<String, Object>(2);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            String primaryKey = dataEntityType.getPrimaryKey().getName();
            List selectedData = relyBdMap.getOrDefault(ID_LIST, Collections.emptyList());
            QFilter exportFilter = new QFilter(primaryKey, "in", selectedData);
            customMap.put("filters", exportFilter.toSerializedString());
            String pageType = configItem.getString("pagetype");
            if ("custom".equals(pageType)) {
                pageType = configItem.getString("custompage");
            }
            String pageId = SubDataPacketDispatch.createFormViewAndGetPageId(entityNumber, pageType, configItem.getString(IMPORT_TYPE));
            SdpOutputParams subSdpOutputParams = SubDataPacketDispatch.exportPacket(packetType, configItem.get("id"), selectPacket, listSelectedRows, pageId, customMap, null);
            if (!subSdpOutputParams.isSuccess()) {
                logger.error("afterExportPacket \u5bfc\u5165\u4f20\u8f93\u5305\u53d1\u751fRiccBizException\u5f02\u5e38", (Object)sdpOutputParams.getDevErrorStr());
                sdpOutputParams.append(subSdpOutputParams.getErrorStr(), subSdpOutputParams.getDevErrorStr());
                throw new RiccBizException();
            }
            DynamicObject subDataPacket = (DynamicObject)subSdpOutputParams.getParam().get("subDataPacket");
            String selectedInfo = SubDataPacketDispatch.getRelyBdSelectedInfo(dataEntityType, entityName, exportFilter);
            String selectedInfoNoBlank = StringUtils.replaceBlank((String)selectedInfo);
            subDataPacket.set("packetdata", (Object)(selectedInfoNoBlank.length() > 25 ? selectedInfoNoBlank.substring(0, 25) + "..." : selectedInfoNoBlank));
            subDataPacket.set("packetdata_tag", (Object)selectedInfo);
            subPacketList.add(subDataPacket);
        }
        return subPacketList;
    }

    private static DynamicObject getConfigItemByEntityNumber(Map<String, List<DynamicObject>> entityNumberConfigItemMap, String entityNumber, String typeName, SdpOutputParams sdpOutputParams) {
        DynamicObject configItem;
        List<DynamicObject> entityConfigList = entityNumberConfigItemMap.get(entityNumber);
        if (entityConfigList == null || entityConfigList.isEmpty()) {
            String tpl = ResManager.loadKDString((String)"\u6253\u5305%1$s\u5b9e\u4f53\u7f16\u7801\u4e3a\u201d%2$s\u201c\u7684\u6570\u636e\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u4e0d\u5b58\u5728\u914d\u7f6e\u8868\u5355\u7f16\u7801\u4e3a\u201c%3$s\u201d\u7684\u914d\u7f6e\u9879\uff0c\u8bf7\u786e\u8ba4\u914d\u7f6e\u9879\u662f\u5426\u5df2\u521b\u5efa", (String)"SubDataPacketDispatch_21", (String)"sys-ricc-platform", (Object[])new Object[0]);
            sdpOutputParams.append(String.format(tpl, typeName, entityNumber, entityNumber));
            throw new RiccBizException();
        }
        List notPresetData = entityConfigList.stream().filter(p -> !p.getBoolean("ispreset")).collect(Collectors.toList());
        if (notPresetData.size() > 1) {
            String tpl = ResManager.loadKDString((String)"\u6253\u5305\u4f9d\u8d56\u914d\u7f6e\u201d%1$s(%2$s)\u201c\u6570\u636e\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8be5\u914d\u7f6e\u7ed1\u5b9a\u4e86\u201c%3$s\u201d%4$s\u4e2a\u914d\u7f6e\u9879\uff0c\u7cfb\u7edf\u65e0\u6cd5\u786e\u5b9a\u6700\u7ec8\u4f7f\u7528\u54ea\u4e2a\u8fdb\u884c\u6253\u5305\uff0c\u8bf7\u624b\u5de5\u5220\u9664\u6216\u8005\u7981\u7528\u4e0d\u9700\u8981\u7684\u914d\u7f6e\u9879\u540e\u91cd\u65b0\u6267\u884c\u6dfb\u52a0\u5230\u4f20\u8f93\u5305", (String)"SubDataPacketDispatch_16", (String)"sys-ricc-platform", (Object[])new Object[0]);
            String entityName = ((DynamicObject)notPresetData.get(0)).getString("entityname");
            String configNames = notPresetData.stream().map(p -> p.getString("name") + "(" + p.getString("number") + ")").collect(Collectors.joining("\u3001"));
            sdpOutputParams.append(String.format(tpl, entityName, entityNumber, configNames, notPresetData.size()));
            throw new RiccBizException();
        }
        if (notPresetData.isEmpty()) {
            List presetData = entityConfigList.stream().filter(p -> p.getBoolean("ispreset")).collect(Collectors.toList());
            configItem = (DynamicObject)presetData.get(0);
        } else {
            configItem = (DynamicObject)notPresetData.get(0);
        }
        return configItem;
    }

    private static String getRelyBdSelectedInfo(MainEntityType dataEntityType, String entityName, QFilter exportFilter) {
        boolean isContainName;
        String nameField;
        String numberField;
        ISimpleProperty primaryKeyPro = dataEntityType.getPrimaryKey();
        String primaryKey = primaryKeyPro.getName();
        HashSet<String> selectFieldSet = new HashSet<String>(4);
        selectFieldSet.add(primaryKey);
        if (dataEntityType instanceof BasedataEntityType) {
            BasedataEntityType basedataEntityType = (BasedataEntityType)dataEntityType;
            numberField = basedataEntityType.getBillNo();
            nameField = basedataEntityType.getNameProperty();
        } else {
            numberField = ((BillEntityType)dataEntityType).getBillNo();
            nameField = "name";
        }
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        boolean isContainNumber = properties.containsKey((Object)numberField);
        if (isContainNumber) {
            selectFieldSet.add(numberField);
        }
        if (isContainName = properties.containsKey((Object)nameField)) {
            selectFieldSet.add(nameField);
        }
        String selectFieldStr = String.join((CharSequence)",", selectFieldSet);
        DynamicObjectCollection data = QueryServiceHelper.query((String)dataEntityType.getName(), (String)selectFieldStr, (QFilter[])exportFilter.toArray());
        StringBuilder selectInfo = new StringBuilder();
        selectInfo.append(String.format(CommonConstant.getSelectedTitle(), entityName, entityName));
        int i = 1;
        for (DynamicObject selectedData : data) {
            String number = isContainNumber ? selectedData.getString(numberField) : selectedData.getString(primaryKey);
            String name = isContainName ? selectedData.getString(nameField) : "";
            selectInfo.append(String.format("%1$s\t\t%2$s\t\t%3$s %n", i, number, name));
            ++i;
        }
        return selectInfo.toString();
    }

    public static List<DynamicObject> getSubPacketByMultiDataList(List<Map<String, Object>> multiDataList, ListSelectedRow selectPacket, String packetType, SdpOutputParams sdpOutputParams) {
        if (multiDataList == null || multiDataList.isEmpty()) {
            return Collections.emptyList();
        }
        boolean isExistEmptyEntityNumber = multiDataList.stream().anyMatch(p -> StringUtils.isEmpty((String)((String)p.get(ENTITY_NUMBER))));
        if (isExistEmptyEntityNumber) {
            String tpl = ResManager.loadKDString((String)"\u6253\u5305\u591a\u6587\u4ef6\u914d\u7f6e\u6570\u636e\u53d1\u751f\u9519\u8bef\uff0c\u5b58\u5728\u6587\u4ef6\u914d\u7f6e\u6570\u636e\u5b9e\u4f53\u6807\u8bc6(entity_number)\u53c2\u6570\u672a\u586b\u5199\u7684\u6570\u636e\uff0c\u8bf7\u786e\u8ba4", (String)"SubDataPacketDispatch_17", (String)"sys-ricc-platform", (Object[])new Object[0]);
            sdpOutputParams.append(tpl);
            throw new RiccBizException();
        }
        boolean isExistEmptyExportUrl = multiDataList.stream().anyMatch(p -> StringUtils.isEmpty((String)p.get("export_url").toString()));
        if (isExistEmptyExportUrl) {
            String tpl = ResManager.loadKDString((String)"\u6253\u5305\u591a\u6587\u4ef6\u914d\u7f6e\u6570\u636e\u53d1\u751f\u9519\u8bef\uff0c\u5b58\u5728\u6587\u4ef6\u914d\u7f6e\u6570\u636e\u4e34\u65f6\u6587\u4ef6\u8def\u5f84\uff08export_url\uff09\u53c2\u6570\u672a\u586b\u5199\u7684\u6570\u636e\uff0c\u8bf7\u786e\u8ba4", (String)"SubDataPacketDispatch_18", (String)"sys-ricc-platform", (Object[])new Object[0]);
            sdpOutputParams.append(tpl);
            throw new RiccBizException();
        }
        List<String> entityNumberList = multiDataList.stream().map(p -> (String)p.get(ENTITY_NUMBER)).collect(Collectors.toList());
        Map<String, List<DynamicObject>> entityNumberConfigItemMap = SubDataPacketDispatch.getConfigInfoGroupByEntityNumber(entityNumberList);
        ArrayList<DynamicObject> subPacketList = new ArrayList<DynamicObject>(multiDataList.size());
        String typeNameTpl = ResManager.loadKDString((String)"\u591a\u6587\u4ef6\u914d\u7f6e", (String)"SubDataPacketDispatch_22", (String)"sys-ricc-platform", (Object[])new Object[0]);
        for (Map<String, Object> relyBdMap : multiDataList) {
            String entityNumber = (String)relyBdMap.get(ENTITY_NUMBER);
            DynamicObject configItem = SubDataPacketDispatch.getConfigItemByEntityNumber(entityNumberConfigItemMap, entityNumber, typeNameTpl, sdpOutputParams);
            String guideNumber = configItem.getString("number");
            String entityName = configItem.getString("entityname");
            String uploadPath = SysParaUtil.getSavePath() + selectPacket.getNumber();
            String exportUrl = relyBdMap.get("export_url").toString();
            List<Map<String, Object>> selectedDataList = relyBdMap.getOrDefault("selected_info", Collections.emptyList());
            List<DynamicObject> fileList = DataPacketHelper.uploadDataPacketByTempUrl(selectPacket.getPrimaryKeyValue(), exportUrl, uploadPath, guideNumber);
            if (fileList == null || fileList.isEmpty()) {
                String tpl = ResManager.loadKDString((String)"\u6253\u5305\u591a\u6587\u4ef6\u914d\u7f6e\u201d%1$s(%2$s)\u201c\u6570\u636e\u5931\u8d25\uff0c\u5c06\u4e34\u65f6\u6587\u4ef6\u4e0a\u4f20\u5230\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25", (String)"SubDataPacketDispatch_20", (String)"sys-ricc-platform", (Object[])new Object[0]);
                sdpOutputParams.append(String.format(tpl, entityName, entityNumber));
                throw new RiccBizException();
            }
            DynamicObject fileInfo = fileList.get(0);
            long fileId = fileInfo.getLong("id");
            int relyLevel = DataPacketTypeEnum.BASEDATA.getVal().equals(packetType) ? -1 : configItem.getInt("relylevel");
            String selectedInfo = SubDataPacketDispatch.buildSelectedInfo(selectedDataList, entityName);
            DynamicObject subDataPacket = SubDataPacketDispatch.createEntryRow(packetType, configItem.get("id"), relyLevel, fileId, fileInfo.getString("name"), null, selectedInfo, selectedDataList.size());
            subPacketList.add(subDataPacket);
        }
        return subPacketList;
    }

    private static Map<String, List<DynamicObject>> getConfigInfoGroupByEntityNumber(List<String> entityNumberList) {
        QFilter qFilter = new QFilter("page.number", "in", entityNumberList).and("enable", "=", (Object)"1");
        DynamicObjectCollection configItemColl = QueryServiceHelper.query((String)"ricc_configitems", (String)"id,enable,number,name,ispreset,page.number as entitynumber,page.name as entityname,importtype,pagetype,custompage,relylevel", (QFilter[])qFilter.toArray(), (String)"id desc");
        if (configItemColl == null || configItemColl.isEmpty()) {
            return Collections.emptyMap();
        }
        return configItemColl.stream().collect(Collectors.groupingBy(p -> p.getString("entitynumber")));
    }

    private static String createFormViewAndGetPageId(String formId, String pageType, String importType) {
        if (!"excel".equals(importType)) {
            return null;
        }
        FormShowParameter parameter = ImportParamAdapter.createFormShowParameter4Import(formId, pageType);
        FormConfigFactory.createConfig((FormShowParameter)parameter);
        DispatchServiceHelper.invokeBOSServiceByFormId((String)formId, (String)"FormService", (String)"batchInvokeAction", (Object[])new Object[]{parameter.getPageId(), "[{\"key\":\"\",\"methodName\":\"loadData\",\"args\":[],\"postData\":[]}]"});
        return parameter.getPageId();
    }

    public static String buildSelectedInfo(List<Map<String, Object>> selectedDataList, String entityName) {
        if (selectedDataList == null || selectedDataList.isEmpty()) {
            return null;
        }
        StringBuilder selectInfo = new StringBuilder();
        selectInfo.append(String.format(CommonConstant.getSelectedTitle(), entityName, entityName));
        int i = 1;
        for (Map<String, Object> selectedData : selectedDataList) {
            String number = (String)selectedData.get("number");
            if (StringUtils.isEmpty((String)number)) {
                Object id = selectedData.get("id");
                number = id instanceof Long ? String.valueOf(id) : (id instanceof String ? (String)id : " ");
            }
            selectInfo.append(String.format("%1$s\t\t%2$s\t\t%3$s %n", i, number, selectedData.get("name")));
            ++i;
        }
        return selectInfo.toString();
    }

    private static void setSortFieldAndSortWay(DynamicObject guide, String entityId, Map<String, Object> param) {
        String importType = guide.getString(IMPORT_TYPE);
        if ("excel".equals(importType) || "json".equals(importType)) {
            String sortField = guide.getString("sortfield");
            if (StringUtils.isEmpty((String)sortField)) {
                MainEntityType entityType;
                EntityMetadata entityMetadata;
                String levelDbName;
                FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
                boolean isExtendTreeModel = SubDataPacketDispatch.isExtendTreeModel(formMetadata);
                if (isExtendTreeModel && !StringUtils.isEmpty((String)(levelDbName = (entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)(entityType = EntityMetadataCache.getDataEntityType((String)entityId)).getName(), (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity)).getFieldByKey("level").getFieldName()))) {
                    param.put("sortfield", "level");
                    param.put("sortway", "asc");
                }
            } else {
                param.put("sortfield", sortField);
                String sortWay = guide.getString("sortway");
                if (StringUtils.isEmpty((String)sortWay)) {
                    param.put("sortway", "asc");
                } else {
                    param.put("sortway", sortWay);
                }
            }
        }
    }

    public static SdpOutputParams importPacket(String packetType, Map<String, Object> param) {
        String exportPlugin;
        String importType;
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        if (param == null) {
            sdpOutputParams.append(ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"SubDataPacketDispatch_5", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return sdpOutputParams;
        }
        DynamicObject guideInfo = (DynamicObject)param.get("guideInfo");
        if (guideInfo == null) {
            sdpOutputParams.append(SubDataPacketDispatch.getNotFoundGuideData(), "");
            sdpOutputParams.setSuccess(false);
            return sdpOutputParams;
        }
        String typeName = guideInfo.getDataEntityType().getName();
        String entityId = guideInfo.getString("page.basedatafield.number");
        if (StringUtils.equals((String)typeName, (String)"ricc_configitems") && (StringUtils.equals((String)(importType = guideInfo.getString(IMPORT_TYPE)), (String)"excel") || StringUtils.equals((String)importType, (String)"json"))) {
            String keyFields = guideInfo.getString("keyfields");
            String guideName = guideInfo.getString("name");
            guideInfo.set("keyfields", (Object)ConfigItemHelper.disPoseKeyField(entityId, keyFields, guideName));
        }
        try {
            exportPlugin = SubDataPacketDispatch.getPluginByImportType(packetType, guideInfo);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5bfc\u5165\u5bfc\u51fa\u63d2\u4ef6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            sdpOutputParams.append(e.getMessage(), e);
            sdpOutputParams.setSuccess(false);
            return sdpOutputParams;
        }
        SdpInputParams sdpInputParams = new SdpInputParams();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(param.size());
        paramMap.putAll(param);
        sdpInputParams.setParam(paramMap);
        try {
            if (exportPlugin.equals(STANDARD_PLUGIN)) {
                String formId = guideInfo.getString("page.number");
                if (DataPacketTypeEnum.CONFIG.getVal().equals(packetType)) {
                    logger.info(String.format("ricc_packetdispatch, formid:[%s], entityid:[%s]", formId, entityId));
                    if (!StringUtils.isEmpty((String)entityId) && !StringUtils.equals((String)formId, (String)entityId)) {
                        formId = entityId;
                    }
                }
                String appId = EntityMetadataCache.getDataEntityType((String)formId).getAppId();
                sdpInputParams.getParam().put("appId", appId);
                sdpInputParams.getParam().put("billFormId", formId);
                sdpInputParams.getParam().put("configItemNumber", guideInfo.getString("number"));
                sdpInputParams.getParam().put("packetType", packetType);
                String pageType = guideInfo.getString("pagetype");
                if ("custom".equals(pageType)) {
                    pageType = guideInfo.getString("custompage");
                }
                sdpInputParams.getParam().put("pageType", pageType);
            }
            ISubDataPacket service = (ISubDataPacket)TypesContainer.getOrRegisterSingletonInstance((String)exportPlugin);
            sdpOutputParams = service.importPacket(sdpInputParams);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u63d2\u4ef6 %s \u8fdb\u884c\u6570\u636e\u5904\u7406\u53d1\u751f\u5f02\u5e38\u3002", (String)"SubDataPacketDispatch_6", (String)"sys-ricc-platform", (Object[])new Object[0]), exportPlugin), e);
            sdpOutputParams.setSuccess(false);
        }
        return sdpOutputParams;
    }

    public static DynamicObject createEntryRow(String packetType, Object guideId, int relyLevel, long fileId, String fileName, Map<String, Object> custParam, String selectedInfo, int dataCount) {
        long id = DB.genLongId((String)"t_ricc_subdatapacket");
        DynamicObject subDataPacket = ORM.create().newDynamicObject("ricc_datapacket.subdatapacket");
        long lastModified = System.currentTimeMillis();
        subDataPacket.set("id", (Object)id);
        subDataPacket.set("bizobject", guideId);
        if (DataPacketTypeEnum.CONFIG.getVal().equals(packetType)) {
            subDataPacket.set("subpackettype", (Object)"ricc_configitems");
        } else if (DataPacketTypeEnum.BASEDATA.getVal().equals(packetType)) {
            subDataPacket.set("subpackettype", (Object)"ricc_basedata_item");
        }
        subDataPacket.set("entrycreatetime", (Object)lastModified);
        subDataPacket.set("entryupdatetime", (Object)lastModified);
        subDataPacket.set("entrystatus", (Object)PacketEntryStatusEnum.NORMAL.getVal());
        subDataPacket.set("packetnum", (Object)dataCount);
        subDataPacket.set("relylevel", (Object)relyLevel);
        subDataPacket.set("filename", (Object)fileName);
        String selectedInfoNoBlank = StringUtils.replaceBlank((String)selectedInfo);
        subDataPacket.set("packetdata", (Object)(selectedInfoNoBlank.length() > 25 ? selectedInfoNoBlank.substring(0, 25) + "..." : selectedInfoNoBlank));
        subDataPacket.set("packetdata_tag", (Object)selectedInfo);
        String custParamStr = JSON.toJSONString(custParam);
        String custParamStrNoBlank = StringUtils.replaceBlank((String)custParamStr);
        subDataPacket.set("custparam", (Object)(custParamStrNoBlank.length() > 25 ? custParamStrNoBlank.substring(0, 25) + "..." : custParamStrNoBlank));
        subDataPacket.set("custparam_tag", (Object)custParamStr);
        MulBasedataDynamicObjectCollection fileList = CommonUtil.createAttachmentField((DynamicObjectType)subDataPacket.getDynamicObjectCollection("subdatapacketfile").getDynamicObjectType(), (long)fileId);
        subDataPacket.set("subdatapacketfile", (Object)fileList);
        return subDataPacket;
    }

    public static void saveSubDataPacket(Object selectedPacketId, DynamicObject subDataPacket) {
        if (StringUtils.isBlank((Object)selectedPacketId)) {
            throw new RiccBizException(ResManager.loadKDString((String)"\u8981\u4fdd\u5b58\u7684\u5b50\u4f20\u8f93\u5305\u4e3a\u7a7a\u3002", (String)"SubDataPacketDispatch_7", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(1);
        list.add(subDataPacket);
        SubDataPacketDispatch.saveBatchSubDataPacket(selectedPacketId, list);
    }

    public static synchronized void saveBatchSubDataPacket(Object selectedPacketId, List<DynamicObject> subDataPackets) {
        if (subDataPackets.isEmpty()) {
            throw new RiccBizException(ResManager.loadKDString((String)"\u8981\u4fdd\u5b58\u7684\u5b50\u4f20\u8f93\u5305\u4e3a\u7a7a\u3002", (String)"SubDataPacketDispatch_7", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)selectedPacketId, (String)"ricc_datapacket");
        DynamicObjectCollection dCollection = dynamicObject.getDynamicObjectCollection("subdatapacket");
        List<DynamicObject> newAttachments = SubDataPacketDispatch.getNewAttachments(subDataPackets);
        SubDataPacketDispatch.validatePacketFileSize(dCollection, newAttachments);
        int subpacketcount = dynamicObject.getInt("subpacketcount");
        int addSize = subDataPackets.size();
        dynamicObject.set("subpacketcount", (Object)(subpacketcount + addSize));
        int seq = dCollection.size();
        for (int i = 0; i < addSize; ++i) {
            DynamicObject subDataPacket = subDataPackets.get(i);
            subDataPacket.set("seq", (Object)(seq + (i + 1)));
            dCollection.add((Object)subDataPacket);
        }
        dynamicObject.set("subdatapacket", (Object)dCollection);
        OperationResult operationResult = SaveServiceHelper.saveOperate((String)"ricc_datapacket", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)OperateOption.create());
        if (!operationResult.isSuccess()) {
            SubDataPacketDispatch.deleteNewAttachments(newAttachments);
            throw new RiccBizException(String.format(ResManager.loadKDString((String)"\u6dfb\u52a0\u5b50\u4f20\u8f93\u5305\u5931\u8d25\u3002%1$s%2$s", (String)"SubDataPacketDispatch_8", (String)"sys-ricc-platform", (Object[])new Object[0]), operationResult.getAllErrorInfo().toString(), operationResult.getAllErrorOrValidateInfo().toString()));
        }
    }

    private static List<DynamicObject> getNewAttachments(List<DynamicObject> subDataPackets) {
        ArrayList attachmentIds = new ArrayList();
        subDataPackets.forEach(subPacket -> {
            Object attachmentId = ((DynamicObject)subPacket.getDynamicObjectCollection("subdatapacketfile").get(0)).get("fbasedataid");
            attachmentIds.add(attachmentId);
        });
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"bd_attachment");
        DynamicObject[] loads = BusinessDataServiceHelper.load((Object[])attachmentIds.toArray(), (DynamicObjectType)dataEntityType);
        return new ArrayList<DynamicObject>(new ArrayList<DynamicObject>(Arrays.asList(loads)));
    }

    private static void validatePacketFileSize(DynamicObjectCollection dCollection, List<DynamicObject> newAttachments) {
        int packSizeLimit = SysParaUtil.getPackSizeLimit();
        int allFileSize = 0;
        for (DynamicObject entry : dCollection) {
            DynamicObject attachment2;
            DynamicObject fileBaseData;
            DynamicObjectCollection attachments;
            String entryStatus = entry.getString("entrystatus");
            if (StringUtils.equals((String)entryStatus, (String)PacketEntryStatusEnum.INVALID.getVal()) || (attachments = (DynamicObjectCollection)entry.get("subdatapacketfile")).isEmpty() || (fileBaseData = (attachment2 = (DynamicObject)attachments.get(0)).getDynamicObject("fbasedataid")) == null) continue;
            int fileSize = fileBaseData.getInt("size");
            allFileSize += fileSize;
        }
        if ((allFileSize += newAttachments.stream().mapToInt(attachment -> attachment.getInt("size")).sum()) > packSizeLimit * 1024 * 1024) {
            SubDataPacketDispatch.deleteNewAttachments(newAttachments);
            String msgTpl = ResManager.loadKDString((String)"\u6dfb\u52a0\u5230\u4f20\u8f93\u5305\u5931\u8d25\uff0c\u4e3a\u4fdd\u969c\u7cfb\u7edf\u7a33\u5b9a\u6027\uff0c\u4f20\u8f93\u5305\u7684\u603b\u6587\u4ef6\u5927\u5c0f\u4e0d\u5f97\u8d85\u8fc7%dMB\uff0c \u8bf7\u6dfb\u52a0\u5230\u65b0\u7684\u4f20\u8f93\u5305\u4f20\u8f93\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u5728\u3010\u53c2\u6570\u8bbe\u7f6e\u3011\u4e2d\u8c03\u6574\u9650\u5236", (String)"SubDataPacketDispatch_12", (String)"sys-ricc-platform", (Object[])new Object[0]);
            throw new RiccBizException(String.format(msgTpl, packSizeLimit));
        }
    }

    private static void deleteNewAttachments(List<DynamicObject> newAttachments) {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        newAttachments.forEach(att -> {
            String url = att.getString("url");
            if (fileService.exists(url)) {
                fileService.delete(url);
            }
        });
        List attIds = newAttachments.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        DeleteServiceHelper.delete((String)"bd_attachment", (QFilter[])new QFilter("id", "in", attIds).toArray());
    }

    public static String getPluginByImportType(String packetType, DynamicObject guide) {
        if (DataPacketTypeEnum.BASEDATA.getVal().equals(packetType)) {
            return STANDARD_PLUGIN;
        }
        String importType = guide.getString(IMPORT_TYPE);
        String guideName = guide.getString("name");
        String customConfig = guide.getString("plugin");
        String plugin = "";
        switch (importType) {
            case "custom": {
                if (StringUtils.isEmpty((String)customConfig)) {
                    throw new RiccBizException(String.format(ResManager.loadKDString((String)"\u57fa\u7840\u914d\u7f6e\u4e2d\u5fc3\u9879\u3010%s\u3011\u8bbe\u7f6e\u7684\u662f\u81ea\u5b9a\u4e49\u5bfc\u5165\u5bfc\u51fa\u9700\u8981\u586b\u5199\u63d2\u4ef6\uff0c\u8bf7\u4fee\u6539\u5bf9\u5e94\u7684\u57fa\u7840\u914d\u7f6e\u4e2d\u5fc3\u9879\uff0c\u586b\u5199\u4e8c\u5f00\u63d2\u4ef6\u3002", (String)"SubDataPacketDispatch_9", (String)"sys-ricc-platform", (Object[])new Object[0]), guideName));
                }
                plugin = customConfig;
                break;
            }
            case "excel": {
                plugin = STANDARD_PLUGIN;
                break;
            }
            case "json": {
                plugin = SERIALIZED_PLUGIN;
                try {
                    Class<?> clz;
                    if (!StringUtils.isNotBlank((CharSequence)customConfig) || (clz = Class.forName(customConfig)) == null || !(clz.newInstance() instanceof JsonDataPacketImpl)) break;
                    plugin = customConfig;
                }
                catch (Exception clz) {}
                break;
            }
            case "microService": {
                plugin = MICROSERVICE_PLUGIN;
                String serviceConfig = guide.getString("plugin");
                JSONObject obj = JSON.parseObject((String)serviceConfig);
                String appNumber = obj.getString("appid");
                String serviceName = obj.getString("servicename");
                if (!StringUtils.isEmpty((String)appNumber) && !StringUtils.isEmpty((String)serviceName)) break;
                throw new RiccBizException(String.format(ResManager.loadKDString((String)"\u57fa\u7840\u914d\u7f6e\u4e2d\u5fc3\u9879\u3010%s\u3011\u8bbe\u7f6e\u7684\u662f\u5fae\u670d\u52a1\u5bfc\u5165\u5bfc\u51fa\uff0c\u8bf7\u786e\u8ba4\u5bf9\u5e94\u7684\u57fa\u7840\u914d\u7f6e\u4e2d\u5fc3\u9879\u662f\u5426\u586b\u5199\u5fae\u670d\u52a1\u6240\u5728\u5e94\u7528\u53ca\u5fae\u670d\u52a1\u670d\u52a1\u540d\u3002", (String)"SubDataPacketDispatch_10", (String)"sys-ricc-platform", (Object[])new Object[0]), guideName));
            }
        }
        if (StringUtils.isEmpty((String)plugin)) {
            throw new RiccBizException(String.format(ResManager.loadKDString((String)"\u57fa\u7840\u914d\u7f6e\u4e2d\u5fc3\u9879\u3010%s\u3011\u4e2d\u672a\u8bbe\u7f6e\u5bfc\u5165\u5bfc\u51fa\u65b9\u5f0f\uff0c\u8bf7\u7ef4\u62a4\u540e\u518d\u64cd\u4f5c\u3002", (String)"SubDataPacketDispatch_11", (String)"sys-ricc-platform", (Object[])new Object[0]), guideName));
        }
        return plugin;
    }

    private static boolean isExtendTreeModel(FormMetadata formMetadata) {
        String inheritPath = formMetadata.getInheritPath();
        boolean isExtendTreeModel = false;
        if (StringUtils.isNotBlank((CharSequence)inheritPath)) {
            String[] parentIds;
            for (String parentId : parentIds = inheritPath.split(",")) {
                String parentNumber = MetadataDao.getNumberById((String)parentId);
                if (!StringUtils.equals((String)parentNumber, (String)"bos_basetreetpl")) continue;
                return true;
            }
        }
        return isExtendTreeModel;
    }
}

