/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.core.impl.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.SysParaUtil;
import kd.sys.ricc.common.util.setter.D;
import kd.sys.ricc.exception.RiccBizException;

public class JsonImportHelper {
    private static final String ID = "id";
    private static final String ENTRYID = "entryid";
    private static final String MASTERID = "masterid";
    private static final String BASEDATA_ID_PROP_SUFFIX = "_id";
    private static final String NUMBER_FIELD = "numberField";
    private static final String CONTENT = "content";
    private static final Log logger = LogFactory.getLog(JsonImportHelper.class);
    private final int bdQueryMethod;
    private final String coverConfig;
    private final DynamicObject curUser;
    private final Map<String, Map<String, DynamicObject>> bdCaches = new HashMap<String, Map<String, DynamicObject>>(8);
    private final String entityNumber;
    private boolean isNew;

    public JsonImportHelper(String entityNumber) {
        this.entityNumber = entityNumber;
        this.bdQueryMethod = this.getBdQueryMethod();
        this.coverConfig = SysParaUtil.getBillCreateInfoCoverConfig();
        this.curUser = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
    }

    public static Object idCovert(String entityName, Object id) {
        if ("sch_job".equals(entityName) || "sch_schedule".equals(entityName) || "bos_entityobject".equals(entityName) || "sch_taskdefine".equals(entityName)) {
            return id;
        }
        try {
            id = Long.parseLong(id.toString());
        }
        catch (NumberFormatException e) {
            logger.error("idCovert\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return id;
        }
        return id;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setIsNew(boolean isNew) {
        this.isNew = isNew;
    }

    private List<String> getEntryBdValInfo(Map<String, Object> bdMap, int i, IDataEntityProperty prop) {
        JSONArray arrays;
        Map bdValueMap = (Map)bdMap.get(prop.getName());
        ArrayList<String> bdValInfo = new ArrayList<String>(4);
        if (bdValueMap != null && (arrays = (JSONArray)JSON.toJSON(bdValueMap.get(CONTENT))).get(i) != null) {
            JSONArray value = arrays.getJSONArray(i);
            if (value.size() > 2) {
                bdValInfo.add(value.getString(2));
            } else {
                bdValInfo.add((String)bdValueMap.get("type"));
            }
            bdValInfo.add((String)bdValueMap.get(NUMBER_FIELD));
            bdValInfo.add(value.getString(0));
            bdValInfo.add(value.getString(1));
        }
        return bdValInfo;
    }

    private List<String> getSubEntryBdValInfo(Map<String, Object> allData, String subEntryKey, int entryLine, int subEntryIndex, IDataEntityProperty prop) {
        JSONArray v;
        Map packetSubBdMap = (Map)allData.get(subEntryKey);
        Map bdValueMap = (Map)packetSubBdMap.get(prop.getName());
        ArrayList<String> bdValInfo = new ArrayList<String>(4);
        JSONArray arrays = (JSONArray)JSON.toJSON(bdValueMap.get(CONTENT));
        if ((arrays = arrays.getJSONArray(entryLine)).get(subEntryIndex) != null) {
            v = arrays.getJSONArray(subEntryIndex);
            if (v.size() > 2) {
                bdValInfo.add(v.getString(2));
            } else {
                bdValInfo.add((String)bdValueMap.get("type"));
            }
        } else {
            return Collections.emptyList();
        }
        bdValInfo.add((String)bdValueMap.get(NUMBER_FIELD));
        bdValInfo.add(v.getString(0));
        bdValInfo.add(v.getString(1));
        return bdValInfo;
    }

    public void map2DynamicObject(DynamicObject currentObj, Map<String, Object> alldata, JSONObject dataMap, Map<String, DynamicObject> fillSuccessDyo, List<String> coverFields) {
        Map billMap = (Map)alldata.get("data");
        Map bdMap = (Map)alldata.get("bd");
        if (currentObj != null && billMap != null) {
            billMap.remove("$pk");
            billMap.remove("$id");
            DataEntityPropertyCollection properties = currentObj.getDataEntityType().getProperties();
            for (Map.Entry entry : billMap.entrySet()) {
                String key = (String)entry.getKey();
                IDataEntityProperty prop = this.getProperty(properties, key);
                if (prop != null) {
                    Object bdValInfo;
                    if (prop.getName().equals(ID) || prop.getName().equals(MASTERID)) {
                        if (!this.isNew) continue;
                        currentObj.set(prop, JsonImportHelper.idCovert(this.entityNumber, entry.getValue()));
                        continue;
                    }
                    if (prop instanceof BasedataProp) {
                        bdValInfo = bdMap.get(prop.getName());
                        if (prop instanceof CreaterProp) {
                            this.setBillCreatorObjVal(currentObj, (List)bdValInfo, (BasedataProp)prop, dataMap, fillSuccessDyo);
                            continue;
                        }
                        if (coverFields.contains(prop.getName()) && !(prop instanceof ModifierProp)) {
                            this.coverAdminInfo(currentObj, prop);
                            continue;
                        }
                        if (prop instanceof ModifierProp) continue;
                        this.setBaseDataObjVal(currentObj, (List)bdValInfo, (BasedataProp)prop, dataMap, fillSuccessDyo);
                        continue;
                    }
                    if (prop instanceof MulBasedataProp && !(prop instanceof AttachmentProp)) {
                        bdValInfo = bdMap.get(prop.getName());
                        this.setMultiBaseDataObjVal(currentObj, bdValInfo, prop, dataMap, fillSuccessDyo);
                        continue;
                    }
                    if (prop instanceof DateTimeProp) {
                        if (prop instanceof CreateDateProp) {
                            this.setBillCreateDateVal(currentObj, entry.getValue(), prop);
                            continue;
                        }
                        if (prop instanceof ModifyDateProp) continue;
                        currentObj.set(prop, (Object)D.t(entry.getValue()));
                        continue;
                    }
                    if (prop instanceof DecimalProp) {
                        currentObj.set(prop, (Object)D.n(entry.getValue()));
                        continue;
                    }
                    if (prop instanceof BooleanProp) {
                        currentObj.set(prop, (Object)D.x(entry.getValue()));
                        continue;
                    }
                    if (prop instanceof EntryProp) {
                        this.map2Entry(currentObj, alldata, billMap, key, dataMap, fillSuccessDyo, coverFields);
                        continue;
                    }
                    currentObj.set(prop, entry.getValue());
                    continue;
                }
                String msgTpl = ResManager.loadKDString((String)"\u5143\u6570\u636e\u4e0d\u5339\u914d\uff0c\u5b57\u6bb5\u3010%1$s\u3011\u5728\u5f53\u524d\u73af\u5883\u7684\u3010%2$s\u3011(%3$s)\u5b9e\u4f53\u4e0a\u4e0d\u5b58\u5728", (String)"JsonDataPacketImpl_16", (String)"sys-ricc-platform", (Object[])new Object[0]);
                LocaleString entityDisplayName = currentObj.getDynamicObjectType().getDisplayName();
                throw new RiccBizException(String.format(msgTpl, key, entityDisplayName, this.entityNumber));
            }
        }
    }

    private void map2Entry(DynamicObject currentObj, Map<String, Object> allData, Map<String, Object> billMap, String entryKey, JSONObject dataMap, Map<String, DynamicObject> fillSuccessDyo, List<String> coverFields) {
        Map entryBdMap = (Map)allData.get(entryKey);
        DynamicObjectCollection entrys = currentObj.getDynamicObjectCollection(entryKey);
        entrys.clear();
        List packetEntryDataList = (List)billMap.get(entryKey);
        DataEntityPropertyCollection properties = entrys.getDynamicObjectType().getProperties();
        for (int i = 0; i < packetEntryDataList.size(); ++i) {
            Map map = (Map)packetEntryDataList.get(i);
            map.remove("$pk");
            map.remove("$id");
            DynamicObject newEntry = entrys.addNew();
            for (Map.Entry entry : map.entrySet()) {
                String propkey = (String)entry.getKey();
                IDataEntityProperty prop = this.getProperty(properties, propkey);
                if (prop != null) {
                    List<String> bdValInfo;
                    if (prop.getName().equals(ID) || prop.getName().equals(ENTRYID)) {
                        newEntry.set(prop, JsonImportHelper.idCovert(this.entityNumber, entry.getValue()));
                        continue;
                    }
                    if (prop instanceof BasedataProp) {
                        bdValInfo = this.getEntryBdValInfo(entryBdMap, i, prop);
                        if (prop instanceof CreaterProp) {
                            this.setBillCreatorObjVal(newEntry, bdValInfo, (BasedataProp)prop, dataMap, fillSuccessDyo);
                            continue;
                        }
                        if (coverFields.contains(prop.getName()) && !(prop instanceof ModifierProp)) {
                            this.coverAdminInfo(newEntry, prop);
                            continue;
                        }
                        if (prop instanceof ModifierProp) continue;
                        this.setBaseDataObjVal(newEntry, bdValInfo, (BasedataProp)prop, dataMap, fillSuccessDyo);
                        continue;
                    }
                    if (prop instanceof MulBasedataProp && !(prop instanceof AttachmentProp)) {
                        bdValInfo = entry.getValue();
                        if (bdValInfo == null) continue;
                        JSONArray bdValInfoList = (JSONArray)bdValInfo;
                        DynamicObjectCollection basedatas = newEntry.getDynamicObjectCollection(prop);
                        basedatas.clear();
                        for (Object id : bdValInfoList) {
                            DynamicObject newRow = new DynamicObject(basedatas.getDynamicObjectType());
                            newRow.set("fbasedataid", ((JSONObject)id).get((Object)ID));
                            basedatas.add((Object)newRow);
                        }
                        newEntry.set(prop, (Object)basedatas);
                        continue;
                    }
                    if (prop instanceof MulBasedataProp) continue;
                    Object value = entry.getValue();
                    if (prop instanceof DateTimeProp) {
                        if (prop instanceof CreateDateProp) {
                            this.setBillCreateDateVal(newEntry, value, prop);
                            continue;
                        }
                        if (prop instanceof ModifyDateProp) continue;
                        newEntry.set(prop, (Object)D.t(value));
                        continue;
                    }
                    if (prop instanceof DecimalProp) {
                        newEntry.set(prop, (Object)D.n(value));
                        continue;
                    }
                    if (prop instanceof BooleanProp) {
                        newEntry.set(prop, (Object)D.x(value));
                        continue;
                    }
                    if (prop instanceof EntryProp) {
                        this.map2SubEntry(currentObj, allData, (List)value, newEntry, propkey, i, dataMap, fillSuccessDyo, coverFields);
                        continue;
                    }
                    newEntry.set(prop, value);
                    continue;
                }
                String msgTpl = ResManager.loadKDString((String)"\u5143\u6570\u636e\u4e0d\u5339\u914d\uff0c\u5206\u5f55\u5b57\u6bb5\u3010%1$s\u3011\u5728\u5f53\u524d\u73af\u5883\u7684\u3010%2$s\u3011\u5b9e\u4f53\u4e0a\u4e0d\u5b58\u5728", (String)"JsonDataPacketImpl_17", (String)"sys-ricc-platform", (Object[])new Object[0]);
                throw new RiccBizException(String.format(msgTpl, propkey, this.entityNumber));
            }
        }
    }

    private IDataEntityProperty getProperty(DataEntityPropertyCollection properties, String propkey) {
        String bdKey;
        IDataEntityProperty bdProp;
        IDataEntityProperty prop = (IDataEntityProperty)properties.get((Object)propkey);
        if (propkey.endsWith(BASEDATA_ID_PROP_SUFFIX) && (bdProp = (IDataEntityProperty)properties.get((Object)(bdKey = propkey.substring(0, propkey.lastIndexOf(BASEDATA_ID_PROP_SUFFIX))))) != null) {
            prop = bdProp;
        }
        return prop;
    }

    private void map2SubEntry(DynamicObject currentObj, Map<String, Object> allData, List<Map<String, Object>> packetSubEntryDataList, DynamicObject newEntry, String subEntryKey, int entryLine, JSONObject dataMap, Map<String, DynamicObject> fillSuccessDyo, List<String> coverFields) {
        DynamicObjectCollection subEntrys = newEntry.getDynamicObjectCollection(subEntryKey);
        subEntrys.clear();
        DataEntityPropertyCollection properties = subEntrys.getDynamicObjectType().getProperties();
        for (int subEntryIndex = 0; subEntryIndex < packetSubEntryDataList.size(); ++subEntryIndex) {
            Map<String, Object> subEntryData = packetSubEntryDataList.get(subEntryIndex);
            subEntryData.remove("$pk");
            subEntryData.remove("$id");
            DynamicObject newSubEntry = subEntrys.addNew();
            for (Map.Entry<String, Object> entryData : subEntryData.entrySet()) {
                String subEntryFieldKey = entryData.getKey();
                IDataEntityProperty prop = this.getProperty(properties, subEntryFieldKey);
                if (prop != null) {
                    Object value = entryData.getValue();
                    if (prop instanceof BasedataProp) {
                        List<String> bdValInfo = this.getSubEntryBdValInfo(allData, subEntryKey, entryLine, subEntryIndex, prop);
                        if (prop instanceof CreaterProp) {
                            this.setBillCreatorObjVal(newSubEntry, bdValInfo, (BasedataProp)prop, dataMap, fillSuccessDyo);
                            continue;
                        }
                        if (coverFields.contains(prop.getName()) && !(prop instanceof ModifierProp)) {
                            this.coverAdminInfo(newSubEntry, prop);
                            continue;
                        }
                        if (prop instanceof ModifierProp) continue;
                        this.setBaseDataObjVal(newSubEntry, bdValInfo, (BasedataProp)prop, dataMap, fillSuccessDyo);
                        continue;
                    }
                    if (prop instanceof MulBasedataProp) continue;
                    if (prop instanceof DateTimeProp) {
                        newSubEntry.set(prop, (Object)D.t((Object)value));
                        continue;
                    }
                    if (prop instanceof DecimalProp) {
                        newSubEntry.set(prop, (Object)D.n((Object)value));
                        continue;
                    }
                    if (prop instanceof BooleanProp) {
                        newSubEntry.set(prop, (Object)D.x((Object)value));
                        continue;
                    }
                    newSubEntry.set(prop, value);
                    continue;
                }
                LocaleString entityDisplayName = currentObj.getDynamicObjectType().getDisplayName();
                String msgTpl = ResManager.loadKDString((String)"\u5143\u6570\u636e\u4e0d\u5339\u914d\uff0c\u5b50\u5355\u636e\u4f53\u5206\u5f55\u5b57\u6bb5\u3010%1$s\u3011\u5728\u5f53\u524d\u73af\u5883\u7684\u3010%2$s\u3011\u5b9e\u4f53\u4e0a\u4e0d\u5b58\u5728", (String)"JsonDataPacketImpl_14", (String)"sys-ricc-platform", (Object[])new Object[0]);
                throw new RiccBizException(String.format(msgTpl, subEntryFieldKey, entityDisplayName));
            }
        }
    }

    private void coverAdminInfo(DynamicObject currentObj, IDataEntityProperty prop) {
        if ("all".equals(this.coverConfig)) {
            currentObj.set(prop, (Object)this.curUser);
            currentObj.set(prop.getName() + BASEDATA_ID_PROP_SUFFIX, (Object)RequestContext.get().getCurrUserId());
        }
    }

    private void setBillCreatorObjVal(DynamicObject currentObj, List<String> bdValInfo, BasedataProp prop, JSONObject dataMap, Map<String, DynamicObject> fillSuccessDyo) {
        if ("all".equals(this.coverConfig)) {
            if (this.isNew()) {
                currentObj.set((IDataEntityProperty)prop, (Object)this.curUser);
                currentObj.set(prop.getName() + BASEDATA_ID_PROP_SUFFIX, (Object)RequestContext.get().getCurrUserId());
            }
        } else if (bdValInfo != null && !bdValInfo.isEmpty()) {
            DynamicObject user = this.getBdFromFilter(bdValInfo.get(0), bdValInfo.get(1), bdValInfo.get(2), bdValInfo.get(3), dataMap, fillSuccessDyo);
            if (user == null) {
                String displayName = prop.getDisplayName().getLocaleValue();
                String baseDataEntityNumber = bdValInfo.get(0);
                String baseDataEntityName = EntityMetadataCache.getDataEntityType((String)baseDataEntityNumber).getDisplayName().getLocaleValue();
                String msgTpl = ResManager.loadKDString((String)"\u201c%1$s\u201d\u5b57\u6bb5\u8bbe\u503c\u5931\u8d25\uff0c\u5728\u5f53\u524d\u73af\u5883\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u3010%2$s\u3011\u7684%3$s(%4$s)\u6570\u636e\uff1b", (String)"JsonDataPacketImpl_13", (String)"sys-ricc-platform", (Object[])new Object[0]);
                throw new RiccBizException(String.format(msgTpl, displayName, bdValInfo.get(3), baseDataEntityName, baseDataEntityNumber));
            }
            currentObj.set((IDataEntityProperty)prop, (Object)user);
            currentObj.set(prop.getName() + BASEDATA_ID_PROP_SUFFIX, user.getPkValue());
        }
    }

    private void setBillCreateDateVal(DynamicObject currentObj, Object dateObj, IDataEntityProperty prop) {
        if ("all".equals(this.coverConfig)) {
            if (this.isNew()) {
                currentObj.set(prop, (Object)new Date());
            }
        } else {
            currentObj.set(prop, (Object)D.t((Object)dateObj));
        }
    }

    private void setBaseDataObjVal(DynamicObject currentObj, List<String> bdValInfo, BasedataProp prop, JSONObject dataMap, Map<String, DynamicObject> fillSuccessDyo) {
        if (bdValInfo != null && !bdValInfo.isEmpty()) {
            String basedataEntityNumber = bdValInfo.get(0);
            String numberVal = bdValInfo.get(3);
            DynamicObject bd = this.getBdFromFilter(basedataEntityNumber, bdValInfo.get(1), bdValInfo.get(2), numberVal, dataMap, fillSuccessDyo);
            if (bd == null) {
                String displayName = prop.getDisplayName().getLocaleValue();
                String baseDataEntityName = EntityMetadataCache.getDataEntityType((String)basedataEntityNumber).getDisplayName().getLocaleValue();
                String msgTpl = ResManager.loadKDString((String)"\u201c%1$s\u201d\u5b57\u6bb5\u8bbe\u503c\u5931\u8d25\uff0c\u5728\u5f53\u524d\u73af\u5883\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u3010%2$s\u3011\u7684%3$s(%4$s)\u6570\u636e\uff1b", (String)"JsonDataPacketImpl_13", (String)"sys-ricc-platform", (Object[])new Object[0]);
                throw new RiccBizException(String.format(msgTpl, displayName, numberVal, baseDataEntityName, basedataEntityNumber));
            }
            currentObj.set((IDataEntityProperty)prop, (Object)bd);
            currentObj.set(prop.getName() + BASEDATA_ID_PROP_SUFFIX, bd.getPkValue());
        }
    }

    private void setMultiBaseDataObjVal(DynamicObject currentObj, Object bdValInfo, IDataEntityProperty prop, JSONObject dataMap, Map<String, DynamicObject> fillSuccessDyo) {
        if (bdValInfo != null) {
            Map bdValueMap = (Map)bdValInfo;
            String basedataEntityNumber = (String)bdValueMap.get("type");
            String numberField = (String)bdValueMap.get(NUMBER_FIELD);
            JSONArray arrays = (JSONArray)JSON.toJSON(bdValueMap.get(CONTENT));
            DynamicObjectCollection basedatas = currentObj.getDynamicObjectCollection(prop);
            basedatas.clear();
            for (int i = 0; i < arrays.size(); ++i) {
                JSONArray value = arrays.getJSONArray(i);
                String numberVal = value.getString(1);
                DynamicObject bd = this.getBdFromFilter(basedataEntityNumber, numberField, value.getString(0), numberVal, dataMap, fillSuccessDyo);
                if (bd == null) {
                    String displayName = prop.getDisplayName().getLocaleValue();
                    String baseDataEntityName = EntityMetadataCache.getDataEntityType((String)basedataEntityNumber).getDisplayName().getLocaleValue();
                    String msgTpl = ResManager.loadKDString((String)"\u201c%1$s\u201d\u5b57\u6bb5\u8bbe\u503c\u5931\u8d25\uff0c\u5728\u5f53\u524d\u73af\u5883\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u3010%2$s\u3011\u7684%3$s(%4$s)\u6570\u636e\uff1b", (String)"JsonDataPacketImpl_13", (String)"sys-ricc-platform", (Object[])new Object[0]);
                    throw new RiccBizException(String.format(msgTpl, displayName, numberVal, baseDataEntityName, basedataEntityNumber));
                }
                DynamicObject newRow = new DynamicObject(basedatas.getDynamicObjectType());
                newRow.set("fbasedataid", (Object)bd);
                basedatas.add((Object)newRow);
            }
        }
    }

    private DynamicObject getBdFromFilter(String entityName, String numberField, Object id, String number, JSONObject dataMap, Map<String, DynamicObject> fillSuccessDyo) {
        String cacheKey;
        Map bdCache = this.bdCaches.computeIfAbsent(entityName, k -> new HashMap(8));
        DynamicObject cacheObj = (DynamicObject)bdCache.get(cacheKey = entityName + numberField + id + number);
        if (cacheObj != null) {
            return cacheObj;
        }
        QFilter filter = null;
        id = JsonImportHelper.idCovert(entityName, id);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        DataEntityPropertyCollection properties = entityType.getProperties();
        boolean containsNumber = properties.containsKey((Object)numberField);
        switch (this.bdQueryMethod) {
            case 0: {
                filter = new QFilter(ID, "=", id);
                break;
            }
            case 1: {
                if (!containsNumber) {
                    String msg = ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u201c%1$s\u201d\u4e0d\u5b58\u5728\u6807\u8bc6\u4e3a\u201c%2$s\u201d\u7f16\u7801\u5b57\u6bb5\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u67e5\u8be2\u552f\u4e00\u503c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"JsonDataPacketImpl_22", (String)"sys-ricc-platform", (Object[])new Object[0]);
                    throw new RiccBizException(String.format(msg, entityType.getDisplayName(), numberField));
                }
                filter = new QFilter(numberField, "=", (Object)number);
                break;
            }
            case 2: {
                filter = new QFilter(ID, "=", id);
                if (!containsNumber || StringUtils.isEmpty((String)number)) break;
                filter.or(numberField, "=", (Object)number);
                break;
            }
            default: {
                filter = new QFilter(ID, "=", id);
                if (!containsNumber || StringUtils.isEmpty((String)number)) break;
                filter.and(numberField, "=", (Object)number);
            }
        }
        if (0 != this.bdQueryMethod) {
            boolean containsBoId = properties.containsKey((Object)"boid");
            boolean containsIsCurrentVersion = properties.containsKey((Object)"iscurrentversion");
            if (containsBoId && containsIsCurrentVersion) {
                logger.info("\u57fa\u7840\u8d44\u6599\uff1a" + entityName + "\u4e3a\u5e26\u5386\u53f2\u7248\u672c\u57fa\u7840\u8d44\u6599\uff0c\u6dfb\u52a0iscurrentversion='1'\u8fc7\u6ee4\u6761\u4ef6");
                filter.and("iscurrentversion", "=", (Object)"1");
            }
        }
        StringBuilder selectFields = new StringBuilder(ID);
        if (containsNumber) {
            selectFields.append(",").append(numberField);
        }
        List idList = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])new QFilter[]{filter}, null, (int)-1);
        DynamicObject bd = null;
        if (CollectionUtils.isNotEmpty((Collection)idList)) {
            DynamicObject[] baseDataObj = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)entityType);
            Map<Object, DynamicObject> baseDataMap = Arrays.stream(baseDataObj).collect(Collectors.toMap(DataEntityBase::getPkValue, e -> e, (n1, n2) -> n2));
            bd = this.getBdFromCacheResult(numberField, id, number, entityType, containsNumber, baseDataMap);
        }
        if (bd != null) {
            bdCache.put(cacheKey, bd);
        } else {
            String keyFieldsValue;
            DynamicObject dyo;
            JSONObject current = dataMap.getJSONObject(id.toString());
            if (current != null && (dyo = fillSuccessDyo.get(keyFieldsValue = current.getString("keyfieldsValue"))) != null) {
                bd = dyo;
                bdCache.put(cacheKey, bd);
            }
        }
        return bd;
    }

    private DynamicObject getBdFromCacheResult(String numberField, Object id, String number, MainEntityType entityType, boolean containsNumber, Map<Object, DynamicObject> baseDataMap) {
        DynamicObject bd = null;
        if (baseDataMap.isEmpty()) {
            return bd;
        }
        if (baseDataMap.size() == 1) {
            bd = baseDataMap.values().iterator().next();
        } else if (containsNumber && !StringUtils.isEmpty((String)number)) {
            int numberValueCount = 0;
            for (DynamicObject bdObj : baseDataMap.values()) {
                String numberValue = bdObj.getString(numberField);
                if (!StringUtils.equals((String)numberValue, (String)number)) continue;
                bd = bdObj;
                if (id.equals(bdObj.getPkValue())) {
                    return bdObj;
                }
                ++numberValueCount;
            }
            if (numberValueCount >= 2) {
                String msg = ResManager.loadKDString((String)"\u201c%1$s\u201d\u540c\u6b65\u5931\u8d25\uff0c\u901a\u8fc7\u201c%2$s\u201d\u5b57\u6bb5\u7f16\u7801\u201c%3$s\u201d\u627e\u5230\u591a\u6761\u6570\u636e\uff0c\u672a\u5339\u914d\u5230\u552f\u4e00\u503c\uff0c\u8bf7\u5728\u7cfb\u7edf\u4e2d\u5904\u7406\u540e\u518d\u8fdb\u884c\u540c\u6b65", (String)"JsonDataPacketImpl_26", (String)"sys-ricc-platform", (Object[])new Object[0]);
                throw new RiccBizException(String.format(msg, entityType.getDisplayName(), numberField, number));
            }
        } else {
            bd = baseDataMap.get(id);
        }
        return bd;
    }

    private int getBdQueryMethod() {
        int key = -1;
        DynamicObject data = BusinessDataServiceHelper.loadSingle((String)"ricc_initconfig", (String)"id,comparekey", (QFilter[])new QFilter[0]);
        if (data != null) {
            key = data.getInt("comparekey");
        }
        return key;
    }

    static interface BaseDataQueryMethods {
        public static final int ONLY_ID = 0;
        public static final int ONLY_NUMBER = 1;
        public static final int ID_OR_NUMBER = 2;
        public static final int ID_AND_NUMBER = 3;
    }
}

