/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.core.impl.metadata;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sys.ricc.business.datapacket.core.ISubDataPacket;
import kd.sys.ricc.business.datapacket.core.model.SdpInputParams;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;
import kd.sys.ricc.business.datapacket.schedule.AddPacketProgress;
import kd.sys.ricc.business.schedule.ScheduleUtil;
import kd.sys.ricc.business.schedule.TaskHandler;
import kd.sys.ricc.business.schedule.TaskIf;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.StringUtils;

public class MetaDataDeployImpl
implements ISubDataPacket {
    private static final Log logger = LogFactory.getLog(MetaDataDeployImpl.class);
    private static final String BOS_DEVPORTAL_BIZCLOUD = "bos_devportal_bizcloud";

    @Override
    public SdpOutputParams exportPacket(SdpInputParams sdpInputParams) {
        return null;
    }

    @Override
    public SdpOutputParams importPacket(SdpInputParams sdpInputParams) {
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        if (EnvTypeHelper.isProductEnv()) {
            String errorMsg = ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u73af\u5883\u7a33\u5b9a\uff0c\u751f\u4ea7\u73af\u5883\u6682\u4e0d\u5141\u8bb8\u7f16\u8f91\u5143\u6570\u636e\u3002", (String)"MetaDataDeployImpl_0", (String)"sys-ricc-platform", (Object[])new Object[0]);
            sdpOutputParams.append(errorMsg);
            return sdpOutputParams;
        }
        boolean isHasPermisson = AppUtils.checkPagePermission((String)"bos_devportal_bizapplist", (String)"4730fc9f000003ae");
        if (!isHasPermisson) {
            sdpOutputParams.append(ResManager.loadKDString((String)"\u6ca1\u6709\u5bfc\u5165\u6743\u9650\uff0c\u8bf7\u5148\u6dfb\u52a0\u5bfc\u5165\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"MetaDataDeployImpl_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return sdpOutputParams;
        }
        String fileUrl = (String)sdpInputParams.getParam().get("fileUrl");
        Map custParam = (Map)sdpInputParams.getParam().get("custparam");
        String cloudNumber = (String)custParam.get("cloudNumber");
        if (StringUtils.isEmpty((String)cloudNumber)) {
            sdpOutputParams.append(ResManager.loadKDString((String)"\u5143\u6570\u636e\u4f20\u8f93\u5305\u5f02\u5e38\uff0c\u65e0\u6cd5\u83b7\u53d6\u5143\u6570\u636e\u5305\u9700\u8981\u90e8\u7f72\u5230\u7684\u4e1a\u52a1\u4e91\u3002", (String)"MetaDataDeployImpl_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return sdpOutputParams;
        }
        QFilter qFilter = new QFilter("number", "=", (Object)cloudNumber);
        DynamicObject selectCloudObject = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_DEVPORTAL_BIZCLOUD, (QFilter[])qFilter.toArray());
        if (selectCloudObject == null) {
            sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e\u4f20\u8f93\u5305\u5f02\u5e38\uff0c\u901a\u8fc7\u4e91\u7f16\u7801\uff1a%1$s \u65e0\u6cd5\u83b7\u53d6\u76ee\u6807\u7cfb\u7edf\u4e1a\u52a1\u4e91\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5b58\u5728\u8be5\u7f16\u7801\u7684\u4e1a\u52a1\u4e91\uff0c\u5982\u4e0d\u5b58\u5728\u8bf7\u5148\u5728\u76ee\u6807\u73af\u5883\u521b\u5efa\u7f16\u7801\u4e3a\uff1a%2$s \u7684\u4e1a\u52a1\u4e91\uff0c\u7136\u540e\u518d\u6b21\u6267\u884c\u540c\u6b65\u3002", (String)"MetaDataDeployImpl_3", (String)"sys-ricc-platform", (Object[])new Object[0]), cloudNumber, cloudNumber));
            return sdpOutputParams;
        }
        String selectCloudId = selectCloudObject.getString("id");
        final AddPacketProgress addPacketProgress = sdpInputParams.getAddPacketProgress();
        String tempFileUrl = FileUtils.getTempUrlFormFileUrl((String)fileUrl, (int)18000);
        String urlName = (String)sdpInputParams.getParam().get("fileName");
        JSONArray jsonArr = new JSONArray();
        JSONObject jsonObj = new JSONObject();
        jsonObj.put(urlName, (Object)tempFileUrl);
        jsonArr.add((Object)jsonObj);
        String urlArr = jsonArr.toJSONString();
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("urlarr", urlArr);
        params.put("bizcloudid", selectCloudId);
        JobFormInfo jobFormInfo = this.buildJobFormInfo(params);
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        new TaskHandler(taskId, new TaskIf(){

            @Override
            public void ifUpdate(TaskInfo taskInfo) {
                ScheduleUtil.addPacketFeedbackProgress(addPacketProgress, taskInfo.getProgress() >= 10 ? taskInfo.getProgress() - 10 : taskInfo.getProgress(), taskInfo.getDesc(), ScheduleUtil.getTaskCustData(taskInfo));
            }
        }).wait2End();
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if ("FAILED".equalsIgnoreCase(taskInfo.getStatus())) {
            sdpOutputParams.append(taskInfo.getFailureReason());
            return sdpOutputParams;
        }
        String taskData = taskInfo.getData();
        if (!StringUtils.isBlank((CharSequence)taskData)) {
            logger.info("\u5143\u6570\u636e\u5bfc\u5165\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)taskData);
            if (StringUtils.equals((String)"old", (String)System.getProperty("dev.appinstall.mode", "old"))) {
                logger.info("\u5143\u6570\u636e\u5bfc\u5165\u8fd4\u56de\u53c2\u6570\u89e3\u6790\u8d706.0\u4ee5\u524d\u7684\u903b\u8f91\u5904\u7406");
                this.oldImportReturnDataParse(taskData, sdpOutputParams);
            } else {
                logger.info("\u5143\u6570\u636e\u5bfc\u5165\u8fd4\u56de\u53c2\u6570\u89e3\u6790\u8d706.0\u65b0\u7248\u903b\u8f91\u5904\u7406");
                this.newImportReturnDataParse(taskData, sdpOutputParams);
            }
        }
        return sdpOutputParams;
    }

    private void newImportReturnDataParse(String taskData, SdpOutputParams sdpOutputParams) {
        Map data = (Map)SerializationUtils.fromJsonString((String)taskData, Map.class);
        boolean isSuccess = Boolean.parseBoolean((String)data.get("success"));
        if (isSuccess) {
            sdpOutputParams.setSuccess(true);
            List deployResultList = (List)SerializationUtils.fromJsonString((String)data.get("detail").toString(), List.class);
            DeployResult deployResult = new DeployResult();
            this.parseDeployResult(deployResultList, deployResult);
            if (deployResult.error > 0) {
                sdpOutputParams.setSuccess(false);
                int successCount = deployResult.total - deployResult.error;
                String msgTpl = ResManager.loadKDString((String)"\u603b\u5171%1$d\u4e2a\u6587\u4ef6\uff0c\u6210\u529f%2$d\u4e2a\uff0c\u5931\u8d25%3$d\u4e2a\uff0c\u8be6\u7ec6\u5931\u8d25\u65e5\u5fd7\uff1a%4$s", (String)"MetaDataDeployImpl_4", (String)"sys-ricc-platform", (Object[])new Object[0]);
                String errorMsg = String.format(msgTpl, deployResult.total, successCount, deployResult.error, deployResult.msg.toString());
                sdpOutputParams.append(errorMsg);
            } else {
                String msgTpl = ResManager.loadKDString((String)"\u6210\u529f%d\u4e2a\u6587\u4ef6", (String)"MetaDataDeployImpl_5", (String)"sys-ricc-platform", (Object[])new Object[0]);
                String errorMsg = String.format(msgTpl, deployResult.total);
                sdpOutputParams.append(errorMsg);
            }
        } else {
            sdpOutputParams.append(data.get("error"));
            sdpOutputParams.setSuccess(false);
        }
    }

    private void oldImportReturnDataParse(String taskData, SdpOutputParams sdpOutputParams) {
        Map data = (Map)SerializationUtils.fromJsonString((String)taskData, Map.class);
        if (Boolean.parseBoolean((String)data.get("success"))) {
            sdpOutputParams.setSuccess(true);
            Map installMsg = (Map)data.get("installmsg");
            List errorList = (List)installMsg.get("errorlist");
            List successList = (List)installMsg.get("successlist");
            List repeatSqlList = (List)installMsg.get("repeatsqllist");
            StringBuilder stringBuilder = new StringBuilder();
            int error = this.getSize(errorList, stringBuilder);
            int success = this.getSize(successList, stringBuilder);
            int repeatSql = this.getSize(repeatSqlList, stringBuilder);
            if (error > 0) {
                stringBuilder.append(String.format(ResManager.loadKDString((String)"\u5931\u8d25\uff1a%1$s\u4e2a\u6587\u4ef6%2$s", (String)"MetaDataDeployImpl_6", (String)"sys-ricc-platform", (Object[])new Object[0]), error, System.lineSeparator()));
                if (repeatSql > 0) {
                    stringBuilder.append(String.format(ResManager.loadKDString((String)"\u6210\u529f\uff1a%1$s\u4e2a\u6587\u4ef6;%2$s\u91cd\u590d\u6267\u884c\uff1a%3$s\u4e2a\u6587\u4ef6%4$s", (String)"MetaDataDeployImpl_10", (String)"sys-ricc-platform", (Object[])new Object[0]), success, System.lineSeparator(), repeatSql, System.lineSeparator()));
                } else {
                    stringBuilder.append(String.format(ResManager.loadKDString((String)"\u6210\u529f\uff1a%1$s\u4e2a\u6587\u4ef6%2$s", (String)"MetaDataDeployImpl_11", (String)"sys-ricc-platform", (Object[])new Object[0]), success, System.lineSeparator()));
                    logger.info("\u5143\u6570\u636e\u5bfc\u51fa\u65e5\u5fd7", (Object)stringBuilder.toString());
                }
                sdpOutputParams.setSuccess(false);
                sdpOutputParams.append(stringBuilder.toString());
            }
        } else {
            sdpOutputParams.append(data.get("error").toString());
            sdpOutputParams.setSuccess(false);
        }
    }

    private int getSize(List<Map<String, String>> list, StringBuilder stringBuilder) {
        int size = 0;
        if (list != null) {
            list = list.stream().filter(f -> !f.isEmpty()).collect(Collectors.toList());
            size = list.size();
            this.buildLogs(list, stringBuilder);
        }
        return size;
    }

    private void buildLogs(List<Map<String, String>> list, StringBuilder stringBuilder) {
        Map<String, String> tempMap = null;
        for (int i = 0; i < list.size(); ++i) {
            tempMap = list.get(i);
            if (tempMap == null) continue;
            Set<Map.Entry<String, String>> entrySet = tempMap.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                stringBuilder.append(entry.getKey());
                stringBuilder.append("->");
                stringBuilder.append(entry.getValue());
                stringBuilder.append('\n');
            }
        }
    }

    private void parseDeployResult(List<Map<String, Object>> resultInfos, DeployResult deployResult) {
        for (Map<String, Object> resultInfo : resultInfos) {
            List subDeployResultInfos;
            List warnMsgs;
            ++deployResult.total;
            String status = (String)resultInfo.get("result");
            if ("error".equals(status) || "fail".equals(status)) {
                ++deployResult.error;
                List errorMsgs = (List)resultInfo.get("errorMsgList");
                if (!errorMsgs.isEmpty()) {
                    deployResult.msg.append(errorMsgs);
                }
            } else if ("warn".equals(status) && !(warnMsgs = (List)resultInfo.get("warnMsgList")).isEmpty()) {
                deployResult.msg.append(warnMsgs);
            }
            if ((subDeployResultInfos = (List)resultInfo.get("subDeployResultInfoList")).isEmpty()) continue;
            this.parseDeployResult(subDeployResultInfos, deployResult);
        }
    }

    private JobFormInfo buildJobFormInfo(Map<String, Object> params) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setName(ResManager.loadKDString((String)"\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u5bfc\u5165\u5143\u6570\u636e\u3002", (String)"MetaDataDeployImpl_8", (String)"sys-ricc-platform", (Object[])new Object[0]));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(UserServiceHelper.getCurrentUserId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId("ricc");
        jobInfo.setTaskClassname("kd.bos.devportal.app.plugin.AppImportTask");
        jobInfo.setParams(params);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setParentPageId("");
        jobFormInfo.setRootPageId("");
        jobFormInfo.setTimeout(1800);
        return jobFormInfo;
    }

    static class DeployResult {
        int total;
        int error;
        StringBuilder msg = new StringBuilder();

        private DeployResult() {
        }
    }
}

