/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.helper;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.devportal.util.AppPackageUtil;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.sys.ricc.business.datapacket.core.ISubDataPacket;
import kd.sys.ricc.business.datapacket.core.model.SdpInputParams;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;
import kd.sys.ricc.common.query.CommonQuery;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.Hex;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.exception.RiccBizException;
import org.apache.commons.io.FilenameUtils;

public class DataPacketHelper {
    private static final Log log = LogFactory.getLog(DataPacketHelper.class);
    private static final String PACKET_VERSION = "packetversion";

    private DataPacketHelper() {
    }

    public static long getLatestPacketVersion() {
        DynamicObject packetVersion;
        long currentUserId = UserServiceHelper.getCurrentUserId();
        QFilter packetFilter = new QFilter("creator.id", "=", (Object)currentUserId);
        DynamicObject[] packets = BusinessDataServiceHelper.load((String)"ricc_datapacket", (String)"id,packetversion", (QFilter[])packetFilter.toArray(), (String)"createtime desc", (int)1);
        if (!Objects.isNull(packets) && packets.length > 0 && (packetVersion = (DynamicObject)packets[0].get(PACKET_VERSION)) != null) {
            return (Long)packetVersion.getPkValue();
        }
        return 0L;
    }

    public static List<DynamicObject> uploadDataPacketByTempUrl(Object packetId, String tempUrl, String uploadPath, String guideNumber) {
        String realUrl;
        TempFileCacheDownloadable.Content cacheContentFromTempUrl = FileUtils.getCacheContentFromTempUrl((String)tempUrl);
        int length = cacheContentFromTempUrl.getLength();
        String fileName = cacheContentFromTempUrl.getFilename();
        int lastIndexOf = fileName.lastIndexOf(46);
        String suffix = fileName.substring(lastIndexOf);
        fileName = guideNumber + "_" + System.currentTimeMillis() + suffix;
        uploadPath = uploadPath + File.separator + fileName;
        FileService fs = FileServiceFactory.getAttachmentFileService();
        try (InputStream in = cacheContentFromTempUrl.getInputStream();){
            FileItem fi = new FileItem(fileName, uploadPath, in);
            realUrl = fs.upload(fi);
        }
        catch (Exception e) {
            String msgTpl = ResManager.loadKDString((String)"\u4e0a\u4f20\u4f20\u8f93\u5305\u5931\u8d25", (String)"DataPacketHelper_0", (String)"sys-ricc-platform", (Object[])new Object[0]);
            throw new RiccBizException(msgTpl, (Throwable)e);
        }
        Map uploadFileMap = CommonUtil.createUploadFileMap((String)"ricc_datapacket", (Object)packetId, (String)"subdatapacketfile", (String)realUrl, (String)fileName, (long)length, (String)fileName.substring(fileName.lastIndexOf(46) + 1));
        ArrayList<Map> attachments = new ArrayList<Map>();
        attachments.add(uploadFileMap);
        return AttachmentFieldServiceHelper.saveAttachments((String)"ricc_datapacket", (String)"", attachments);
    }

    public static String getFilters(Map<String, Object> param) {
        Object customParamObject = param.get("custparam");
        String filters = null;
        if (customParamObject instanceof Map) {
            Map customParamMap = (Map)customParamObject;
            filters = (String)customParamMap.get("filters");
        }
        log.info("\u6279\u91cf\u6253\u5305\u8fc7\u6ee4\u6761\u4ef6\uff1a{}", filters);
        return filters;
    }

    public static List<Map<String, Object>> getCustomParam(String entityNumber, Object[] selectedRowsPk, String filterStr, Set<String> keyFields) {
        QFilter filter = null;
        if (selectedRowsPk != null && selectedRowsPk.length > 0) {
            filter = new QFilter("id", "in", (Object)selectedRowsPk);
        } else if (StringUtils.isNotBlank((CharSequence)filterStr)) {
            filter = QFilter.fromSerializedString((String)filterStr);
        }
        ArrayList<Map<String, Object>> customParam = new ArrayList<Map<String, Object>>(10);
        CommonQuery.getAllSelectData((String)entityNumber, (QFilter)filter, (boolean)true, customParam, keyFields);
        return customParam;
    }

    public static String getFileUrl(DynamicObject row) {
        DynamicObjectCollection fileDy = (DynamicObjectCollection)row.get("subdatapacketfile");
        if (fileDy.isEmpty()) {
            return null;
        }
        DynamicObject file = (DynamicObject)fileDy.get(0);
        DynamicObject fileBaseDataId = file.getDynamicObject("fbasedataid");
        if (fileBaseDataId == null) {
            return null;
        }
        String fileUrl = fileBaseDataId.getString("url");
        return CommonUtil.checkUrl((String)fileUrl);
    }

    public static DynamicObject[] getSelectedPackets(Object[] listSelectedRows) {
        MainEntityType itemType = EntityMetadataCache.getDataEntityType((String)"ricc_datapacket");
        return BusinessDataServiceHelper.load((Object[])listSelectedRows, (DynamicObjectType)itemType);
    }

    public static List<Object> getItemIdsByPacket(DynamicObject[] packets, boolean needAbandoned) {
        ArrayList<Object> itemIdList = new ArrayList<Object>(10);
        for (DynamicObject packet : packets) {
            DynamicObjectCollection subDataPack = packet.getDynamicObjectCollection("subdatapacket");
            for (DynamicObject subDataPackRow : subDataPack) {
                DynamicObject bizObject;
                String entryStatus;
                if (!needAbandoned && StringUtils.equals((String)"1", (String)(entryStatus = subDataPackRow.getString("entrystatus"))) || (bizObject = subDataPackRow.getDynamicObject("bizobject")) == null) continue;
                itemIdList.add(bizObject.getPkValue());
            }
        }
        return itemIdList;
    }

    public static Map<String, Object> getPreViewParams(DynamicObject subDataPackRow, String importType, int pageSize, int pageIndex) {
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        param.put("pageSize", pageSize);
        param.put("pageIndex", pageIndex);
        param.put("isReturnAllData", false);
        switch (importType) {
            case "excel": 
            case "json": {
                String customParam = (String)subDataPackRow.get("custparam_tag");
                String codeParam = "";
                if (StringUtils.isNotBlank((CharSequence)customParam) && !StringUtils.equals((String)customParam, (String)"null")) {
                    codeParam = StringUtils.compressString((String)customParam);
                    param.put("custparam", codeParam);
                    break;
                }
                throw new RiccBizException(ResManager.loadKDString((String)"\u9884\u89c8\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u6253\u5305\u6216\u9009\u62e9\u6570\u636e\u3002", (String)"DataPacketHelper_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
            }
            case "custom": 
            case "microService": {
                String dataStream = null;
                String fileUrl = DataPacketHelper.getFileUrl(subDataPackRow);
                FileService fs = FileServiceFactory.getAttachmentFileService();
                if (fileUrl == null || !fs.exists(fileUrl)) {
                    throw new RiccBizException(ResManager.loadKDString((String)"\u5b50\u5305\u4e2d\u65e0\u6cd5\u627e\u5230\u6709\u6548\u6587\u4ef6", (String)"DataPacketHelper_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
                }
                try (InputStream inputStream = fs.getInputStream(fileUrl);){
                    byte[] dataPacketBytes = FileUtils.inputStreamToByte((InputStream)inputStream);
                    dataStream = Hex.encode((byte[])dataPacketBytes);
                }
                catch (Exception ex) {
                    log.info("\u6587\u4ef6\u8f6c\u5b57\u7b26\u6d41\u5931\u8d25", (Object)ex);
                    throw new RiccBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u8f6c\u5b57\u7b26\u6d41\u5931\u8d25", (String)"DataPacketHelper_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
                }
                param.put("filePathStream ", dataStream);
                break;
            }
        }
        return param;
    }

    public static List<String> getMetaNumbers(List<Long> packetIds) {
        DynamicObject[] objs;
        ArrayList<String> metaNumbers = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(packetIds) && (objs = BusinessDataServiceHelper.load((Object[])packetIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ricc_datapacket"))) != null && objs.length > 0) {
            Arrays.stream(objs).forEach(obj -> {
                DynamicObjectCollection subDataPackets = obj.getDynamicObjectCollection("subdatapacket");
                if (CollectionUtils.isNotEmpty((Collection)subDataPackets)) {
                    for (DynamicObject row : subDataPackets) {
                        DynamicObjectCollection fileDy = (DynamicObjectCollection)row.get("subdatapacketfile");
                        if (CollectionUtils.isEmpty((Collection)fileDy)) continue;
                        DynamicObject dataPackage = (DynamicObject)fileDy.get(0);
                        DynamicObject fileBaseDataId = dataPackage.getDynamicObject("fbasedataid");
                        String fileUrl = (String)fileBaseDataId.get("url");
                        String tempFileUrl = FileUtils.getTempUrlFormFileUrl((String)fileUrl, (int)18000);
                        TempFileCache fs = CacheFactory.getCommonCacheFactory().getTempFileCache();
                        try {
                            InputStream in = fs.getInputStream(tempFileUrl);
                            Throwable throwable = null;
                            try {
                                ZipInputStream zipInputStream = new ZipInputStream(in, Charset.forName("UTF-8"));
                                Throwable throwable2 = null;
                                try {
                                    ZipEntry nextEntry;
                                    while ((nextEntry = zipInputStream.getNextEntry()) != null) {
                                        String zipEntryFileName = nextEntry.getName();
                                        if (!zipEntryFileName.endsWith(".zip") || !zipEntryFileName.startsWith("dm")) continue;
                                        try {
                                            ZipEntry dmZipEntry;
                                            byte[] ret = AppPackageUtil.readFileContentToByteArr((ZipInputStream)zipInputStream);
                                            ZipInputStream dmZipIn = new ZipInputStream(new ByteArrayInputStream(ret));
                                            while ((dmZipEntry = dmZipIn.getNextEntry()) != null) {
                                                String dmZipEntryFileName;
                                                if (dmZipEntry.isDirectory() || !(dmZipEntryFileName = dmZipEntry.getName()).endsWith("dym")) continue;
                                                metaNumbers.add(FilenameUtils.getBaseName((String)dmZipEntryFileName));
                                            }
                                        }
                                        catch (Exception e) {
                                            throw new RiccBizException(e.getMessage());
                                        }
                                    }
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    if (zipInputStream == null) continue;
                                    if (throwable2 != null) {
                                        try {
                                            zipInputStream.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                        continue;
                                    }
                                    zipInputStream.close();
                                }
                            }
                            catch (Throwable throwable5) {
                                throwable = throwable5;
                                throw throwable5;
                            }
                            finally {
                                if (in == null) continue;
                                if (throwable != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                    continue;
                                }
                                in.close();
                            }
                        }
                        catch (Exception e) {
                            throw new RiccBizException(e.getMessage());
                        }
                    }
                }
            });
        }
        return metaNumbers;
    }

    public static String getMicroExportUrl(String exportPlugin, ListSelectedRowCollection selectRows, String entityNumber, String entityName, DynamicObject configItem) {
        ISubDataPacket service = (ISubDataPacket)TypesContainer.getOrRegisterSingletonInstance((String)exportPlugin);
        String localPath = FileUtils.generateLocalPath();
        FileUtils.checkAndCreateDir((String)localPath);
        SdpInputParams sdpInputParams = new SdpInputParams();
        sdpInputParams.setLocalPath(localPath);
        sdpInputParams.setSelectRows(selectRows);
        HashMap<String, Object> serviceParam = new HashMap<String, Object>(16);
        serviceParam.put("entitynumber", entityNumber);
        serviceParam.put("entityname", entityName);
        serviceParam.put("guideId", configItem);
        serviceParam.put("pageenterparam", configItem.getString("pageenterparam"));
        serviceParam.put("serviceconfig", configItem.getString("plugin"));
        sdpInputParams.setParam(serviceParam);
        SdpOutputParams sdpOutputParams = service.exportPacket(sdpInputParams);
        return sdpOutputParams.getExportFilePath();
    }
}

