/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.impt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.impt.SheetHandler;
import kd.bos.util.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class CompareDataSheetHandler
extends SheetHandler {
    private final Map<Integer, String> fieldsMap;
    private final Map<Integer, String> titleMap;
    private final List<Map<Integer, Object>> rowList;
    private final String entityNumber;

    public CompareDataSheetHandler(Map<Integer, String> fieldsMap, Map<Integer, String> titleMap, List<Map<Integer, Object>> rowList, String entityNumber) {
        this.setReadOriginalNum(true);
        this.fieldsMap = fieldsMap;
        this.titleMap = titleMap;
        this.rowList = rowList;
        this.entityNumber = entityNumber;
    }

    public void handleRow(SheetHandler.ParsedRow row) {
        if (row.getRowNum() == 0) {
            this.titleMap.putAll(row.getData());
        }
        if (row.getRowNum() == 2) {
            this.fieldsMap.putAll(row.getData());
        }
        if (row.getRowNum() >= 4 && !row.isEmpty()) {
            CompareDataSheetHandler.dealRowData(row, this.rowList, this.titleMap, this.fieldsMap, this.entityNumber);
        }
    }

    private static void dealRowData(SheetHandler.ParsedRow row, List<Map<Integer, Object>> rowList, Map<Integer, String> titleMap, Map<Integer, String> fieldsMap, String entityNumber) {
        HashMap<Integer, Object> data = new HashMap<Integer, Object>(row.getData());
        if (CollectionUtils.isNotEmpty(rowList)) {
            Set keys = row.getData().keySet();
            List<Integer> sortedKeys = keys.stream().sorted().collect(Collectors.toList());
            List<Integer> entryKeys = keys.stream().filter(o -> titleMap.containsKey(o) && o != 0).sorted().collect(Collectors.toList());
            Integer firstKey = sortedKeys.toArray(new Integer[0])[0];
            if (titleMap.containsKey(firstKey) && firstKey != 0) {
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                for (int i = Math.min(entryKeys.get(0), (Integer)sortedKeys.get(sortedKeys.size() - 1)); i <= Math.max(entryKeys.get(0), (Integer)sortedKeys.get(sortedKeys.size() - 1)); ++i) {
                    Integer rowIndex;
                    IDataEntityProperty prop = dataEntityType.findProperty(String.valueOf(fieldsMap.get(i)));
                    if (prop == null) {
                        String field = fieldsMap.get(i);
                        if (field.contains(".")) {
                            prop = dataEntityType.findProperty(field.substring(0, field.lastIndexOf(46)));
                        } else if (field.endsWith("_id")) {
                            prop = dataEntityType.findProperty(field.substring(0, field.lastIndexOf(95)));
                        }
                    }
                    if (prop == null) {
                        data.remove(i);
                        continue;
                    }
                    Map<Integer, Object> rowMap = rowList.get(rowList.size() - 1);
                    if (titleMap.containsKey(i)) {
                        if (prop instanceof SubEntryProp) {
                            IDataEntityProperty parentProp = CompareDataSheetHandler.buildParentProp(dataEntityType, fieldsMap, i);
                            rowIndex = CompareDataSheetHandler.buildRowIndex(fieldsMap, parentProp);
                            List entryRowList = (List)rowMap.get(rowIndex);
                            Map entryMap = (Map)entryRowList.get(entryRowList.size() - 1);
                            HashMap subEntryMap = new HashMap();
                            subEntryMap.put(i, data.remove(i));
                            if (entryMap.containsKey(i)) {
                                List subEntryList = (List)entryMap.get(i);
                                subEntryList.add(subEntryMap);
                                continue;
                            }
                            entryMap.put(i, new ArrayList(Collections.singletonList(subEntryMap)));
                            continue;
                        }
                        List entryList = (List)rowMap.get(i);
                        HashMap entryMap = new HashMap();
                        entryMap.put(i, data.remove(i));
                        entryList.add(entryMap);
                        continue;
                    }
                    IDataEntityProperty property = CompareDataSheetHandler.buildParentProp(dataEntityType, fieldsMap, i);
                    rowIndex = CompareDataSheetHandler.buildRowIndex(fieldsMap, property);
                    Map<Integer, Object> lastData = rowList.get(rowList.size() - 1);
                    if (property instanceof SubEntryProp) {
                        IDataEntityProperty entryProperty = CompareDataSheetHandler.buildParentProp(dataEntityType, fieldsMap, rowIndex);
                        Integer entryRowIndex = CompareDataSheetHandler.buildRowIndex(fieldsMap, entryProperty);
                        List entryList = (List)lastData.get(entryRowIndex);
                        Map entryMap = (Map)entryList.get(entryList.size() - 1);
                        List subEntryList = (List)entryMap.get(rowIndex);
                        Map subEntryMap = (Map)subEntryList.get(subEntryList.size() - 1);
                        subEntryMap.put(i, data.remove(i));
                    } else {
                        List entryList = (List)lastData.get(rowIndex);
                        Map entryMap = (Map)entryList.get(entryList.size() - 1);
                        entryMap.put(i, data.remove(i));
                    }
                    data.remove(i);
                }
            } else {
                CompareDataSheetHandler.dealEntryRow(entryKeys, entryKeys, data, titleMap, fieldsMap, entityNumber);
                rowList.add(data);
            }
        } else {
            Set keys = row.getData().keySet();
            List<Integer> sortedKeys = keys.stream().sorted().collect(Collectors.toList());
            List<Integer> entryKeys = keys.stream().filter(o -> titleMap.containsKey(o) && o != 0).sorted().collect(Collectors.toList());
            CompareDataSheetHandler.dealEntryRow(entryKeys, sortedKeys, data, titleMap, fieldsMap, entityNumber);
            rowList.add(data);
        }
    }

    private static void dealEntryRow(List<Integer> entryKeys, List<Integer> sortedKeys, Map<Integer, Object> data, Map<Integer, String> titleMap, Map<Integer, String> fieldsMap, String entityNumber) {
        if (CollectionUtils.isNotEmpty(entryKeys)) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            for (int i = Math.min(entryKeys.get(0), sortedKeys.get(sortedKeys.size() - 1)); i <= Math.max(entryKeys.get(0), sortedKeys.get(sortedKeys.size() - 1)); ++i) {
                Map entryMap;
                List entryList;
                Integer rowIndex;
                IDataEntityProperty prop = CompareDataSheetHandler.buildProp(dataEntityType, fieldsMap, i);
                if (prop == null) {
                    data.remove(i);
                    continue;
                }
                if (titleMap.containsKey(i)) {
                    if (prop instanceof SubEntryProp) {
                        IDataEntityProperty parentProp = CompareDataSheetHandler.buildParentProp(dataEntityType, fieldsMap, i);
                        rowIndex = CompareDataSheetHandler.buildRowIndex(fieldsMap, parentProp);
                        entryList = (List)data.get(rowIndex);
                        entryMap = (Map)entryList.get(entryList.size() - 1);
                        HashMap<Integer, Object> subEntryMap = new HashMap<Integer, Object>();
                        subEntryMap.put(i, data.remove(i));
                        entryMap.put(i, new ArrayList(Collections.singletonList(subEntryMap)));
                        continue;
                    }
                    HashMap<Integer, Object> entryMap2 = new HashMap<Integer, Object>();
                    entryMap2.put(i, data.get(i));
                    data.put(i, new ArrayList(Collections.singletonList(entryMap2)));
                    continue;
                }
                IDataEntityProperty property = CompareDataSheetHandler.buildParentProp(dataEntityType, fieldsMap, i);
                rowIndex = CompareDataSheetHandler.buildRowIndex(fieldsMap, property);
                if (property instanceof SubEntryProp) {
                    IDataEntityProperty entryProperty = CompareDataSheetHandler.buildParentProp(dataEntityType, fieldsMap, rowIndex);
                    Integer entryRowIndex = CompareDataSheetHandler.buildRowIndex(fieldsMap, entryProperty);
                    List entryList2 = (List)data.get(entryRowIndex);
                    Map entryMap3 = (Map)entryList2.get(entryList2.size() - 1);
                    List subEntryList = (List)entryMap3.get(rowIndex);
                    Map subEntryMap = (Map)subEntryList.get(subEntryList.size() - 1);
                    subEntryMap.put(i, data.remove(i));
                    continue;
                }
                entryList = (List)data.get(rowIndex);
                entryMap = (Map)entryList.get(entryList.size() - 1);
                entryMap.put(i, data.remove(i));
            }
        }
    }

    private static Integer buildRowIndex(Map<Integer, String> fieldsMap, IDataEntityProperty property) {
        if (property == null) {
            return null;
        }
        for (Map.Entry<Integer, String> entry : fieldsMap.entrySet()) {
            String field = entry.getValue();
            if (StringUtils.equals((String)property.getName(), (String)field)) {
                return entry.getKey();
            }
            if (field.contains(".")) {
                field = field.substring(0, field.lastIndexOf(46));
            } else if (field.endsWith("_id")) {
                field = field.substring(0, field.lastIndexOf(95));
            }
            if (!StringUtils.equals((String)property.getName(), (String)field)) continue;
            return entry.getKey();
        }
        return null;
    }

    private static IDataEntityProperty buildParentProp(MainEntityType dataEntityType, Map<Integer, String> fieldsMap, int index) {
        IDataEntityProperty prop = dataEntityType.findProperty(String.valueOf(fieldsMap.get(index)));
        if (prop == null) {
            String field = fieldsMap.get(index);
            if (field.contains(".")) {
                prop = dataEntityType.findProperty(field.substring(0, field.lastIndexOf(46)));
            } else if (field.endsWith("_id")) {
                prop = dataEntityType.findProperty(field.substring(0, field.lastIndexOf(95)));
            }
        }
        if (prop != null) {
            return dataEntityType.findProperty(prop.getParent().getName());
        }
        return null;
    }

    private static IDataEntityProperty buildProp(MainEntityType dataEntityType, Map<Integer, String> fieldsMap, int index) {
        IDataEntityProperty prop = dataEntityType.findProperty(String.valueOf(fieldsMap.get(index)));
        if (prop == null) {
            String field = fieldsMap.get(index);
            if (field.contains(".")) {
                prop = dataEntityType.findProperty(field.substring(0, field.lastIndexOf(46)));
            } else if (field.endsWith("_id")) {
                prop = dataEntityType.findProperty(field.substring(0, field.lastIndexOf(95)));
            }
        }
        return prop;
    }
}

