/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.impt;

import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ORMUtil;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.sys.ricc.business.impt.CompareDataSheetHandler;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.setter.D;

public class ExcelResolveHelper {
    private static final Log logger = LogFactory.getLog(ExcelResolveHelper.class);
    private static final String XLSX = ".xlsx";
    private static final String ZIP = ".zip";
    private static final String SIGN = ".";

    public static List<Map<String, Object>> resolveXlsxFile(String url, Long configItemId) throws KDException {
        LinkedList<Map<String, Object>> dataList;
        block45: {
            String fileName = FileUtils.getFileNameFromPath((String)url);
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            HashMap<Integer, String> fieldsMap = new HashMap<Integer, String>();
            HashMap<Integer, String> titleMap = new HashMap<Integer, String>();
            LinkedList<Map<Integer, Object>> rowList = new LinkedList<Map<Integer, Object>>();
            dataList = new LinkedList<Map<String, Object>>();
            DynamicObject configItemObj = BusinessDataServiceHelper.loadSingleFromCache((Object)configItemId, (String)"ricc_configitems");
            if (configItemObj != null) {
                String entityNumber = configItemObj.getDynamicObject("page").getString("number");
                if (fileName.endsWith(ZIP)) {
                    try (InputStream inputStream = fileService.getInputStream(url);
                         ZipInputStream zipInputStream = new ZipInputStream(inputStream, Charset.forName("GBK"));){
                        ZipEntry nextEntry = zipInputStream.getNextEntry();
                        while (nextEntry != null) {
                            fileName = nextEntry.getName();
                            if (!(fileName.endsWith("_attach.json") || fileName.equals("attach/") || fileName.startsWith("attach/"))) {
                                ExcelResolveHelper.handleData(zipInputStream, titleMap, fieldsMap, rowList, dataList, entityNumber);
                            }
                            nextEntry = zipInputStream.getNextEntry();
                        }
                        break block45;
                    }
                    catch (Exception e) {
                        throw new KDException(e.getMessage());
                    }
                }
                if (fileName.endsWith(XLSX)) {
                    try (InputStream inputStream = fileService.getInputStream(url);){
                        ExcelResolveHelper.handleData(inputStream, titleMap, fieldsMap, rowList, dataList, entityNumber);
                        break block45;
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                        throw new KDException(e.getMessage());
                    }
                }
                throw new KDException(ResManager.loadKDString((String)"\u6587\u4ef6\u201c%s\u201d\u65e0\u6cd5\u8bc6\u522b\u4e3aexcel\u6587\u4ef6\uff0c\u8bf7\u91cd\u65b0\u6253\u5305\u8fdb\u884c\u4f20\u8f93\u540c\u6b65\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u5904\u7406\u3002", (String)"ExcelResolveHelper_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
            }
        }
        return dataList;
    }

    private static void handleData(InputStream inputStream, Map<Integer, String> titleMap, Map<Integer, String> fieldsMap, List<Map<Integer, Object>> rowList, List<Map<String, Object>> dataList, String entityNumber) throws Exception {
        new ExcelReader().read(inputStream, (SheetHandler)new CompareDataSheetHandler(fieldsMap, titleMap, rowList, entityNumber));
        if (CollectionUtils.isNotEmpty(rowList)) {
            ExcelResolveHelper.dealRowFieldMappping(fieldsMap, rowList, dataList, entityNumber);
        }
    }

    private static void dealRowFieldMappping(Map<Integer, String> fieldsMap, List<Map<Integer, Object>> rowList, List<Map<String, Object>> dataList, String entityNumber) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        rowList.forEach(o -> {
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (Map.Entry<Integer, Object> entry : o.entrySet()) {
                if (!fieldsMap.containsKey(entry.getKey())) continue;
                DynamicProperty prop = dataEntityType.getProperty(String.valueOf(fieldsMap.get(entry.getKey())));
                if (prop == null) {
                    String field = (String)fieldsMap.get(entry.getKey());
                    if (field.contains(SIGN)) {
                        prop = dataEntityType.findProperty(field.substring(0, field.lastIndexOf(46)));
                    } else if (field.endsWith("_id")) {
                        prop = dataEntityType.findProperty(field.substring(0, field.lastIndexOf(95)));
                    }
                }
                ExcelResolveHelper.dealProp(fieldsMap, entry, (IDataEntityProperty)prop, data);
            }
            dataList.add(data);
        });
    }

    private static void dealProp(Map<Integer, String> fieldsMap, Map.Entry<Integer, Object> row, IDataEntityProperty prop, Map<String, Object> data) {
        String key = fieldsMap.get(row.getKey());
        if (key.endsWith(".id") || key.endsWith("_id")) {
            key = "id";
        }
        if (row.getValue() == null) {
            data.put(key, null);
            return;
        }
        if (prop instanceof AdminDivisionProp) {
            ExcelResolveHelper.dealAdminDivisionProp(fieldsMap, row, data);
        } else if (prop instanceof ComboProp) {
            ExcelResolveHelper.dealComboProp(fieldsMap, row, prop, data);
        } else if (prop instanceof BooleanProp) {
            ExcelResolveHelper.dealBooleanProp(fieldsMap, row, data);
        } else if (prop instanceof MuliLangTextProp) {
            ExcelResolveHelper.dealMuliLangTextProp(fieldsMap, row, data);
        } else if (prop instanceof BasedataProp) {
            ExcelResolveHelper.dealBaseDataProp(fieldsMap, row, (BasedataProp)prop, data);
        } else if (prop instanceof EntryProp) {
            ExcelResolveHelper.dealEntryProp(fieldsMap, row, prop, data);
        } else if (prop instanceof DateTimeProp) {
            if (prop instanceof CreateDateProp || prop instanceof ModifyDateProp) {
                String value = (String)row.getValue();
                int index = value.lastIndexOf(":");
                if (index > 0 && value.substring(index + 1).length() == 3) {
                    data.put(key, value.substring(0, index) + SIGN + value.substring(index + 1));
                } else {
                    data.put(key, D.t((Object)row.getValue()));
                }
            } else {
                data.put(key, D.t((Object)row.getValue()));
            }
        } else if (prop instanceof TimeProp) {
            data.put(key, TimeProp.timeToSecond((Object)row.getValue(), (String)key));
        } else if (prop instanceof DecimalProp) {
            int scale = ((DecimalProp)prop).getScale();
            BigDecimal bigDecimal = new BigDecimal((String)row.getValue()).setScale(scale);
            data.put(key, bigDecimal);
        } else if (prop instanceof MulBasedataProp) {
            ExcelResolveHelper.dealMulBasedata(row, prop, data, key);
        } else {
            data.put(key, row.getValue());
        }
    }

    private static void dealMulBasedata(Map.Entry<Integer, Object> row, IDataEntityProperty prop, Map<String, Object> data, String key) {
        String value = (String)row.getValue();
        String[] splitValue = value.split(",");
        String[] splitKey = key.split("\\.");
        String valueKey = splitKey[splitKey.length - 1];
        String preKey = splitKey[0];
        if (data.containsKey(preKey)) {
            List dataList = (List)data.get(preKey);
            block0: for (int index = 0; index <= dataList.size() - 1; ++index) {
                if (valueKey.equals(((MulBasedataProp)prop).getDisplayProp())) {
                    Set valueKeySet = prop.getDisplayName().keySet();
                    for (String keyValue : valueKeySet) {
                        if (!keyValue.equals(RequestContext.get().getLang().name())) continue;
                        HashMap<String, String> valueMap = new HashMap<String, String>();
                        valueMap.put(keyValue, splitValue[index]);
                        ((Map)dataList.get(index)).put(valueKey, valueMap);
                        continue block0;
                    }
                    continue;
                }
                ((Map)dataList.get(index)).put(valueKey, splitValue[index]);
            }
        } else {
            ArrayList dataList = new ArrayList(splitValue.length);
            for (String valueData : splitValue) {
                HashMap<String, Object> valueMap = new HashMap<String, Object>();
                if (valueKey.equals(((MulBasedataProp)prop).getDisplayProp())) {
                    Set valueKeySet = prop.getDisplayName().keySet();
                    for (String keyValue : valueKeySet) {
                        if (!keyValue.equals(RequestContext.get().getLang().name())) continue;
                        HashMap<String, String> langValueMap = new HashMap<String, String>();
                        langValueMap.put(keyValue, valueData);
                        valueMap.put(valueKey, langValueMap);
                        break;
                    }
                } else {
                    valueMap.put(valueKey, valueData);
                }
                dataList.add(valueMap);
            }
            data.put(preKey, dataList);
        }
    }

    private static void dealEntryProp(Map<Integer, String> fieldsMap, Map.Entry<Integer, Object> row, IDataEntityProperty prop, Map<String, Object> data) {
        List values = (List)row.getValue();
        DynamicObjectType dynamicCollectionItemPropertyType = ((EntryProp)prop).getDynamicCollectionItemPropertyType();
        LinkedList<HashMap<String, Object>> dataList = new LinkedList<HashMap<String, Object>>();
        String key = String.valueOf(fieldsMap.get(row.getKey()));
        key = key.substring(0, key.lastIndexOf(95));
        int seq = 0;
        for (Map value : values) {
            HashMap<String, Object> entryData = new HashMap<String, Object>();
            entryData.put("seq", ++seq);
            for (Map.Entry<Integer, Object> entry : value.entrySet()) {
                String field = fieldsMap.get(entry.getKey());
                DynamicProperty property = dynamicCollectionItemPropertyType.getProperty(fieldsMap.get(entry.getKey()));
                if (property == null) {
                    if (field.contains(SIGN)) {
                        property = dynamicCollectionItemPropertyType.getProperty(field.substring(0, field.lastIndexOf(46)));
                    } else if (field.endsWith("_id")) {
                        property = dynamicCollectionItemPropertyType.getProperty(field.substring(0, field.lastIndexOf(95)));
                    }
                }
                ExcelResolveHelper.dealProp(fieldsMap, entry, (IDataEntityProperty)property, entryData);
            }
            dataList.add(entryData);
        }
        data.put(key, dataList);
    }

    private static void dealBaseDataProp(Map<Integer, String> fieldsMap, Map.Entry<Integer, Object> row, BasedataProp prop, Map<String, Object> data) {
        String baseEntityId = prop.getBaseEntityId();
        MainEntityType metaEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
        String field = String.valueOf(fieldsMap.get(row.getKey()));
        String key = field.substring(0, field.lastIndexOf(46));
        String valueKey = field.substring(field.lastIndexOf(46) + 1);
        IDataEntityProperty baseDataProp = metaEntityType.findProperty(valueKey);
        if (data.containsKey(key)) {
            ExcelResolveHelper.dealMuliLangProForBaseData(row, data, key, baseDataProp, valueKey);
        } else {
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            valueMap.put(valueKey, row.getValue());
            data.put(key, valueMap);
        }
    }

    private static void dealMuliLangProForBaseData(Map.Entry<Integer, Object> row, Map<String, Object> data, String key, IDataEntityProperty baseDataProp, String valueKey) {
        Map valueMap = (Map)data.get(key);
        if (baseDataProp instanceof MuliLangTextProp) {
            String lang = RequestContext.getOrCreate().getLang().name();
            if (valueMap.containsKey(lang)) {
                Map langMap = (Map)valueMap.get(lang);
                langMap.put(lang, row.getValue());
            } else {
                HashMap<String, Object> MuliLangvalueMap = new HashMap<String, Object>();
                MuliLangvalueMap.put(lang, row.getValue());
                valueMap.put(valueKey, MuliLangvalueMap);
            }
        } else {
            valueMap.put(valueKey, row.getValue());
        }
    }

    private static void dealComboProp(Map<Integer, String> fieldsMap, Map.Entry<Integer, Object> row, IDataEntityProperty prop, Map<String, Object> data) {
        List items = ((ComboProp)prop).getComboItems();
        if (items == null || items.isEmpty()) {
            return;
        }
        if (row.getValue() == null) {
            return;
        }
        Set<String> comboValues = ExcelResolveHelper.getComboValues(prop, (String)row.getValue(), items);
        ArrayList<String> comboValueList = new ArrayList<String>(comboValues);
        String key = fieldsMap.get(row.getKey());
        boolean isMulCombo = prop instanceof MulComboProp;
        if (isMulCombo) {
            comboValueList.add(0, "");
            comboValueList.add(comboValueList.size(), "");
        }
        data.put(key, String.join((CharSequence)",", comboValueList));
    }

    private static void dealMuliLangTextProp(Map<Integer, String> fieldsMap, Map.Entry<Integer, Object> row, Map<String, Object> data) {
        String field = String.valueOf(fieldsMap.get(row.getKey()));
        String key = field.substring(0, field.lastIndexOf(46));
        String valueKey = field.substring(field.lastIndexOf(46) + 1);
        if (data.containsKey(key)) {
            Map valueMap = (Map)data.get(key);
            valueMap.put(valueKey, row.getValue());
        } else {
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            valueMap.put(valueKey, row.getValue());
            data.put(key, valueMap);
        }
    }

    private static void dealBooleanProp(Map<Integer, String> fieldsMap, Map.Entry<Integer, Object> row, Map<String, Object> data) {
        HashSet<String> trueSet = new HashSet<String>(Arrays.asList(ResManager.loadKDString((String)"\u662f", (String)"ExcelResolveHelper_1", (String)"sys-ricc-platform", (Object[])new Object[0]), ResManager.loadKDString((String)"\u771f", (String)"ExcelResolveHelper_2", (String)"sys-ricc-platform", (Object[])new Object[0]), ResManager.loadKDString((String)"\u52fe\u9009", (String)"ExcelResolveHelper_3", (String)"sys-ricc-platform", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bf9", (String)"ExcelResolveHelper_4", (String)"sys-ricc-platform", (Object[])new Object[0]), "true", "yes", "ok"));
        String key = fieldsMap.get(row.getKey());
        data.put(key, trueSet.contains(((String)row.getValue()).toLowerCase()));
    }

    private static void dealAdminDivisionProp(Map<Integer, String> fieldsMap, Map.Entry<Integer, Object> row, Map<String, Object> data) {
        String fullName = ((String)row.getValue()).replace('/', '_');
        Object adminId = ORMUtil.getAdminDivisionByName((String)fullName);
        String key = fieldsMap.get(row.getKey());
        if (StringUtils.isNotBlank((Object)adminId)) {
            data.put(key, adminId);
        }
    }

    public static Set<String> getComboValues(IDataEntityProperty prop, String val, List<ValueMapItem> items) {
        List<String> cellValueSplit = Arrays.asList(val.split(","));
        LinkedHashSet<String> values = new LinkedHashSet<String>();
        boolean isMulCombo = prop instanceof MulComboProp;
        if (isMulCombo) {
            for (String cellValue : cellValueSplit) {
                ExcelResolveHelper.findAndInsertComboValue(items, values, cellValue);
            }
        } else {
            String cellValue = cellValueSplit.get(0);
            ExcelResolveHelper.findAndInsertComboValue(items, values, cellValue);
        }
        return values;
    }

    private static void findAndInsertComboValue(List<ValueMapItem> items, Set<String> values, String cellValue) {
        Optional<ValueMapItem> optionalValueMapItem = items.stream().filter(item -> StringUtils.equals((CharSequence)cellValue, (CharSequence)item.getName().getLocaleValue())).findFirst();
        optionalValueMapItem.ifPresent(valueMapItem -> values.add(valueMapItem.getValue()));
    }
}

