/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.impt;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sys.ricc.common.util.ShowParameterUtil;
import kd.sys.ricc.common.util.StringUtils;

public class ImportParamAdapter {
    private static final Log logger = LogFactory.getLog(ImportParamAdapter.class);
    public static final String IMPORT_OP = "importdata";
    private static final String SETCUSTOMPARAM = "setCustomParam";
    private static final String SETAPPID = "setAppId";
    private static final String SETCAPTION = "setCaption";
    private static final String ADDCUSTPLUGIN = "addCustPlugin";

    private ImportParamAdapter() {
    }

    public static FormShowParameter createFormShowParameter4Import(String formId, String pageType) {
        Object showParameter = "bos_dynamicform".equals(pageType) ? ShowParameterUtil.formShowParameter((String)formId, (ShowType)ShowType.MainNewTabPage, null, null, null) : ShowParameterUtil.listShowParameter((String)formId, (String)pageType, (ShowType)ShowType.MainNewTabPage, null, null, (String)"", (String)"");
        FormConfig formConfig = ImportParamAdapter.getFormConfig(formId, showParameter);
        String bizAppNumber = formConfig.getBizAppNumber();
        String serviceAppId = showParameter.getServiceAppId();
        logger.info(String.format("createFormShowParameter4Import serviceAppId:%1$s,appid:%2$s", serviceAppId, formConfig.getAppId()));
        showParameter.setAppId(bizAppNumber);
        showParameter.setCustomParam("ServiceAppId", (Object)serviceAppId);
        showParameter.setCustomParam("CheckRightAppId", (Object)bizAppNumber);
        showParameter.setCustomParam("BillFormId", (Object)formId);
        showParameter.setCustomParam("appId", (Object)bizAppNumber);
        showParameter.getOpenStyle().setShowType(ShowType.NonModal);
        return showParameter;
    }

    public static void setExcelParams(String formId, FormShowParameter showParameter, Map<String, String> excelParams) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formId);
        String entityDisplayName = entityType.getDisplayName().getLocaleValue();
        String entityName = entityType.getName();
        String saveOp = EntityMetadataCache.getDataEntityOperations((String)entityName).getSave();
        String importPlugin = ImportParamAdapter.getImportPlugin(entityName);
        if (excelParams != null) {
            String importType = excelParams.get("dataimporttype");
            if (StringUtils.isEmpty((String)importType)) {
                showParameter.setCustomParam("Type", (Object)"overridenew");
            } else {
                showParameter.setCustomParam("Type", (Object)importType);
            }
            String keyFields = excelParams.get("keyfields");
            showParameter.setCustomParam("KeyFields", (Object)keyFields);
            String isOverrideEntry = excelParams.get("isoverrideentry");
            showParameter.setCustomParam("OverrideEntry", (Object)isOverrideEntry);
        } else {
            showParameter.setCustomParam("Type", (Object)"overridenew");
            showParameter.setCustomParam("KeyFields", (Object)",id,");
            showParameter.setCustomParam("OverrideEntry", (Object)"true");
        }
        showParameter.setCustomParam("OpSave", (Object)saveOp);
        showParameter.setCustomParam("ImportPlugin", (Object)importPlugin);
        showParameter.setCustomParam("SetNULL", (Object)"true");
        showParameter.setCustomParam("OperateKey", (Object)saveOp);
        showParameter.setCustomParam("ListName", (Object)entityDisplayName);
    }

    private static FormConfig getFormConfig(String formId, FormShowParameter showParameter) {
        FormConfig formConfig = null;
        formConfig = showParameter instanceof ListShowParameter ? FormMetadataCache.getListFormConfig((String)((ListShowParameter)showParameter).getBillFormId()) : FormMetadataCache.getFormConfig((String)formId);
        return formConfig;
    }

    public static void specialFormParameters(String pageEnterParam, FormShowParameter formShowParameter) {
        if (StringUtils.isEmpty((String)pageEnterParam)) {
            return;
        }
        JSONObject map = JSONObject.parseObject((String)pageEnterParam).getJSONObject("params");
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Map tempMap = (Map)entry.getValue();
            for (Map.Entry anoentry : tempMap.entrySet()) {
                String name = (String)anoentry.getKey();
                String value = (String)anoentry.getValue();
                switch (key) {
                    case "setCustomParam": {
                        formShowParameter.setCustomParam(name, (Object)value);
                        break;
                    }
                    case "setAppId": {
                        formShowParameter.setAppId(value);
                        break;
                    }
                    case "setCaption": {
                        formShowParameter.setCaption(value);
                        break;
                    }
                    case "addCustPlugin": {
                        formShowParameter.addCustPlugin(value);
                        break;
                    }
                }
            }
        }
    }

    private static String getImportPlugin(String entityName) {
        int size;
        ArrayList plugins;
        String importPlugin = "";
        Map importOpMap = EntityMetadataCache.getDataEntityOperate((String)entityName, (String)IMPORT_OP);
        LinkedHashMap opParam = (LinkedHashMap)importOpMap.get("parameter");
        if (opParam != null && (plugins = (ArrayList)opParam.get("plugins")) != null && (size = plugins.size()) > 0) {
            for (int i = 0; i < size; ++i) {
                Map p = (Map)plugins.get(i);
                if (!Boolean.TRUE.equals(p.get("Enabled"))) continue;
                importPlugin = String.valueOf(p.get("ClassName"));
                break;
            }
        }
        return importPlugin;
    }
}

