/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.schedule;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.sys.ricc.business.datapacket.schedule.AddPacketProgress;
import kd.sys.ricc.common.util.StringUtils;

public class ScheduleUtil {
    private ScheduleUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static JobFormInfo buildJobFormInfo(String jobName, String taskClassName, String clickClassName, IFormView view, Map<String, Object> params) {
        String routeAppId = "";
        if (view != null) {
            routeAppId = view.getFormShowParameter().getServiceAppId();
        }
        JobInfo jobInfo = ScheduleUtil.getJobInfo(jobName, taskClassName, routeAppId, params);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setClickClassName(clickClassName);
        jobFormInfo.setCanBackground(true);
        if (view != null) {
            jobFormInfo.setParentPageId(view.getPageId());
            FormShowParameter showParams = view.getFormShowParameter();
            jobFormInfo.setParentPageId(showParams.getParentPageId());
            jobFormInfo.getParams().putAll(showParams.getCustomParams());
        }
        return jobFormInfo;
    }

    public static JobInfo getJobInfo(String jobName, String taskClassName, String serviceAppId, Map<String, Object> params) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setName(ResManager.loadKDString((String)jobName, (String)"bos-ricc-common-job", (String)"sys-ricc-platform", (Object[])new Object[0]));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setTaskClassname(taskClassName);
        jobInfo.setParams(params);
        if (!StringUtils.isEmpty((String)serviceAppId)) {
            jobInfo.setAppId(serviceAppId);
        }
        return jobInfo;
    }

    public static Map<String, Object> getTaskCustData(TaskInfo taskInfo) {
        String strData = taskInfo.getData();
        if (StringUtils.isBlank((CharSequence)strData)) {
            return new HashMap<String, Object>();
        }
        return (Map)SerializationUtils.fromJsonString((String)strData, Map.class);
    }

    public static Map<String, Object> getTaskCustData(String taskId) {
        return ScheduleUtil.getTaskCustData(ScheduleServiceHelper.queryTask((String)taskId));
    }

    public static void buildAddPacketProgressDesc(AddPacketProgress addPacketProgress, Log logger, String desc) {
        if (addPacketProgress == null) {
            return;
        }
        addPacketProgress.feedbackProgress(desc);
        if (logger != null) {
            logger.info(desc);
        }
    }

    public static void addPacketFeedbackProgress(AddPacketProgress addPacketProgress, int total, int complete) {
        if (addPacketProgress == null) {
            return;
        }
        if (total == complete) {
            addPacketProgress.feedbackProgress(total, complete);
            return;
        }
        if (total >= 1000) {
            if (complete % 100 == 0) {
                addPacketProgress.feedbackProgress(total, complete);
            }
        } else if (total > 10 && total < 1000) {
            if (complete % 10 == 0) {
                addPacketProgress.feedbackProgress(total, complete);
            }
        } else {
            addPacketProgress.feedbackProgress(total, complete);
        }
    }

    public static int getFeedbackProgressTotalCount(AddPacketProgress addPacketProgress) {
        if (addPacketProgress == null) {
            return 0;
        }
        return addPacketProgress.getProgressTotalCount();
    }

    public static int getFeedbackProgressCompleteCount(AddPacketProgress addPacketProgress) {
        if (addPacketProgress == null) {
            return 0;
        }
        return addPacketProgress.getProgressCompleteCount();
    }

    public static void addPacketProgressComplete(AddPacketProgress addPacketProgress) {
        if (addPacketProgress == null) {
            return;
        }
        addPacketProgress.complete();
    }

    public static void addPacketFeedbackProgress(AddPacketProgress addPacketProgress, int progress, String desc, Map<String, Object> custData) {
        if (addPacketProgress == null) {
            return;
        }
        addPacketProgress.feedbackProgress(progress, desc, custData);
    }

    public static int getDynamicSleepSecond(int beginSecond, int maxSecond) {
        if (beginSecond >= maxSecond) {
            return maxSecond;
        }
        return beginSecond * 13 / 10;
    }
}

