/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.training;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;

public class ApiGateWayUtils {
    private static final Log log = LogFactory.getLog(ApiGateWayUtils.class);

    public static Map<String, String> buildHeader(Map<String, String> param, String appId, String appSecret) {
        HashMap<String, String> headers = new HashMap<String, String>(16);
        String timestamp = String.valueOf(System.currentTimeMillis());
        headers.put("x-acgw-timestamp", timestamp);
        String nonce = StringUtils.randomWord((int)32);
        headers.put("x-acgw-nonce", nonce);
        headers.put("x-acgw-sign", ApiGateWayUtils.getSign(param, timestamp, nonce, appSecret));
        headers.put("x-acgw-appid", appId);
        headers.put("Accept-Charset", "UTF-8");
        headers.put("Content-Type", "application/json; charset=UTF-8");
        return headers;
    }

    private static String getSign(Map<String, String> param, String timestamp, String nonce, String appSecret) {
        String stringA = timestamp + nonce;
        List paramKeyList = param.entrySet().stream().filter(e -> e.getValue() != null).map(Map.Entry::getKey).sorted().collect(Collectors.toList());
        String stringB = paramKeyList.stream().map(e -> {
            String paramValue = (String)param.get(e);
            byte[] bytes = paramValue.getBytes(StandardCharsets.UTF_8);
            return new String(bytes, 0, Math.min(bytes.length, 100), StandardCharsets.UTF_8);
        }).collect(Collectors.joining(""));
        String message = stringA + stringB;
        return Base64.encodeBase64String((byte[])new HmacUtils(HmacAlgorithms.HMAC_SHA_256, appSecret.getBytes(StandardCharsets.UTF_8)).hmac(message.getBytes(StandardCharsets.UTF_8)));
    }
}

