/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.training;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.cloudplatform.model.CloudPlatformConfigInfo;
import kd.bos.login.cloudplatform.model.CloudPlatformResult;
import kd.bos.login.cloudplatform.utils.CloudPlatformUtils;
import kd.bos.login.user.DefaultParameterService;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.JSONUtils;
import kd.sys.ricc.business.training.CloudTrainConfig;
import kd.sys.ricc.business.training.KdCloudUtils;
import kd.sys.ricc.business.training.TrainConfigUtils;
import org.apache.commons.lang3.StringUtils;

public class CloudAccountUtils {
    private static final Log log = LogFactory.getLog(CloudAccountUtils.class);
    private static final String APP = "app";
    private static final String APP_STR = "app_str";

    public static CustomApiResult<String> getCloudAuthCodeNew() {
        CloudTrainConfig cloudConfig = TrainConfigUtils.getCloudConfig();
        return CloudAccountUtils.getCloudAuthCodeNew(cloudConfig.getTrainTargetId());
    }

    public static CustomApiResult<String> getCloudAuthCodeNew(String targetId) {
        DynamicObject kdCloudInfo = KdCloudUtils.getKdCloudInfo(UserServiceHelper.getCurrentUserId());
        return CloudAccountUtils.getCloudAuthCodeNew(targetId, kdCloudInfo);
    }

    public static CustomApiResult<String> getCloudAuthCodeNew(String targetId, DynamicObject kdCloudInfo) {
        try {
            Object responseData;
            if (kdCloudInfo == null) {
                log.info("CloudAccountUtils_getCloudAuthCodeNew: cloud info is null");
                return CustomApiResult.fail((String)"1001", (String)"cloud info is null");
            }
            String identity = kdCloudInfo.getString("identity");
            if (kd.bos.util.StringUtils.isEmpty((String)identity)) {
                log.info("CloudAccountUtils_getCloudAuthCodeNew: cloud user identity is null");
                return CustomApiResult.fail((String)"1002", (String)"cloud user identity is null");
            }
            String config = DefaultParameterService.getDefaultValueByKey((String)"cloud_customer_service_config");
            if (kd.bos.util.StringUtils.isEmpty((String)config)) {
                log.info("CloudAccountUtils_getCloudAuthCodeNew: cloud_customer_service_config is null");
                return CustomApiResult.fail((String)"1003", (String)"cloud_customer_service_config is null");
            }
            Map configData = (Map)JSON.parseObject((String)config, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            CloudPlatformConfigInfo cloudPlatformConfigInfo = new CloudPlatformConfigInfo();
            cloudPlatformConfigInfo.setServiceUrl((String)configData.get("serviceUrl"));
            if (kd.bos.util.StringUtils.isEmpty((String)targetId)) {
                cloudPlatformConfigInfo.setTargetId((String)configData.get("targetId"));
            } else {
                cloudPlatformConfigInfo.setTargetId(targetId);
            }
            cloudPlatformConfigInfo.setServiceId((String)configData.get("serviceId"));
            if (!configData.containsKey(APP) || !configData.containsKey(APP_STR)) {
                cloudPlatformConfigInfo.setUrl(DefaultParameterService.getDefaultValueByKey((String)"cloud_platform_mcapi_url"));
                CloudAccountUtils.createAppSecretByCloudPlatform(cloudPlatformConfigInfo);
            } else {
                cloudPlatformConfigInfo.setAppId((String)configData.get(APP));
                cloudPlatformConfigInfo.setAppStr((String)configData.get(APP_STR));
                Map paramMap = LicenseServiceHelper.getProductInfo();
                String prodInstCode = "";
                if (paramMap != null) {
                    prodInstCode = (String)paramMap.get("prodInstCode");
                }
                if (!prodInstCode.equals(configData.get("prodInstCode"))) {
                    CloudAccountUtils.createAppSecretByCloudPlatform(cloudPlatformConfigInfo);
                }
            }
            HashMap<String, String> body = new HashMap<String, String>(8);
            body.put("identity", identity);
            body.put("targetId", cloudPlatformConfigInfo.getTargetId());
            CloudPlatformResult cloudPlatformResult = CloudPlatformUtils.identity2codeByCloudPlatform((CloudPlatformConfigInfo)cloudPlatformConfigInfo, body);
            if (!cloudPlatformResult.isSuccess()) {
                if ("50061".equals(cloudPlatformResult.getErrCode())) {
                    cloudPlatformResult = CloudPlatformUtils.refreshIdentityByCloudPlatform((CloudPlatformConfigInfo)cloudPlatformConfigInfo, body);
                    responseData = cloudPlatformResult.getData();
                    if (responseData != null) {
                        Map data = (Map)JSON.parseObject((String)responseData.toString(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                        identity = (String)data.get("refreshIdentity");
                        kdCloudInfo.set("identity", (Object)identity);
                        SaveServiceHelper.update((DynamicObject)kdCloudInfo);
                    }
                    body = new HashMap(8);
                    body.put("identity", identity);
                    body.put("targetId", cloudPlatformConfigInfo.getTargetId());
                    cloudPlatformResult = CloudPlatformUtils.identity2codeByCloudPlatform((CloudPlatformConfigInfo)cloudPlatformConfigInfo, body);
                }
                if (!cloudPlatformResult.isSuccess()) {
                    log.info("CloudAccountUtils_getCloudAuthCodeNew: " + SerializationUtils.toJsonString((Object)cloudPlatformResult));
                    return CustomApiResult.fail((String)"1005", (String)cloudPlatformResult.getMessage());
                }
            }
            if ((responseData = cloudPlatformResult.getData()) != null) {
                Map data = (Map)JSON.parseObject((String)responseData.toString(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                String code = (String)data.get("code");
                return CustomApiResult.success((Object)code);
            }
            log.info("CloudAccountUtils_getCloudAuthCodeNew: get_auth_code is fail");
            return CustomApiResult.fail((String)"1006", (String)"get_auth_code is fail");
        }
        catch (Exception ex) {
            log.error("CloudAccountUtils_getCloudAuthCodeNew_error", (Throwable)ex);
            return CustomApiResult.fail((String)"1007", (String)ex.getMessage());
        }
    }

    private static void createAppSecretByCloudPlatform(CloudPlatformConfigInfo cloudPlatformConfigInfo) throws Exception {
        CloudPlatformResult cloudPlatformResult;
        Map productInfo = LicenseServiceHelper.getProductInfo();
        ArrayList<Map> list = new ArrayList<Map>(8);
        if (productInfo == null) {
            return;
        }
        list.add(productInfo);
        cloudPlatformConfigInfo.setUrl(DefaultParameterService.getDefaultValueByKey((String)"cloud_platform_mcapi_url"));
        String config = DefaultParameterService.getDefaultValueByKey((String)"login_sms_app_config");
        if (StringUtils.isNotBlank((CharSequence)config)) {
            Map map = (Map)JSON.parseObject((String)config, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
            cloudPlatformConfigInfo.setSeedId(String.valueOf(map.get("seed_app")));
            cloudPlatformConfigInfo.setSeedStr(String.valueOf(map.get("seed_app_str")));
        }
        if (!(cloudPlatformResult = CloudPlatformUtils.createAppSecretByCloudPlatform((CloudPlatformConfigInfo)cloudPlatformConfigInfo, list)).isSuccess()) {
            throw new Exception(cloudPlatformResult.getMessage());
        }
        String createAppId = String.valueOf(cloudPlatformResult.getData());
        Thread.sleep(3000L);
        cloudPlatformResult = CloudPlatformUtils.getAppSecretByCloudPlatform((CloudPlatformConfigInfo)cloudPlatformConfigInfo, (String)createAppId);
        if (!cloudPlatformResult.isSuccess()) {
            throw new Exception(cloudPlatformResult.getMessage());
        }
        Object data = cloudPlatformResult.getData();
        if (data != null) {
            Map result = (Map)JSON.parseObject((String)data.toString(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            String appId = (String)result.get("appId");
            String appSrt = CloudPlatformUtils.decryptGCM((String)cloudPlatformConfigInfo.getSeedStr(), (String)((String)result.get("appSrt")));
            cloudPlatformConfigInfo.setAppId(appId);
            cloudPlatformConfigInfo.setAppStr(appSrt);
            Map params = (Map)JSON.parseObject((String)DefaultParameterService.getDefaultValueByKey((String)"cloud_customer_service_config"), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
            params.put(APP, appId);
            params.put(APP_STR, appSrt);
            params.put("prodInstCode", productInfo.get("prodInstCode"));
            DefaultParameterService.updateDefaultParamsConfig((Account)AccountUtils.getAccountById((String)RequestContext.get().getAccountId()), (String)"cloud_customer_service_config", (String)JSONUtils.toString((Object)params));
        }
    }
}

