/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.training;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.DateUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.Pair;
import kd.sys.ricc.business.training.TrainCourseUtils;
import kd.sys.ricc.common.entity.TrainRankListValue;
import kd.sys.ricc.common.entity.TrainRptListParam;
import kd.sys.ricc.common.entity.TrainRptListValue;
import kd.sys.ricc.common.entity.TrainRptParam;
import kd.sys.ricc.common.entity.TrainRptSingleParam;
import kd.sys.ricc.common.enums.ReportParamEnum;

public class ReportParamUtils {
    private static final Log log = LogFactory.getLog(ReportParamUtils.class);

    public static InputStream getReportTemplate() {
        Lang lang = RequestContext.getOrCreate().getLang();
        try {
            InputStream tempInputStream = ReportParamUtils.getTemplate(lang);
            if (tempInputStream != null) {
                return tempInputStream;
            }
        }
        catch (Exception ex) {
            log.error("ReportParamUtils_Get_Gcp_Template_fail.", (Throwable)ex);
        }
        InputStream localTemplate = ReportParamUtils.getLocalTemplate(lang);
        if (localTemplate != null) {
            return localTemplate;
        }
        if (lang != Lang.defaultLang()) {
            lang = Lang.defaultLang();
            return ReportParamUtils.getLocalTemplate(lang);
        }
        return null;
    }

    private static InputStream getTemplate(Lang lang) throws IOException {
        long fileId;
        List attachments;
        QFilter langQFilter = new QFilter("lang", "=", (Object)lang.name());
        langQFilter.or(new QFilter("lang", "=", (Object)"other").and(new QFilter("otherlang", "=", (Object)lang.name())));
        QFilter sceneQFilter = new QFilter("scene", "=", (Object)"trainRptTemplate");
        sceneQFilter.or(new QFilter("scene", "=", (Object)"other").and(new QFilter("otherscene", "=", (Object)"trainRptTemplate")));
        DynamicObject file = QueryServiceHelper.queryOne((String)"ricc_filemanage", (String)"id, filename", (QFilter[])new QFilter[]{langQFilter, sceneQFilter});
        if (file != null && CollectionUtils.isNotEmpty((Collection)(attachments = AttachmentServiceHelper.getAttachments((String)"ricc_filemanage", (Object)(fileId = file.getLong("id")), (String)"attachment")))) {
            return new URL(String.valueOf(((Map)attachments.get(0)).get("url"))).openConnection().getInputStream();
        }
        return null;
    }

    private static InputStream getLocalTemplate(Lang lang) {
        String source = String.format("kd/sys/ricc/train/TrainReport_%s.docx", lang.name());
        return ReportParamUtils.class.getClassLoader().getResourceAsStream(source);
    }

    public static Map<String, TrainRptParam> collectTrainRptParam(IFormView view) {
        DynamicObject[] assigns;
        HashMap<String, TrainRptParam> rptParamMap = new HashMap<String, TrainRptParam>(16);
        Pair<Date, Date> dateRange = ReportParamUtils.getDateRange(view);
        IDataModel model = view.getModel();
        rptParamMap.put(ReportParamEnum.COMPANY.getReplaceKey(), new TrainRptSingleParam((String)model.getValue("company")));
        rptParamMap.put(ReportParamEnum.AUTHOR.getReplaceKey(), new TrainRptSingleParam(UserServiceHelper.getCurrentUser((String)"name").getString("name")));
        rptParamMap.put(ReportParamEnum.TIME_RANGE.getReplaceKey(), new TrainRptSingleParam(DateUtils.formatDate((Date)((Date)dateRange.getKey()), (Object[])new Object[]{ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)"ReportParamUtils_0", (String)"sys-ricc-platform", (Object[])new Object[0])}) + "\u2014" + DateUtils.formatDate((Date)((Date)dateRange.getValue()), (Object[])new Object[]{ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)"ReportParamUtils_0", (String)"sys-ricc-platform", (Object[])new Object[0])})));
        rptParamMap.put(ReportParamEnum.CREATE_TIME.getReplaceKey(), new TrainRptSingleParam(DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)"ReportParamUtils_0", (String)"sys-ricc-platform", (Object[])new Object[0])})));
        ArrayList<Object> listValues = new ArrayList<Object>(16);
        DynamicObjectCollection courses = QueryServiceHelper.query((String)"ricc_course", (String)"id, courselist", null);
        Map<Long, List<DynamicObject>> courseMap = courses.stream().collect(Collectors.groupingBy(e -> e.getLong("courselist")));
        DynamicObjectCollection details = QueryServiceHelper.query((String)"ricc_learningdetail", (String)"user, course, status", null);
        Map<Long, List<DynamicObject>> detailMap = details.stream().collect(Collectors.groupingBy(e -> e.getLong("course")));
        for (DynamicObject assign : assigns = BusinessDataServiceHelper.load((String)"ricc_courseassign", (String)"courselist, trainee, role", null)) {
            TrainRptListValue listValue = new TrainRptListValue();
            DynamicObject courseList = assign.getDynamicObject("courselist");
            listValue.setCourseList(courseList.getString("name"));
            DynamicObjectCollection trainee = assign.getDynamicObjectCollection("trainee");
            Set userIds = trainee.stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toSet());
            DynamicObjectCollection roles = assign.getDynamicObjectCollection("role");
            List<Long> roleUserIds = TrainCourseUtils.getRoleUsers(roles, k -> k.getString("fbasedataid_id"));
            userIds.addAll(roleUserIds);
            listValue.setTrainees(new ArrayList<Long>(userIds));
            List<DynamicObject> refCourses = courseMap.get(courseList.getLong("id"));
            listValue.setCourseCount(refCourses.size());
            if (userIds.size() == 0) {
                listValue.setCompleteTrainees(new ArrayList<Long>(16));
                listValue.setLearnTrainees(new ArrayList<Long>(16));
            } else {
                Map<Long, List<DynamicObject>> userMap = refCourses.stream().map(e -> detailMap.getOrDefault(e.getLong("id"), Collections.emptyList())).flatMap(Collection::stream).collect(Collectors.groupingBy(k -> k.getLong("user")));
                List<Long> complete = userMap.entrySet().stream().filter(k -> {
                    List records = (List)k.getValue();
                    return records.stream().allMatch(j -> "complete".equals(j.getString("status")));
                }).map(Map.Entry::getKey).collect(Collectors.toList());
                listValue.setCompleteTrainees(complete);
                complete.forEach(userIds::remove);
                ArrayList<Long> learning = new ArrayList<Long>(userIds);
                listValue.setLearnTrainees(learning);
            }
            listValues.add(listValue);
        }
        listValues.sort(Comparator.comparingInt(k -> {
            TrainRptListValue listValue = (TrainRptListValue)k;
            List<Long> trainees = listValue.getTrainees();
            if (trainees.size() == 0) {
                return 0;
            }
            return listValue.getCompleteTrainees().size() * 100 / listValue.getTrainees().size();
        }).thenComparingInt(k -> ((TrainRptListValue)k).getTrainees().size()).thenComparingInt(k -> ((TrainRptListValue)k).getCompleteTrainees().size()).reversed());
        List totalTrainees = listValues.stream().map(TrainRptListValue::getTrainees).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        int totalCount = totalTrainees.size();
        rptParamMap.put(ReportParamEnum.TOTAL_PERSON.getReplaceKey(), new TrainRptSingleParam(String.valueOf(totalCount)));
        List learningTrainees = listValues.stream().map(TrainRptListValue::getLearnTrainees).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        int learnCount = learningTrainees.size();
        rptParamMap.put(ReportParamEnum.LEARN_PERSON.getReplaceKey(), new TrainRptSingleParam(String.valueOf(learnCount)));
        rptParamMap.put(ReportParamEnum.FINISH_PERSON.getReplaceKey(), new TrainRptSingleParam(String.valueOf(totalCount - learnCount)));
        rptParamMap.put(ReportParamEnum.FINISH_RATE.getReplaceKey(), new TrainRptSingleParam(totalCount == 0 ? "0%" : (totalCount - learnCount) * 100 / totalCount + "%"));
        rptParamMap.put(ReportParamEnum.COURSE_LIST_COUNT.getReplaceKey(), new TrainRptSingleParam(String.valueOf(assigns.length)));
        rptParamMap.put(ReportParamEnum.COURSE_COUNT.getReplaceKey(), new TrainRptSingleParam(String.valueOf(listValues.stream().mapToInt(TrainRptListValue::getCourseCount).sum())));
        rptParamMap.put(ReportParamEnum.COURSE_LIST.getReplaceKey(), new TrainRptListParam(listValues.stream().map(TrainRptListValue::getCourseList).collect(Collectors.toList())));
        rptParamMap.put(ReportParamEnum.STUDENT_COUNT.getReplaceKey(), new TrainRptListParam(listValues.stream().map(e -> e.getTrainees().size()).collect(Collectors.toList())));
        rptParamMap.put(ReportParamEnum.LEARNING_STUDENT.getReplaceKey(), new TrainRptListParam(listValues.stream().map(e -> e.getLearnTrainees().size()).collect(Collectors.toList())));
        rptParamMap.put(ReportParamEnum.FINISHED_STUDENT.getReplaceKey(), new TrainRptListParam(listValues.stream().map(e -> e.getCompleteTrainees().size()).collect(Collectors.toList())));
        rptParamMap.put(ReportParamEnum.COURSE_LIST_FINISH_RATE.getReplaceKey(), new TrainRptListParam(listValues.stream().map(e -> {
            List<Long> allTrainee = e.getTrainees();
            List<Long> completeTrainee = e.getCompleteTrainees();
            return allTrainee.size() == 0 ? "0%" : completeTrainee.size() * 100 / allTrainee.size() + "%";
        }).collect(Collectors.toList())));
        List allTrainees = listValues.stream().map(TrainRptListValue::getTrainees).flatMap(Collection::stream).collect(Collectors.toList());
        List userMainOrgId = UserServiceHelper.getUserMainOrgId(allTrainees);
        Map orgUserMap = userMainOrgId.stream().map(Map::entrySet).filter(e -> e.iterator().hasNext()).map(e -> (Map.Entry)e.iterator().next()).collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toList())));
        QFilter qFilter = new QFilter("id", "in", orgUserMap.keySet());
        DynamicObjectCollection bosOrg = QueryServiceHelper.query((String)"bos_org", (String)"id, name", (QFilter[])qFilter.toArray());
        Map<Long, String> orgMap = bosOrg.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getString("name"), (n1, n2) -> n2));
        ArrayList<Object> orgList = new ArrayList<Object>(16);
        ArrayList<Object> orgTrainee = new ArrayList<Object>(16);
        ArrayList<Object> orgLearn = new ArrayList<Object>(16);
        ArrayList<Object> orgComplete = new ArrayList<Object>(16);
        ArrayList<Object> orgRate = new ArrayList<Object>(16);
        ArrayList tmp = new ArrayList(totalTrainees);
        tmp.removeAll(learningTrainees);
        orgUserMap.forEach((key, value) -> {
            orgList.add(orgMap.getOrDefault(key, ""));
            orgTrainee.add(value.size());
            ArrayList tmp1 = new ArrayList(tmp);
            tmp1.retainAll((Collection<?>)value);
            orgComplete.add(tmp1.size());
            ArrayList tmp2 = new ArrayList(value);
            tmp2.removeAll(tmp1);
            orgLearn.add(tmp2.size());
            orgRate.add(value.size() == 0 ? "0%" : tmp1.size() * 100 / value.size() + "%");
        });
        rptParamMap.put(ReportParamEnum.DEPARTMENT.getReplaceKey(), new TrainRptListParam(orgList));
        rptParamMap.put(ReportParamEnum.DEPARTMENT_STUDENT.getReplaceKey(), new TrainRptListParam(orgTrainee));
        rptParamMap.put(ReportParamEnum.DEPARTMENT_LEARNING_STUDENT.getReplaceKey(), new TrainRptListParam(orgLearn));
        rptParamMap.put(ReportParamEnum.DEPARTMENT_FINISHED_STUDENT.getReplaceKey(), new TrainRptListParam(orgComplete));
        rptParamMap.put(ReportParamEnum.DEPARTMENT_FINISH_RATE.getReplaceKey(), new TrainRptListParam(orgRate));
        ArrayList<Object> rankListValues = new ArrayList<Object>(16);
        Map<Long, List<DynamicObject>> userMap = details.stream().collect(Collectors.groupingBy(e -> e.getLong("user")));
        List userInfo = UserServiceHelper.getUserInfoByID(new ArrayList<Long>(userMap.keySet()));
        Map<Long, String> userInfoMap = userInfo.stream().collect(Collectors.toMap(e -> e.getOrDefault("id", 0L), e -> e.getOrDefault("name", "")));
        userMap.forEach((key, value) -> {
            TrainRankListValue rankListValue = new TrainRankListValue();
            rankListValue.setUserId((Long)key);
            rankListValue.setCourses(value.stream().map(e -> e.getLong("course")).collect(Collectors.toList()));
            rankListValue.setCompletes(value.stream().filter(e -> "complete".equals(e.getString("status"))).map(e -> e.getLong("course")).collect(Collectors.toList()));
            rankListValues.add(rankListValue);
        });
        rankListValues.sort(Comparator.comparingInt(e -> ((TrainRankListValue)e).getCompletes().size()).reversed());
        rptParamMap.put(ReportParamEnum.SEQ.getReplaceKey(), new TrainRptListParam(rankListValues.stream().map(e -> rankListValues.indexOf(e) + 1).collect(Collectors.toList())));
        rptParamMap.put(ReportParamEnum.RANKING_STUDENT.getReplaceKey(), new TrainRptListParam(rankListValues.stream().map(e -> userInfoMap.getOrDefault(e.getUserId(), "")).collect(Collectors.toList())));
        rptParamMap.put(ReportParamEnum.RANKING_TOTAL_COURSE_COUNT.getReplaceKey(), new TrainRptListParam(rankListValues.stream().map(e -> e.getCourses().size()).collect(Collectors.toList())));
        rptParamMap.put(ReportParamEnum.RANKING_FINISHED_COUNT.getReplaceKey(), new TrainRptListParam(rankListValues.stream().map(e -> e.getCompletes().size()).collect(Collectors.toList())));
        rptParamMap.put(ReportParamEnum.RANKING_FINISH_RATE.getReplaceKey(), new TrainRptListParam(rankListValues.stream().map(e -> {
            List<Long> rankCourses = e.getCourses();
            return rankCourses.size() == 0 ? "0%" : e.getCompletes().size() * 100 / rankCourses.size() + "%";
        }).collect(Collectors.toList())));
        return rptParamMap;
    }

    private static Pair<Date, Date> getDateRange(IFormView view) {
        IDataModel model = view.getModel();
        return new Pair((Object)((Date)model.getValue("start")), (Object)((Date)model.getValue("end")));
    }
}

