/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.training;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.sys.ricc.business.training.CloudAccountUtils;
import kd.sys.ricc.business.training.CloudTrainConfig;
import kd.sys.ricc.business.training.KdCloudUtils;
import kd.sys.ricc.business.training.TrainConfigUtils;
import kd.sys.ricc.business.training.TrainInterfaceUtils;
import kd.sys.ricc.business.training.TrainRoleUserUtils;
import kd.sys.ricc.business.training.TrainThreadUtils;
import kd.sys.ricc.business.training.task.JoinToCourseListTask;
import kd.sys.ricc.common.entity.Course;
import kd.sys.ricc.common.entity.CourseList;
import kd.sys.ricc.common.entity.LearningRecord;
import kd.sys.ricc.common.entity.MyCourse;
import kd.sys.ricc.common.entity.ViewCourse;
import org.apache.commons.collections.CollectionUtils;

public class TrainCourseUtils {
    private static final Log log = LogFactory.getLog(TrainCourseUtils.class);
    private static volatile Map<String, Set<Long>> roleUserMap = null;

    public static CustomApiResult<String> syncCourseList() {
        CustomApiResult result = CustomApiResult.success((Object)ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\u3002", (String)"TrainCourseUtils_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
        try (TXHandle tx = TX.requiresNew((String)"syncCourseList");){
            try {
                TrainCourseUtils.syncCloudCourseList((CustomApiResult<String>)result);
                TrainCourseUtils.syncAssignRecord();
                TrainCourseUtils.syncCloudCourse((CustomApiResult<String>)result);
                TrainCourseUtils.syncLearningRecord();
            }
            catch (Exception ex) {
                tx.markRollback();
                log.error("TrainCourseUtils_syncCourseList", (Throwable)ex);
                result.setStatus(false);
                result.setMessage(ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25\u3002", (String)"TrainCourseUtils_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
                if (StringUtils.isEmpty((String)result.getErrorCode())) {
                    result.setErrorCode("1001");
                }
            }
        }
        return result;
    }

    private static void syncCloudCourseList(CustomApiResult<String> result) {
        HashMap<String, String> param = new HashMap<String, String>(16);
        TrainInterfaceUtils.addEnvParam(param, true, true);
        JSONObject jsonObject = TrainInterfaceUtils.doGetHttp(param, "/space-checklist");
        if (TrainCourseUtils.checkIsInvokeFail(jsonObject)) {
            if (jsonObject == null) {
                throw new KDBizException("/space-checklist result is null");
            }
            Object errorCode = jsonObject.get((Object)"errorCode");
            result.setStatus(false);
            result.setErrorCode(String.valueOf(errorCode));
            throw new KDBizException(jsonObject.getString("message"));
        }
        JSONArray data = jsonObject.getJSONArray("data");
        HashMap<String, JSONObject> dataMap = new HashMap<String, JSONObject>(16);
        for (int i = 0; i < data.size(); ++i) {
            JSONObject dataObject = data.getJSONObject(i);
            dataMap.put(dataObject.getString("id"), dataObject);
        }
        DynamicObject[] courseLists = BusinessDataServiceHelper.load((String)"ricc_courselist", (String)"courselistid, name, desc", null);
        Map<String, DynamicObject> courseListMap = Arrays.stream(courseLists).collect(Collectors.toMap(e -> e.getString("courselistid"), e -> e, (n1, n2) -> n2));
        List<DynamicObject> toSaveList = courseListMap.entrySet().stream().filter(e -> dataMap.containsKey(e.getKey())).map(e -> {
            JSONObject dataObject = (JSONObject)dataMap.get(e.getKey());
            DynamicObject courseList = (DynamicObject)e.getValue();
            courseList.set("name", (Object)dataObject.getString("title"));
            courseList.set("desc", (Object)dataObject.getString("recommendation"));
            return courseList;
        }).collect(Collectors.toList());
        if (toSaveList.size() != 0) {
            SaveServiceHelper.save((DynamicObject[])toSaveList.toArray(new DynamicObject[0]));
        }
        ArrayList dataListIds = new ArrayList(dataMap.keySet());
        ArrayList<String> courseListIds = new ArrayList<String>(courseListMap.keySet());
        dataListIds.removeAll(courseListIds);
        toSaveList = dataListIds.stream().map(e -> {
            JSONObject dataObject = (JSONObject)dataMap.get(e);
            DynamicObject courseList = BusinessDataServiceHelper.newDynamicObject((String)"ricc_courselist");
            courseList.set("courselistid", e);
            courseList.set("name", (Object)dataObject.getString("title"));
            courseList.set("number", (Object)CodeRuleServiceHelper.getNumber((String)"ricc_courselist", (DynamicObject)courseList, null));
            courseList.set("desc", (Object)dataObject.getString("recommendation"));
            return courseList;
        }).collect(Collectors.toList());
        if (toSaveList.size() != 0) {
            SaveServiceHelper.save((DynamicObject[])toSaveList.toArray(new DynamicObject[0]));
        }
        dataListIds = new ArrayList(dataMap.keySet());
        courseListIds = new ArrayList<String>(courseListMap.keySet());
        courseListIds.removeAll(dataListIds);
        QFilter qFilter = new QFilter("courselistid", "in", courseListIds);
        TrainCourseUtils.delete("ricc_courselist", qFilter.toArray());
    }

    private static void syncAssignRecord() {
        Map courseList = BusinessDataServiceHelper.loadFromCache((String)"ricc_courselist", null);
        Map<Long, String> courseListMap = courseList.values().stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getString("name"), (n1, n2) -> n2));
        DynamicObject[] courseAssigns = BusinessDataServiceHelper.load((String)"ricc_courseassign", (String)"name, courselist", null);
        Map<Long, DynamicObject> assignMap = Arrays.stream(courseAssigns).collect(Collectors.toMap(e -> e.getLong("courselist_id"), e -> e, (n1, n2) -> n2));
        List<DynamicObject> toSaves = assignMap.entrySet().stream().filter(e -> courseListMap.containsKey(e.getKey())).map(e -> {
            DynamicObject assign = (DynamicObject)e.getValue();
            assign.set("name", courseListMap.get(e.getKey()));
            return assign;
        }).collect(Collectors.toList());
        if (toSaves.size() != 0) {
            SaveServiceHelper.save((DynamicObject[])toSaves.toArray(new DynamicObject[0]));
        }
        ArrayList<Long> courseListIds = new ArrayList<Long>(courseListMap.keySet());
        ArrayList<Long> assignCourseListIds = new ArrayList<Long>(assignMap.keySet());
        courseListIds.removeAll(assignCourseListIds);
        toSaves = courseListIds.stream().map(e -> {
            DynamicObject assign = BusinessDataServiceHelper.newDynamicObject((String)"ricc_courseassign");
            assign.set("number", (Object)CodeRuleServiceHelper.getNumber((String)"ricc_courseassign", (DynamicObject)assign, null));
            assign.set("name", courseListMap.get(e));
            assign.set("courselist", e);
            assign.set("traineecount", (Object)0);
            return assign;
        }).collect(Collectors.toList());
        if (toSaves.size() != 0) {
            SaveServiceHelper.save((DynamicObject[])toSaves.toArray(new DynamicObject[0]));
        }
        courseListIds = new ArrayList<Long>(courseListMap.keySet());
        assignCourseListIds = new ArrayList<Long>(assignMap.keySet());
        assignCourseListIds.removeAll(courseListIds);
        QFilter qFilter = new QFilter("courselist", "in", assignCourseListIds);
        TrainCourseUtils.delete("ricc_courseassign", qFilter.toArray());
    }

    private static void syncCloudCourse(CustomApiResult<String> result) {
        Map courseList = BusinessDataServiceHelper.loadFromCache((String)"ricc_courselist", null);
        Map<String, DynamicObject> courseListMap = courseList.values().stream().collect(Collectors.toMap(e -> e.getString("courselistid"), e -> e, (n1, n2) -> n2));
        Map<String, JSONObject> cloudCourseMap = courseListMap.keySet().stream().map(e -> {
            HashMap<String, String> param = new HashMap<String, String>(16);
            param.put("id", (String)e);
            TrainInterfaceUtils.addEnvParam(param, true, true);
            JSONObject jsonObject = TrainInterfaceUtils.doGetHttp(param, "/space-checklist/items");
            if (TrainCourseUtils.checkIsInvokeFail(jsonObject)) {
                if (jsonObject == null) {
                    throw new KDBizException("/space-checklist/items result is null");
                }
                Object errorCode = jsonObject.get((Object)"errorCode");
                result.setStatus(false);
                result.setErrorCode(String.valueOf(errorCode));
                throw new KDBizException(jsonObject.getString("message"));
            }
            return jsonObject.getJSONObject("data");
        }).collect(Collectors.toMap(e -> e.getString("id"), e -> e, (n1, n2) -> n2));
        String fields = "courseid, number, name, type, time, url, courselist, videoid, sourcetype";
        DynamicObject[] courses = BusinessDataServiceHelper.load((String)"ricc_course", (String)fields, null);
        HashMap courseMap = new HashMap(16);
        ArrayList hasDeleteList = new ArrayList(16);
        Arrays.stream(courses).forEach(e -> {
            String courseListId;
            DynamicObject list = e.getDynamicObject("courselist");
            if (list == null) {
                hasDeleteList.add(e.getLong("courselist_id"));
                courseListId = "0";
            } else {
                courseListId = list.getString("courselistid");
            }
            Map map = courseMap.computeIfAbsent(courseListId, k -> new HashMap(16));
            map.put(e.getString("courseid"), e);
        });
        ArrayList toUpdates = new ArrayList(16);
        ArrayList toAdds = new ArrayList(16);
        ArrayList toDeletes = new ArrayList(16);
        cloudCourseMap.forEach((key, value) -> {
            Map map = courseMap.getOrDefault(key, new HashMap(16));
            DynamicObject courseListInfo = (DynamicObject)courseListMap.get(key);
            ArrayList<String> cloudCourseList = new ArrayList<String>(16);
            JSONArray categories = value.getJSONArray("category");
            for (int i = 0; i < categories.size(); ++i) {
                JSONObject category = categories.getJSONObject(i);
                JSONArray items = category.getJSONArray("items");
                for (int j = 0; j < items.size(); ++j) {
                    JSONObject item = items.getJSONObject(j);
                    String itemId = item.getString("id");
                    DynamicObject course = (DynamicObject)map.get(itemId);
                    if (course == null) {
                        course = BusinessDataServiceHelper.newDynamicObject((String)"ricc_course");
                        course.set("courseid", (Object)itemId);
                        course.set("number", (Object)CodeRuleServiceHelper.getNumber((String)"ricc_course", (DynamicObject)course, null));
                        course.set("courselist", (Object)courseListInfo.getLong("id"));
                        toAdds.add(course);
                    } else {
                        toUpdates.add(course);
                    }
                    course.set("name", (Object)item.getString("title"));
                    course.set("type", (Object)item.getString("sourceType"));
                    course.set("time", (Object)item.getString("num"));
                    course.set("sourcetype", (Object)item.getString("resourceType"));
                    course.set("url", (Object)item.getString("url"));
                    course.set("videoid", (Object)item.getString("resourceId"));
                    cloudCourseList.add(itemId);
                }
            }
            ArrayList courseListIds = new ArrayList(map.keySet());
            courseListIds.removeAll(cloudCourseList);
            courseListIds.forEach(e -> {
                DynamicObject course = (DynamicObject)map.get(e);
                toDeletes.add(course.getLong("id"));
            });
        });
        if (toUpdates.size() != 0) {
            SaveServiceHelper.save((DynamicObject[])toUpdates.toArray(new DynamicObject[0]));
        }
        if (toAdds.size() != 0) {
            SaveServiceHelper.save((DynamicObject[])toAdds.toArray(new DynamicObject[0]));
        }
        QFilter qFilter = new QFilter("id", "in", toDeletes);
        TrainCourseUtils.delete("ricc_course", qFilter.toArray());
        qFilter = new QFilter("courselist", "in", hasDeleteList);
        TrainCourseUtils.delete("ricc_course", qFilter.toArray());
    }

    private static void syncLearningRecord() {
        Map courses = BusinessDataServiceHelper.loadFromCache((String)"ricc_course", null);
        QFilter qFilter = new QFilter("course", "not in", courses.keySet());
        TrainCourseUtils.delete("ricc_learningdetail", qFilter.toArray());
        Map courseAssignMap = BusinessDataServiceHelper.loadFromCache((String)"ricc_courseassign", null);
        TrainCourseUtils.updateCourseDetail(courseAssignMap.values().toArray(new DynamicObject[0]));
    }

    public static boolean checkIsInvokeFail(JSONObject jsonObject) {
        if (jsonObject == null) {
            return true;
        }
        String code = jsonObject.getString("code");
        if (StringUtils.isNotEmpty((String)code) && !"200".equals(code)) {
            return true;
        }
        String errorCode = jsonObject.getString("errorCode");
        return StringUtils.isNotEmpty((String)errorCode) && !"0".equals(errorCode);
    }

    public static CustomApiResult<String> transferPerm(String kdCloudUId) {
        HashMap<String, String> param = new HashMap<String, String>(16);
        param.put("uid", kdCloudUId);
        TrainInterfaceUtils.addEnvParam(param, true, true);
        JSONObject jsonObject = TrainInterfaceUtils.doPostHttp(param, "/space-checklist/transfer");
        if (TrainCourseUtils.checkIsInvokeFail(jsonObject)) {
            if (jsonObject == null) {
                return CustomApiResult.fail((String)"1001", (String)ResManager.loadKDString((String)"\u79fb\u4ea4\u5931\u8d25\u3002", (String)"TrainCourseUtils_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
            }
            log.error("TrainCourseUtils_transferPerm: {}", (Object)jsonObject.getString("message"));
            Object errorCode = jsonObject.get((Object)"errorCode");
            return CustomApiResult.fail((String)String.valueOf(errorCode), (String)ResManager.loadKDString((String)"\u79fb\u4ea4\u5931\u8d25\u3002", (String)"TrainCourseUtils_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
        log.info("TrainCourseUtils_transferPerm: {}", (Object)jsonObject.toJSONString());
        return CustomApiResult.success((Object)ResManager.loadKDString((String)"\u79fb\u4ea4\u6210\u529f\u3002", (String)"TrainCourseUtils_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
    }

    public static List<LearningRecord> getCloudLearnRecords(DynamicObject courseList, String uid) {
        return TrainCourseUtils.getCloudLearnRecords(courseList, uid, true);
    }

    public static List<LearningRecord> getCloudLearnRecords(DynamicObject courseList, String uid, boolean increment) {
        CustomApiResult<Boolean> result;
        String invokeTime;
        ArrayList<LearningRecord> learningRecords = new ArrayList<LearningRecord>(16);
        HashMap<String, String> param = new HashMap<String, String>(16);
        param.put("id", courseList.getString("courselistid"));
        param.put("uid", uid);
        param.put("pageSize", "100");
        if (increment && StringUtils.isNotEmpty((String)(invokeTime = TrainCourseUtils.getInvokeTime(courseList.getLong("id"), uid)))) {
            param.put("from", invokeTime);
        }
        TrainInterfaceUtils.addEnvParam(param, true, true);
        Date date = new Date();
        int i = 1;
        while ((result = TrainCourseUtils.getSinglePageCloudLearnRecords(param, learningRecords, i)).isStatus() && !((Boolean)result.getData()).booleanValue()) {
            ++i;
        }
        if (result.isStatus()) {
            TrainCourseUtils.updateInvokeTime(courseList.getLong("id"), uid, date);
        }
        return learningRecords;
    }

    private static CustomApiResult<Boolean> getSinglePageCloudLearnRecords(Map<String, String> param, List<LearningRecord> learningRecords, int pageIndex) {
        HashMap<String, String> tmp = new HashMap<String, String>(param);
        tmp.put("pageIndex", String.valueOf(pageIndex));
        JSONObject jsonObject = TrainInterfaceUtils.doGetHttp(tmp, "/space-checklist/learn-records");
        if (TrainCourseUtils.checkIsInvokeFail(jsonObject)) {
            log.error("TrainCourseUtils_getCloudLearnRecords" + (jsonObject == null ? "" : jsonObject.getString("message")));
            return CustomApiResult.fail((String)"1001", (String)"getRecordError");
        }
        Boolean last = jsonObject.getBoolean("last");
        JSONArray dataList = jsonObject.getJSONArray("data");
        if (dataList == null) {
            if (last.booleanValue()) {
                return CustomApiResult.success((Object)true);
            }
            return CustomApiResult.fail((String)"1002", (String)"getRecordDataError");
        }
        for (int i = 0; i < dataList.size(); ++i) {
            Object lastVisitAt;
            Object finishedAt;
            JSONObject dataObject = dataList.getJSONObject(i);
            LearningRecord learningRecord = new LearningRecord();
            learningRecord.setItemId(dataObject.getString("itemId"));
            learningRecord.setUid(dataObject.getString("uid"));
            Object status = dataObject.get((Object)"status");
            if (status != null) {
                learningRecord.setStatus(dataObject.getInteger("status"));
            }
            if ((finishedAt = dataObject.get((Object)"finishedAt")) != null) {
                learningRecord.setFinishedAt(dataObject.getLong("finishedAt"));
            }
            if ((lastVisitAt = dataObject.get((Object)"lastVisitAt")) != null) {
                learningRecord.setLastVisitAt(dataObject.getLong("lastVisitAt"));
            }
            learningRecords.add(learningRecord);
        }
        return CustomApiResult.success((Object)last);
    }

    private static String getInvokeTime(long courseListId, String uid) {
        QFilter qFilter = new QFilter("courselist", "=", (Object)courseListId);
        qFilter.and("uid", "=", (Object)uid);
        DynamicObject learnRecordTime = QueryServiceHelper.queryOne((String)"ricc_learnrecordtime", (String)"invoketime", (QFilter[])qFilter.toArray());
        if (learnRecordTime == null) {
            return "";
        }
        return String.valueOf(learnRecordTime.getDate("invoketime").getTime());
    }

    private static void updateInvokeTime(long courseListId, String uid, Date date) {
        QFilter qFilter = new QFilter("courselist", "=", (Object)courseListId);
        qFilter.and("uid", "=", (Object)uid);
        DynamicObject learnRecordTime = BusinessDataServiceHelper.loadSingle((String)"ricc_learnrecordtime", (QFilter[])qFilter.toArray());
        if (learnRecordTime == null) {
            learnRecordTime = BusinessDataServiceHelper.newDynamicObject((String)"ricc_learnrecordtime");
            learnRecordTime.set("courselist", (Object)courseListId);
            learnRecordTime.set("uid", (Object)uid);
        }
        learnRecordTime.set("invoketime", (Object)date);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{learnRecordTime});
    }

    public static void addTrainees(Object retData, ListSelectedRowCollection selectedRows) {
        if (retData == null) {
            return;
        }
        ListSelectedRowCollection rows = (ListSelectedRowCollection)retData;
        DynamicObject[] assignUsers = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_user"));
        Map<Object, DynamicObject> userMap = Arrays.stream(assignUsers).collect(Collectors.toMap(DataEntityBase::getPkValue, e -> e, (n1, n2) -> n2));
        DynamicObject[] selectAssigns = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ricc_courseassign"));
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                TrainCourseUtils.batchDealAssign(TrainCourseUtils::getSendUsers, new ArrayList<Object>(userMap.keySet()), selectAssigns);
                for (DynamicObject selectAssign : selectAssigns) {
                    HashSet<Object> assignPkIds = new HashSet<Object>(userMap.keySet());
                    DynamicObjectCollection trainees = selectAssign.getDynamicObjectCollection("trainee");
                    List<Object> pkValues = trainees.stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toList());
                    pkValues.forEach(assignPkIds::remove);
                    assignPkIds.forEach(e -> {
                        DynamicObject dynamicObject = trainees.addNew();
                        dynamicObject.set("fbasedataid_id", e);
                        dynamicObject.set("fbasedataid", userMap.get(e));
                    });
                    selectAssign.set("traineecount", (Object)trainees.size());
                }
                SaveServiceHelper.save((DynamicObject[])selectAssigns);
                TrainCourseUtils.updateCourseDetail(selectAssigns);
            }
            catch (Exception ex) {
                txHandle.markRollback();
                log.error("TrainCourseUtils_addTrainees", (Throwable)ex);
            }
        }
    }

    public static void updateTrainees(Object retData, Object rowPkId) {
        if (retData == null) {
            return;
        }
        ListSelectedRowCollection rows = (ListSelectedRowCollection)retData;
        DynamicObject assign = BusinessDataServiceHelper.loadSingle((Object)rowPkId, (String)"ricc_courseassign");
        DynamicObject[] assignUsers = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_user"));
        Map<Object, DynamicObject> userMap = Arrays.stream(assignUsers).collect(Collectors.toMap(DataEntityBase::getPkValue, e -> e, (n1, n2) -> n2));
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                ArrayList<Object> assignUserIds = new ArrayList<Object>(userMap.keySet());
                TrainCourseUtils.batchDealAssign(TrainCourseUtils::getSendUsers, assignUserIds, assign);
                assign.set("traineecount", (Object)rows.size());
                DynamicObjectCollection trainees = assign.getDynamicObjectCollection("trainee");
                List users = trainees.stream().map(e -> e.get("fbasedataid_id")).collect(Collectors.toList());
                users.removeAll(assignUserIds);
                QFilter qFilter = new QFilter("courselist", "=", (Object)assign.getLong("courselist_id"));
                qFilter.and("uid", "in", KdCloudUtils.getBindingCloudUserUIds(users));
                TrainCourseUtils.delete("ricc_learnrecordtime", qFilter.toArray());
                trainees.clear();
                rows.forEach(e -> {
                    DynamicObject dynamicObject = trainees.addNew();
                    dynamicObject.set("fbasedataid_id", e.getPrimaryKeyValue());
                    dynamicObject.set("fbasedataid", userMap.get(e.getPrimaryKeyValue()));
                });
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{assign});
                TrainCourseUtils.updateCourseDetail(assign);
            }
            catch (Exception ex) {
                txHandle.markRollback();
                log.error("TrainCourseUtils_updateTrainees", (Throwable)ex);
                throw new KDBizException(ResManager.loadKDString((String)"\u5206\u914d\u5b66\u5458\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TrainCourseUtils_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
            }
        }
    }

    public static void addRoles(Object retData, ListSelectedRowCollection selectedRows) {
        if (retData == null) {
            return;
        }
        ListSelectedRowCollection rows = (ListSelectedRowCollection)retData;
        DynamicObject[] assignRoles = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"perm_role"));
        Map<Object, DynamicObject> roleMap = Arrays.stream(assignRoles).collect(Collectors.toMap(DataEntityBase::getPkValue, e -> e, (n1, n2) -> n2));
        DynamicObject[] selectAssigns = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ricc_courseassign"));
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                TrainCourseUtils.batchDealAssign(TrainCourseUtils::getRoleUsers, new ArrayList<Object>(roleMap.keySet()), selectAssigns);
                for (DynamicObject selectAssign : selectAssigns) {
                    HashSet<Object> assignPkIds = new HashSet<Object>(roleMap.keySet());
                    DynamicObjectCollection roles = selectAssign.getDynamicObjectCollection("role");
                    List<Object> pkValues = roles.stream().map(e -> e.get("fbasedataid_id")).collect(Collectors.toList());
                    pkValues.forEach(assignPkIds::remove);
                    assignPkIds.forEach(e -> {
                        DynamicObject dynamicObject = roles.addNew();
                        dynamicObject.set("fbasedataid_id", e);
                        dynamicObject.set("fbasedataid", roleMap.get(e));
                    });
                    selectAssign.set("rolecount", (Object)roles.size());
                }
                SaveServiceHelper.save((DynamicObject[])selectAssigns);
                TrainCourseUtils.updateCourseDetail(selectAssigns);
            }
            catch (Exception ex) {
                txHandle.markRollback();
                log.error("TrainCourseUtils_addRoles", (Throwable)ex);
            }
        }
    }

    public static void updateRoles(Object retData, Object rowPkId) {
        if (retData == null) {
            return;
        }
        ListSelectedRowCollection rows = (ListSelectedRowCollection)retData;
        DynamicObject assign = BusinessDataServiceHelper.loadSingle((Object)rowPkId, (String)"ricc_courseassign");
        DynamicObject[] assignRoles = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"perm_role"));
        Map<Object, DynamicObject> roleMap = Arrays.stream(assignRoles).collect(Collectors.toMap(DataEntityBase::getPkValue, e -> e, (n1, n2) -> n2));
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                ArrayList<Object> assignRoleIds = new ArrayList<Object>(roleMap.keySet());
                TrainCourseUtils.batchDealAssign(TrainCourseUtils::getRoleUsers, assignRoleIds, assign);
                assign.set("rolecount", (Object)rows.size());
                DynamicObjectCollection roles = assign.getDynamicObjectCollection("role");
                List roleIds = roles.stream().map(e -> e.get("fbasedataid_id")).collect(Collectors.toList());
                roleIds.removeAll(assignRoleIds);
                QFilter qFilter = new QFilter("courselist", "=", (Object)assign.getLong("courselist_id"));
                qFilter.and("uid", "in", KdCloudUtils.getBindingCloudUserUIds(TrainCourseUtils.getRoleUsers(roleIds, String::valueOf)));
                TrainCourseUtils.delete("ricc_learnrecordtime", qFilter.toArray());
                roles.clear();
                rows.forEach(e -> {
                    DynamicObject dynamicObject = roles.addNew();
                    dynamicObject.set("fbasedataid_id", e.getPrimaryKeyValue());
                    dynamicObject.set("fbasedataid", roleMap.get(e.getPrimaryKeyValue()));
                });
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{assign});
                TrainCourseUtils.updateCourseDetail(assign);
            }
            catch (Exception ex) {
                txHandle.markRollback();
                log.error("TrainCourseUtils_updateRoles", (Throwable)ex);
                throw new KDBizException(ResManager.loadKDString((String)"\u5206\u914d\u5b66\u5458\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TrainCourseUtils_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
            }
        }
    }

    public static void updateCourseDetail(DynamicObject ... courseAssigns) {
        ArrayList messageInfoList = new ArrayList(16);
        Map<Long, List> courseAssignMap = Arrays.stream(courseAssigns).collect(Collectors.toMap(e -> e.getLong("courselist_id"), e -> {
            DynamicObjectCollection trainees = e.getDynamicObjectCollection("trainee");
            List userIds = trainees.stream().map(k -> k.getLong("fbasedataid_id")).collect(Collectors.toList());
            DynamicObjectCollection roles = e.getDynamicObjectCollection("role");
            List<Long> roleUserIds = TrainCourseUtils.getRoleUsers(roles, (T k) -> k.getString("fbasedataid_id"));
            roleUserIds.removeAll(userIds);
            userIds.addAll(roleUserIds);
            messageInfoList.add(TrainCourseUtils.createAssignMessageInfo(e, roleUserIds));
            return userIds.stream().distinct().collect(Collectors.toList());
        }, (oldValue, newValue) -> newValue));
        QFilter qFilter = new QFilter("courselist", "in", courseAssignMap.keySet());
        DynamicObjectCollection courses = QueryServiceHelper.query((String)"ricc_course", (String)"id, courselist", (QFilter[])qFilter.toArray());
        Map courseMap = courses.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(course -> course.getLong("courselist"), Collectors.mapping(course -> course.getLong("id"), Collectors.toList())));
        ArrayList courseIds = new ArrayList(16);
        courseMap.values().forEach(courseIds::addAll);
        qFilter = new QFilter("course", "in", courseIds);
        DynamicObjectCollection learningRecords = QueryServiceHelper.query((String)"ricc_learningdetail", (String)"id, user, course", (QFilter[])qFilter.toArray());
        Map<Long, List<DynamicObject>> learningRecordMap = learningRecords.stream().collect(Collectors.groupingBy(e -> e.getLong("course")));
        HashSet addRecords = new HashSet(16);
        ArrayList toSaves = new ArrayList(16);
        ArrayList toDeletes = new ArrayList(16);
        courseAssignMap.forEach((key, value) -> {
            List listCourseIds = (List)courseMap.get(key);
            listCourseIds.forEach(e -> {
                List records = learningRecordMap.getOrDefault(e, new ArrayList(16));
                ArrayList tmp = new ArrayList(value);
                Map<Long, DynamicObject> recordMap = records.stream().collect(Collectors.toMap(k -> k.getLong("user"), k -> k, (n1, n2) -> n2));
                HashSet<Long> trainees = new HashSet<Long>(recordMap.keySet());
                tmp.removeAll(trainees);
                tmp.forEach(k -> {
                    if (addRecords.add(k + "#" + e)) {
                        DynamicObject learningRecord = BusinessDataServiceHelper.newDynamicObject((String)"ricc_learningdetail");
                        learningRecord.set("user", k);
                        learningRecord.set("course", e);
                        learningRecord.set("status", (Object)"unstart");
                        toSaves.add(learningRecord);
                    }
                });
                tmp = new ArrayList(value);
                tmp.forEach(trainees::remove);
                toDeletes.addAll(trainees.stream().map(k -> {
                    DynamicObject record = (DynamicObject)recordMap.get(k);
                    if (record != null) {
                        return record.getLong("id");
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList()));
            });
        });
        if (toSaves.size() != 0) {
            SaveServiceHelper.save((DynamicObject[])toSaves.toArray(new DynamicObject[0]));
        }
        if (toDeletes.size() != 0) {
            qFilter = new QFilter("id", "in", toDeletes);
            TrainCourseUtils.delete("ricc_learningdetail", qFilter.toArray());
        }
        if (messageInfoList.size() != 0) {
            Map result = MessageCenterServiceHelper.batchSendMessages(messageInfoList);
            log.info("TrainCourseUtils_sendMessage: " + SerializationUtils.toJsonString((Object)result));
        }
    }

    public static void batchDealAssign(BiFunction<DynamicObject, List<Object>, List<Long>> sendUsersFun, List<Object> infoList, DynamicObject ... courseAssigns) {
        ArrayList<MessageInfo> messageInfoList = new ArrayList<MessageInfo>(16);
        for (DynamicObject courseAssign : courseAssigns) {
            List<Long> addUserIds = sendUsersFun.apply(courseAssign, infoList);
            if (addUserIds.size() == 0) continue;
            MessageInfo messageInfo = TrainCourseUtils.createAssignMessageInfo(courseAssign, addUserIds);
            messageInfoList.add(messageInfo);
            JoinToCourseListTask joinTask = new JoinToCourseListTask(courseAssign, addUserIds);
            TrainThreadUtils.submit(joinTask);
        }
        if (messageInfoList.size() != 0) {
            Map result = MessageCenterServiceHelper.batchSendMessages(messageInfoList);
            log.info("TrainCourseUtils_sendMessage: " + SerializationUtils.toJsonString((Object)result));
        }
    }

    public static void joinToCourseList(DynamicObject courseAssign, List<Long> addUserIds) {
        DynamicObject courseList = courseAssign.getDynamicObject("courselist");
        if (courseList == null) {
            return;
        }
        String courseListId = courseList.getString("courselistid");
        if (StringUtils.isEmpty((String)courseListId)) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("id", courseListId);
        TrainInterfaceUtils.addEnvParam(params, true, true);
        HashMap<String, Object> param = new HashMap<String, Object>(params);
        List<String> uIdList = KdCloudUtils.getBindingCloudUserUIds(addUserIds);
        if (uIdList.size() == 0) {
            return;
        }
        param.put("uid", uIdList);
        JSONObject result = TrainInterfaceUtils.doCommonPostHttp(param, "/space-checklist/join");
        if (result == null) {
            log.error("TrainCourseUtils_joinToCourseList_uid_fail: result is null");
            return;
        }
        if (TrainCourseUtils.checkIsInvokeFail(result)) {
            log.error("TrainCourseUtils_joinToCourseList_uid_fail: " + result.toJSONString());
        }
    }

    private static MessageInfo createAssignMessageInfo(DynamicObject courseAssign, List<Long> userIds) {
        LocaleString title = new LocaleString();
        LocaleString message = new LocaleString();
        LocaleString tag = new LocaleString();
        MessageInfo messageInfo = new MessageInfo();
        tag.setLocaleValue(ResManager.loadKDString((String)"\u5b9e\u65bd\u57f9\u8bad", (String)"TrainCourseUtils_5", (String)"sys-ricc-platform", (Object[])new Object[0]));
        messageInfo.setMessageTag((ILocaleString)tag);
        title.setLocaleValue(ResManager.loadKDString((String)"\u8bfe\u7a0b\u5b66\u4e60", (String)"TrainCourseUtils_6", (String)"sys-ricc-platform", (Object[])new Object[0]));
        messageInfo.setMessageTitle((ILocaleString)title);
        message.setLocaleValue(ResManager.loadKDString((String)"\u60a8\u6709\u4e00\u95e8\u65b0\u7684\u5b66\u4e60\u8bfe\u7a0b\u300a%1$s\u300b", (String)"TrainCourseUtils_7", (String)"sys-ricc-platform", (Object[])new Object[]{courseAssign.getString("name")}));
        messageInfo.setMessageContent((ILocaleString)message);
        messageInfo.setUserIds(userIds);
        messageInfo.setSenderName(ResManager.loadKDString((String)"\u7cfb\u7edf\u53d1\u9001", (String)"TrainCourseUtils_8", (String)"sys-ricc-platform", (Object[])new Object[0]));
        messageInfo.setSendTime(new Date());
        messageInfo.setNotifyType(MessageChannels.MC.getNumber());
        messageInfo.setSource("ricc_courseassign");
        messageInfo.setNestAppid("ippm");
        String currentUrl = UrlService.getDomainContextUrl();
        messageInfo.setContentUrl(currentUrl + "/?formId=ricc_mycourse");
        return messageInfo;
    }

    public static MessageInfo createNotifyMessageInfo(Long userId, int count) {
        LocaleString title = new LocaleString();
        LocaleString message = new LocaleString();
        LocaleString tag = new LocaleString();
        MessageInfo messageInfo = new MessageInfo();
        tag.setLocaleValue(ResManager.loadKDString((String)"\u5b9e\u65bd\u57f9\u8bad", (String)"TrainCourseUtils_5", (String)"sys-ricc-platform", (Object[])new Object[0]));
        messageInfo.setMessageTag((ILocaleString)tag);
        title.setLocaleValue(ResManager.loadKDString((String)"\u8bfe\u7a0b\u5b66\u4e60\u63d0\u9192", (String)"TrainCourseUtils_9", (String)"sys-ricc-platform", (Object[])new Object[0]));
        messageInfo.setMessageTitle((ILocaleString)title);
        message.setLocaleValue(ResManager.loadKDString((String)"\u60a8\u6709%1$s\u95e8\u8bfe\u7a0b\u672a\u5b8c\u6210\u5b66\u4e60\uff0c\u8bf7\u5c3d\u5feb\u5b8c\u6210\u3002", (String)"TrainCourseUtils_10", (String)"sys-ricc-platform", (Object[])new Object[]{count}));
        messageInfo.setMessageContent((ILocaleString)message);
        messageInfo.setUserIds(Collections.singletonList(userId));
        messageInfo.setSenderName(ResManager.loadKDString((String)"\u7cfb\u7edf\u53d1\u9001", (String)"TrainCourseUtils_8", (String)"sys-ricc-platform", (Object[])new Object[0]));
        messageInfo.setSendTime(new Date());
        messageInfo.setNotifyType(MessageChannels.MC.getNumber());
        messageInfo.setSource("ricc_learningrecord");
        messageInfo.setNestAppid("ippm");
        String currentUrl = UrlService.getDomainContextUrl();
        messageInfo.setContentUrl(currentUrl + "/?formId=ricc_mycourse");
        return messageInfo;
    }

    private static List<Long> getSendUsers(DynamicObject courseAssign, List<Object> users) {
        ArrayList<Long> userIds = new ArrayList<Long>(16);
        if (users == null || users.size() == 0) {
            return userIds;
        }
        DynamicObjectCollection trainees = courseAssign.getDynamicObjectCollection("trainee");
        List traineeIds = trainees.stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toList());
        for (Object user : users) {
            try {
                Long userId = (Long)ObjectConverter.convert((Object)user, Long.class, (boolean)true);
                if (userId == null) continue;
                userIds.add(userId);
            }
            catch (Exception ex) {
                log.error("TrainCourseUtils_getSendUsers", (Throwable)ex);
            }
        }
        userIds.removeAll(traineeIds);
        DynamicObjectCollection roles = courseAssign.getDynamicObjectCollection("role");
        List roleIds = roles.stream().map(e -> e.get("fbasedataid_id")).collect(Collectors.toList());
        List<Long> roleUsers = TrainCourseUtils.getRoleUsers(roleIds, String::valueOf);
        userIds.removeAll(roleUsers);
        return userIds;
    }

    private static List<Long> getRoleUsers(DynamicObject courseAssign, List<Object> roleList) {
        ArrayList<Object> tmp = new ArrayList<Object>(roleList);
        DynamicObjectCollection roles = courseAssign.getDynamicObjectCollection("role");
        List roleIds = roles.stream().map(e -> e.get("fbasedataid_id")).collect(Collectors.toList());
        tmp.removeAll(roleIds);
        List<Long> roleUsers = TrainCourseUtils.getRoleUsers(tmp, String::valueOf);
        roleIds.retainAll(roleList);
        List<Long> enableUsers = TrainCourseUtils.getEnableUsers();
        ArrayList<String> toSaveRoles = new ArrayList<String>(16);
        roleUsers.addAll(roleIds.stream().map(e -> {
            Set befUserIds;
            String roleId = String.valueOf(e);
            List<Long> userList = TrainCourseUtils.getPermUserByRoleId(roleId, enableUsers);
            HashSet<Long> userSet = new HashSet<Long>(userList);
            if (!CollectionUtils.isEqualCollection(userSet, (Collection)(befUserIds = (Set)TrainCourseUtils.getRoleUserMap().getOrDefault(roleId, new HashSet(16))))) {
                toSaveRoles.add(roleId);
                TrainCourseUtils.getRoleUserMap().put(roleId, userSet);
            }
            userList.removeAll(befUserIds);
            return userList;
        }).flatMap(Collection::stream).collect(Collectors.toList()));
        if (toSaveRoles.size() != 0) {
            TrainRoleUserUtils.saveRoleUserMap(toSaveRoles, TrainCourseUtils.getRoleUserMap());
        }
        DynamicObjectCollection trainees = courseAssign.getDynamicObjectCollection("trainee");
        List traineeIds = trainees.stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toList());
        roleUsers.removeAll(traineeIds);
        return roleUsers;
    }

    public static <T> List<Long> getRoleUsers(Collection<T> roleListIds, Function<T, String> func) {
        ArrayList<String> toSaveRoles = new ArrayList<String>(16);
        List<Long> roleUsers = TrainCourseUtils.getRoleUsers(roleListIds, func, toSaveRoles);
        if (toSaveRoles.size() != 0) {
            TrainRoleUserUtils.saveRoleUserMap(toSaveRoles, TrainCourseUtils.getRoleUserMap());
        }
        return roleUsers;
    }

    public static <T> List<Long> getRoleUsers(Collection<T> roleListIds, Function<T, String> func, List<String> toSaveRoles) {
        List<Long> enableUsers = TrainCourseUtils.getEnableUsers();
        return roleListIds.stream().map(e -> {
            Set befUserIds;
            String roleId = (String)func.apply(e);
            List<Long> userList = TrainCourseUtils.getPermUserByRoleId(roleId, enableUsers);
            HashSet<Long> userSet = new HashSet<Long>(userList);
            if (!CollectionUtils.isEqualCollection(userSet, (Collection)(befUserIds = (Set)TrainCourseUtils.getRoleUserMap().getOrDefault(roleId, new HashSet(16))))) {
                toSaveRoles.add(roleId);
                TrainCourseUtils.getRoleUserMap().put(roleId, userSet);
            }
            return userList;
        }).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    public static String getSimpleUuidIdString() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String getUuidIdWithDataString() {
        return DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss_SSS").format(LocalDateTime.now()) + "_" + TrainCourseUtils.getSimpleUuidIdString();
    }

    public static void addErrorInfo(OperationResult operationResult, ExtendedDataEntity dataEntity, String content, String opName, boolean isSingle) {
        if (dataEntity == null) {
            return;
        }
        if (!isSingle) {
            content = dataEntity.getBillNo() + "\uff1a " + content;
        }
        ValidationErrorInfo info = new ValidationErrorInfo("", (Object)dataEntity.getDataEntity().getLong("id"), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_001", opName, content, ErrorLevel.Error);
        info.setEntityKey("ricc_learningrecord");
        info.setSubRowIndex(0);
        operationResult.addErrorInfo((OperateErrorInfo)info);
    }

    public static JSONObject toJSONObject(Map<String, Object> map) {
        return new JSONObject(map);
    }

    public static String skipLearnListPage() {
        CloudTrainConfig cloudConfig = TrainConfigUtils.getCloudConfig();
        String skipCodeUrl = String.format("%s/people/center?tab=learnList&isCustomer=true&productLineId=2", cloudConfig.getServiceHttp());
        CustomApiResult<String> cloudAuthCodeNew = CloudAccountUtils.getCloudAuthCodeNew(null);
        if (!cloudAuthCodeNew.isStatus()) {
            throw new KDBizException(cloudAuthCodeNew.getMessage());
        }
        try {
            return String.format("%s/sso/login?auth_code=%s&redirect_url=%s", cloudConfig.getCloudHttp(), cloudAuthCodeNew.getData(), URLEncoder.encode(skipCodeUrl, "UTF-8"));
        }
        catch (Exception ex) {
            log.error("TrainCourseUtils", (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
    }

    public static String getCourseTime(String type, String time) {
        if (StringUtils.isEmpty((String)time)) {
            time = "0";
        }
        if ("document".equals(type) || "courseware".equals(type)) {
            return ResManager.loadKDString((String)"%1$s\u9875", (String)"TrainCourseUtils_11", (String)"sys-ricc-platform", (Object[])new Object[]{time});
        }
        if ("customization".equals(type)) {
            return "";
        }
        long second = Long.parseLong(time);
        long minutes = second / 60L + (long)(second % 60L == 0L ? 0 : 1);
        long hours = minutes / 60L;
        if (hours == 0L) {
            return ResManager.loadKDString((String)"%1$s\u5206\u949f", (String)"TrainCourseUtils_12", (String)"sys-ricc-platform", (Object[])new Object[]{minutes});
        }
        return ResManager.loadKDString((String)"%1$s\u5c0f\u65f6%2$s\u5206\u949f", (String)"TrainCourseUtils_13", (String)"sys-ricc-platform", (Object[])new Object[]{hours, minutes});
    }

    public static boolean isCustomizationCourse(DynamicObject course) {
        if (course == null) {
            return false;
        }
        String videoId = course.getString("videoid");
        return StringUtils.isEmpty((String)videoId);
    }

    public static void updateCustomCourseStatus(Long courseId, Long userId) {
        TrainCourseUtils.updateCourseStatus(courseId, userId, "complete");
    }

    public static void updateCourseStatus(Long courseId, Long userId, String status) {
        QFilter qFilter = new QFilter("course", "=", (Object)courseId);
        qFilter.and("user", "=", (Object)userId);
        DynamicObject courseRecord = BusinessDataServiceHelper.loadSingle((String)"ricc_learningdetail", (QFilter[])qFilter.toArray());
        if (courseRecord == null) {
            return;
        }
        courseRecord.set("status", (Object)status);
        Date now = TimeServiceHelper.now();
        courseRecord.set("lastlearntime", (Object)now);
        Date completeTime = courseRecord.getDate("completetime");
        if (completeTime == null) {
            courseRecord.set("completetime", (Object)now);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{courseRecord});
    }

    public static List<Long> getOwnCourseLists() {
        long userId = UserServiceHelper.getCurrentUserId();
        Set roleIds = PermissionServiceHelper.getRolesByUser((Long)userId);
        Map assigns = BusinessDataServiceHelper.loadFromCache((String)"ricc_courseassign", (String)"courselist, trainee, role", null);
        return assigns.values().stream().filter(e -> {
            DynamicObjectCollection trainees = e.getDynamicObjectCollection("trainee");
            if (trainees.stream().anyMatch(k -> k.getLong("fbasedataid_id") == userId)) {
                return true;
            }
            DynamicObjectCollection roles = e.getDynamicObjectCollection("role");
            return roles.stream().anyMatch(k -> roleIds.contains(k.getString("fbasedataid_id")));
        }).map(e -> {
            DynamicObject courseList = e.getDynamicObject("courselist");
            return courseList.getLong("id");
        }).collect(Collectors.toList());
    }

    public static void updateCloudLearnRecords(List<Long> courseListIds) {
        String curKdCloudUId = KdCloudUtils.getCurKdCloudUId();
        QFilter qFilter = new QFilter("id", "in", courseListIds);
        DynamicObjectCollection courseLists = QueryServiceHelper.query((String)"ricc_courselist", (String)"id, courselistid", (QFilter[])qFilter.toArray());
        Map<String, LearningRecord> learningRecordMap = courseLists.stream().map(e -> TrainCourseUtils.getCloudLearnRecords(e, curKdCloudUId)).flatMap(Collection::stream).collect(Collectors.toMap(LearningRecord::getItemId, e -> e, (oldValue, newValue) -> newValue));
        long userId = UserServiceHelper.getCurrentUserId();
        qFilter = new QFilter("user", "=", (Object)userId);
        qFilter.and("course.courseid", "in", learningRecordMap.keySet());
        DynamicObject[] learningDetails = BusinessDataServiceHelper.load((String)"ricc_learningdetail", (String)"user, course, status, completetime, lastlearntime", (QFilter[])qFilter.toArray());
        if (learningDetails == null || learningDetails.length == 0) {
            return;
        }
        List<DynamicObject> toSaves = Arrays.stream(learningDetails).peek(e -> {
            DynamicObject course = e.getDynamicObject("course");
            LearningRecord learningRecord = (LearningRecord)learningRecordMap.get(course.getString("courseid"));
            e.set("status", (Object)(learningRecord.getStatus() == 1 ? "complete" : "learning"));
            e.set("completetime", (Object)(learningRecord.getFinishedAt() == 0L ? null : new Date(learningRecord.getFinishedAt())));
            e.set("lastlearntime", (Object)(learningRecord.getLastVisitAt() == 0L ? null : new Date(learningRecord.getLastVisitAt())));
        }).collect(Collectors.toList());
        if (toSaves.size() != 0) {
            SaveServiceHelper.save((DynamicObject[])toSaves.toArray(new DynamicObject[0]));
        }
    }

    public static MyCourse getCourseFrontData(List<Long> courseListIds) {
        MyCourse myCourse = new MyCourse();
        myCourse.setViewEvent("viewCourse");
        Map courseListMap = BusinessDataServiceHelper.loadFromCache((Object[])courseListIds.toArray(), (String)"ricc_courselist");
        QFilter qFilter = new QFilter("course.courselist", "in", courseListIds);
        qFilter.and("user", "=", (Object)UserServiceHelper.getCurrentUserId());
        DynamicObject[] learningRecordMap = BusinessDataServiceHelper.load((String)"ricc_learningdetail", (String)"course,status", (QFilter[])qFilter.toArray());
        myCourse.setCourseList(Arrays.stream(learningRecordMap).collect(Collectors.groupingBy(e -> {
            DynamicObject course = e.getDynamicObject("course");
            return course.getLong("courselist.id");
        })).entrySet().stream().map(e -> {
            CourseList courseList = new CourseList();
            AtomicReference<Integer> processCurrent = new AtomicReference<Integer>(0);
            List<Course> courses = ((List)e.getValue()).stream().map(k -> {
                DynamicObject courseInfo = k.getDynamicObject("course");
                DynamicObject list = courseInfo.getDynamicObject("courselist");
                long courseListId = list.getLong("id");
                DynamicObject obj = (DynamicObject)courseListMap.get(courseListId);
                if (obj != null) {
                    courseList.setClassName(obj.getString("name"));
                }
                Course course = new Course();
                course.setClassId(courseInfo.getString("courseid"));
                course.setCourseId(courseInfo.getString("videoid"));
                String type = courseInfo.getString("type");
                if (TrainCourseUtils.isCustomizationCourse(courseInfo)) {
                    type = "customization";
                }
                course.setType(type);
                course.setTime(TrainCourseUtils.getCourseTime(type, courseInfo.getString("time")));
                course.setName(courseInfo.getString("name"));
                course.setStatus("complete".equals(k.getString("status")) ? 1 : 0);
                if (1 == course.getStatus()) {
                    processCurrent.set((Integer)processCurrent.get() + 1);
                }
                return course;
            }).sorted(Comparator.comparingLong(k -> Long.parseLong(k.getClassId()))).collect(Collectors.toList());
            DynamicObject courseListDyn = (DynamicObject)courseListMap.get(e.getKey());
            if (courseListDyn != null) {
                courseList.setCourseListId(courseListDyn.getString("courselistid"));
            } else {
                courseList.setCourseListId("0");
            }
            courseList.setClassDetailList(courses);
            courseList.setProcessCurrent(processCurrent.get());
            courseList.setProcessTotal(courses.size());
            courseList.setStudyOk(processCurrent.get().intValue() == courses.size());
            return courseList;
        }).collect(Collectors.toList()));
        myCourse.setMethod("refresh");
        return myCourse;
    }

    public static CustomApiResult<ViewCourse> getViewCourse(DynamicObject course) {
        if (course == null) {
            return CustomApiResult.fail((String)"1001", (String)ResManager.loadKDString((String)"\u8bfe\u7a0b\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"TrainCourseUtils_14", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
        CustomApiResult<String> result = CloudAccountUtils.getCloudAuthCodeNew();
        if (!result.isStatus()) {
            log.error("TrainCourseUtils_getAuthCode_error: " + SerializationUtils.toJsonString(result));
            return CustomApiResult.fail((String)"1002", (String)ResManager.loadKDString((String)"\u83b7\u53d6AuthCode\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"TrainCourseUtils_15", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
        ViewCourse viewCourse = new ViewCourse();
        viewCourse.setAuthCode((String)result.getData());
        viewCourse.setCourseId(course.getString("videoid"));
        viewCourse.setShowTitle(true);
        viewCourse.setSource(ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u661f\u7a7a-\u65d7\u8230\u7248", (String)"TrainCourseUtils_16", (String)"sys-ricc-platform", (Object[])new Object[0]));
        CloudTrainConfig cloudConfig = TrainConfigUtils.getCloudConfig();
        viewCourse.setRuntime(cloudConfig.getRuntime());
        DynamicObject courseList = course.getDynamicObject("courselist");
        viewCourse.setResourceId(courseList.getString("courselistid"));
        viewCourse.setResourceType("LearningChecklist");
        viewCourse.setClassId(course.getString("courseid"));
        return CustomApiResult.success((Object)viewCourse);
    }

    public static void updateRoleUserMap() {
        Map assigns = BusinessDataServiceHelper.loadFromCache((String)"ricc_courseassign", null);
        ArrayList toUpdateAssigns = new ArrayList(16);
        ArrayList<String> toSaveRoles = new ArrayList<String>(16);
        HashMap<String, List> roleAssignMap = new HashMap<String, List>(16);
        assigns.values().forEach(assign -> {
            DynamicObjectCollection roles = assign.getDynamicObjectCollection("role");
            roles.forEach(role -> {
                List roleAssigns = roleAssignMap.computeIfAbsent(role.getString("fbasedataid_id"), k -> new ArrayList());
                roleAssigns.add(assign);
            });
        });
        List<Long> enableUsers = TrainCourseUtils.getEnableUsers();
        roleAssignMap.forEach((roleId, assignList) -> {
            Set beforeUserIds;
            List<Long> userIds = TrainCourseUtils.getPermUserByRoleId(roleId, enableUsers);
            HashSet<Long> userSet = new HashSet<Long>(userIds);
            if (!CollectionUtils.isEqualCollection(userSet, (Collection)(beforeUserIds = (Set)TrainCourseUtils.getRoleUserMap().getOrDefault(roleId, new HashSet(16))))) {
                toSaveRoles.add((String)roleId);
                toUpdateAssigns.addAll(assignList);
                TrainCourseUtils.getRoleUserMap().put((String)roleId, (Set<Long>)userSet);
            }
        });
        if (toSaveRoles.size() != 0) {
            TrainRoleUserUtils.saveRoleUserMap(toSaveRoles, TrainCourseUtils.getRoleUserMap());
        }
        if (toUpdateAssigns.size() != 0) {
            TrainCourseUtils.updateCourseDetail(toUpdateAssigns.toArray(new DynamicObject[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, Set<Long>> getRoleUserMap() {
        if (roleUserMap != null) return roleUserMap;
        Class<TrainCourseUtils> clazz = TrainCourseUtils.class;
        synchronized (TrainCourseUtils.class) {
            if (roleUserMap != null) return roleUserMap;
            roleUserMap = TrainRoleUserUtils.getRoleUserMap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return roleUserMap;
        }
    }

    public static void delete(String entityName, QFilter[] qFilters) {
        int sum = 5000;
        while (sum == 5000) {
            sum = DeleteServiceHelper.delete((String)entityName, (QFilter[])qFilters);
        }
    }

    public static List<Long> getPermUserByRoleId(String roleId, List<Long> userIds) {
        List userList = PermissionServiceHelper.getUsersByRoleID((String)roleId);
        userList.retainAll(userIds);
        return userList;
    }

    public static List<Long> getEnableUsers() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        qFilters.add(new QFilter("isforbidden", "=", (Object)"0"));
        qFilters.add(new QFilter("id", "not in", Arrays.asList(1L, 2L, 10L, 3L)));
        qFilters.add(new QFilter("usertypes.fbasedataid.category", "=", (Object)"1"));
        qFilters.add(new QFilter("entryentity.ispartjob", "=", (Object)"0").or(QFilter.emptyOrNotExists((String)"entryentity.dpt.number")));
        DynamicObjectCollection users = QueryServiceHelper.query((String)"bos_user", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
        return users.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
    }
}

