/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.training;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.Pair;
import kd.sys.ricc.business.training.ApiGateWayUtils;
import kd.sys.ricc.business.training.TrainConfigUtils;

public class TrainInterfaceUtils {
    private static final Log log = LogFactory.getLog(TrainInterfaceUtils.class);

    public static void addEnvParam(Map<String, String> param, boolean needSecret, boolean needEnvId) {
        Pair<String, String> envConfig = TrainConfigUtils.getEnvConfig();
        if (needSecret) {
            param.put("secret", (String)envConfig.getKey());
        }
        if (needEnvId) {
            param.put("envId", (String)envConfig.getValue());
        }
    }

    public static JSONObject doGetHttp(Map<String, String> param, String method) {
        TreeMap<String, String> tmp = new TreeMap<String, String>(param);
        Map<String, String> headers = ApiGateWayUtils.buildHeader(tmp, TrainConfigUtils.getAppId(), TrainConfigUtils.getAppSecret());
        String url = TrainConfigUtils.getApiServiceHttp(method);
        log.info("TrainInterfaceUtils_doGetHttp", (Object)url);
        return JSON.parseObject((String)HttpClientUtils.get((String)url, headers, new HashMap<String, String>(tmp)));
    }

    public static JSONObject doPostHttp(Map<String, String> param, String method) {
        return TrainInterfaceUtils.doCommonPostHttp(new HashMap<String, Object>(param), method);
    }

    public static JSONObject doCommonPostHttp(Map<String, Object> param, String method) {
        log.info("TrainInterfaceUtils_doPostHttp", (Object)JSON.toJSONString(param));
        HashMap<String, String> tmp = new HashMap<String, String>(16);
        Map<String, String> headers = ApiGateWayUtils.buildHeader(tmp, TrainConfigUtils.getAppId(), TrainConfigUtils.getAppSecret());
        JSONObject requestBody = new JSONObject();
        requestBody.putAll(param);
        try {
            return JSON.parseObject((String)HttpClientUtils.postAppJson((String)TrainConfigUtils.getApiServiceHttp(method), headers, (Map)requestBody.getInnerMap()));
        }
        catch (Exception ex) {
            log.error("TrainInterfaceUtils_doPostHttp", (Throwable)ex);
            return new JSONObject();
        }
    }
}

