/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.training;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sys.ricc.common.entity.TrainRptListParam;
import kd.sys.ricc.common.entity.TrainRptParam;
import kd.sys.ricc.common.entity.TrainRptSingleParam;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFTable;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFChart;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;

public class TrainReportUtils {
    private static final Log log = LogFactory.getLog(TrainReportUtils.class);

    /*
     * Exception decompiling
     */
    public static boolean createTrainRpt(IFormView view) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void replaceParagraphs(List<XWPFParagraph> paragraphs, Map<String, TrainRptParam> rptParamMap) {
        if (paragraphs == null || paragraphs.size() == 0) {
            return;
        }
        for (XWPFParagraph paragraph : paragraphs) {
            List runs = paragraph.getRuns();
            String text = runs.stream().map(e -> e.getText(0)).collect(Collectors.joining());
            if (StringUtils.isEmpty((CharSequence)text)) continue;
            boolean replaced = false;
            String regex = "\\{\\{(.*?)\\}\\}";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(text);
            while (matcher.find()) {
                TrainRptSingleParam singleParam;
                String paramValues;
                String paramKey = matcher.group(1);
                TrainRptParam trainRptParam = rptParamMap.get(paramKey);
                if (trainRptParam == null || !"single".equals(trainRptParam.getType()) || (paramValues = (singleParam = (TrainRptSingleParam)trainRptParam).getParamValues()) == null) continue;
                text = text.replaceAll("\\{\\{" + paramKey + "\\}\\}", paramValues);
                List<XWPFRun> containRuns = TrainReportUtils.getContainRuns(runs, "{{" + paramKey + "}}");
                if (containRuns.size() != 0) {
                    while (containRuns.size() != 0) {
                        for (int i = 0; i < containRuns.size(); ++i) {
                            XWPFRun xwpfRun = containRuns.get(i);
                            if (i == 0) {
                                xwpfRun.setText(paramValues, 0);
                                continue;
                            }
                            xwpfRun.setText("", 0);
                        }
                        containRuns = TrainReportUtils.getContainRuns(runs, "{{" + paramKey + "}}");
                    }
                    continue;
                }
                replaced = true;
            }
            regex = "\\[\\[(.*?)\\]\\]";
            pattern = Pattern.compile(regex);
            matcher = pattern.matcher(text);
            while (matcher.find()) {
                TrainRptListParam listParam;
                Object paramValues;
                TrainRptParam trainRptParam;
                String funKey = matcher.group(1);
                String[] split = funKey.split("[<,>]");
                if (split.length != 3 || !"Top".equals(split[0]) && !"Bottom".equals(split[0]) || (trainRptParam = rptParamMap.get(split[1])) == null || !"list".equals(trainRptParam.getType()) || (paramValues = (listParam = (TrainRptListParam)trainRptParam).getParamValues()) == null || paramValues.size() == 0) continue;
                int index = Integer.parseInt(split[2]);
                String replaceText = "Top".equals(split[0]) ? String.valueOf(index < paramValues.size() ? paramValues.get(index) : "") : String.valueOf(paramValues.size() - 1 - index >= 0 ? paramValues.get(paramValues.size() - 1 - index) : "");
                text = text.replaceAll("\\[\\[" + funKey + "\\]\\]", replaceText);
                List<XWPFRun> containRuns = TrainReportUtils.getContainRuns(runs, "[[" + funKey + "]]");
                if (containRuns.size() != 0) {
                    while (containRuns.size() != 0) {
                        for (int i = 0; i < containRuns.size(); ++i) {
                            XWPFRun xwpfRun = containRuns.get(i);
                            if (i == 0) {
                                xwpfRun.setText(replaceText, 0);
                                continue;
                            }
                            xwpfRun.setText("", 0);
                        }
                        containRuns = TrainReportUtils.getContainRuns(runs, "[[" + funKey + "]]");
                    }
                    continue;
                }
                replaced = true;
            }
            if (!replaced) continue;
            int index = 0;
            for (XWPFRun run : runs) {
                if (text.length() == index) {
                    run.setText("", 0);
                    continue;
                }
                if (text.length() - index > 100) {
                    run.setText(text.substring(index, index + 100), 0);
                    index += 100;
                    continue;
                }
                run.setText(text.substring(index), 0);
                index = text.length();
            }
        }
    }

    private static List<XWPFRun> getContainRuns(List<XWPFRun> runs, String filterKey) {
        for (int i = 0; i < runs.size(); ++i) {
            String text;
            List<XWPFRun> containRuns = TrainReportUtils.getContainRuns(runs, filterKey, i);
            if (containRuns.size() == 0 || !filterKey.equals(text = containRuns.stream().map(e -> e.getText(0)).collect(Collectors.joining()))) continue;
            return containRuns;
        }
        return new ArrayList<XWPFRun>(16);
    }

    private static List<XWPFRun> getContainRuns(List<XWPFRun> runs, String filterKey, int index) {
        ArrayList<XWPFRun> containRuns = new ArrayList<XWPFRun>(16);
        if (runs.size() <= index) {
            return containRuns;
        }
        XWPFRun xwpfRun = runs.get(index);
        if (xwpfRun == null) {
            return TrainReportUtils.getContainRuns(runs, filterKey, index + 1);
        }
        String text = xwpfRun.getText(0);
        if (filterKey.contains(text)) {
            containRuns.add(xwpfRun);
            containRuns.addAll(TrainReportUtils.getContainRuns(runs, filterKey, index + 1));
        }
        return containRuns;
    }

    private static void replaceTables(List<XWPFTable> tables, Map<String, TrainRptParam> rptParamMap) {
        if (tables == null || tables.size() == 0) {
            return;
        }
        for (int i = 0; i < tables.size(); ++i) {
            XWPFTable table;
            if (i == 0) {
                table = tables.get(i);
                for (XWPFTableRow row : table.getRows()) {
                    for (XWPFTableCell cell : row.getTableCells()) {
                        TrainRptSingleParam singleParam;
                        String paramValues;
                        String paramKey;
                        TrainRptParam trainRptParam;
                        String text = cell.getText();
                        String regex = "\\{\\{(.*?)\\}\\}";
                        Pattern pattern = Pattern.compile(regex);
                        Matcher matcher = pattern.matcher(text);
                        if (!matcher.find() || (trainRptParam = rptParamMap.get(paramKey = matcher.group(1))) == null || !"single".equals(trainRptParam.getType()) || (paramValues = (singleParam = (TrainRptSingleParam)trainRptParam).getParamValues()) == null) continue;
                        text = text.replaceAll("\\{\\{" + paramKey + "\\}\\}", paramValues);
                        TrainReportUtils.setCellText(cell, text);
                    }
                }
                continue;
            }
            table = tables.get(i);
            XWPFTableRow row = table.getRow(1);
            ArrayList<Object> paramList = new ArrayList<Object>(16);
            int maxRow = -1;
            ArrayList<Boolean> isBoldList = new ArrayList<Boolean>(16);
            ArrayList<String> fontFamilies = new ArrayList<String>(16);
            ArrayList<Double> fontSizes = new ArrayList<Double>(16);
            for (XWPFTableCell cell : row.getTableCells()) {
                XWPFParagraph xwpfParagraph;
                List runs;
                List paragraphs;
                String text = cell.getText();
                String regex = "\\[\\[(.*?)\\]\\]";
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(text);
                if (matcher.find()) {
                    int rowIndex;
                    String funKey = matcher.group(1);
                    String[] split = funKey.split("[<,>]");
                    if (split.length != 2 && split.length != 3) {
                        paramList.add(new ArrayList());
                        continue;
                    }
                    if (!"List".equals(split[0])) {
                        paramList.add(new ArrayList());
                        continue;
                    }
                    TrainRptParam trainRptParam = rptParamMap.get(split[1]);
                    if (trainRptParam == null) {
                        paramList.add(new ArrayList());
                        continue;
                    }
                    if (!"list".equals(trainRptParam.getType())) {
                        paramList.add(new ArrayList());
                        continue;
                    }
                    TrainRptListParam listParam = (TrainRptListParam)trainRptParam;
                    Object paramValues = listParam.getParamValues();
                    if (paramValues == null || paramValues.size() == 0) {
                        paramList.add(new ArrayList());
                        continue;
                    }
                    if (split.length == 3) {
                        rowIndex = Integer.parseInt(split[2]);
                        if (rowIndex >= paramValues.size()) {
                            paramList.add(paramValues);
                            rowIndex = paramValues.size();
                        } else {
                            paramList.add(paramValues.subList(0, rowIndex));
                        }
                    } else {
                        paramList.add(paramValues);
                        rowIndex = paramValues.size();
                    }
                    maxRow = Math.max(rowIndex, maxRow);
                } else {
                    paramList.add(new ArrayList(16));
                }
                if ((paragraphs = cell.getParagraphs()) == null || paragraphs.size() == 0 || (runs = (xwpfParagraph = (XWPFParagraph)paragraphs.get(0)).getRuns()) == null || runs.size() == 0) continue;
                XWPFRun xwpfRun = (XWPFRun)runs.get(0);
                if (xwpfRun.isBold()) {
                    isBoldList.add(true);
                } else {
                    isBoldList.add(false);
                }
                String fontFamily = xwpfRun.getFontFamily();
                fontFamilies.add(fontFamily);
                fontSizes.add(xwpfRun.getFontSizeAsDouble());
            }
            List rows = table.getRows();
            for (int k = 1; k <= maxRow; ++k) {
                XWPFTableRow xwpfTableRow = k < rows.size() ? (XWPFTableRow)rows.get(k) : table.createRow();
                for (int j = 0; j < paramList.size(); ++j) {
                    List paramValues = (List)paramList.get(j);
                    XWPFTableCell cell = xwpfTableRow.getCell(j);
                    if (k > paramValues.size()) continue;
                    TrainReportUtils.setCellText(cell, String.valueOf(paramValues.get(k - 1)), true, (Boolean)isBoldList.get(j), (String)fontFamilies.get(j), (Double)fontSizes.get(j));
                }
            }
        }
    }

    public static void setCellText(XWPFTableCell cell, String text) {
        TrainReportUtils.setCellText(cell, text, false, false, "", Double.NaN);
    }

    public static void setCellText(XWPFTableCell cell, String text, Boolean useBold, Boolean isBold, String fontFamily, Double fontSize) {
        List paragraphs = cell.getParagraphs();
        List runs = paragraphs.stream().map(e -> {
            e.setAlignment(ParagraphAlignment.CENTER);
            return e.getRuns();
        }).flatMap(Collection::stream).collect(Collectors.toList());
        if (runs.size() != 0) {
            int index = 0;
            for (XWPFRun run : runs) {
                if (text.length() == index) {
                    run.setText("", 0);
                    continue;
                }
                if (text.length() - index > 100) {
                    run.setText(text.substring(index, index + 100), 0);
                    index += 100;
                    continue;
                }
                run.setText(text.substring(index), 0);
                index = text.length();
            }
        } else {
            cell.setText(text);
            for (XWPFParagraph paragraph : paragraphs) {
                for (XWPFRun run : paragraph.getRuns()) {
                    if (useBold.booleanValue()) {
                        run.setBold(isBold.booleanValue());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)fontFamily)) {
                        run.setFontFamily(fontFamily);
                    }
                    if (Double.isNaN(fontSize)) continue;
                    run.setFontSize(fontSize.doubleValue());
                }
            }
        }
    }

    private static void replaceCharts(List<XWPFChart> charts, Map<String, TrainRptParam> rptParamMap) throws IOException, InvalidFormatException {
        if (charts == null || charts.size() == 0) {
            return;
        }
        for (XWPFChart chart : charts) {
            XSSFWorkbook workbook = chart.getWorkbook();
            XSSFSheet sheetAt = workbook.getSheetAt(0);
            XSSFRow row = sheetAt.getRow(1);
            ArrayList<Object> paramList = new ArrayList<Object>(16);
            int maxRow = -1;
            int maxCol = row.getLastCellNum();
            for (int i = 0; i < maxCol; ++i) {
                XSSFCell cell = row.getCell(i);
                String cellValue = cell.getStringCellValue();
                String regex = "\\[\\[(.*?)\\]\\]";
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(cellValue);
                if (matcher.find()) {
                    int rowIndex;
                    String funKey = matcher.group(1);
                    String[] split = funKey.split("[<,>]");
                    if (split.length != 2 && split.length != 3) {
                        paramList.add(new ArrayList());
                        continue;
                    }
                    if (!"List".equals(split[0])) {
                        paramList.add(new ArrayList());
                        continue;
                    }
                    TrainRptParam trainRptParam = rptParamMap.get(split[1]);
                    if (trainRptParam == null) {
                        paramList.add(new ArrayList());
                        continue;
                    }
                    if (!"list".equals(trainRptParam.getType())) {
                        paramList.add(new ArrayList());
                        continue;
                    }
                    TrainRptListParam listParam = (TrainRptListParam)trainRptParam;
                    Object paramValues = listParam.getParamValues();
                    if (paramValues == null || paramValues.size() == 0) {
                        paramList.add(new ArrayList());
                        continue;
                    }
                    if (split.length == 3) {
                        rowIndex = Integer.parseInt(split[2]);
                        if (rowIndex >= paramValues.size()) {
                            paramList.add(paramValues);
                            rowIndex = paramValues.size();
                        } else {
                            paramList.add(paramValues.subList(0, rowIndex));
                        }
                    } else {
                        paramList.add(paramValues);
                        rowIndex = paramValues.size();
                    }
                    maxRow = Math.max(rowIndex, maxRow);
                    continue;
                }
                paramList.add(new ArrayList());
            }
            XSSFCellStyle cellStyle = workbook.createCellStyle();
            XSSFDataFormat dataFormat = workbook.createDataFormat();
            cellStyle.setDataFormat(dataFormat.getFormat("0%"));
            HashSet<Integer> percentIndex = new HashSet<Integer>(16);
            for (int k = 1; k <= maxRow; ++k) {
                XSSFRow xssfRow = sheetAt.getRow(k);
                if (xssfRow == null) {
                    xssfRow = sheetAt.createRow(k);
                }
                for (int i = 0; i < maxCol; ++i) {
                    ArrayList paramValues;
                    XSSFCell cell = xssfRow.getCell(i);
                    if (cell == null) {
                        cell = xssfRow.createCell(i);
                    }
                    if ((paramValues = (ArrayList)paramList.get(i)) == null) {
                        paramValues = new ArrayList(16);
                    }
                    if (i == 0) {
                        if (k <= paramValues.size()) {
                            cell.setCellValue(String.valueOf(paramValues.get(k - 1)));
                            continue;
                        }
                        cell.setCellValue("");
                        continue;
                    }
                    if (k <= paramValues.size()) {
                        String paramValue = String.valueOf(paramValues.get(k - 1));
                        if (paramValue.endsWith("%")) {
                            int paramData = Integer.parseInt(paramValue.substring(0, paramValue.length() - 1));
                            cell.setCellValue((double)paramData / 100.0);
                            cell.setCellStyle((CellStyle)cellStyle);
                            percentIndex.add(i);
                            continue;
                        }
                        cell.setCellValue(Double.parseDouble(paramValue));
                        continue;
                    }
                    cell.setCellValue(0.0);
                }
            }
            AreaReference areaReference = new AreaReference(new CellReference("A1"), new CellReference(String.valueOf((char)(65 + maxCol - 1)) + (maxRow + 1)), null);
            List relations = sheetAt.getRelations();
            relations.forEach(relation -> {
                if (relation instanceof XSSFTable) {
                    ((XSSFTable)relation).setArea(areaReference);
                }
            });
            List chartSeries = chart.getChartSeries();
            for (XDDFChartData chartData : chartSeries) {
                for (int i = 0; i < chartData.getSeriesCount(); ++i) {
                    XDDFChartData.Series series = chartData.getSeries(i);
                    int rowIndex = TrainReportUtils.getCellRowIndex(series.getCategoryData().getFormula());
                    XDDFCategoryDataSource categories = XDDFDataSourcesFactory.fromStringCellRange((XSSFSheet)sheetAt, (CellRangeAddress)new CellRangeAddress(1, maxRow, rowIndex, rowIndex));
                    rowIndex = TrainReportUtils.getCellRowIndex(series.getValuesData().getFormula());
                    XDDFNumericalDataSource dataSource = XDDFDataSourcesFactory.fromNumericCellRange((XSSFSheet)sheetAt, (CellRangeAddress)new CellRangeAddress(1, maxRow, rowIndex, rowIndex));
                    if (percentIndex.contains(rowIndex)) {
                        dataSource.setFormatCode("0%");
                    }
                    series.replaceData((XDDFDataSource)categories, dataSource);
                }
                chart.plot(chartData);
            }
        }
    }

    private static int getCellRowIndex(String formula) {
        String[] split = formula.split("\\$");
        if (split.length < 2) {
            return -1;
        }
        return split[1].charAt(0) - 65;
    }
}

