/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;

public abstract class AbstractProgressFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String KEY_PROGRESSBAR = "progressbarap";
    private boolean canClose = false;

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.startBar();
        String taskId = this.getTaskId();
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 90;
            }
            ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
            bar.setPercent(progress);
            this.showDetails(taskInfo);
        }
    }

    public void onProgress(ProgressEvent e) {
        String taskId = this.getTaskId();
        boolean start = this.isStart();
        this.setStart();
        if (!start && StringUtils.isBlank((CharSequence)taskId)) {
            this.dispatchTask();
            return;
        }
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (taskInfo.isTaskEnd()) {
            this.complete(taskInfo, e);
        } else {
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 90;
            }
            e.setProgress(progress);
            this.showDetails(taskInfo);
        }
    }

    public abstract void showDetails(TaskInfo var1);

    public void complete(TaskInfo taskInfo, ProgressEvent e) {
        boolean isFinished = this.isFinished();
        this.setFinished();
        if (!isFinished) {
            e.setProgress(99);
            this.showDetails(taskInfo);
            return;
        }
        this.showComplete(taskInfo, e);
    }

    public abstract void showComplete(TaskInfo var1, ProgressEvent var2);

    private JobFormInfo getJobFormInfo() {
        String str = this.getView().getFormShowParameter().getCustomParams().containsKey("ricc_jobforminfo") ? (String)this.getView().getFormShowParameter().getCustomParam("ricc_jobforminfo") : this.getPageCache().get("ricc_jobforminfo");
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return (JobFormInfo)SerializationUtils.fromJsonString((String)str, JobFormInfo.class);
    }

    private void putJobFormInfo(JobFormInfo jobFormInfo) {
        if (jobFormInfo == null) {
            this.getPageCache().remove("ricc_jobforminfo");
        } else {
            String str = SerializationUtils.toJsonString((Object)jobFormInfo);
            this.getPageCache().put("ricc_jobforminfo", str);
        }
    }

    public abstract JobFormInfo buildJobFormInfo();

    public boolean isSuspending() {
        String suspending = this.getPageCache().get(this.getCurrentAppCacheKey());
        if (StringUtils.isBlank((CharSequence)suspending)) {
            return false;
        }
        return Boolean.parseBoolean(suspending);
    }

    public String getTaskId() {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("ricc_taskid")) {
            return (String)this.getView().getFormShowParameter().getCustomParam("ricc_taskid");
        }
        return this.getPageCache().get("ricc_taskid");
    }

    private void putTaskId(String taskId) {
        this.getPageCache().put("ricc_taskid", taskId);
    }

    public boolean isStart() {
        String start = this.getPageCache().get("isstart");
        return !StringUtils.isBlank((CharSequence)start) && Boolean.parseBoolean(start);
    }

    public void setStart() {
        this.getPageCache().put("isstart", String.valueOf(true));
    }

    public boolean isFinished() {
        String finished = this.getPageCache().get("isfinished");
        if (StringUtils.isBlank((CharSequence)finished)) {
            return false;
        }
        return Boolean.parseBoolean(finished);
    }

    public void setFinished() {
        this.getPageCache().put("isfinished", String.valueOf(true));
    }

    public void registerListener(EventObject e) {
        ProgressBar progressbar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
        progressbar.addProgressListener((ProgresssListener)this);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (!this.isStart() || this.isSuspending()) {
            e.setCancel(true);
            return;
        }
        if (this.isCanClose() || this.isFinished()) {
            this.notifyBeforeClosed(this.getView());
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getTaskId())) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u628a\u5f53\u524d\u4efb\u52a1\u8f6c\u4e3a\u540e\u53f0\u6267\u884c\uff1f\u8f6c\u4e3a\u540e\u53f0\u6267\u884c\u540e\uff0c\u53ef\u4ee5\u518d\u6b21\u901a\u8fc7\u53f3\u4e0b\u89d2\u7684\u540e\u53f0\u8fd0\u884c\u8fdb\u5ea6\u7403\u518d\u6b21\u6253\u5f00\u3002%s", (String)"AbstractProgressFormPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]), this.getExtCloseConfirmMsg()), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("CLOSE_CONFIRMED", (IFormPlugin)this));
            this.stopBar();
            e.setCancel(true);
        }
    }

    public String getExtCloseConfirmMsg() {
        return ResManager.loadKDString((String)"\u5982\u53f3\u4e0b\u89d2\u6ca1\u6709\u51fa\u73b0\u8fdb\u5ea6\u7403\uff0c\u53ef\u524d\u5f80\u3010\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u3011->\u3010\u76d1\u63a7\u7edf\u8ba1\u3011->\u3010\u4f20\u8f93\u5305\u65e5\u5fd7\u7ba1\u7406\u3011\u70b9\u51fb\u7f16\u53f7\u8d85\u94fe\u63a5\u67e5\u770b\u3002", (String)"AbstractProgressFormPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]);
    }

    public void notifyBeforeClosed(IFormView view) {
    }

    public void confirmCallBack(MessageBoxClosedEvent messageboxclosedevent) {
        super.confirmCallBack(messageboxclosedevent);
        if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
            this.toBackground();
        } else {
            ProgressBar bar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
            bar.start();
        }
    }

    private void startBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.start();
    }

    public void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.stop();
    }

    private void closeForm() {
        this.setCanClose(true);
        TaskClientProxy.setProgressPageId((String)this.getTaskId(), (String)"");
        this.getView().close();
    }

    private void dispatchTask() {
        JobFormInfo jobFormInfo = this.buildJobFormInfo();
        if (jobFormInfo == null) {
            return;
        }
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        this.putTaskId(taskId);
        this.putJobFormInfo(jobFormInfo);
    }

    public IAppCache getCurrentAppCache() {
        return AppCache.get((String)EntityMetadataCache.getDataEntityType((String)"ricc_datapacket").getAppId());
    }

    public String getCurrentAppCacheKey() {
        return this.getTaskName() + "_SUSPEND_" + "ricc_datapacket";
    }

    private void toBackground() {
        JobFormInfo jobFormInfo;
        this.closeForm();
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (!TaskClientProxy.isExistTask((String)taskId) && (jobFormInfo = this.getJobFormInfo()) != null) {
            TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)Objects.requireNonNull(jobFormInfo), (TaskInfo)taskInfo);
            BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
            ThreadPools.executeOnce((String)(this.getTaskName() + "-background-monitor"), (Runnable)subscriber);
        }
    }

    public void modifyControlName(String controlKey, String newName) {
        HashMap controlMap = new HashMap(2);
        HashMap<String, String> controlNameMap = new HashMap<String, String>(2);
        controlNameMap.put(Lang.get().toString(), newName);
        controlMap.put("text", controlNameMap);
        this.getView().updateControlMetadata(controlKey, controlMap);
    }

    public boolean isCanClose() {
        return this.canClose;
    }

    public void setCanClose(boolean canClose) {
        this.canClose = canClose;
    }

    public String getTaskName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

