/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.batchdatacompare.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sys.ricc.api.IRiccObtainDataService;
import kd.sys.ricc.business.configitem.ConfigItemHelper;
import kd.sys.ricc.business.datapacket.core.ISubDataPacket;
import kd.sys.ricc.business.datapacket.core.SubDataPacketDispatch;
import kd.sys.ricc.business.datapacket.helper.DataPacketHelper;
import kd.sys.ricc.business.schedule.AbstractSerailTask;
import kd.sys.ricc.common.enums.CompareDataResultEnum;
import kd.sys.ricc.common.enums.CompareStatusEnum;
import kd.sys.ricc.common.enums.DataPacketTypeEnum;
import kd.sys.ricc.common.enums.RiccObtainDataServiceEnum;
import kd.sys.ricc.common.helper.DataCompareHelper;
import kd.sys.ricc.common.util.ApiUtil;
import kd.sys.ricc.common.util.BatchSplitUtil;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.DynamicObjectUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.SysParaUtil;
import kd.sys.ricc.common.util.TimeCostUtil;
import kd.sys.ricc.common.util.TransferUtil;
import kd.sys.ricc.exception.RiccBizException;
import kd.sys.ricc.formplugin.batchdatacompare.model.CompareConfigRowModel;
import kd.sys.ricc.formplugin.batchdatacompare.model.CompareInfoRowModel;

public class BatchDataCompareTask
extends AbstractSerailTask {
    private static final Log logger = LogFactory.getLog(BatchDataCompareTask.class);
    private Tuple<String, String> itemEntityInfo;
    private MainEntityType entityType;
    private int batchCount;
    private Map<String, Object> loginParams;
    private boolean isIgnoreCreateInfo;
    private boolean isIgnoreKey;
    private boolean isIgnoreBdId;
    private boolean isIgnoreMultilingual;
    private long dataCompareRptId;
    private DynamicObject dataCompareRpt;
    private int curDataCount = 0;
    private int targetDataCount = 0;
    private String compareType;
    private DynamicObject dataPacket;
    private String tarCenterType;
    private List<Map<String, Object>> entryData = new ArrayList<Map<String, Object>>(10);
    private Map<Long, DynamicObject> itemIpMapping;
    private Map<String, Tuple<String, String>> entityInfoMapping = new HashMap<String, Tuple<String, String>>(2);
    private String keyFields;
    private String keyFieldShow;
    private Set<IDataEntityProperty> uniqueKeyProps = new HashSet<IDataEntityProperty>(4);
    private long itemId;
    private int seq = 1;
    private DynamicObjectCollection compareInfoRowList = new DynamicObjectCollection();
    private DynamicObjectCollection compareConfigRowModelList = new DynamicObjectCollection();
    private String compareStatus = CompareDataResultEnum.NO_DIFFERENCE.getVal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void realExecute(RequestContext requestContext, Map<String, Object> paramsMap) {
        long startTime = System.currentTimeMillis();
        String status = CompareStatusEnum.NO_START.getVal();
        try {
            this.initTaskParam(paramsMap);
            this.initUpdateProgress(this.entryData.size(), startTime, this.taskId, RequestContext.get().getTraceId());
            for (Map<String, Object> planRowData : this.entryData) {
                DynamicObject configItem = (DynamicObject)planRowData.get("configItem");
                this.itemId = configItem.getLong("id");
                String itemNumber = configItem.getString("number");
                logger.info(String.format("\u7b2c%d\u884c\u5f00\u59cb\u5bf9\u6bd4, \u914d\u7f6e\u9879\u7f16\u7801\u4e3a%s", this.seq, itemNumber));
                this.itemEntityInfo = this.entityInfoMapping.get(itemNumber);
                this.entityType = EntityMetadataCache.getDataEntityType((String)((String)this.itemEntityInfo.item1));
                DataEntityPropertyCollection properties = this.entityType.getProperties();
                Map<String, Object> compareRequiresPropMap = DataCompareHelper.getCompareRequiresPropMap(properties);
                String importType = configItem.getString("importtype");
                String exportPlugin = SubDataPacketDispatch.getPluginByImportType(DataPacketTypeEnum.CONFIG.getVal(), configItem);
                this.keyFields = (String)planRowData.get("keyFields");
                this.keyFieldShow = (String)planRowData.get("keyfieldshow");
                HashSet<String> keyFieldsSet = new HashSet<String>(Arrays.asList(this.keyFields.trim().replaceFirst(",", "").split(",")));
                this.uniqueKeyProps.clear();
                for (IDataEntityProperty property : properties) {
                    for (String keyField : keyFieldsSet) {
                        if (!property.getName().equals(keyField)) continue;
                        this.uniqueKeyProps.add(property);
                    }
                }
                HashMap<String, Object> param = new HashMap<String, Object>(2);
                if (StringUtils.equals((String)this.compareType, (String)"item")) {
                    QFilter filter = (QFilter)planRowData.get("filter");
                    List pksList = QueryServiceHelper.queryPrimaryKeys((String)((String)this.itemEntityInfo.item1), (QFilter[])filter.toArray(), null, (int)-1);
                    switch (importType) {
                        case "excel": 
                        case "json": {
                            this.generalItemCompare(compareRequiresPropMap, exportPlugin, param, pksList);
                            break;
                        }
                        case "custom": 
                        case "microService": {
                            this.customItemCompare(configItem, exportPlugin, param, pksList);
                            break;
                        }
                    }
                } else {
                    this.dataPacketCompare(planRowData, configItem, exportPlugin, param);
                }
                this.curDataCount = 0;
                this.targetDataCount = 0;
                ++this.seq;
            }
            status = CompareStatusEnum.FINISHED.getVal();
            this.dataCompareRpt.set("ricc_plandata_entry", (Object)this.compareConfigRowModelList);
            this.dataCompareRpt.set("ricc_datacompare_entry", (Object)this.compareInfoRowList);
            SaveServiceHelper.saveOperate((String)"ricc_datacompare_rpt", (DynamicObject[])new DynamicObject[]{this.dataCompareRpt}, (OperateOption)OperateOption.create());
        }
        catch (Exception e) {
            String errorMessage = BatchDataCompareTask.subErrorMessage(e);
            String tagErrorMessage = e.getMessage() + CommonUtil.getExceptionDetailInfo((Throwable)e);
            logger.error("\u6570\u636e\u5bf9\u6bd4\u65e5\u5fd7", (Throwable)e);
            status = CompareStatusEnum.UNUSUAL_STOP.getVal();
            long endTime = System.currentTimeMillis();
            String consumeTime = TimeCostUtil.getUsedTime((long)startTime, (long)endTime);
            this.errorUpdateProgress(errorMessage, tagErrorMessage, endTime, consumeTime);
        }
        finally {
            long endTime = System.currentTimeMillis();
            String consumeTime = TimeCostUtil.getUsedTime((long)startTime, (long)endTime);
            this.completeUpdateProgress(endTime, consumeTime, status);
        }
    }

    private void dataPacketCompare(Map<String, Object> planRowData, DynamicObject configItem, String exportPlugin, Map<String, Object> param) {
        String fileUrl = (String)planRowData.get("fileurl");
        this.customCompareData(configItem, exportPlugin, param, fileUrl);
    }

    private void customCompareData(DynamicObject configItem, String exportPlugin, Map<String, Object> param, String fileUrl) {
        HashMap<String, Object> parseDataParam = new HashMap<String, Object>(2);
        parseDataParam.put("itemId", configItem.getLong("id"));
        parseDataParam.put("fileUrl", fileUrl);
        Map<String, Object> returnDataMap = this.executeParseDataPackageData(parseDataParam, exportPlugin);
        if (returnDataMap != null && returnDataMap.containsKey("selectDatas") && returnDataMap.get("selectDatas") != null) {
            List sourceData = (List)returnDataMap.get("selectDatas");
            logger.info("\u81ea\u5b9a\u4e49\u914d\u7f6e\u9879\u7b2c{}\u884c\u89e3\u6790\u51fa\u7684\u6570\u91cf\u4e3a\uff1a{}", (Object)sourceData.size());
            List splitsData = BatchSplitUtil.splitBatch((List)sourceData, (int)this.batchCount);
            logger.info("\u81ea\u5b9a\u4e49\u914d\u7f6e\u9879\u7b2c{}\u884c\u5171{}\u53d6\u6570\u6279\u6b21\uff0c\u6bcf\u6279\u6b21{}\u6761\u6570\u636e", new Object[]{this.seq, splitsData.size(), this.batchCount});
            ArrayList<Map<String, Object>> apiData = new ArrayList<Map<String, Object>>(sourceData.size());
            this.keyFields = (String)returnDataMap.get("keyFields");
            int i = 1;
            for (List dataMap : splitsData) {
                Map<String, Object> oneBatchApiData;
                logger.info("\u81ea\u5b9a\u4e49\u914d\u7f6e\u9879\u7b2c{}\u884c\u7b2c{}\u6279\u6b21\u53d6\u6570\u5f00\u59cb", (Object)this.seq, (Object)i++);
                QFilter keyFieldFilter = BatchDataCompareTask.getCurDataFilter(dataMap, this.keyFields);
                param.put("itemEntityNumber", configItem.get("formid"));
                param.put("filter", keyFieldFilter.toSerializedString());
                if (StringUtils.equals((String)this.tarCenterType, (String)"tar")) {
                    oneBatchApiData = this.getApiData(param);
                } else {
                    IRiccObtainDataService service = RiccObtainDataServiceEnum.getServiceByType("compareGetData");
                    CustomApiResult<Object> customApiResult = service.obtainData(param);
                    oneBatchApiData = BatchDataCompareTask.toMap(customApiResult);
                }
                if (oneBatchApiData == null) continue;
                boolean success = (Boolean)oneBatchApiData.get("status");
                if (success) {
                    String data = (String)oneBatchApiData.get("data");
                    List apiDataList = (List)JSON.parseObject((String)data, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
                    apiData.addAll(apiDataList);
                    continue;
                }
                throw new RiccBizException((String)oneBatchApiData.get("message"));
            }
            this.executeCompare(exportPlugin, sourceData, apiData);
        }
    }

    private void generalItemCompare(Map<String, Object> compareRequiresPropMap, String exportPlugin, Map<String, Object> param, List<Object> pks) {
        DynamicObject[] currentDyo = BusinessDataServiceHelper.load((Object[])pks.toArray(), (DynamicObjectType)this.entityType);
        List<Map<String, Object>> sourceData = Arrays.stream(currentDyo).map(dyo -> DynamicObjectUtil.object2Map((DynamicObject)dyo, (Map)compareRequiresPropMap)).collect(Collectors.toList());
        List splitsData = BatchSplitUtil.splitBatch(Arrays.asList(currentDyo), (int)this.batchCount);
        logger.info("\u7b2c{}\u884c\u5171{}\u53d6\u6570\u6279\u6b21\uff0c\u6bcf\u6279\u6b21{}\u6761\u6570\u636e", new Object[]{this.seq, splitsData.size(), this.batchCount});
        ArrayList<Map<String, Object>> tarData = new ArrayList<Map<String, Object>>(sourceData.size());
        int i = 1;
        for (List oneBatchData : splitsData) {
            logger.info("\u7b2c{}\u884c\u7b2c{}\u53d6\u6570\u6279\u6b21\u5f00\u59cb", (Object)this.seq, (Object)i++);
            QFilter keyFieldFilter = this.getKeyFieldFilter(oneBatchData);
            param.put("filter", keyFieldFilter == null ? "" : keyFieldFilter.toSerializedString());
            param.put("itemEntityNumber", this.itemEntityInfo.item1);
            Map<String, Object> oneBatchApiData = this.getApiData(param);
            if (oneBatchApiData == null) continue;
            boolean success = (Boolean)oneBatchApiData.get("status");
            if (success) {
                String apiData = (String)oneBatchApiData.get("data");
                List apiDataList = (List)JSON.parseObject((String)apiData, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
                tarData.addAll(apiDataList);
                continue;
            }
            throw new RiccBizException((String)oneBatchApiData.get("message"));
        }
        this.executeCompare(exportPlugin, sourceData, tarData);
    }

    private void customItemCompare(DynamicObject configItem, String exportPlugin, Map<String, Object> param, List<Object> pksList) {
        String realUrl;
        ListSelectedRowCollection selectedRows = new ListSelectedRowCollection();
        for (Object pks : pksList) {
            ListSelectedRow selectedRow = new ListSelectedRow();
            selectedRow.setPrimaryKeyValue(pks);
            selectedRows.add((Object)selectedRow);
        }
        String exportFilePath = DataPacketHelper.getMicroExportUrl(exportPlugin, selectedRows, (String)this.itemEntityInfo.item1, (String)this.itemEntityInfo.item2, configItem);
        FileService fs = FileServiceFactory.getAttachmentFileService();
        String uploadPath = SysParaUtil.getSavePath() + configItem.get("number");
        try (FileInputStream fileInputStream = new FileInputStream(exportFilePath);){
            FileItem fi = new FileItem(configItem.getString("number"), uploadPath, (InputStream)fileInputStream);
            realUrl = fs.upload(fi);
        }
        catch (Exception e) {
            throw new RiccBizException((Throwable)e);
        }
        this.customCompareData(configItem, exportPlugin, param, realUrl);
    }

    private Map<String, Object> executeParseDataPackageData(Map<String, Object> param, String exportPlugin) {
        ISubDataPacket service = (ISubDataPacket)TypesContainer.getOrRegisterSingletonInstance((String)exportPlugin);
        Map<String, Object> sourceData = null;
        Map<String, Object> result = service.parseUrlData(param);
        if (result != null) {
            boolean success = (Boolean)result.get("success");
            if (!success) {
                throw new RiccBizException((String)result.get("errMessage"));
            }
            return (Map)result.get("data");
        }
        return sourceData;
    }

    private void initTaskParam(Map<String, Object> paramsMap) {
        long planId = (Long)paramsMap.get("planId");
        DynamicObject comparePlan = BusinessDataServiceHelper.loadSingle((Object)planId, (String)"ricc_datacompare_plan");
        this.dataCompareRptId = (Long)paramsMap.get("dataCompareRptId");
        this.dataCompareRpt = BusinessDataServiceHelper.loadSingle((Object)this.dataCompareRptId, (String)"ricc_datacompare_rpt");
        this.compareType = (String)paramsMap.get("compareType");
        this.batchCount = comparePlan.getInt("batchcount");
        this.tarCenterType = comparePlan.getString("tarcentertype");
        if (StringUtils.equals((String)this.tarCenterType, (String)"tar")) {
            long destAccountPk = (Long)((DynamicObject)comparePlan.get("targetdatacenter")).getPkValue();
            String targetCenterUser = comparePlan.getString("targetdatacenteruser");
            this.loginParams = TransferUtil.destAccountLoginParams((long)destAccountPk, (String)targetCenterUser);
        }
        this.isIgnoreBdId = comparePlan.getBoolean("isIgnoreBdId");
        this.isIgnoreCreateInfo = comparePlan.getBoolean("isIgnoreCreateInfo");
        this.isIgnoreKey = comparePlan.getBoolean("isIgnoreKey");
        this.isIgnoreMultilingual = comparePlan.getBoolean("isIgnoreMultilingual");
        DynamicObjectCollection comparePlanEntry = comparePlan.getDynamicObjectCollection("ricc_compare_entry");
        this.initItemsMapping(comparePlanEntry);
        HashMap<String, String> fileMap = new HashMap<String, String>(2);
        if (!StringUtils.equals((String)this.compareType, (String)"item")) {
            this.dataPacket = BusinessDataServiceHelper.loadSingle((Object)comparePlan.getDynamicObject("datapacket").getLong("id"), (String)"ricc_datapacket");
            DynamicObjectCollection subDataPacket = this.dataPacket.getDynamicObjectCollection("subdatapacket");
            int index = 1;
            for (DynamicObject subDataRow : subDataPacket) {
                DynamicObject packItem = subDataRow.getDynamicObject("bizobject");
                if (packItem != null) {
                    fileMap.put(packItem.getString("number") + index, DataPacketHelper.getFileUrl(subDataRow));
                }
                ++index;
            }
        }
        for (int i = 0; i < comparePlanEntry.size(); ++i) {
            DynamicObject rowData = (DynamicObject)comparePlanEntry.get(i);
            HashMap<String, Object> oneData = new HashMap<String, Object>(4);
            DynamicObject configItem = rowData.getDynamicObject("itemid");
            Integer packIndex = (Integer)rowData.get("packindex");
            String itemNumber = configItem.getString("number");
            oneData.put("configItem", this.itemIpMapping.get(configItem.getLong("id")));
            oneData.put("keyFields", rowData.getString("keyfieldsentry"));
            oneData.put("keyfieldshow", rowData.getString("keyfieldshow"));
            Tuple<String, String> oneItemEntityInfo = ConfigItemHelper.getEntityNumberAndName(configItem.getPkValue());
            if (oneItemEntityInfo == null) {
                return;
            }
            this.entityInfoMapping.put(itemNumber, oneItemEntityInfo);
            if (StringUtils.equals((String)this.compareType, (String)"item")) {
                String dataStore = rowData.getString("datastore_tag");
                String dataSelectWay = rowData.getString("dataselection");
                oneData.put("filter", DataCompareHelper.getEntryRowFilters((String)oneItemEntityInfo.item1, dataSelectWay, dataStore));
            } else {
                oneData.put("fileurl", fileMap.get(itemNumber + packIndex));
            }
            this.entryData.add(oneData);
        }
    }

    private void executeCompare(String exportPlugin, List<Map<String, Object>> sourceData, List<Map<String, Object>> apiData) {
        this.curDataCount = sourceData.size();
        this.targetDataCount = apiData.size();
        HashMap<String, Object> compareParam = new HashMap<String, Object>(4);
        compareParam.put("sourceData", sourceData);
        compareParam.put("tarData", apiData);
        compareParam.put("keyFields", this.keyFields);
        compareParam.put("entityNumber", this.itemEntityInfo.item1);
        compareParam.put("isIgnore", this.getIsIgnoreMap());
        ISubDataPacket service = (ISubDataPacket)TypesContainer.getOrRegisterSingletonInstance((String)exportPlugin);
        logger.info("\u7b2c{}\u884c\u6267\u884c\u5bf9\u6bd4\u5f00\u59cb", (Object)this.seq);
        Map<String, Object> result = service.compareData(compareParam);
        if (result != null) {
            boolean success = (Boolean)result.get("success");
            if (!success) {
                String errMessage = (String)result.get("errMessage");
                throw new RiccBizException(errMessage);
            }
        } else {
            String errMessage = ResManager.loadKDString((String)"\u8c03\u7528\u5bf9\u6bd4\u65b9\u6cd5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BatchDataCompareTask_0", (String)"sys-ricc-platform", (Object[])new Object[0]);
            throw new RiccBizException(errMessage);
        }
        List dataRow = (List)result.get("dataComPareResult");
        this.handleResult(dataRow);
    }

    private Map<String, Object> getIsIgnoreMap() {
        HashMap<String, Object> isIgnoreMap = new HashMap<String, Object>(4);
        isIgnoreMap.put("isIgnoreBdId", this.isIgnoreBdId);
        isIgnoreMap.put("isIgnoreCreateInfo", this.isIgnoreCreateInfo);
        isIgnoreMap.put("isIgnoreKey", this.isIgnoreKey);
        isIgnoreMap.put("isIgnoreMultilingual", this.isIgnoreMultilingual);
        return isIgnoreMap;
    }

    private Map<String, Object> getApiData(Map<String, Object> param) {
        String tarCenterData = ApiUtil.getDestAccountMetaLogData(param, this.loginParams, (String)"compareGetData");
        return (Map)JSON.parseObject((String)tarCenterData, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
    }

    private void handleResult(List<Map<String, Object>> compareRowDataList) {
        int differentCount = 0;
        int ignoreCount = 0;
        String configResult = CompareDataResultEnum.NO_DIFFERENCE.getVal();
        for (int i = 0; i < compareRowDataList.size(); ++i) {
            String compareInfoResult;
            Map<String, Object> oneRowData = compareRowDataList.get(i);
            List dataRelList = (List)oneRowData.get("dataRelList");
            String dataRelStr = "";
            if (dataRelList != null && !dataRelList.isEmpty()) {
                dataRelStr = JSON.toJSONString((Object)dataRelList);
            }
            List dataDetailList = (List)oneRowData.get("dataDetailList");
            String dataDetailStr = "";
            if (dataDetailList != null && !dataDetailList.isEmpty()) {
                dataDetailStr = JSON.toJSONString((Object)dataDetailList);
            }
            Map curDataMap = (Map)oneRowData.get("curDataMap");
            String curId = String.valueOf(curDataMap.get("id"));
            String curNumber = (String)curDataMap.get("number");
            String curName = (String)curDataMap.get("name");
            String tarId = "";
            String tarNumber = "";
            String tarName = "";
            if (oneRowData.containsKey("tarDataMap") && oneRowData.get("tarDataMap") != null) {
                Map tarDataMap = (Map)oneRowData.get("tarDataMap");
                tarId = String.valueOf(tarDataMap.get("id"));
                tarNumber = String.valueOf(tarDataMap.get("number"));
                tarName = String.valueOf(tarDataMap.get("name"));
            }
            if (StringUtils.equals((String)(compareInfoResult = (String)oneRowData.get("compareResult")), (String)CompareDataResultEnum.DIFFERENCE.getVal())) {
                ++differentCount;
            } else if (StringUtils.equals((String)compareInfoResult, (String)CompareDataResultEnum.IGNORE.getVal())) {
                compareInfoResult = CompareDataResultEnum.NO_DIFFERENCE.getVal();
                ++ignoreCount;
            }
            if (compareInfoResult.equals(CompareDataResultEnum.DIFFERENCE.getVal()) && configResult.equals(CompareDataResultEnum.NO_DIFFERENCE.getVal())) {
                configResult = CompareDataResultEnum.DIFFERENCE.getVal();
            }
            if (configResult.equals(CompareDataResultEnum.DIFFERENCE.getVal()) && this.compareStatus.equals(CompareDataResultEnum.NO_DIFFERENCE.getVal())) {
                this.compareStatus = CompareDataResultEnum.DIFFERENCE.getVal();
            }
            String diffExplain = (String)oneRowData.get("diffExplain");
            CompareInfoRowModel compareInfoRow = new CompareInfoRowModel(i, this.itemId, curId, curNumber, curName, tarId, tarNumber, tarName, compareInfoResult, diffExplain, dataDetailStr, dataRelStr);
            this.compareInfoRowList.add((Object)compareInfoRow.toDyO());
        }
        CompareConfigRowModel configRow = new CompareConfigRowModel(this.seq, this.itemId, this.keyFieldShow, configResult, this.curDataCount, this.targetDataCount, differentCount, ignoreCount);
        this.compareConfigRowModelList.add((Object)configRow.toDyo());
    }

    private static String subErrorMessage(Exception e) {
        String errorMessage = e.getMessage();
        if (StringUtils.isEmpty((String)errorMessage)) {
            return "";
        }
        int maxSize = 160;
        if (errorMessage.length() > maxSize) {
            errorMessage = errorMessage.substring(0, maxSize);
        }
        return errorMessage;
    }

    private void initItemsMapping(DynamicObjectCollection comparePlanEntry) {
        List idList = comparePlanEntry.stream().map(entryRow -> entryRow.getDynamicObject("itemid")).filter(Objects::nonNull).map(item -> item.getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection queryData = QueryServiceHelper.query((String)"ricc_configitems", (String)"id,number,name,page.number as formid,page.modeltype modeltype,pagetype, custompage, page.bizappid as bizappid, page.basedatafield.number as entityid,supportpreview,supportaddtopacket,custparampage,importtype,plugin,relylevel,importtemplateid,pageenterparam,dataimporttype,keyfields,isoverrideEntry,sortfield,sortway, istransferattach, attachmentfield", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
        this.itemIpMapping = queryData.stream().collect(Collectors.toMap(y -> y.getLong("id"), Function.identity(), (existing, replacement) -> existing));
    }

    private void initUpdateProgress(int allDataCount, long startTime, String taskId, String traceId) {
        String progressDesc = String.format("%d/%d", 0, allDataCount);
        String updateSql = "UPDATE T_RICC_DATACOMPARE_RPT SET FCOMPAREPROGRESS = ?, FSTARTTIME = ?, FTASKID = ?, FTRACEID = ? WHERE FID = ?";
        ArrayList<SqlParameter> paraList = new ArrayList<SqlParameter>(6);
        paraList.add(new SqlParameter(":FPROGRESS", 12, (Object)progressDesc));
        paraList.add(new SqlParameter(":FSTARTTIME", 91, (Object)new Date(startTime)));
        paraList.add(new SqlParameter(":FTASKID", 12, (Object)taskId));
        paraList.add(new SqlParameter(":FTRACEID", 12, (Object)traceId));
        paraList.add(new SqlParameter(":FID", -5, (Object)this.dataCompareRptId));
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)updateSql, (Object[])paraList.toArray(new SqlParameter[5]));
    }

    private void errorUpdateProgress(String displayErrorMessage, String tagErrorMessage, long errorEndTime, String consumeTime) {
        String updateSql = "UPDATE T_RICC_DATACOMPARE_RPT SET FERRORMESSAGE = ?, FERRORMESSAGE_TAG = ?, FENDTIME = ?, FCOMPARETIME = ?, FCOMPARESTATUS = ? WHERE FID = ?";
        ArrayList<SqlParameter> paraList = new ArrayList<SqlParameter>(6);
        paraList.add(new SqlParameter(":FERRORMESSAGE", -9, (Object)displayErrorMessage));
        paraList.add(new SqlParameter(":FERRORMESSAGE_TAG", -9, (Object)tagErrorMessage));
        paraList.add(new SqlParameter(":FENDTIME", 91, (Object)new Date(errorEndTime)));
        paraList.add(new SqlParameter(":FCOMPARETIME", -9, (Object)consumeTime));
        paraList.add(new SqlParameter(":FCOMPARESTATUS", 12, (Object)CompareStatusEnum.UNUSUAL_STOP.getVal()));
        paraList.add(new SqlParameter(":FID", -5, (Object)this.dataCompareRptId));
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)updateSql, (Object[])paraList.toArray(new SqlParameter[6]));
    }

    private void completeUpdateProgress(long endTime, String consumeTime, String status) {
        String updateSql = "UPDATE T_RICC_DATACOMPARE_RPT SET FCOMPAREPROGRESS = ?, FCOMPARESTATUS = ?, FENDTIME = ?, FCOMPARETIME = ?, FCOMPARERESULT = ? WHERE FID = ?";
        ArrayList<SqlParameter> paraList = new ArrayList<SqlParameter>(10);
        paraList.add(new SqlParameter(":FCOMPAREPROGRESS", 12, (Object)String.format("%d/%d", this.entryData.size(), this.entryData.size())));
        paraList.add(new SqlParameter(":FCOMPARESTATUS", -9, (Object)status));
        paraList.add(new SqlParameter(":FENDTIME", 91, (Object)new Date(endTime)));
        paraList.add(new SqlParameter(":FCOMPARETIME", -9, (Object)consumeTime));
        paraList.add(new SqlParameter(":FCOMPARERESULT", 12, (Object)this.compareStatus));
        paraList.add(new SqlParameter(":FID", -5, (Object)this.dataCompareRptId));
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)updateSql, (Object[])paraList.toArray(new SqlParameter[6]));
    }

    private QFilter getKeyFieldFilter(List<DynamicObject> currentData) {
        QFilter filter = null;
        for (IDataEntityProperty prop : this.uniqueKeyProps) {
            HashSet<Object> valueSet = new HashSet<Object>(4);
            String name = prop.getName();
            for (DynamicObject dy : currentData) {
                Object keyFieldsValue = this.getKeyFieldsValue(prop, dy);
                valueSet.add(keyFieldsValue);
            }
            if (prop instanceof BasedataProp) {
                name = prop.getName() + ".id";
            }
            if (filter == null) {
                filter = new QFilter(name, "in", valueSet);
                continue;
            }
            filter.and(new QFilter(name, "in", valueSet));
        }
        return filter;
    }

    private Object getKeyFieldsValue(IDataEntityProperty prop, DynamicObject srcData) {
        String name = prop.getName();
        Object keyFieldsValue = prop instanceof MuliLangTextProp ? srcData.getString(name) : (prop instanceof BasedataProp ? ((DynamicObject)srcData.get(name)).get("id") : srcData.get(name));
        return keyFieldsValue;
    }

    private static QFilter getCurDataFilter(List<Map<String, Object>> data, String keyFields) {
        String[] split;
        QFilter filter = new QFilter("1", "!=", (Object)-1);
        for (String key : split = keyFields.split(",")) {
            if (StringUtils.isBlank((CharSequence)key)) continue;
            HashSet<Object> valueSet = new HashSet<Object>(4);
            for (Map<String, Object> oneData : data) {
                if (StringUtils.equals((String)"createorg", (String)key)) {
                    valueSet.add(oneData.get(key + "_" + "id"));
                    continue;
                }
                valueSet.add(oneData.get(key));
            }
            filter.and(new QFilter(key, "in", valueSet));
        }
        return filter;
    }

    public static Map<String, Object> toMap(CustomApiResult<Object> customApiResult) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", customApiResult.isStatus());
        map.put("message", customApiResult.getMessage());
        map.put("data", customApiResult.getData());
        return map;
    }
}

