/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.check;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.cache.AppCache;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.sys.ricc.business.configitem.check.ConfigCheckTask;
import kd.sys.ricc.business.schedule.ScheduleUtil;
import kd.sys.ricc.common.util.StringUtils;

public class ConfigCheckBillFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log logger = LogFactory.getLog(ConfigCheckBillFormPlugin.class);
    private static final String EXCUTE = "excute";
    private static final String CLEARDATA = "cleardata";
    private static final String TERMINATE = "terminate";
    private static final String PROGRESSDESC = "progressdesc";
    private static final String PRO_GRESS_BAR = "progressbarap";
    private static final String CHECKITEM_ENTRY = "checkitem_entry";
    private static final int FIVE_MINUTES = 300000;
    private static final String REFRESH = "refresh";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        ProgressBar progressbar = (ProgressBar)this.getControl(PRO_GRESS_BAR);
        progressbar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        String taskStatus;
        super.afterBindData(e);
        String taskId = (String)this.getModel().getValue("taskid");
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        ProgressBar bar = (ProgressBar)this.getView().getControl(PRO_GRESS_BAR);
        switch (taskStatus = (String)this.getModel().getValue("taskstatus")) {
            case "wait": {
                this.getView().setVisible(Boolean.FALSE, new String[]{PRO_GRESS_BAR, PROGRESSDESC});
                this.getView().setEnable(Boolean.FALSE, new String[]{TERMINATE, CLEARDATA});
                break;
            }
            case "running": {
                bar.start();
                bar.setPercent(taskInfo.getProgress());
                this.lockFormData();
                this.getView().setEnable(Boolean.FALSE, new String[]{EXCUTE, CLEARDATA});
                this.getView().setEnable(Boolean.TRUE, new String[]{TERMINATE});
                this.getView().setVisible(Boolean.TRUE, new String[]{PRO_GRESS_BAR, PROGRESSDESC});
                break;
            }
            case "complete": 
            case "suspend": 
            case "error": {
                this.lockFormData();
                bar.stop();
                bar.setPercent(taskInfo.getProgress());
                this.getView().setEnable(Boolean.FALSE, new String[]{EXCUTE, TERMINATE});
                this.getView().setEnable(Boolean.TRUE, new String[]{CLEARDATA});
                this.getView().setVisible(Boolean.TRUE, new String[]{PRO_GRESS_BAR, PROGRESSDESC});
                break;
            }
        }
    }

    private void lockFormData() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"billno", "name", "checkconfigs", CHECKITEM_ENTRY, "newentry", "deleteentry", "moveentryup", "moveentrydown"});
    }

    public void onProgress(ProgressEvent progressEvent) {
        TaskInfo initTask;
        String taskId = (String)this.getModel().getValue("taskid");
        ProgressBar bar = (ProgressBar)this.getView().getControl(PRO_GRESS_BAR);
        if (StringUtils.isNotEmpty((String)taskId) && (initTask = ScheduleServiceHelper.queryTask((String)taskId)) != null) {
            String taskStatus = initTask.getStatus();
            if (StringUtils.equals((String)"SCHEDULED", (String)taskStatus)) {
                boolean isTimeOut;
                long dispatchTime = initTask.getDispachTime();
                boolean bl = isTimeOut = System.currentTimeMillis() - dispatchTime > 300000L;
                if (isTimeOut) {
                    this.setSuspend();
                    bar.stop();
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u957f\u65f6\u95f4\u7b49\u5f85\u540e\u4ecd\u5904\u4e8e\u8ba1\u5212\u72b6\u6001\u800c\u672a\u5f00\u59cb\u6267\u884c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u8c03\u5ea6\u670d\u52a1\u662f\u5426\u6b63\u5e38\u8fd0\u8f6c\u3002", (String)"ConfigCheckBillFormPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    progressEvent.setProgress(0);
                }
            } else if (initTask.isTaskEnd()) {
                bar.stop();
                progressEvent.setProgress(initTask.getProgress());
                this.getView().invokeOperation(REFRESH);
            } else {
                progressEvent.setProgress(initTask.getProgress());
                this.getView().invokeOperation(REFRESH);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean success;
        super.beforeDoOperation(args);
        String opKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if (StringUtils.equals((String)opKey, (String)EXCUTE) && !(success = this.validateBeforeExecute())) {
            args.setCancel(true);
            return;
        }
    }

    private boolean validateBeforeExecute() {
        long pk = (Long)this.getModel().getDataEntity().getPkValue();
        if (pk == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u4efb\u52a1\u5355\u636e", (String)"ConfigCheckBillFormPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection checkItemEntrys = this.getModel().getEntryEntity(CHECKITEM_ENTRY);
        if (!checkItemEntrys.isEmpty()) {
            String packCheckItemNum = "data_packet_check";
            String syncCheckItemNum = "data_sync_check";
            boolean hasPack = false;
            for (DynamicObject checkItemEntry : checkItemEntrys) {
                DynamicObject checkItem = checkItemEntry.getDynamicObject("task_checkitems");
                if (checkItem == null || (hasPack = hasPack || packCheckItemNum.equals(checkItem.getString("number"))) || !syncCheckItemNum.equals(checkItem.getString("number"))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u68c0\u67e5\u9879\u4e2d\uff0c\u540c\u6b65\u73af\u8282\u4e4b\u524d\u5fc5\u987b\u5b58\u5728\u6253\u5305\u73af\u8282\uff0c\u8bf7\u8c03\u6574\u68c0\u67e5\u9879\u540e\u518d\u8bd5\u3002", (String)"ConfigCheckBillFormPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        if (StringUtils.equals((String)opKey, (String)TERMINATE)) {
            if (args.getOperationResult().isSuccess()) {
                this.setSuspend();
            }
        } else if (StringUtils.equals((String)opKey, (String)EXCUTE)) {
            if (args.getOperationResult().isSuccess()) {
                this.executeCheckTask();
            }
        } else if (StringUtils.equals((String)opKey, (String)CLEARDATA) && args.getOperationResult().isSuccess()) {
            this.clearTestData();
        }
    }

    private void clearTestData() {
        String taskNo = (String)this.getModel().getValue("billno");
        QFilter filter = new QFilter("name", "like", (Object)(taskNo + "%"));
        List packetIds = QueryServiceHelper.queryPrimaryKeys((String)"ricc_datapacket", (QFilter[])filter.toArray(), null, (int)-1);
        if (packetIds.isEmpty()) {
            return;
        }
        logger.info(String.format("\u68c0\u67e5\u4efb\u52a1\u53f7\uff1a%1$s, \u672c\u6b21\u51c6\u5907\u6e05\u7a7a\u7684\u4f20\u8f93\u5305id\uff1a[%2$s]", taskNo, packetIds));
        try (TXHandle handle = TX.requiresNew();){
            try {
                DeleteServiceHelper.delete((String)"ricc_log", (QFilter[])new QFilter("packet.id", "in", (Object)packetIds).toArray());
                DeleteServiceHelper.delete((String)"ricc_datapacket", (QFilter[])new QFilter("id", "in", (Object)packetIds).toArray());
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                handle.markRollback();
                throw e;
            }
        }
    }

    private void executeCheckTask() {
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("checkbillid", this.getModel().getDataEntity().getPkValue());
        String jobName = ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u68c0\u67e5\u4efb\u52a1", (String)"ConfigCheckBillFormPlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]);
        JobFormInfo jobFormInfo = ScheduleUtil.buildJobFormInfo(jobName, ConfigCheckTask.class.getName(), "", this.getView(), param);
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        Object pk = this.getModel().getDataEntity().getPkValue();
        DynamicObject taskBill = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"ricc_config_checktask");
        taskBill.set("taskid", (Object)taskId);
        taskBill.set("taskstatus", (Object)"running");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskBill});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u68c0\u67e5\u4efb\u52a1\u5f00\u59cb\u6267\u884c\uff0c\u8bf7\u70b9\u51fb\u5237\u65b0\u6309\u94ae\u67e5\u770b\u8fdb\u5ea6\u3002", (String)"ConfigCheckBillFormPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
        ProgressBar bar = (ProgressBar)this.getView().getControl(PRO_GRESS_BAR);
        bar.start();
        this.getView().setEnable(Boolean.FALSE, new String[]{CHECKITEM_ENTRY, "moveentryup", "moveentrydown", EXCUTE, CLEARDATA});
        this.getView().invokeOperation(REFRESH);
    }

    private void setSuspend() {
        String suspendKey = "ITEMCHECK_SUSPEND_" + this.getModel().getDataEntity().getPkValue();
        AppCache.get((String)"ricc").put(suspendKey, (Object)"true");
        this.getModel().setValue("taskstatus", (Object)"suspend");
    }
}

