/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.datacompare;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class RelationDataComparePlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static List<Map<String, Object>> dataRelList;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null || !customParams.containsKey("relevancyData")) {
            return;
        }
        Object obj = customParams.get("relevancyData");
        if (obj == null) {
            return;
        }
        this.buildDataEntity(obj);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setTabAndColumnName();
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        entryGrid.selectRows(new int[]{0}, 0);
        this.buildSubEntry(0);
    }

    private void setTabAndColumnName() {
        String compareType = (String)this.getView().getFormShowParameter().getCustomParam("compareType");
        String curName = StringUtils.equals((String)compareType, (String)"item") ? ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3", (String)"RelationDataComparePlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f20\u8f93\u5305", (String)"RelationDataComparePlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]);
        EntryGrid gridData = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        gridData.setColumnProperty("srcentryfieldgroupap", "header", (Object)new LocaleString(curName));
        EntryGrid gridDetail = (EntryGrid)this.getControl("subentryentity");
        String value = String.format(ResManager.loadKDString((String)"%s\u503c", (String)"RelationDataComparePlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]), curName);
        gridDetail.setColumnProperty("srcvalue", "header", (Object)new LocaleString(value));
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((String)KEY_ENTRYENTITY, (String)entryGrid.getKey())) {
            int focusRow = entryGrid.getEntryState().getFocusRow();
            this.buildSubEntry(focusRow);
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((String)KEY_ENTRYENTITY, (String)entryGrid.getKey())) {
            int focusRow = entryGrid.getEntryState().getFocusRow();
            this.buildSubEntry(focusRow);
        }
    }

    private void buildDataEntity(Object obj) {
        Map relationDataMap = (Map)JSON.parseObject((String)obj.toString(), Map.class);
        this.getModel().setItemValueByNumber("configitem", (String)relationDataMap.get("configitem"));
        this.getModel().setValue("datanumber", relationDataMap.get("datanumber"));
        this.getModel().setValue("dataname", relationDataMap.get("dataname"));
        this.getModel().setValue("id", relationDataMap.get("id"));
        if (relationDataMap.containsKey("dataRelList")) {
            dataRelList = (List)relationDataMap.get("dataRelList");
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter setter = new TableValueSetter(new String[0]);
            int row = 0;
            for (Map<String, Object> data : dataRelList) {
                setter.set("relationtype", data.get("dataClassify"), row);
                setter.set("relationtype", data.get("dataClassify"), row);
                setter.set("relationtypenum", data.get("entityNum"), row);
                setter.set("hasdiff", data.get("relDiff"), row);
                setter.set("diffdetail", data.get("relDiffExplain"), row);
                if (data.containsKey("curDataMap") && data.get("curDataMap") != null) {
                    Map curDataMap = (Map)data.get("curDataMap");
                    setter.set("srcid", curDataMap.get("id"), row);
                    setter.set("srcnumber", curDataMap.get("number"), row);
                    setter.set("srcname", curDataMap.get("name"), row);
                }
                if (data.containsKey("tarDataMap") && data.get("tarDataMap") != null) {
                    Map tarDataMap = (Map)data.get("tarDataMap");
                    setter.set("tarid", tarDataMap.get("id"), row);
                    setter.set("tarnumber", tarDataMap.get("number"), row);
                    setter.set("tarname", tarDataMap.get("name"), row);
                }
                ++row;
            }
            model.batchCreateNewEntryRow(KEY_ENTRYENTITY, setter);
            model.endInit();
        }
    }

    private void buildSubEntry(int focusRow) {
        if (CollectionUtils.isNotEmpty(dataRelList)) {
            Map<String, Object> data = dataRelList.get(focusRow);
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            this.buildSubEntryData(data, model);
            model.endInit();
        }
    }

    private void buildSubEntryData(Map<String, Object> data, AbstractFormDataModel model) {
        if (data.containsKey("relDataDetailList") && data.get("relDataDetailList") != null) {
            TableValueSetter setter = new TableValueSetter(new String[0]);
            List relationDetails = (List)data.get("relDataDetailList");
            int subEntryRow = 0;
            for (Map relationDetail : relationDetails) {
                setter.set("fieldname", relationDetail.get("fieldName"), subEntryRow);
                setter.set("fieldnumber", relationDetail.get("fieldKey"), subEntryRow);
                setter.set("srcvalue", relationDetail.get("curValue"), subEntryRow);
                setter.set("tarvalue", relationDetail.get("tarValue"), subEntryRow);
                setter.set("difftype", relationDetail.get("diffType"), subEntryRow);
                ++subEntryRow;
            }
            model.batchCreateNewEntryRow("subentryentity", setter);
            this.getView().updateView("subentryentity");
        }
    }
}

