/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.datasummary;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sys.ricc.business.configitem.ConfigItemHelper;
import kd.sys.ricc.business.datasummary.DataSummaryHelper;
import kd.sys.ricc.business.schedule.TaskSerailHelper;
import kd.sys.ricc.common.util.StringUtils;

public class DataSummaryListPlugin
extends AbstractListPlugin {
    private static final String BACK_UPDATE_OP = "backupdate";
    private static final String SHOW_LOG_OP = "showlog";
    private static final String BACK_UPDATE_ACTION_ID = "back_update_action_id";

    public void afterCreateNewData(EventObject e) {
        this.showLastUpdateTimeTips();
    }

    private void showLastUpdateTimeTips() {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"ricc_datasummary", (String)"updatetime", null, (String)"updatetime desc", (int)1);
        if (query.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tips"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"tips"});
            Label tips = (Label)this.getControl("tips");
            Date lastUpdateTime = ((DynamicObject)query.get(0)).getDate("updatetime");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dateFormat = sdf.format(lastUpdateTime);
            tips.setText(String.format(ResManager.loadKDString((String)"\u6700\u540e\u66f4\u65b0\u65f6\u95f4\uff1a%s", (String)"DataSummaryListPlugin_5", (String)"sys-ricc-platform", (Object[])new Object[0]), dateFormat));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("refresh".equals(operateKey)) {
            this.showLastUpdateTimeTips();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        if (StringUtils.equals((String)BACK_UPDATE_OP, (String)key)) {
            if (TaskSerailHelper.taskExist("ricc_data_summary_task")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540e\u53f0\u914d\u7f6e\u6570\u636e\u7edf\u8ba1\u66f4\u65b0\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u70b9\u51fb\u67e5\u770b\u65e5\u5fd7\u67e5\u770b\u5177\u4f53\u6267\u884c\u60c5\u51b5\u3002", (String)"DataSummaryListPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return;
            }
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(BACK_UPDATE_ACTION_ID, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u5c06\u91cd\u65b0\u66f4\u65b0\u6240\u6709\u57fa\u7840\u914d\u7f6e\u9879\u7684\u6570\u636e\u603b\u6570\uff0c\u786e\u8ba4\u6267\u884c\uff1f", (String)"DataSummaryListPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
        } else if (StringUtils.equals((String)SHOW_LOG_OP, (String)key)) {
            this.showTaskLogDetail();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes && callBackId.equals(BACK_UPDATE_ACTION_ID)) {
            DataSummaryHelper.executeSchedulePlan();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u65e5\u5fd7\u83b7\u53d6\u6267\u884c\u72b6\u6001\u6216\u8005\u5237\u65b0\u9875\u9762\u83b7\u53d6\u6267\u884c\u7ed3\u679c\u3002", (String)"DataSummaryListPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
    }

    private void showTaskLogDetail() {
        DynamicObject schedulePlan = DataSummaryHelper.getDataSummarySchedulePlan();
        String schedulePlanId = schedulePlan.getString("id");
        String planName = schedulePlan.getString("name");
        String planDesc = "";
        DynamicObjectCollection scheduleJobEntry = schedulePlan.getDynamicObjectCollection("entryentity");
        DynamicObject scheduleJob = (DynamicObject)scheduleJobEntry.get(0);
        String scheduleJobId = scheduleJob.getString("jobnumber.id");
        String scheduleJobNumber = scheduleJob.getString("jobnumber.number");
        String scheduleJobName = scheduleJob.getString("jobnumber.name");
        String pageId = this.getView().getPageId() + "_" + scheduleJobId + "_" + scheduleJobNumber;
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("sch_tasklog_details");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCaption(ResManager.loadKDString((String)"\u8fd0\u884c\u65e5\u5fd7\u8be6\u60c5", (String)"DataSummaryListPlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
        showParameter.setCustomParam("number", (Object)scheduleJobId);
        showParameter.setCustomParam("jobNumber", (Object)scheduleJobNumber);
        showParameter.setCustomParam("jobName", (Object)scheduleJobName);
        showParameter.setCustomParam("rule", (Object)planDesc);
        showParameter.setCustomParam("scheduleId", (Object)schedulePlanId);
        showParameter.setCustomParam("planName", (Object)planName);
        showParameter.setPageId(pageId);
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String clickField = args.getFieldName();
        args.setCancel(true);
        Object selectedId = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo().getPrimaryKeyValue();
        if ("count".equals(clickField)) {
            DynamicObject dataSummary = BusinessDataServiceHelper.loadSingle((Object)selectedId, (String)"ricc_datasummary");
            String configNumber = dataSummary.getString("number");
            QFilter qFilter = new QFilter("number", "=", (Object)configNumber);
            DynamicObject configItem = BusinessDataServiceHelper.loadSingle((String)"ricc_configitems", (QFilter[])qFilter.toArray());
            if (configItem == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4e2d\u627e\u4e0d\u5230\u52fe\u9009\u7684\u6570\u636e\uff0c\u6709\u53ef\u80fd\u5df2\u88ab\u522b\u4eba\u5220\u9664\uff0c\u8bf7\u70b9\u51fb \u201d\u540e\u53f0\u66f4\u65b0\u201c \u66f4\u65b0\u6570\u636e\u3002", (String)"DataSummaryListPlugin_6", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return;
            }
            ConfigItemHelper.openConfigForm(configItem, this.getView(), false);
        }
    }
}

