/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.schemeconfig;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.url.UrlService;
import kd.sys.ricc.business.schedule.ScheduleUtil;
import kd.sys.ricc.business.schemeconfig.IscInitActionHelper;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.PermissionUtil;
import kd.sys.ricc.common.util.ShowParameterUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.SysParaUtil;
import kd.sys.ricc.exception.RiccBizException;

public class SynSchemeConfigFormPlugin
extends AbstractBillPlugIn
implements ProgresssListener,
HyperLinkClickListener {
    private static final Log log = LogFactory.getLog(SynSchemeConfigFormPlugin.class);
    private static final String RESTORE_FACTORY_CALLBACK = "bdcenter_restore_factory_setting";
    private static final String OP_CLEARDATA = "cleardata";
    private static final String OP_START_INIT = "begininit";
    private static final String OP_RESET_SETTING = "resetsetting";
    private static final String REFRESH = "refresh";
    private static final String BAR_BEGIN_INIT = "bar_begin_init";
    private static final String BAR_RESET_SETTING = "bar_reset_setting";
    private static final String CURRENT_TYPE = "currenttype";
    private static final String IERP_PROXY_USER = "ierpproxyuser";
    private static final String CONNECTION = "connectionenv";
    private static final String USER = "user";
    private static final String MAIN_TASK_STATUS = "init_status";
    private static final String CURRENT_SYS_URL = "current_sys_url";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String PRO_GRESS_BAR = "progressbar";
    private static final String HANDLEPAGE = "handlepage";
    private static final String LAB_NOT_START = "notstart";
    private static final String LAB_EXECUTING = "executing";
    private static final String LAB_SUCCESS = "success";
    private static final String LAB_FAIL = "fail";
    private static final String IMPLEDETAILS_TAG = "impledetails_tag";
    private static final String INITTASK_ID = "inittaskid";
    private static final String TASK_STATUS = "taskStatus";
    private static final int FIVE_MINUTES = 300000;
    private static final String RICC_BASEDATA_ITEM = "ricc_basedata_item";
    private static final String RICC_CONFIG_ITEMS = "ricc_configitems";
    private static final String STARTTIME = "starttime";
    private static final String ENDTIME = "endtime";
    private static final String USEDTIMES = "usedtimes";
    private static final String PROGRESS = "progress";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        PermissionUtil.preOpenFormIsAdmin((PreOpenFormEventArgs)e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        ProgressBar progressbar = (ProgressBar)this.getControl(PRO_GRESS_BAR);
        progressbar.addProgressListener((ProgresssListener)this);
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        grid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl(PRO_GRESS_BAR);
        int initStatus = Integer.parseInt((String)this.getModel().getValue(MAIN_TASK_STATUS));
        if (initStatus == 2) {
            bar.start();
            this.updateStatusLabel(LAB_EXECUTING);
            this.getView().setVisible(Boolean.TRUE, new String[]{PRO_GRESS_BAR});
            this.setFormControlEnable(false);
        } else if (initStatus == 1) {
            this.updateStatusLabel(LAB_NOT_START);
            this.setFormControlEnable(true);
        } else if (initStatus == 3) {
            this.updateStatusLabel(LAB_SUCCESS);
            this.getView().setEnable(Boolean.TRUE, new String[]{BAR_RESET_SETTING});
            this.getView().setVisible(Boolean.FALSE, new String[]{PRO_GRESS_BAR});
            this.getView().setEnable(Boolean.FALSE, new String[]{BAR_BEGIN_INIT, CURRENT_TYPE, IERP_PROXY_USER, CONNECTION, USER, CURRENT_SYS_URL});
        } else {
            this.updateStatusLabel(LAB_FAIL);
            this.getView().setVisible(Boolean.TRUE, new String[]{PRO_GRESS_BAR});
            bar.setPercent(this.getSuccessBar());
            this.setFormControlEnable(true);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.setCurrentSystemUrl();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        boolean exists = QueryServiceHelper.exists((String)"ricc_schemeconfig", (Object)1384008697021203456L);
        if (!exists) {
            this.initSchemeConfig();
        }
        this.getView().setStatus(OperationStatus.EDIT);
        this.getView().setVisible(Boolean.FALSE, new String[]{PRO_GRESS_BAR});
        BillView view = (BillView)this.getView();
        view.load((Object)1384008697021203456L);
        this.setCurrentSystemUrl();
    }

    private void setCurrentSystemUrl() {
        try {
            String curUrl = (String)this.getModel().getValue(CURRENT_SYS_URL);
            if (StringUtils.isEmpty((String)curUrl)) {
                String defaultUrl = UrlService.getDomainContextUrl().replace("localhost", InetAddress.getLocalHost().getHostAddress());
                this.getModel().setValue(CURRENT_SYS_URL, (Object)defaultUrl);
            }
        }
        catch (UnknownHostException exception) {
            log.warn("ricc.DeployUrlConfirmForm.\u83b7\u53d6\u672c\u5730ip\u5730\u5740\u51fa\u73b0\u5f02\u5e38: " + CommonUtil.getExceptionDetailInfo((Throwable)exception));
        }
    }

    private void initSchemeConfig() {
        DynamicObject config = BusinessDataServiceHelper.newDynamicObject((String)"ricc_schemeconfig");
        config.set(MAIN_TASK_STATUS, (Object)1);
        config.set("id", (Object)1384008697021203456L);
        config.set(ENTRY_ENTITY, IscInitActionHelper.createSubTaskEntries());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{config});
        this.getView().setVisible(Boolean.FALSE, new String[]{PRO_GRESS_BAR});
    }

    public void onProgress(ProgressEvent progressEvent) {
        int initStatus = Integer.parseInt((String)this.getModel().getValue(MAIN_TASK_STATUS));
        String initTaskId = (String)this.getModel().getValue(INITTASK_ID);
        TaskInfo initTask = ScheduleServiceHelper.queryTask((String)initTaskId);
        switch (initStatus) {
            case 1: {
                this.getView().setVisible(Boolean.FALSE, new String[]{PRO_GRESS_BAR});
                if (!StringUtils.isEmpty((String)initTaskId)) {
                    boolean isTimeOut;
                    long dispatchTime = initTask.getDispachTime();
                    boolean isScheduled = StringUtils.equals((String)initTask.getStatus(), (String)"SCHEDULED");
                    boolean bl = isTimeOut = System.currentTimeMillis() - dispatchTime > 300000L;
                    if (isScheduled && isTimeOut) {
                        this.handleScheduleSystemError();
                        this.startOrStopBar(false);
                    }
                }
                progressEvent.setProgress(0);
                this.getView().invokeOperation(REFRESH);
                break;
            }
            case 2: {
                if (initTask.isFailure()) {
                    this.handleErrorTaskStatus(initTask.getFailureReason());
                    this.startOrStopBar(false);
                }
                progressEvent.setProgress(this.getSuccessBar());
                this.getView().invokeOperation(REFRESH);
                break;
            }
            case 3: {
                this.getView().setVisible(Boolean.FALSE, new String[]{PRO_GRESS_BAR});
                this.startOrStopBar(false);
                break;
            }
            case 4: {
                this.startOrStopBar(false);
                progressEvent.setProgress(this.getSuccessBar());
                break;
            }
        }
    }

    private int getSuccessBar() {
        DynamicObjectCollection subTasks = this.getModel().getEntryEntity(ENTRY_ENTITY);
        int progress = 0;
        for (DynamicObject subTask : subTasks) {
            int taskProgress = (Integer)subTask.get(PROGRESS);
            progress += taskProgress;
        }
        return progress;
    }

    private void handleScheduleSystemError() {
        DynamicObject config = BusinessDataServiceHelper.loadSingle((Object)1384008697021203456L, (String)"ricc_schemeconfig");
        DynamicObjectCollection subTasks = config.getDynamicObjectCollection(ENTRY_ENTITY);
        config.set(MAIN_TASK_STATUS, (Object)4);
        ((DynamicObject)subTasks.get(0)).set(TASK_STATUS, (Object)4);
        ((DynamicObject)subTasks.get(0)).set(IMPLEDETAILS_TAG, (Object)ResManager.loadKDString((String)"\u4efb\u52a1\u957f\u65f6\u95f4\u7b49\u5f85\u540e\u4ecd\u5904\u4e8e\u8ba1\u5212\u72b6\u6001\u800c\u672a\u5f00\u59cb\u6267\u884c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u8c03\u5ea6\u670d\u52a1\u662f\u5426\u6b63\u5e38\u8fd0\u8f6c\u3002", (String)"SynSchemeConfigFormPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{config});
    }

    private void handleErrorTaskStatus(String error) {
        DynamicObject config = BusinessDataServiceHelper.loadSingle((Object)1384008697021203456L, (String)"ricc_schemeconfig");
        DynamicObjectCollection subTasks = config.getDynamicObjectCollection(ENTRY_ENTITY);
        boolean isSubTaskStarted = false;
        String failureReason = String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u53d1\u751f\u5f02\u5e38\uff0c\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5 \u3002%s", (String)"SynSchemeConfigFormPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]), error);
        for (DynamicObject subTask : subTasks) {
            if (Integer.parseInt((String)subTask.get(TASK_STATUS)) != 2) continue;
            subTask.set(TASK_STATUS, (Object)4);
            subTask.set(IMPLEDETAILS_TAG, (Object)failureReason);
            isSubTaskStarted = true;
            break;
        }
        if (!isSubTaskStarted) {
            ((DynamicObject)subTasks.get(0)).set(TASK_STATUS, (Object)4);
            ((DynamicObject)subTasks.get(0)).set(IMPLEDETAILS_TAG, (Object)failureReason);
        }
        config.set(MAIN_TASK_STATUS, (Object)4);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{config});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String url;
        super.beforeDoOperation(args);
        String opKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if (StringUtils.equals((String)opKey, (String)OP_CLEARDATA)) {
            if (!PermissionServiceHelper.isAdminUser((long)UserServiceHelper.getCurrentUserId())) {
                args.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u4f7f\u7528\u7ba1\u7406\u5458\u529f\u80fd\u3002", (String)"SynSchemeConfigFormPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            try {
                this.restoreFactorySettingConfirm();
            }
            catch (RiccBizException e) {
                log.error("ricc_clearbddata_error: " + CommonUtil.getExceptionDetailInfo((Throwable)e));
                args.setCancelMessage(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e05\u7406\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u8fdb\u884c\u5904\u7406\uff1a%s", (String)"SynSchemeConfigFormPlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]), CommonUtil.getExceptionDetailInfo((Throwable)e)));
                args.setCancel(true);
            }
        } else if (StringUtils.equals((String)opKey, (String)OP_START_INIT) && !StringUtils.isUrl((String)(url = (String)this.getModel().getValue(CURRENT_SYS_URL)))) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5730\u5740\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"SynSchemeConfigFormPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        if (StringUtils.equals((String)opKey, (String)OP_START_INIT)) {
            if (args.getOperationResult().isSuccess()) {
                args.getOperationResult().setShowMessage(false);
                this.getView().setVisible(Boolean.TRUE, new String[]{PRO_GRESS_BAR});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u4efb\u52a1\u5f00\u59cb\u6267\u884c", (String)"SynSchemeConfigFormPlugin_5", (String)"sys-ricc-platform", (Object[])new Object[0]));
                this.startOrStopBar(true);
                HashMap<String, Object> param = new HashMap<String, Object>(2);
                JobFormInfo jobFormInfo = ScheduleUtil.buildJobFormInfo(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u4efb\u52a1", (String)"SynSchemeConfigFormPlugin_6", (String)"sys-ricc-platform", (Object[])new Object[0]), "kd.sys.ricc.business.schemeconfig.IscInitTask", "", this.getView(), param);
                jobFormInfo.getJobInfo().setAppId("ricc");
                String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
                DynamicObject config = BusinessDataServiceHelper.loadSingle((Object)1384008697021203456L, (String)"ricc_schemeconfig");
                config.set(INITTASK_ID, (Object)taskId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{config});
                this.getView().invokeOperation(REFRESH);
            }
        } else if (StringUtils.equals((String)opKey, (String)OP_RESET_SETTING)) {
            this.startOrStopBar(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{PRO_GRESS_BAR});
            DynamicObject config = BusinessDataServiceHelper.loadSingle((Object)1384008697021203456L, (String)"ricc_schemeconfig");
            DynamicObjectCollection subTasks = config.getDynamicObjectCollection(ENTRY_ENTITY);
            config.set(MAIN_TASK_STATUS, (Object)1);
            for (DynamicObject subTask : subTasks) {
                subTask.set(TASK_STATUS, (Object)1);
                subTask.set(IMPLEDETAILS_TAG, (Object)"");
                subTask.set(STARTTIME, null);
                subTask.set(ENDTIME, null);
                subTask.set(USEDTIMES, null);
                subTask.set(PROGRESS, (Object)0);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{config});
            boolean success = SysParaUtil.iscLinkDelete();
            if (success) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u7f6e\u8bbe\u7f6e\u6210\u529f", (String)"SynSchemeConfigFormPlugin_7", (String)"sys-ricc-platform", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u91cd\u7f6e\u8bbe\u7f6e\u6210\u529f,\u76f8\u5173\u8054\u7684\u96c6\u6210\u8fde\u63a5\u672a\u6210\u529f\u5220\u9664\u3002", (String)"SynSchemeConfigFormPlugin_8", (String)"sys-ricc-platform", (Object[])new Object[0]));
            }
            this.getView().invokeOperation(REFRESH);
        }
    }

    private void startOrStopBar(boolean action) {
        ProgressBar bar = (ProgressBar)this.getView().getControl(PRO_GRESS_BAR);
        if (action) {
            bar.start();
        } else {
            bar.stop();
        }
    }

    private void setFormControlEnable(boolean enable) {
        this.getView().setEnable(Boolean.valueOf(enable), new String[]{BAR_BEGIN_INIT, BAR_RESET_SETTING, CURRENT_TYPE, IERP_PROXY_USER, CONNECTION, USER, CURRENT_SYS_URL});
    }

    private void restoreFactorySettingConfirm() {
        String msg = ResManager.loadKDString((String)"\u6062\u590d\u51fa\u5382\u8bbe\u7f6e\u540e\u4f1a\u6e05\u9664\u4ee5\u4e0b\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u64cd\u4f5c?", (String)"SynSchemeConfigFormPlugin_9", (String)"sys-ricc-platform", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"1.\u96c6\u6210\u540c\u6b65\u65b9\u6848\u914d\u7f6e\u4fe1\u606f\uff1b", (String)"SynSchemeConfigFormPlugin_13", (String)"sys-ricc-platform", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"2.\u96c6\u6210\u540c\u6b65\u65e5\u5fd7\u6570\u636e\uff1b", (String)"SynSchemeConfigFormPlugin_14", (String)"sys-ricc-platform", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"3.\u57fa\u7840\u914d\u7f6e\u4e2d\u5fc3\u914d\u7f6e\u9879\u7684\u96c6\u6210\u65b9\u6848\u5217\u8868\u4fe1\u606f\uff1b", (String)"SynSchemeConfigFormPlugin_15", (String)"sys-ricc-platform", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"4.\u96c6\u6210\u670d\u52a1\u8fde\u63a5\u914d\u7f6e\u3002", (String)"SynSchemeConfigFormPlugin_16", (String)"sys-ricc-platform", (Object[])new Object[0]);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        ConfirmTypes confirmTypes = ConfirmTypes.Delete;
        ConfirmCallBackListener callBack = new ConfirmCallBackListener(RESTORE_FACTORY_CALLBACK, (IFormPlugin)this);
        this.getView().showConfirm(msg, detail, options, confirmTypes, callBack);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult messageboxResult;
        super.confirmCallBack(messageBoxClosedEvent);
        if (RESTORE_FACTORY_CALLBACK.equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)(messageboxResult = messageBoxClosedEvent.getResult()))) {
            this.delete();
            String parentPageId = this.getView().getFormShowParameter().getParentPageId();
            IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
            if (parentView == null) {
                parentView = this.getView().getMainView();
            }
            if (parentView != null) {
                parentView.showSuccessNotification(ResManager.loadKDString((String)"\u6062\u590d\u51fa\u5382\u8bbe\u7f6e\u5b8c\u6210", (String)"SynSchemeConfigFormPlugin_11", (String)"sys-ricc-platform", (Object[])new Object[0]));
                this.getView().sendFormAction(parentView);
            }
            this.getView().close();
        }
    }

    private void delete() {
        try (TXHandle handler = TX.requiresNew();){
            log.info(String.format("1.ricc_clearbddata_\u540c\u6b65\u65b9\u6848\u914d\u7f6e_\u6210\u529f\u5220\u9664%d", DeleteServiceHelper.delete((String)"ricc_schemeconfig", null)));
            log.info(String.format("2.ricc_clearbddata_\u96c6\u6210\u540c\u6b65\u65e5\u5fd7\u7ba1\u7406_\u6210\u529f\u5220\u9664%d", DeleteServiceHelper.delete((String)"ricc_basedata_log", null)));
            log.info(String.format("3.ricc_clearbddata_\u57fa\u7840\u6570\u636e\u9879\u65b9\u6848_\u6210\u529f\u5220\u9664%d", this.deleteBdItemSchemeEntry()));
            log.info(String.format("4.ricc_clearbddata_\u57fa\u7840\u914d\u7f6e\u9879\u96c6\u6210\u65b9\u6848_\u6210\u529f\u5220\u9664%d", this.deleteBcItemSchemeEntry()));
            log.info(String.format("5.ricc_clearbddata_\u57fa\u7840\u6570\u636e\u540c\u6b65\u65e5\u5fd7_\u6210\u529f\u5220\u9664%d", DeleteServiceHelper.delete((String)"ricc_bdsync_log", null)));
        }
        boolean success = SysParaUtil.iscLinkDelete();
        log.info("6.ricc_clearbddata_\u96c6\u6210\u8fde\u63a5\u4e0e\u6570\u636e\u6e90_\u53bb\u6389\u5173\u8054%s", (Object)String.valueOf(success));
    }

    private int deleteBdItemSchemeEntry() {
        DynamicObject[] bdItems;
        Object[] pks = QueryServiceHelper.queryPrimaryKeys((String)RICC_BASEDATA_ITEM, null, null, (int)-1).toArray();
        for (DynamicObject bdItem : bdItems = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)RICC_BASEDATA_ITEM))) {
            DynamicObjectCollection schemeEntry = bdItem.getDynamicObjectCollection("ricc_schemeentry");
            schemeEntry.clear();
        }
        return SaveServiceHelper.save((DynamicObject[])bdItems).length;
    }

    private int deleteBcItemSchemeEntry() {
        DynamicObject[] bdItems;
        Object[] pks = QueryServiceHelper.queryPrimaryKeys((String)RICC_CONFIG_ITEMS, null, null, (int)-1).toArray();
        for (DynamicObject bdItem : bdItems = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)RICC_CONFIG_ITEMS))) {
            DynamicObjectCollection schemeEntry = bdItem.getDynamicObjectCollection("ricc_schemeentry");
            schemeEntry.clear();
        }
        return SaveServiceHelper.save((DynamicObject[])bdItems).length;
    }

    private void updateStatusLabel(String lab) {
        this.getView().setVisible(Boolean.FALSE, new String[]{LAB_NOT_START, LAB_EXECUTING, LAB_SUCCESS, LAB_FAIL});
        this.getView().setVisible(Boolean.TRUE, new String[]{lab});
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        IDataModel entryOperate = this.getModel();
        if (HANDLEPAGE.equals(e.getFieldName())) {
            String formTemplateId;
            String formId;
            int rowIndex = e.getRowIndex();
            DynamicObject entry = entryOperate.getEntryRowEntity(ENTRY_ENTITY, rowIndex);
            long entryPk = (Long)entry.getPkValue();
            if (entryPk == 0L) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5206\u5f55\u7684\u6570\u636e\u5f02\u5e38\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u5206\u5f55id\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u754c\u9762\u8bd5\u8bd5\u3002", (String)"SynSchemeConfigFormPlugin_12", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return;
            }
            if (entryPk == 1553603468705404928L) {
                String formId2 = "isc_data_copy";
                String formTemplateId2 = "isc_integration_schema";
                this.schemeCheck(formId2, formTemplateId2, 1);
                return;
            }
            if (entryPk == 1553603468705404929L) {
                String formId3 = "isc_data_copy_trigger";
                String formTemplateId3 = "isc_trigger_schema";
                this.schemeCheck(formId3, formTemplateId3, 2);
                return;
            }
            if (entryPk == 1553603468705404930L) {
                String formId4 = "isc_service_flow";
                String formTemplateId4 = "isc_service_flow_tree";
                this.schemeCheck(formId4, formTemplateId4, 3);
                return;
            }
            if (entryPk == 1553603468705404931L) {
                formId = RICC_BASEDATA_ITEM;
                formTemplateId = "bos_templatetreelist";
            } else if (entryPk == 1553603468705404935L) {
                formId = RICC_CONFIG_ITEMS;
                formTemplateId = "ricc_templatetreelist";
            } else {
                formId = "isc_database_link";
                formTemplateId = "bos_list";
            }
            String parentPageId = ShowParameterUtil.getParentPageId((IFormView)this.getView());
            ListShowParameter showParam = ShowParameterUtil.listShowParameter((String)formId, (String)formTemplateId, (ShowType)ShowType.MainNewTabPage, null, null, null, null);
            showParam.setParentPageId(parentPageId);
            this.getView().showForm((FormShowParameter)showParam);
        }
    }

    private void schemeCheck(String formId, String templateId, int iscType) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("number", "like", (Object)"RICC%"));
        ListShowParameter listShowParameter = ShowParameterUtil.listShowParameter((String)formId, (String)templateId, (ShowType)ShowType.MainNewTabPage, null, filters, null, (String)"");
        listShowParameter.setCustomParam("isc_type", (Object)iscType);
        listShowParameter.addCustPlugin("kd.bos.ext.imsc.ricc.form.listext.TriggerSchemaTreeExtPlugin");
        String parentPageId = ShowParameterUtil.getParentPageId((IFormView)this.getView());
        if (parentPageId == null) {
            listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        }
        listShowParameter.setParentPageId(parentPageId);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }
}

