/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.training;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.sys.ricc.business.training.TrainCommonMethod;
import kd.sys.ricc.business.training.TrainCourseUtils;

public class LearningRecordListPlugin
extends AbstractListPlugin
implements TrainCommonMethod {
    private static final Log log = LogFactory.getLog(LearningRecordListPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        TrainCourseUtils.updateRoleUserMap();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.showEntryPage();
    }

    private void showEntryPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ricc_progressentry");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("entrypanel");
        this.getView().showForm(showParameter);
        this.putCache("EntryPageId", showParameter.getPageId());
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                LearningRecordListPlugin.this.cacheQFilters(this.getQFilters());
                LearningRecordListPlugin.this.invokeEntryPageOp("refreshdata");
                return super.getData(start, limit);
            }
        });
    }

    private void cacheQFilters(List<QFilter> qFilters) {
        List qFilterJsonList = qFilters.stream().map(QFilter::toSerializedString).collect(Collectors.toList());
        this.putCache("EntryQFilter", qFilterJsonList);
    }

    private void invokeEntryPageOp(String operate) {
        String entryPageId = (String)this.getCache("EntryPageId", String.class);
        if (StringUtils.isEmpty((CharSequence)entryPageId)) {
            return;
        }
        IFormView view = this.getView().getView(entryPageId);
        if (view != null) {
            try {
                view.invokeOperation(operate);
                this.getView().sendFormAction(view);
            }
            catch (Exception ex) {
                log.error("LearningRecordListPlugin_invokeEntryPageOp", (Throwable)ex);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "learnnotify": {
                this.invokeEntryPageOp("notify");
                break;
            }
            case "learndetail": {
                this.invokeEntryPageOp("learndetail");
                break;
            }
            case "exportlist": {
                this.invokeEntryPageOp("exportentry");
                break;
            }
            case "createrpt": {
                this.showTrainReportPage();
                break;
            }
        }
    }

    @Override
    public Map<String, Supplier<String>> getExecMap() {
        return new HashMap<String, Supplier<String>>(16);
    }

    private void showTrainReportPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ricc_trainreportconfig");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }
}

