/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.training;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sys.ricc.business.training.CommonMethod;
import kd.sys.ricc.business.training.TrainCourseUtils;

public class TrainAssignUserDetailPlugin
extends AbstractFormPlugin
implements CommonMethod {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadDetailData();
    }

    private void loadDetailData() {
        Long assignId = (Long)this.getCustomFormParam("assignId");
        DynamicObject assign = BusinessDataServiceHelper.loadSingleFromCache((Object)assignId, (String)"ricc_courseassign", (String)"trainee, role");
        if (assign == null) {
            return;
        }
        DynamicObjectCollection trainees = assign.getDynamicObjectCollection("trainee");
        Set assignUserSet = trainees.stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toSet());
        DynamicObjectCollection roles = assign.getDynamicObjectCollection("role");
        List<String> roleIds = roles.stream().map(e -> e.getString("fbasedataid_id")).collect(Collectors.toList());
        Map<String, Set<Long>> roleUserMap = TrainCourseUtils.getRoleUserMap();
        HashMap assignRoleUserMap = new HashMap(16);
        roleIds.forEach(roleId -> {
            Set userIds = roleUserMap.getOrDefault(roleId, new HashSet(16));
            userIds.forEach(userId -> {
                List roleList = assignRoleUserMap.computeIfAbsent(userId, k -> new ArrayList(16));
                roleList.add(roleId);
            });
        });
        List userIds = new ArrayList(assignUserSet);
        userIds.addAll(assignRoleUserMap.keySet());
        userIds = userIds.stream().distinct().sorted(Comparator.comparingLong(Long::longValue)).collect(Collectors.toList());
        for (Long userId : userIds) {
            int newEntryRow = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("trainee", (Object)userId, newEntryRow);
            ArrayList<String> assignTypes = new ArrayList<String>(16);
            assignTypes.add("");
            if (assignUserSet.contains(userId)) {
                assignTypes.add("user");
            }
            if (assignRoleUserMap.containsKey(userId)) {
                assignTypes.add("role");
            }
            assignTypes.add("");
            this.getModel().setValue("assigntype", (Object)String.join((CharSequence)",", assignTypes), newEntryRow);
            List roleList = (List)assignRoleUserMap.get(userId);
            if (roleList == null || roleList.size() == 0) continue;
            this.getModel().setValue("role", (Object)roleList.toArray(), newEntryRow);
        }
    }
}

