/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.gcpmanage;

import com.alibaba.fastjson.JSON;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import kd.bos.ai.util.JsonUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.imsc.cc.business.gcpmanage.GcpModel;
import kd.imsc.cc.business.gcpmanage.TypeEnum;
import kd.imsc.cc.common.exception.KdXkIprmException;
import kd.imsc.cc.common.utils.OkHttpUtils;

public class GcpApiBuilder {
    private static Log logger = LogFactory.getLog(GcpApiBuilder.class);
    private static final String DEFAULT_CONNECTION_TIMEOUT = "c_t";
    private static final String DEFAULT_READ_TIMEOUT = "r_t";
    private Map<String, Object> param;
    private String accessToken;

    public GcpApiBuilder(Map<String, Object> param) {
        if (null == param || param.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5185\u5bb9\u5e73\u53f0\u53c2\u6570\u914d\u7f6e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GcpApiBuilder_0", (String)"imsc-cc", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)String.valueOf(param.getOrDefault("url", ""))) || StringUtils.isEmpty((String)String.valueOf(param.getOrDefault("appid", ""))) || StringUtils.isEmpty((String)String.valueOf(param.getOrDefault("userphone", "")))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5185\u5bb9\u5e73\u53f0\u53c2\u6570\u914d\u7f6e\u4e0d\u5b8c\u6574\u3002", (String)"GcpApiBuilder_1", (String)"imsc-cc", (Object[])new Object[0]));
        }
        this.param = param;
    }

    public String getBaseUrl() {
        String baseUrl = String.valueOf(this.param.getOrDefault("url", ""));
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        try {
            String configGcp = System.getProperty("gcp.ip");
            if (StringUtils.isNotEmpty((String)configGcp)) {
                URL url = new URL(baseUrl);
                String urlHost = url.getHost();
                baseUrl = baseUrl.replaceAll(urlHost, configGcp);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.info("gcp host {}", (Object)baseUrl);
        return baseUrl;
    }

    public String getFullUrl(TypeEnum type) throws Exception {
        return this.getFullUrl(type, "", true);
    }

    public String getFullUrl(TypeEnum type, String dynamicPath) throws Exception {
        return this.getFullUrl(type, dynamicPath, true);
    }

    private String getFullUrl(TypeEnum type, String dynamicPath, boolean isNeedToken) throws Exception {
        if (type == null) {
            return this.getBaseUrl();
        }
        String url = String.format("%s%s", this.getBaseUrl(), type.getPath());
        if (!StringUtils.isEmpty((String)dynamicPath)) {
            url = String.format("%s/%s", url, dynamicPath);
        }
        if (isNeedToken) {
            if (StringUtils.isEmpty((String)this.accessToken)) {
                this.accessToken = this.getAccessToken();
            }
            return String.format("%s?access_token=%s", url, this.accessToken);
        }
        return url;
    }

    public String getAccessToken() throws Exception {
        String appToken = this.getAppToken();
        return this.login(appToken);
    }

    private String getAppToken() throws Exception {
        Map resultData;
        Map resultMap;
        String baseUrl = this.getBaseUrl();
        String appId = String.valueOf(this.param.getOrDefault("appid", ""));
        String secret = String.valueOf(this.param.getOrDefault("secret", ""));
        String url = String.format("%s%s", baseUrl, TypeEnum.URL_APPTOKEN.getPath());
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        GcpModel.AppTokenParam param = new GcpModel.AppTokenParam();
        param.setAppId(appId);
        param.setAppSecuret(secret);
        logger.info("getAppToken|url:{}|header:{}|body:{}", new Object[]{url, JSON.toJSONString(header), JSON.toJSONString((Object)param)});
        long startTime = System.currentTimeMillis();
        String result = OkHttpUtils.postJsonRequest(url, header, JsonUtil.encodeToString((Object)param));
        logger.info("getAppToken\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - startTime));
        logger.info("result {}", (Object)result);
        if (!StringUtils.isEmpty((String)result) && null != (resultMap = (Map)SerializationUtils.fromJsonString((String)result, Map.class)) && !resultMap.isEmpty() && resultMap.get("data") != null && null != (resultData = (Map)resultMap.get("data")) && !resultData.isEmpty() && StringUtils.isNotEmpty((String)((String)resultData.get("app_token")))) {
            return (String)resultData.get("app_token");
        }
        throw new KdXkIprmException(ResManager.loadKDString((String)"token\u83b7\u53d6\u5f02\u5e38", (String)"GcpApiBuilder_2", (String)"imsc-cc", (Object[])new Object[0]), 5000);
    }

    private String login(String appToken) throws Exception {
        Map resultData;
        Map resultMap;
        String baseUrl = this.getBaseUrl();
        String user = String.valueOf(this.param.getOrDefault("userphone", ""));
        String url = String.format("%s%s", baseUrl, TypeEnum.URL_LOGIN.getPath());
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        GcpModel.LoginParam param = new GcpModel.LoginParam();
        param.setUser(user);
        param.setApptoken(appToken);
        logger.info("getAccessToken|url:{}|header:{}|body:{}", new Object[]{url, JSON.toJSONString(header), JSON.toJSONString((Object)param)});
        long startTime = System.currentTimeMillis();
        String result = OkHttpUtils.postJsonRequest(url, header, JsonUtil.encodeToString((Object)param));
        logger.info("getAccessToken\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - startTime));
        logger.info("result2 {}", (Object)result);
        if (!StringUtils.isEmpty((String)result) && null != (resultMap = (Map)SerializationUtils.fromJsonString((String)result, Map.class)) && !resultMap.isEmpty() && resultMap.get("data") != null && null != (resultData = (Map)resultMap.get("data")) && !resultData.isEmpty() && StringUtils.isNotEmpty((String)((String)resultData.get("access_token")))) {
            return (String)resultData.get("access_token");
        }
        throw new KdXkIprmException(ResManager.loadKDString((String)"token\u767b\u5f55\u5f02\u5e38", (String)"GcpApiBuilder_3", (String)"imsc-cc", (Object[])new Object[0]), 5000);
    }

    public int getConfigConnectTime() {
        return this.param.get(DEFAULT_CONNECTION_TIMEOUT) == null ? 3000 : (Integer)this.param.get(DEFAULT_CONNECTION_TIMEOUT);
    }

    public int getConfigReadTime() {
        return this.param.get(DEFAULT_READ_TIMEOUT) == null ? 10000 : (Integer)this.param.get(DEFAULT_READ_TIMEOUT);
    }
}

