/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.helper.installprogress;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.imsc.cc.business.install.IDataPackageInstallListener;
import kd.imsc.cc.business.proxy.DataPackageInstallerProxy;
import kd.imsc.cc.common.entity.DataPackageInputModel;
import kd.imsc.cc.common.entity.DataPackageModifyConfig;
import kd.imsc.cc.common.entity.DataPackageModifyResult;
import kd.imsc.cc.common.entity.InstallFailResult;
import kd.imsc.cc.common.entity.InstallFeedbackResult;
import kd.imsc.cc.common.entity.InstallFinishResult;
import kd.imsc.cc.common.entity.InstallSubDataResult;
import kd.imsc.cc.common.entity.SubDataInstallResult;

public class InstallProgressServiceTaskImpl
extends AbstractTask
implements IDataPackageInstallListener {
    private static final Log logger = LogFactory.getLog(InstallProgressServiceTaskImpl.class);
    private Map<String, DataPackageModifyResult> modifyResultMap;
    private InstallFeedbackResult installFeedbackResult;
    private final List<InstallSubDataResult> subInstallResult = new ArrayList<InstallSubDataResult>(8);

    public MessageHandler getMessageHandle() {
        return super.getMessageHandle();
    }

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        DataPackageInputModel model;
        this.installFeedbackResult = new InstallFeedbackResult();
        try {
            model = this.getModel(params);
            this.modifyResultMap = this.getReplaceData(params);
            this.installFeedbackResult.setTotalTaskNum(this.modifyResultMap.size());
        }
        catch (Exception e) {
            logger.error("\u52a0\u8f7d\u5185\u5bb9\u5305|\u89e3\u6790\u4efb\u52a1\u53c2\u6570\u5f02\u5e38|{}", (Object)JSON.toJSONString(params), (Object)e);
            this.installFeedbackResult.setErrMsg(ResManager.loadKDString((String)"\u89e3\u6790\u4efb\u52a1\u53c2\u6570\u5f02\u5e38", (String)"InstallProgressServiceTaskImpl_0", (String)"imsc-iprm-business", (Object[])new Object[0]));
            HashMap<String, String> installMap = new HashMap<String, String>(1);
            installMap.put("installFeedbackResult", JSON.toJSONString((Object)this.installFeedbackResult));
            this.feedbackCustomdata(installMap);
            return;
        }
        DataPackageInstallerProxy installerProxy = new DataPackageInstallerProxy(model, this, this.taskId);
        installerProxy.invokeDataPackageInstallStage();
        HashMap<String, String> installMap = new HashMap<String, String>(1);
        installMap.put("installFeedbackResult", JSON.toJSONString((Object)this.installFeedbackResult));
        this.feedbackCustomdata(installMap);
    }

    public DataPackageInputModel getModel(Map<String, Object> params) {
        Map modelMap = (Map)JSON.parseObject((String)((String)params.get("job_param_model")), Map.class);
        Map objInfoMap = (Map)modelMap.get("objInfoMap");
        return new DataPackageInputModel.Builder().id((String)modelMap.get("id")).name((String)modelMap.get("name")).ver((String)modelMap.get("ver")).type((String)modelMap.get("type")).resourceFileUrl((String)modelMap.get("resourceFileUrl")).objInfoMap(objInfoMap).builder();
    }

    public Map<String, DataPackageModifyResult> getReplaceData(Map<String, Object> params) {
        HashMap<String, DataPackageModifyResult> result = new HashMap<String, DataPackageModifyResult>(8);
        Map replaceData = (Map)JSON.parseObject((String)((String)params.get("job_param_replaceData")), Map.class);
        Set entries = replaceData.entrySet();
        for (Map.Entry entry : entries) {
            DataPackageModifyResult dataPackageModifyResult = (DataPackageModifyResult)JSON.parseObject((String)JSON.toJSONString(entry.getValue()), DataPackageModifyResult.class);
            HashMap<String, Object> mapResult = new HashMap<String, Object>();
            Map<String, Object> replaceRegMap = dataPackageModifyResult.getReplaceRegMap();
            if (null != replaceRegMap) {
                Set<Map.Entry<String, Object>> replaceRegEntries = replaceRegMap.entrySet();
                for (Map.Entry<String, Object> replaceRegEntry : replaceRegEntries) {
                    DynamicObject valueObj;
                    JSONObject replaceRegObj = (JSONObject)replaceRegEntry.getValue();
                    HashMap<String, Object> modifyObj = new HashMap<String, Object>();
                    Object pkId = replaceRegObj.get((Object)"pkId");
                    String entityName = replaceRegObj.getString("entityName");
                    if (null == pkId || !StringUtils.isNotEmpty((String)entityName) || (valueObj = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)entityName)) == null) continue;
                    modifyObj.put("new_data", valueObj);
                    modifyObj.put("fields", replaceRegObj.getJSONArray("fields"));
                    mapResult.put(replaceRegEntry.getKey(), modifyObj);
                }
                dataPackageModifyResult.setReplaceRegMap(mapResult);
            }
            result.put((String)entry.getKey(), dataPackageModifyResult);
        }
        return result;
    }

    public int calcProgress(int total, int execute) {
        return execute * 100 / total;
    }

    @Override
    public void dataPackageInstallInfoCallback(int totalPackageCount, int subPackageCount) {
    }

    @Override
    public void dataPackageInstallProgress(String fileName, SubDataInstallResult installResult, int subStatus) {
        InstallSubDataResult subDataResult = new InstallSubDataResult();
        subDataResult.setFileName(fileName);
        subDataResult.setResult(installResult);
        subDataResult.setSubStatus(subStatus);
        this.subInstallResult.add(subDataResult);
        this.installFeedbackResult.setSubInstallResult(this.subInstallResult);
        this.setInstallFeedbackResultInfo(subStatus);
        int execute = this.installFeedbackResult.getSuccessTaskNum() + this.installFeedbackResult.getPartSuccessTaskNum() + this.installFeedbackResult.getFailTaskNum();
        this.feedbackProgress(this.calcProgress(this.installFeedbackResult.getTotalTaskNum(), execute));
    }

    @Override
    public void dataPackageInstallFinish(String installMsg, String logPkId, int status, List<String> fileNameList) {
        InstallFinishResult installFinishResult = new InstallFinishResult();
        installFinishResult.setMsg(installMsg);
        installFinishResult.setLogPKId(logPkId);
        installFinishResult.setStatus(status);
        installFinishResult.setFileNames(fileNameList);
        this.installFeedbackResult.setInstallFinishResult(installFinishResult);
    }

    @Override
    public void dataPackageInstallFail(int code, String errMsg) {
        InstallFailResult installFailResult = new InstallFailResult();
        installFailResult.setCode(code);
        installFailResult.setErrMsg(errMsg);
        this.installFeedbackResult.setInstallFailResult(installFailResult);
    }

    @Override
    public Map<String, DataPackageModifyResult> checkDataPackageReplaceCallBack(Map<String, DataPackageModifyConfig> beforeDataPackageMap) {
        return this.modifyResultMap;
    }

    @Override
    public Map<String, DataPackageModifyResult> getDataPackageReplaceAsync() {
        return this.modifyResultMap;
    }

    private void setInstallFeedbackResultInfo(int subStatus) {
        if (subStatus == 1) {
            this.installFeedbackResult.setSuccessTaskNum(this.installFeedbackResult.getSuccessTaskNum() + 1);
        } else if (subStatus == 3) {
            this.installFeedbackResult.setPartSuccessTaskNum(this.installFeedbackResult.getPartSuccessTaskNum() + 1);
        } else if (subStatus == 2) {
            this.installFeedbackResult.setFailTaskNum(this.installFeedbackResult.getFailTaskNum() + 1);
        }
    }
}

