/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.iprm.gcpapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.util.DateUtil;
import kd.bos.openapi.common.util.OpenJsonUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.EncryptUtils;
import kd.imsc.cc.common.constants.iprm.model.GcpApiType;

public class GcpDigestApiBuilder {
    private static final Log logger = LogFactory.getLog(GcpDigestApiBuilder.class);
    private static final String SIGNATUR_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String GCP_DECRYPT_KEY = "GCP_DATA";
    private static final String GCP_ENV_CONFIG_KEY = "gcp.env.config";
    private GcpDigestApiParam gcpDigestApiParam;

    public static GcpDigestApiBuilder getGcpDigestApiBuilder() {
        Map<String, Object> param = GcpDigestApiBuilder.getGcpDigestConfigInfo();
        if (param.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e91\u5185\u5bb9\u5e73\u53f0\u6458\u8981\u8ba4\u8bc1\u53c2\u6570\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a", (String)"GcpDigestApiBuilder_0", (String)"bos-ext-imsc-business", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)String.valueOf(param.getOrDefault("url", ""))) || StringUtils.isEmpty((CharSequence)String.valueOf(param.getOrDefault("appid", ""))) || StringUtils.isEmpty((CharSequence)String.valueOf(param.getOrDefault("publickey", ""))) || StringUtils.isEmpty((CharSequence)String.valueOf(param.getOrDefault("userphone", "")))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e91\u5185\u5bb9\u5e73\u53f0\u6458\u8981\u8ba4\u8bc1\u53c2\u6570\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b8c\u6574", (String)"GcpDigestApiBuilder_1", (String)"bos-ext-imsc-business", (Object[])new Object[0]));
        }
        GcpDigestApiParam gcpDigestApiParam = new GcpDigestApiParam();
        gcpDigestApiParam.setUrl(String.valueOf(param.getOrDefault("url", "")));
        gcpDigestApiParam.setAppId(String.valueOf(param.getOrDefault("appid", "")));
        gcpDigestApiParam.setPublicKey(String.valueOf(param.getOrDefault("publickey", "")));
        gcpDigestApiParam.setUserPhone(String.valueOf(param.getOrDefault("userphone", "")));
        gcpDigestApiParam.setAccountId(String.valueOf(param.getOrDefault("accountId", "")));
        GcpDigestApiBuilder gcpDigestApiBuilder = new GcpDigestApiBuilder();
        gcpDigestApiBuilder.setGcpDigestApiParam(gcpDigestApiParam);
        return gcpDigestApiBuilder;
    }

    public Map<String, String> doPostDigest(Map<String, Object> body) {
        String timestamp = DateUtil.convertToStr((String)SIGNATUR_TIME_FORMAT, (Date)new Date());
        String uuid = UUID.randomUUID().toString();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        header.put("appId", this.gcpDigestApiParam.getAppId());
        header.put("timestamp", timestamp);
        header.put("signatureNonce", uuid);
        header.put("usertype", "Mobile");
        header.put("accountId", this.gcpDigestApiParam.getAccountId());
        header.put("user", this.gcpDigestApiParam.getUserPhone());
        if (null == body || body.isEmpty()) {
            body = new HashMap<String, Object>();
        }
        String toJson = OpenJsonUtil.toJson(body);
        StringBuilder sb = GcpDigestApiBuilder.getSignatureString(toJson, timestamp, uuid);
        String encyptString = GcpDigestApiBuilder.hmacSHA256(sb.toString(), this.gcpDigestApiParam.getPublicKey());
        header.put("signature", encyptString);
        return header;
    }

    public String doGetDigest(Map<String, Object> parameters) {
        StringBuilder url = new StringBuilder();
        url.append("?appId=").append(this.gcpDigestApiParam.getAppId());
        url.append("&user=").append(this.gcpDigestApiParam.getUserPhone());
        String timestamp = DateUtil.convertToStr((String)SIGNATUR_TIME_FORMAT, (Date)new Date());
        String uuid = UUID.randomUUID().toString();
        url.append("&signatureNonce=").append(uuid);
        url.append("&usertype=").append("Mobile");
        url.append("&accountId").append(this.gcpDigestApiParam.getAccountId());
        url.append("&timestamp=").append(URLEncoder.encode(timestamp));
        if (null == parameters || parameters.isEmpty()) {
            parameters = new HashMap<String, Object>();
        }
        String content = GcpDigestApiBuilder.mapToUrl(parameters);
        String contentEncode = GcpDigestApiBuilder.mapToUrlAndEncode(parameters);
        String parametersKey = GcpDigestApiBuilder.getMapKey(parameters);
        StringBuilder sb = GcpDigestApiBuilder.getSignatureString(content, timestamp, uuid);
        String encyptString = GcpDigestApiBuilder.hmacSHA256(sb.toString(), this.gcpDigestApiParam.getPublicKey());
        url.append("&").append("signature").append("=").append(encyptString);
        url.append("&").append(contentEncode);
        if (StringUtils.isNotEmpty((CharSequence)parametersKey)) {
            url.append("&").append("parameters").append("=").append(parametersKey);
        }
        return url.toString();
    }

    private static String mapToUrlAndEncode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            sb.append("&").append(entry.getKey()).append("=").append(URLEncoder.encode(String.valueOf(entry.getValue())));
        }
        String param = sb.substring(1);
        return param;
    }

    private static String mapToUrl(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            sb.append("&").append(entry.getKey()).append("=").append(entry.getValue());
        }
        String param = sb.substring(1);
        return param;
    }

    private static String getMapKey(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            sb.append(",").append(entry.getKey());
        }
        String param = sb.substring(1);
        return param;
    }

    private static StringBuilder getSignatureString(String body, String datetimeString, String signatureNonce) {
        StringBuilder sb = new StringBuilder();
        sb.append(body);
        sb.append(datetimeString);
        sb.append(signatureNonce);
        return sb;
    }

    public static String hmacSHA256(String data, String key) {
        try {
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA256");
            sha256_HMAC.init(secret_key);
            byte[] array = sha256_HMAC.doFinal(data.getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder();
            for (byte item : array) {
                sb.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (Exception e) {
            logger.error("\u7b7e\u540d\u9519\u8bef\uff1a", (Throwable)e);
            return null;
        }
    }

    private static Map<String, Object> getGcpDigestConfigInfo() {
        String valueStr;
        DynamicObject value;
        HashMap<String, Object> respMap = new HashMap<String, Object>();
        String configByMc = GcpDigestApiBuilder.getGcpConfigByMc();
        if (StringUtils.isNotBlank((CharSequence)configByMc)) {
            String decrypt = EncryptUtils.decrypt((String)GCP_DECRYPT_KEY, (String)configByMc);
            logger.info(" mc decrypt {}", (Object)decrypt);
            JSONObject decMap = JSON.parseObject((String)decrypt);
            respMap.putAll((Map<String, Object>)decMap);
            return respMap;
        }
        String fields = "paramvalue";
        QFilter qFilter = new QFilter("paramkey", "=", (Object)"gcp_digest_config");
        DynamicObject[] values = BusinessDataServiceHelper.load((String)"cc_parameter", (String)fields, (QFilter[])qFilter.toArray());
        if (values == null) {
            return respMap;
        }
        int n = 0;
        DynamicObject[] dynamicObjectArray = values;
        int n2 = dynamicObjectArray.length;
        if (n < n2 && (value = dynamicObjectArray[n]) != null && !StringUtils.isEmpty((CharSequence)(valueStr = value.getString("paramvalue")))) {
            try {
                String decrypt = EncryptUtils.decrypt((String)GCP_DECRYPT_KEY, (String)valueStr);
                logger.info("local decrypt {}", (Object)decrypt);
                JSONObject decMap = JSON.parseObject((String)decrypt);
                respMap.putAll((Map<String, Object>)decMap);
                return respMap;
            }
            catch (Exception e) {
            }
        }
        return respMap;
    }

    private static String getGcpConfigByMc() {
        String key = String.format("%s_%s", RequestContext.get().getTenantCode(), GCP_ENV_CONFIG_KEY);
        String config = System.getProperty(key);
        if (StringUtils.isNotEmpty((CharSequence)config)) {
            return config;
        }
        return System.getProperty(GCP_ENV_CONFIG_KEY);
    }

    public String getBaseUrl() {
        String baseUrl = String.valueOf(this.gcpDigestApiParam.getUrl());
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        try {
            String configGcp = System.getProperty("gcp.ip");
            if (kd.bos.util.StringUtils.isNotEmpty((String)configGcp)) {
                URL url = new URL(baseUrl);
                String urlHost = url.getHost();
                baseUrl = baseUrl.replaceAll(urlHost, configGcp);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.info("gcp host {}", (Object)baseUrl);
        return baseUrl;
    }

    public String getFullUrl(GcpApiType type) {
        if (type == null) {
            return this.getBaseUrl();
        }
        return String.format("%s%s", this.getBaseUrl(), type.getPath());
    }

    public GcpDigestApiParam getGcpDigestApiParam() {
        return this.gcpDigestApiParam;
    }

    public void setGcpDigestApiParam(GcpDigestApiParam gcpDigestApiParam) {
        this.gcpDigestApiParam = gcpDigestApiParam;
    }

    public static class GcpDigestApiParam {
        private String url;
        private String appId;
        private String publicKey;
        private String userPhone;
        private String accountId;

        public String getAccountId() {
            return this.accountId;
        }

        public void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getPublicKey() {
            return this.publicKey;
        }

        public void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        public String getUserPhone() {
            return this.userPhone;
        }

        public void setUserPhone(String userPhone) {
            this.userPhone = userPhone;
        }
    }
}

