/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.zip.io.inputstream.ZipInputStream;
import kd.bos.zip.model.LocalFileHeader;
import kd.imsc.cc.business.utils.ResourceInfoUtil;
import kd.imsc.cc.common.exception.CcBizException;
import kd.imsc.cc.common.utils.CommonUtils;
import kd.imsc.cc.common.utils.FileUtils;
import kd.imsc.cc.common.utils.PackUploadUtils;

public class PackUploader {
    private static final Log logger = LogFactory.getLog(PackUploader.class);
    private static final String CONFIG_KEY = "configKey";
    private final String storagePath = PackUploadUtils.getUploadPrefixPath() + "/cc_mycontent/";
    private final HashMap<String, Object> uploadResult = new HashMap(2);
    private final StringBuilder msg = new StringBuilder();
    private final StringBuilder devMsg = new StringBuilder();
    private JSONObject dataPacketJson;
    private String packageNumber;
    private boolean success = true;
    private String url;
    private String uploadName;
    private ZipInputStream zipInputStream;
    private final Map<String, Map<String, String>> nameTempFileInfoMap = new HashMap<String, Map<String, String>>();

    public String getMsg() {
        return this.msg.toString();
    }

    public String getUploadName() {
        return this.uploadName;
    }

    public void setUploadName(String uploadName) {
        this.uploadName = uploadName;
    }

    public PackUploader(String url) {
        this.url = url;
        this.init();
    }

    public PackUploader(ZipInputStream zipInputStream) {
        this.zipInputStream = zipInputStream;
        this.init();
    }

    private void init() {
        logger.info("\u5f00\u59cb\u89e3\u6790\u5185\u5bb9\u5305\u6587\u4ef6\uff0curl\uff1a" + this.url);
        try {
            this.getZipFileFromUrl();
            this.getJsonFromFile();
        }
        catch (Exception e) {
            logger.info("\u89e3\u6790\u5305\u6587\u4ef6\u65f6\u53d1\u751f\u672a\u77e5\u5f02\u5e38\u3002", (Object)e);
            this.setFailure();
            this.msg.append(ResManager.loadKDString((String)"\u89e3\u6790\u5305\u6587\u4ef6\u65f6\u53d1\u751f\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u7aef\u65e5\u5fd7\u83b7\u53d6\u8be6\u60c5\u3002", (String)"PackUploader_0", (String)"imsc-cc", (Object[])new Object[0])).append(e.getMessage());
        }
    }

    private void getZipFileFromUrl() throws Exception {
        if (StringUtils.isEmpty((CharSequence)this.url)) {
            return;
        }
        Exception bizException = null;
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        String[] queryParams = new URL(this.url).getQuery().split("&");
        HashMap<String, String> downloadFileParams = new HashMap<String, String>(queryParams.length);
        for (String queryParam : queryParams) {
            String[] p = queryParam.split("=");
            downloadFileParams.put(p[0], p[1]);
        }
        try {
            TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get(CONFIG_KEY), (String)downloadFileParams.get("id"));
            InputStream in = content.getInputStream();
            this.zipInputStream = new ZipInputStream(in, Charset.forName("GBK"));
        }
        catch (Exception e) {
            logger.error("\u5185\u5bb9\u5305\u4ece\u4e34\u65f6\u6587\u4ef6\u4e0a\u4f20\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            String msgTpl = ResManager.loadKDString((String)"\u5185\u5bb9\u5305\u4eceredis\u7f13\u5b58 %s\u4e2d\u4e0b\u8f7d\u5931\u8d25\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"PackUploader_1", (String)"imsc-cc", (Object[])new Object[0]);
            bizException = new Exception(msgTpl, e);
        }
        if (bizException != null) {
            throw bizException;
        }
    }

    private void getJsonFromFile() {
        JSONObject fileJsonObj;
        if (this.zipInputStream == null) {
            throw new CcBizException(ResManager.loadKDString((String)"\u670d\u52a1\u7aef\u63a5\u6536\u5230\u7684\u538b\u7f29\u6587\u4ef6\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"PackUploader_2", (String)"imsc-cc", (Object[])new Object[0]));
        }
        String jsonStr = "";
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        try {
            LocalFileHeader entry;
            while ((entry = this.zipInputStream.getNextEntry()) != null) {
                String entryName = entry.getFileName();
                byte[] fileBytes = FileUtils.inputStreamToByte((InputStream)this.zipInputStream);
                if ("coc_resourceissue.json".equals(entryName)) {
                    jsonStr = new String(fileBytes, StandardCharsets.UTF_8);
                    continue;
                }
                Map tempFileInfo = tempFileCache.save(entryName, fileBytes, 18000);
                this.nameTempFileInfoMap.put(entryName, tempFileInfo);
            }
            if (StringUtils.isEmpty((CharSequence)jsonStr)) {
                throw new CcBizException(ResManager.loadKDString((String)"\u5305\u6587\u4ef6\u4e2d\u83b7\u53d6\u4e0d\u5230\u5185\u5bb9\u5305\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u5904\u7406\u540e\u4e0a\u4f20\u3002", (String)"PackUploader_3", (String)"imsc-cc", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            String errorTips = String.format(ResManager.loadKDString((String)"\u89e3\u538b\u5904\u7406\u5f02\u5e38\uff0c%s", (String)"PackUploader_4", (String)"imsc-cc", (Object[])new Object[0]), e.getMessage());
            throw new CcBizException(errorTips, e);
        }
        try {
            fileJsonObj = (JSONObject)JSON.parse((String)jsonStr);
        }
        catch (JSONException e) {
            String msgTpl = ResManager.loadKDString((String)"Json\u683c\u5f0f\u5316\u5f02\u5e38\uff1a%1$s%n", (String)"PackUploader_5", (String)"imsc-cc", (Object[])new Object[0]);
            throw new CcBizException(String.format(msgTpl, jsonStr), e);
        }
        this.dataPacketJson = fileJsonObj;
        if (!fileJsonObj.containsKey((Object)"number")) {
            throw new CcBizException(ResManager.loadKDString((String)"\u5185\u5bb9\u5305\u914d\u7f6e\u6587\u4ef6\u4e2d\u672a\u83b7\u53d6\u5230\u7f16\u7801number\uff0c\u65e0\u6cd5\u4e0a\u4f20", (String)"PackUploader_6", (String)"imsc-cc", (Object[])new Object[0]));
        }
        this.packageNumber = fileJsonObj.getString("number");
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setFailure() {
        boolean isUpload;
        this.success = false;
        if (this.zipInputStream != null) {
            try {
                this.zipInputStream.close();
            }
            catch (IOException e) {
                logger.error("\u4e0a\u4f20\u5173\u6d41\u5931\u8d25setfail\u3002", (Throwable)e);
            }
        }
        if (!this.uploadResult.isEmpty() && (isUpload = ((Boolean)this.uploadResult.get("isupload")).booleanValue())) {
            FileService fs = FileServiceFactory.getAttachmentFileService();
            Map nameUrlMap = (Map)this.uploadResult.get("urls");
            nameUrlMap.values().forEach(arg_0 -> ((FileService)fs).delete(arg_0));
        }
    }

    public void doUpload() {
        logger.info("\u5f00\u59cb\u6267\u884c\u4e0a\u4f20\uff0c\u6587\u4ef6\u6570\uff1a" + this.nameTempFileInfoMap.size());
        if (!this.isSuccess()) {
            return;
        }
        try {
            this.validate();
            this.createContentObject();
        }
        catch (CcBizException e) {
            logger.error("\u4e0a\u4f20\u65f6\u51fa\u73b0\u5f02\u5e38\u3002", (Throwable)e);
            this.msg.append(ResManager.loadKDString((String)"\u4e0a\u4f20\u65f6\u51fa\u73b0\u5f02\u5e38\u3002", (String)"PackUploader_7", (String)"imsc-cc", (Object[])new Object[0])).append(e.getMessage());
            this.devMsg.append(CommonUtils.getExceptionDetailInfo(e));
            this.setFailure();
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u903b\u8f91\u51fa\u73b0\u4ee3\u7801\u672a\u68c0\u67e5\u5f02\u5e38\u3002", (Throwable)e);
            this.msg.append(ResManager.loadKDString((String)"\u4e0a\u4f20\u903b\u8f91\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u7aef\u65e5\u5fd7\u83b7\u53d6\u8be6\u60c5\u3002", (String)"PackUploader_8", (String)"imsc-cc", (Object[])new Object[0]));
            this.setFailure();
        }
        finally {
            this.removeSubPacketTempFiles();
        }
    }

    private void removeSubPacketTempFiles() {
        if (this.nameTempFileInfoMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Map<String, String>> nameTempFileInfo : this.nameTempFileInfoMap.entrySet()) {
            Map<String, String> tempFileInfo = nameTempFileInfo.getValue();
            this.removeTempFile(tempFileInfo);
        }
    }

    private void removeTempFile(Map<String, String> tempFileInfo) {
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String tempUrl = PackUploader.getTempUrl(tempFileInfo);
        tempFileCache.remove(tempUrl);
    }

    private static String getTempUrl(Map<String, String> tempFileInfo) {
        return String.format("tempfile/download.do?configKey=%s&id=%s", tempFileInfo.get(CONFIG_KEY), tempFileInfo.get("id"));
    }

    private void validate() {
        if (StringUtils.isEmpty((CharSequence)this.packageNumber)) {
            throw new CcBizException(ResManager.loadKDString((String)"\u5185\u5bb9\u5305\u4e2d\u7684\u7f16\u53f7\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"PackUploader_9", (String)"imsc-cc", (Object[])new Object[0]));
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("billno", "=", (Object)this.packageNumber)};
        boolean isExistAuditPacket = QueryServiceHelper.exists((String)"cc_mycontent", (QFilter[])qFilters);
        if (isExistAuditPacket) {
            String msg = ResManager.loadKDString((String)"\u76ee\u6807\u73af\u5883\u5df2\u7ecf\u5b58\u5728\u5df2\u5ba1\u6838\u7684\u76f8\u540c\u7f16\u7801\u7684\u4f20\u8f93\u5305\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"PackUploader_10", (String)"imsc-cc", (Object[])new Object[0]);
            throw new CcBizException(msg);
        }
    }

    private void createContentObject() throws IOException {
        DynamicObject newContent = ORM.create().newDynamicObject("cc_mycontent");
        this.createBillHead(this.dataPacketJson, newContent);
        newContent.set("contenthightstore_tag", (Object)this.dataPacketJson.getString("lightspot_tag"));
        newContent.set("introduction_tag", (Object)this.dataPacketJson.getString("detailtextuse_tag"));
        if (this.nameTempFileInfoMap.isEmpty()) {
            return;
        }
        String zipUrl = this.uploadSourceFile(newContent);
        this.setResourceEntry(newContent, zipUrl);
        this.saveContent(newContent);
    }

    private void saveContent(DynamicObject pkg) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("importtag_of_datasource", "true");
        OperationResult result = SaveServiceHelper.saveOperate((String)"cc_mycontent", (DynamicObject[])new DynamicObject[]{pkg}, (OperateOption)option);
        if (!result.isSuccess()) {
            StringBuilder opErr = new StringBuilder();
            opErr.append(result.getMessage());
            result.getAllErrorOrValidateInfo().forEach(validateInfo -> opErr.append(validateInfo.getMessage()));
            throw new CcBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u4e0a\u4f20\u4f20\u8f93\u5305\u65f6\u5931\u8d25\uff1a%s", (String)"PackUploader_11", (String)"imsc-cc", (Object[])new Object[0]), opErr));
        }
    }

    private void setResourceEntry(DynamicObject newContent, String zipUrl) {
        String pkgInfoContent = this.readZip(zipUrl);
        if (StringUtils.isEmpty((CharSequence)pkgInfoContent)) {
            throw new CcBizException(ResManager.loadKDString((String)"\u5185\u5bb9\u5305\u5185\u672a\u5305\u542b\u6709\u6548\u7684\u63cf\u8ff0\u6587\u4ef6\uff0c\u6216\u8005\u6587\u4ef6\u5185\u5bb9\u683c\u5f0f\u9519\u8bef\u3002", (String)"PackUploader_12", (String)"imsc-cc", (Object[])new Object[0]));
        }
        DynamicObjectCollection dCollection = newContent.getDynamicObjectCollection("resource_entry");
        try {
            JSONObject pckInfoJson = JSON.parseObject((String)pkgInfoContent);
            List files = (List)pckInfoJson.get((Object)"subdatapacket");
            for (Map fileInfo : files) {
                JSONObject pkgEntryInfo = (JSONObject)fileInfo.get("pkgEntryInfo");
                DynamicObject newRowData = dCollection.addNew();
                newRowData.set("sourcename", (Object)pkgEntryInfo.getString("fileName"));
                newRowData.set("businessobjecttype", (Object)pkgEntryInfo.getString("formName"));
                newRowData.set("billname", (Object)pkgEntryInfo.getString("formId"));
                newRowData.set("dataencrypt", (Object)pckInfoJson.getBoolean("dataencrypt"));
            }
        }
        catch (Throwable t) {
            throw new CcBizException(ResManager.loadKDString((String)"\u5185\u5bb9\u5305\u5185\u672a\u5305\u542b\u6709\u6548\u7684\u63cf\u8ff0\u6587\u4ef6\uff0c\u6216\u8005\u6587\u4ef6\u5185\u5bb9\u683c\u5f0f\u9519\u8bef\u3002", (String)"PackUploader_12", (String)"imsc-cc", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readZip(String zipUrl) {
        String line = "";
        try {
            ZipEntry zipEntry;
            FileService fs = FileServiceFactory.getAttachmentFileService();
            InputStream in = fs.getInputStream(zipUrl);
            Charset gbk = Charset.forName("GBK");
            java.util.zip.ZipInputStream zipInputStream = new java.util.zip.ZipInputStream(in, gbk);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int nRead;
                if (!"datapackage_configure.json".equalsIgnoreCase(zipEntry.getName())) continue;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] data = new byte[64];
                while ((nRead = zipInputStream.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                buffer.flush();
                byte[] targetArray = buffer.toByteArray();
                line = new String(targetArray, StandardCharsets.UTF_8);
                break;
            }
        }
        catch (Exception e) {
            String string = "";
            return string;
        }
        finally {
            try {
                this.zipInputStream.close();
            }
            catch (IOException e) {
                logger.error("Zip\u6587\u4ef6\u6d41\u65e0\u6cd5\u5173\u95ed", (Throwable)e);
            }
        }
        return this.delInvalidChar(line);
    }

    private String delInvalidChar(String str) {
        char[] chars;
        if (str == null || "".equals(str)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (char aChar : chars = str.toCharArray()) {
            boolean boo;
            boolean bl = boo = aChar <= '\b' || aChar >= '\u000b' && aChar <= '\f' || aChar >= '\u000e' && aChar <= '\u001f';
            if (boo) continue;
            sb.append(aChar);
        }
        return sb.toString();
    }

    private String uploadSourceFile(DynamicObject newContent) throws IOException {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        String uploadPath = this.storagePath + this.packageNumber + File.separator;
        HashMap<String, String> nameUrlMap = new HashMap<String, String>(this.nameTempFileInfoMap.size());
        String fileName = "";
        HashMap<String, Integer> nameSizeMap = new HashMap<String, Integer>(2);
        for (Map.Entry<String, Map<String, String>> fileEntry : this.nameTempFileInfoMap.entrySet()) {
            fileName = fileEntry.getKey();
            String fileFullPath = uploadPath + fileName;
            Map<String, String> tempFileInfo = fileEntry.getValue();
            TempFileCacheDownloadable.Content content = downLoad.get(tempFileInfo.get(CONFIG_KEY), tempFileInfo.get("id"));
            InputStream inputStream = content.getInputStream();
            Throwable throwable = null;
            try {
                nameSizeMap.put(fileName, inputStream.available());
                FileItem fileItem = new FileItem(fileName, fileFullPath, inputStream);
                String realUrl = FileUtils.uploadToFileService(fileService, fileItem);
                nameUrlMap.put(fileName, realUrl);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                inputStream.close();
            }
        }
        ArrayList<Map<String, Object>> attachments = new ArrayList<Map<String, Object>>();
        String realUrl = (String)nameUrlMap.get(fileName);
        if (StringUtils.isEmpty((CharSequence)realUrl)) {
            String errTpl = ResManager.loadKDString((String)"\u901a\u8fc7\u6587\u4ef6\u540d\u201c%1$s\u201d\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6\u5730\u5740\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"PackUploader_13", (String)"imsc-cc", (Object[])new Object[0]);
            String error = String.format(errTpl, fileName);
            throw new CcBizException(error);
        }
        String type = fileName.substring(fileName.lastIndexOf(46) + 1);
        Map<String, Object> uploadFileMap = FileUtils.createUploadFileMap("cc_mycontent", newContent.get("id"), "resourcefile", realUrl, fileName, ((Integer)nameSizeMap.get(fileName)).intValue(), type);
        attachments.add(uploadFileMap);
        List attList = AttachmentFieldServiceHelper.saveAttachments((String)"cc_mycontent", (String)"", attachments);
        for (DynamicObject dyo : attList) {
            dyo.set("tempfile", (Object)1);
        }
        SaveServiceHelper.save((DynamicObject[])attList.toArray(new DynamicObject[0]));
        MulBasedataDynamicObjectCollection fileList = new MulBasedataDynamicObjectCollection();
        DynamicObject dyFile = new DynamicObject(newContent.getDynamicObjectCollection("resourcefile").getDynamicObjectType());
        dyFile.set("FPKID", (Object)ID.genLongId());
        dyFile.set("fbasedataid", ((DynamicObject)attList.get(0)).get("id"));
        dyFile.set("fbasedataid_id", ((DynamicObject)attList.get(0)).get("id"));
        fileList.add(dyFile);
        newContent.set("resourcefile", (Object)fileList);
        return realUrl;
    }

    private void createBillHead(JSONObject fileJson, DynamicObject contentNewData) {
        JSONObject writer;
        JSONObject createTeam;
        JSONObject themeStr;
        DynamicObject theme;
        Object id = fileJson.get((Object)"id");
        if (!(id instanceof Long)) {
            id = DB.genLongId((String)"cc_mycontent");
        }
        contentNewData.set("id", id);
        contentNewData.set("billstatus", (Object)fileJson.getString("billstatus"));
        contentNewData.set("creator", (Object)RequestContext.get().getCurrUserId());
        contentNewData.set("createtime", (Object)System.currentTimeMillis());
        contentNewData.set("billno", fileJson.get((Object)"number"));
        contentNewData.set("name", (Object)this.getUploadName());
        contentNewData.set("createdate", fileJson.get((Object)"createdate"));
        contentNewData.set("brief", (Object)fileJson.getString("intro"));
        JSONObject adaIndustry = fileJson.getJSONObject("adaindustry");
        DynamicObject industry = this.getEntity(adaIndustry, "cc_res_rtype");
        if (industry != null) {
            contentNewData.set("rtype", industry.get("id"));
            contentNewData.set("industry", industry.get("name"));
        }
        JSONArray domainArr = fileJson.getJSONArray("domain");
        DynamicObjectCollection domain = contentNewData.getDynamicObjectCollection("domain2");
        if (CollectionUtils.isNotEmpty((Collection)domainArr)) {
            ArrayList<String> collect = new ArrayList<String>(10);
            this.setDyCollection(domainArr, domain, "cc_res_itype", collect);
            contentNewData.set("domain2", (Object)domain);
            contentNewData.set("domain", ResourceInfoUtil.getDomainFromList(collect));
        }
        if ((theme = this.getEntity(themeStr = fileJson.getJSONObject("classification"), "cc_res_ttype")) != null) {
            contentNewData.set("ttype", theme.get("id"));
            contentNewData.set("typename", theme.get("name"));
        }
        JSONArray supportLangStr = fileJson.getJSONArray("supportlang");
        DynamicObjectCollection supportlang = contentNewData.getDynamicObjectCollection("supportlang2");
        if (CollectionUtils.isNotEmpty((Collection)supportLangStr)) {
            this.setDyCollection(supportLangStr, supportlang, "cc_res_supportlang");
            contentNewData.set("supportlang2", (Object)supportlang);
        }
        JSONArray countryStr = fileJson.getJSONArray("country");
        DynamicObjectCollection country = contentNewData.getDynamicObjectCollection("country2");
        if (CollectionUtils.isNotEmpty((Collection)countryStr)) {
            this.setDyCollection(countryStr, country, "cc_res_country");
            contentNewData.set("country2", (Object)country);
        }
        contentNewData.set("create_org", (createTeam = (JSONObject)fileJson.get((Object)"createteam")) == null ? null : createTeam.getJSONObject("name").get((Object)"zh_CN"));
        contentNewData.set("contenttype", fileJson.get((Object)"contenttype"));
        contentNewData.set("enable", (Object)"1");
        contentNewData.set("collectstatus", (Object)"uncollect");
        contentNewData.set("version", fileJson.get((Object)"versiontext"));
        JSONArray scene = fileJson.getJSONArray("scene");
        DynamicObjectCollection sceneCollection = contentNewData.getDynamicObjectCollection("scenestore");
        if (CollectionUtils.isNotEmpty((Collection)scene)) {
            this.setDyCollection(scene, sceneCollection, "cc_scene");
            contentNewData.set("scenestore", (Object)sceneCollection);
        }
        if ((writer = fileJson.getJSONObject("writer")) != null) {
            contentNewData.set("writerstr", writer.get((Object)"membername"));
        }
        JSONArray appVisions = fileJson.getJSONArray("appvision");
        StringBuilder appVisionStr = new StringBuilder();
        for (Object appVision : appVisions) {
            JSONObject object;
            if (!(appVision instanceof JSONObject) || !(object = (JSONObject)appVision).containsKey((Object)"name")) continue;
            appVisionStr.append(object.getJSONObject("name").get((Object)"zh_CN")).append(',');
        }
        if (appVisionStr.length() > 0) {
            appVisionStr.deleteCharAt(appVisionStr.lastIndexOf(","));
        }
        String backwards = fileJson.getString("backwards");
        boolean aTrue = StringUtils.equals((CharSequence)backwards, (CharSequence)"true");
        String appVisionValue = appVisionStr.length() == 0 ? "" : (aTrue ? appVisionStr.append(ResManager.loadKDString((String)"\u53ca\u4ee5\u4e0a\u7248\u672c", (String)"PackUploader_14", (String)"imsc-cc", (Object[])new Object[0])).toString() : appVisionStr.toString());
        contentNewData.set("appvision", (Object)(appVisionStr.length() == 0 ? "" : appVisionValue));
        contentNewData.set("issuedate", (Object)fileJson.getString("groundingdate"));
        contentNewData.set("tabtype", (Object)"localtab");
        this.setPictureInfo(contentNewData, fileJson);
    }

    private void setPictureInfo(DynamicObject newContent, JSONObject fileJson) {
        for (int i = 1; i <= 5; ++i) {
            String pictUrl = fileJson.getString("picurl" + i);
            String pictTag = fileJson.getString("pic" + i + "_tag");
            if (StringUtils.isEmpty((CharSequence)pictTag)) continue;
            int commaIndex = pictTag.indexOf(",");
            pictTag = commaIndex != -1 ? pictTag.substring(commaIndex + 1) : pictTag;
            String newUrl = PackUploadUtils.uploadPicture(pictUrl, pictTag);
            newContent.set("pict" + i, (Object)newUrl);
        }
    }

    private DynamicObject getEntity(JSONObject jsonData, String entityNumber) {
        if (jsonData == null) {
            return null;
        }
        QFilter qFilter = new QFilter("number", "=", (Object)jsonData.getString("number"));
        DynamicObject data = QueryServiceHelper.queryOne((String)entityNumber, (String)"id,number,name", (QFilter[])qFilter.toArray());
        if (data != null) {
            return data;
        }
        DynamicObject newData = BusinessDataServiceHelper.newDynamicObject((String)entityNumber);
        if (!"cc_scene".equals(entityNumber)) {
            newData.set("status", (Object)"C");
            newData.set("enable", (Object)"1");
        }
        newData.set("number", (Object)jsonData.getString("number"));
        newData.set("name", (Object)CommonUtils.getLocaleStringFromMap(jsonData.getJSONObject("name")));
        newData.set("id", jsonData.get((Object)"id"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newData});
        return newData;
    }

    private void setDyCollection(JSONArray jsonArray, DynamicObjectCollection collect, String entityNumber, List<String> collectNameList) {
        for (Object o : jsonArray) {
            JSONObject jsonData = (JSONObject)o;
            DynamicObject newData = new DynamicObject(collect.getDynamicObjectType());
            DynamicObject entity = this.getEntity(jsonData, entityNumber);
            if (collectNameList != null && entity != null) {
                collectNameList.add(entity.getString("name"));
            }
            if (entity == null) continue;
            newData.set("fbasedataId", (Object)entity.getLong("id"));
            collect.add((Object)newData);
        }
    }

    private void setDyCollection(JSONArray jsonArray, DynamicObjectCollection collect, String entityNumber) {
        this.setDyCollection(jsonArray, collect, entityNumber, null);
    }
}

