/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.formplugin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.imsc.cc.business.resource.ResourceListProxy;
import kd.imsc.cc.business.utils.ResourceInfoUtil;
import kd.imsc.cc.common.exception.KdXkIprmException;
import kd.imsc.cc.common.model.ContentInfoModel;
import kd.imsc.cc.common.model.ContentListModel;
import kd.imsc.cc.formplugin.helper.CollectHelper;

public class ResourceListDataProvider
extends ListDataProvider {
    private static final Log logger = LogFactory.getLog(ResourceListDataProvider.class);
    Param myParam = null;
    private static final String INDUSTRY_KEY = "typeNum1";
    private static final String DOMAIN_KEY = "typeNum2";
    private static final String THEME_KEY = "typeNum3";
    private static final String SUPPORT_LANG_KEY = "typeNum4";
    private static final String COUNTRY_KEY = "typeNum5";
    private static final String FILTER_KEY = "filterKey";
    private IFormView formView;

    public ResourceListDataProvider(Param param, IFormView view) {
        this.myParam = param;
        this.formView = view;
    }

    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection rowsOldData = super.getData(0, 0);
        try {
            int pageIndex = start / limit;
            Map<String, String> map = this.getFilter();
            String industry = map.get(INDUSTRY_KEY);
            String domainKey = map.get(DOMAIN_KEY);
            String theme = map.get(THEME_KEY);
            String supportLang = map.get(SUPPORT_LANG_KEY);
            String country = map.get(COUNTRY_KEY);
            String filterKey = map.get(FILTER_KEY);
            String collectFilter = map.get("collectFilter");
            String schemeFilterStr = map.get("schemeFilter");
            if (collectFilter != null && collectFilter.equals("[]")) {
                return rowsOldData;
            }
            ContentListModel resourceListData = ResourceListProxy.getResourceListFromGcp(pageIndex, limit, industry, domainKey, theme, supportLang, country, filterKey, collectFilter, schemeFilterStr);
            if (resourceListData == null || resourceListData.getCloudList() == null) {
                return rowsOldData;
            }
            DynamicObjectCollection rowsNewData = new DynamicObjectCollection(rowsOldData.getDynamicObjectType(), null);
            List<ContentInfoModel> rowArr = resourceListData.getCloudList();
            for (ContentInfoModel row : rowArr) {
                String classification;
                String adaIndustry;
                DynamicObject newDataRow = rowsOldData.addNew();
                newDataRow.set("id", (Object)row.getContentId());
                newDataRow.set("name", (Object)row.getPkgName());
                newDataRow.set("billno", (Object)row.getPkgNumber());
                String content = row.getPkgSummery();
                if (!StringUtils.isEmpty((String)content)) {
                    content = content + "\r\n";
                }
                newDataRow.set("brief", (Object)content);
                newDataRow.set("re_score", (Object)row.getGrade());
                String string = adaIndustry = row.getAdaindustry() == null ? "" : row.getAdaindustry();
                if (StringUtils.isNotEmpty((String)adaIndustry) && adaIndustry.length() > 6) {
                    adaIndustry = adaIndustry.substring(0, 5);
                }
                newDataRow.set("industry", (Object)adaIndustry);
                Object domain = ResourceInfoUtil.getDomainFromList(row.getDomain());
                newDataRow.set("domain", domain);
                String string2 = classification = row.getClassification() == null ? "" : row.getClassification();
                if (StringUtils.isNotEmpty((String)classification) && classification.length() > 6) {
                    classification = classification.substring(0, 6);
                }
                newDataRow.set("typename", (Object)classification);
                newDataRow.set("create_org", (Object)row.getCreateTeam());
                newDataRow.set("collectstatus", (Object)(CollectHelper.isCollect(row.getPkgNumber(), RequestContext.get().getCurrUserId()) ? "collect" : "uncollect"));
                if (StringUtils.isNotEmpty((String)collectFilter)) {
                    newDataRow.set("tabtype", (Object)"collecttab");
                }
                rowsNewData.add((Object)newDataRow);
            }
            return rowsNewData;
        }
        catch (KdXkIprmException e) {
            logger.error("\u4e91\u5185\u5bb9\u5217\u8868\u67e5\u8be2|\u83b7\u53d6\u4e91\u5185\u5bb9\u5217\u8868\u6570\u636e\u5f02\u5e38", (Throwable)e);
            this.formView.showErrorNotification(e.getMessage());
            this.formView.getPageCache().put("isVisibleNoDataFlex", "true");
            return rowsOldData;
        }
        catch (Exception e) {
            logger.error("\u4e91\u5185\u5bb9\u5217\u8868\u67e5\u8be2|\u83b7\u53d6\u4e91\u5185\u5bb9\u5217\u8868\u6570\u636e\u5f02\u5e38", (Throwable)e);
            this.formView.showErrorNotification(ResManager.loadKDString((String)"\u4e91\u5185\u5bb9\u548c\u5e94\u7528\u5217\u8868\u67e5\u8be2\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ResourceListDataProvider_0", (String)"imsc-iprm-formplugin", (Object[])new Object[0]));
            this.formView.getPageCache().put("isVisibleNoDataFlex", "true");
            return rowsOldData;
        }
    }

    public int getRealCount() {
        Map<String, String> map = this.getFilter();
        String typeNum1 = map.get(INDUSTRY_KEY);
        String typeNum2 = map.get(DOMAIN_KEY);
        String typeNum3 = map.get(THEME_KEY);
        String typeNum4 = map.get(SUPPORT_LANG_KEY);
        String typeNum5 = map.get(COUNTRY_KEY);
        String collectFilter = map.get("collectFilter");
        String schemeFilter = map.get("schemeFilter");
        String filterKey = map.get(FILTER_KEY);
        return ResourceListProxy.getResourceCountFromGcp(typeNum1, typeNum2, typeNum3, typeNum4, typeNum5, filterKey, collectFilter, schemeFilter);
    }

    public int getBillDataCount() {
        return this.getRealCount();
    }

    Map<String, String> getFilter() {
        String[] strings;
        Object value;
        String industry = "";
        String domain = "";
        String theme = "";
        String supportLang = "";
        String country = "";
        String contentNumberStr = "";
        String schemeFilterStr = "";
        if (this.myParam != null) {
            industry = this.myParam.getIndustryNum();
            domain = this.myParam.getDomainNum();
            theme = this.myParam.getThemeNum();
            supportLang = this.myParam.getSupportLangNum();
            country = this.myParam.getCountryNum();
            contentNumberStr = this.myParam.getCollectFilter();
            schemeFilterStr = this.myParam.getSchemeFilter();
        }
        List qFilters = this.getQFilters();
        for (QFilter qFilter : qFilters) {
            Object qFilterValue = qFilter.getOriginValue();
            if (qFilterValue == null) continue;
            if (qFilter.getProperty().equals("rtype.number")) {
                industry = qFilterValue.toString();
            }
            if (qFilter.getProperty().equals("itype.number")) {
                domain = qFilterValue.toString();
            }
            if (!qFilter.getProperty().equals("ttype.number")) continue;
            theme = qFilterValue.toString();
        }
        String filterKey = "";
        if (qFilters.size() > 0 && (value = ((QFilter)qFilters.get(0)).getValue()) != null && !StringUtils.isEmpty((String)value.toString()) && value.toString().contains("#") && (strings = value.toString().split("#")).length > 0) {
            filterKey = strings[strings.length - 1];
            if (value.toString().contains("businessobjecttype") && !value.toString().contains(",")) {
                String businessNumber = this.formView.getPageCache().get("cache_key_business_number");
                String businessName = this.formView.getPageCache().get("cache_key_business_name");
                if (StringUtils.isNotEmpty((String)businessNumber) && filterKey.equals(businessName)) {
                    filterKey = businessNumber;
                }
            }
        }
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put(INDUSTRY_KEY, industry);
        map.put(DOMAIN_KEY, domain);
        map.put(THEME_KEY, theme);
        map.put(SUPPORT_LANG_KEY, supportLang);
        map.put(COUNTRY_KEY, country);
        map.put("collectFilter", contentNumberStr);
        map.put(FILTER_KEY, filterKey);
        map.put("schemeFilter", schemeFilterStr);
        return map;
    }

    public static class Param {
        String industryNum = "";
        String domainNum = "";
        String themeNum = "";
        String supportLangNum = "";
        String countryNum = "";
        String collectFilterStr;
        String schemeFilter;

        public String getSchemeFilter() {
            return this.schemeFilter;
        }

        public void setSchemeFilter(String schemeFilter) {
            this.schemeFilter = schemeFilter;
        }

        public String getCollectFilter() {
            return this.collectFilterStr;
        }

        public void setCollectFilter(String collectFilter) {
            this.collectFilterStr = collectFilter;
        }

        public void setIndustry(String industryNum) {
            this.industryNum = industryNum;
        }

        public String getIndustryNum() {
            return this.industryNum;
        }

        public void setDomain(String theme) {
            this.domainNum = theme;
        }

        public String getDomainNum() {
            return this.domainNum;
        }

        public void setThemeNum(String level3Num) {
            this.themeNum = level3Num;
        }

        public String getThemeNum() {
            return this.themeNum;
        }

        public String getSupportLangNum() {
            return this.supportLangNum;
        }

        public void setSupportLang(String level4Num) {
            this.supportLangNum = level4Num;
        }

        public String getCountryNum() {
            return this.countryNum;
        }

        public void setCountry(String countryNum) {
            this.countryNum = countryNum;
        }
    }
}

