/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Rate;
import kd.bos.form.control.events.RateEvent;
import kd.bos.form.control.events.RateListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.imsc.cc.business.gcpmanage.GcpManager;
import kd.imsc.cc.common.constants.iprm.model.BizOperationResult;

public class ResourceScoreFormPlugin
extends AbstractFormPlugin
implements RateListener {
    private static final String RATEAP = "rateap";
    private static final String SUBMIT = "submit";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Rate rate = (Rate)this.getControl(RATEAP);
        rate.addRateListener((RateListener)this);
    }

    public void update(RateEvent evt) {
        Number rateScore = evt.getRateScore();
        Rate rate = (Rate)evt.getSource();
        this.getPageCache().put(rate.getKey(), rateScore.toString());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (SUBMIT.equals(operateKey)) {
            Object content;
            Object resourceNumber = this.getResourceNumber();
            if (ObjectUtils.isEmpty((Object)resourceNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u8bc4\u4ef7\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ResourceScoreFormPlugin_0", (String)"imsc-cc", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String s = this.getPageCache().get(RATEAP);
            if (StringUtils.isEmpty((String)s)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5185\u5bb9\u8bc4\u5206\u3002", (String)"ResourceScoreFormPlugin_1", (String)"imsc-cc", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (Integer.parseInt(s) <= 3 && ObjectUtils.isEmpty((Object)(content = this.getModel().getValue("eva_content")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u4ef7\u5185\u5bb9\u3002", (String)"ResourceScoreFormPlugin_2", (String)"imsc-cc", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (SUBMIT.equals(operateKey)) {
            this.submit();
        }
    }

    private void submit() {
        BizOperationResult bizOperationResult = GcpManager.submitResourceScore(this.getParams());
        boolean success = bizOperationResult.getSuccess();
        if (success) {
            this.setReturnData();
            this.getView().close();
        } else {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u8bc4\u4ef7\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"ResourceScoreFormPlugin_3", (String)"imsc-cc", (Object[])new Object[0]), bizOperationResult.getData()));
        }
    }

    private Map<String, Object> getParams() {
        HashMap<String, Object> params = new HashMap<String, Object>(12);
        params.put("number", this.getResourceNumber());
        params.put("score", Integer.valueOf(this.getPageCache().get(RATEAP)));
        IDataModel model = this.getModel();
        params.put("evacontent", model.getValue("eva_content"));
        params.put("telphone", model.getValue("phone"));
        params.put("username", model.getValue("name"));
        return params;
    }

    private Object getResourceNumber() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        return showParameter.getCustomParams().get("form_key_billno");
    }

    public void setReturnData() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("submitSuccess", Boolean.TRUE);
        this.getView().returnDataToParent(params);
    }
}

