/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.formplugin.mycontent;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.Rate;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.imsc.cc.business.gcpmanage.GcpManager;
import kd.imsc.cc.business.helper.NewResourceHelper;
import kd.imsc.cc.business.resource.ResourceListProxy;
import kd.imsc.cc.business.utils.ResourceInfoUtil;
import kd.imsc.cc.common.constants.iprm.model.BizOperationResult;
import kd.imsc.cc.common.entity.DataPackageInputModel;
import kd.imsc.cc.common.exception.KdXkIprmException;
import kd.imsc.cc.common.model.ContentDetailModel;
import kd.imsc.cc.common.utils.ContentHelper;
import kd.imsc.cc.common.utils.PackUploadUtils;
import kd.imsc.cc.formplugin.helper.CollectHelper;

public class MyContentPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final Log logger = LogFactory.getLog(MyContentPlugin.class);
    private static final String CONTENT_INFO_CACHE = "contentInfoCache";
    private static final String CONTROL_LABEL_001 = "industry_1";
    private static final String CONTROL_LABEL_002 = "domain_1";
    private static final String CONTROL_LABEL_003 = "theme";
    private static final String LABEI_SCORE = "labelap2";
    private static final String INDEX_ROW_CACHE = "entryRowCache";

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("resource_entry");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        Image image = (Image)this.getControl("picture");
        image.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{"collectpic", "uncollectpic"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String tabSelectType = (String)showParameter.getCustomParam("tabSelectType");
        this.getView().getPageCache().put("tabSelectType", tabSelectType);
        String billNumber = (String)showParameter.getCustomParam("billno");
        this.getModel().setValue("billno", (Object)billNumber);
        logger.info("\u6211\u7684\u5185\u5bb9{}\u6253\u5f00\u7c7b\u578b\u4e3a{}", (Object)billNumber, (Object)tabSelectType);
    }

    public void afterBindData(EventObject e) {
        String resourceNumber = (String)this.getModel().getValue("billno");
        this.setLabelValue("billno_1", resourceNumber);
        String tabSelectType = this.getView().getPageCache().get("tabSelectType");
        if ("localtab".equals(tabSelectType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap3", "collectvect", "bar_score", "collect"});
            DynamicObject oneContent = BusinessDataServiceHelper.loadSingle((String)"cc_mycontent", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)resourceNumber)});
            Image image = (Image)this.getControl("picture");
            ArrayList<String> pictUrlCache = new ArrayList<String>(10);
            String pict1 = (String)oneContent.get("pict1");
            if (StringUtils.isNotEmpty((String)pict1)) {
                image.setUrl(UrlService.getImageFullUrl((String)pict1));
                pictUrlCache.add(pict1);
            }
            pictUrlCache.add(oneContent.getString("pict2"));
            pictUrlCache.add(oneContent.getString("pict3"));
            pictUrlCache.add(oneContent.getString("pict4"));
            pictUrlCache.add(oneContent.getString("pict5"));
            List collect = pictUrlCache.stream().filter(StringUtils::isNotEmpty).collect(Collectors.toList());
            this.getView().getPageCache().put("pictUrlCache", SerializationUtils.toJsonString(collect));
            this.setLabelValue("labelaptitle", oneContent.getString("name"));
            this.getView().getPageCache().put("contentName", oneContent.getString("name"));
            this.setLabelValue("versions", oneContent.getString("version"));
            this.getView().getPageCache().put("contentVersion", oneContent.getString("version"));
            this.setLabelValue(CONTROL_LABEL_001, oneContent.getString("rtype.name"));
            DynamicObjectCollection domainArr = oneContent.getDynamicObjectCollection("domain2");
            ArrayList<String> labVal = new ArrayList<String>(10);
            for (DynamicObject item : domainArr) {
                DynamicObject dyo = item.getDynamicObject("fbasedataid");
                if (dyo == null) continue;
                labVal.add(dyo.getLocaleString("name").getLocaleValue());
            }
            Object domain = ResourceInfoUtil.getDomain(labVal, Boolean.FALSE);
            this.setLabelValue(CONTROL_LABEL_002, (String)domain);
            this.setLabelValue(CONTROL_LABEL_003, oneContent.getString("ttype.name"));
            DynamicObjectCollection sceneArr = oneContent.getDynamicObjectCollection("scenestore");
            ArrayList<String> sceneList = new ArrayList<String>(10);
            for (DynamicObject item : sceneArr) {
                DynamicObject dyo = item.getDynamicObject("fbasedataid");
                if (dyo == null) continue;
                sceneList.add(dyo.getLocaleString("name").getLocaleValue());
            }
            ContentHelper.setScene(sceneList, this.getView());
            this.getModel().setValue("brief", oneContent.get("brief"));
            this.setLabelValue("writer", oneContent.getString("writerstr"));
            this.setLabelValue("createorg", oneContent.getString("create_org"));
            this.setData(oneContent.getDate("issuedate"));
            this.setLabelValue("appvisionstr", oneContent.getString("appvision"));
            this.setDetailText("contenthighlights", oneContent.getString("contenthightstore_tag"));
            this.setDetailText("richtexteditorap", oneContent.getString("introduction_tag"));
            DynamicObjectCollection resourceFile = oneContent.getDynamicObjectCollection("resourcefile");
            this.getView().getPageCache().put("resourceFile", resourceFile == null ? "" : ((DynamicObject)resourceFile.get(0)).getDynamicObject("fbasedataid").getString("url"));
            DynamicObjectCollection resourceEntry = oneContent.getDynamicObjectCollection("resource_entry");
            this.refreshResourceList(resourceEntry);
            this.getModel().setValue("collectstatus", (Object)"uncollect");
        } else {
            try {
                this.setFormList(resourceNumber);
            }
            catch (KdXkIprmException ex) {
                String msg = ResManager.loadKDString((String)"\u5185\u5bb9\u5305\u5df2\u4e0b\u67b6\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u3002", (String)"MyContentPlugin_0", (String)"imsc-cc", (Object[])new Object[0]);
                if (ex.getCode() == 99) {
                    msg = "Network error!";
                }
                if (ex.getCode() == 5002) {
                    msg = ex.getMessage();
                }
                if (this.getView().getParentView() != null) {
                    this.getView().returnDataToParent((Object)msg);
                }
                this.getView().close();
            }
        }
    }

    private void setFormList(String resourceNumber) throws KdXkIprmException {
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap3", "collectvect", "bar_score", "collect"});
        ContentDetailModel dataMap = this.getInfoData(resourceNumber);
        if (dataMap == null) {
            return;
        }
        NewResourceHelper.recordBrowseCount(resourceNumber);
        Image image = (Image)this.getControl("picture");
        this.getView().getPageCache().put("pictUrlCache", PackUploadUtils.getPictureInfo(dataMap.getPicList(), image));
        this.setLabelValue("labelaptitle", dataMap.getPkgName());
        this.setLabelValue("versions", dataMap.getVersion());
        String indValue = StringUtils.getStringValue((Object)ResourceInfoUtil.getIndustry(dataMap.getAdaindustry(), Boolean.FALSE));
        if (!StringUtils.isEmpty((String)indValue)) {
            this.setLabelValue(CONTROL_LABEL_001, indValue);
        }
        this.getView().setVisible(Boolean.valueOf(!StringUtils.isEmpty((String)indValue)), new String[]{CONTROL_LABEL_001});
        String domainValue = StringUtils.getStringValue((Object)ResourceInfoUtil.getDomain(dataMap.getDomain(), Boolean.FALSE));
        if (!StringUtils.isEmpty((String)domainValue)) {
            this.setLabelValue(CONTROL_LABEL_002, domainValue);
        }
        this.getView().setVisible(Boolean.valueOf(!StringUtils.isEmpty((String)domainValue)), new String[]{CONTROL_LABEL_002});
        String typeValue = StringUtils.getStringValue((Object)ResourceInfoUtil.getClassification(dataMap.getClassification(), Boolean.FALSE));
        if (!StringUtils.isEmpty((String)typeValue)) {
            this.setLabelValue(CONTROL_LABEL_003, typeValue);
        }
        this.getView().setVisible(Boolean.valueOf(!StringUtils.isEmpty((String)typeValue)), new String[]{CONTROL_LABEL_003});
        List<String> sceneList = dataMap.getScene();
        ContentHelper.setScene(sceneList, this.getView());
        this.getModel().setValue("brief", (Object)dataMap.getPkgSummery());
        this.getView().updateView("brief");
        this.setLabelValue("writer", dataMap.getAuthorName());
        Label creatorOrgLabel = (Label)this.getView().getControl("createorg");
        String createOrg = dataMap.getCreateTeam();
        creatorOrgLabel.setText(createOrg == null ? null : String.valueOf(createOrg));
        Date dataVal = dataMap.getReleaseDate();
        this.setData(dataVal);
        Label appVisionLab = (Label)this.getView().getControl("appvisionstr");
        List<String> starryVersion = dataMap.getStarryVersion();
        boolean backwards = dataMap.isBackwards();
        StringBuilder appVision = new StringBuilder();
        starryVersion.forEach(y -> appVision.append((String)y).append(','));
        appVision.deleteCharAt(appVision.lastIndexOf(","));
        appVisionLab.setText(backwards ? String.format(ResManager.loadKDString((String)"%s\u53ca\u4ee5\u4e0a\u7248\u672c", (String)"MyContentPlugin_1", (String)"imsc-cc", (Object[])new Object[0]), appVision) : appVision.toString());
        this.getPageCache().put(CONTENT_INFO_CACHE, SerializationUtils.toJsonString((Object)dataMap));
        this.getModel().setValue("name", (Object)dataMap.getPkgName());
        this.getModel().setValue("createdate", (Object)dataMap.getCreateDate());
        RichTextEditor contentHighlights = (RichTextEditor)this.getView().getControl("contenthighlights");
        contentHighlights.setText(dataMap.getLightDetail());
        this.getView().updateView("contenthighlights");
        String detailText = dataMap.getDetailText();
        this.setDetailText("richtexteditorap", detailText);
        this.refreshResourceList(dataMap);
        String scoreVal = dataMap.getGrade();
        this.getModel().setValue("re_score", (Object)scoreVal);
        this.setLabelValue(LABEI_SCORE, scoreVal);
        Rate rate = (Rate)this.getView().getControl("rateap");
        rate.setRateScore((Number)Double.valueOf(scoreVal));
        this.getModel().setValue("collectstatus", (Object)(CollectHelper.isCollect(resourceNumber, RequestContext.get().getCurrUserId()) ? "collect" : "uncollect"));
    }

    private void setData(Date dataVal) {
        if (dataVal != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            this.setLabelValue("data", sdf.format(dataVal));
        }
    }

    private void setLabelValue(String labNumber, String value) {
        Label label = (Label)this.getView().getControl(labNumber);
        label.setText(value);
        this.getView().setVisible(Boolean.valueOf(!StringUtils.isEmpty((String)value)), new String[]{labNumber});
    }

    private void setDetailText(String key, String detailText) {
        if (!StringUtils.isEmpty((String)detailText)) {
            detailText = ResourceInfoUtil.convertFromBase64Image(detailText);
            RichTextEditor richTextEditor = (RichTextEditor)this.getView().getControl(key);
            richTextEditor.setText(detailText);
            this.getView().updateView(key);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String fieldKey = control.getKey();
        String billNo = (String)this.getModel().getValue("billno");
        if ("picture".equals(fieldKey)) {
            String pictUrlCacheStr = this.getView().getPageCache().get("pictUrlCache");
            List pictUrlCache = (List)SerializationUtils.fromJsonString((String)pictUrlCacheStr, List.class);
            this.getView().showPictureView(pictUrlCache.toArray(new String[0]), 1);
        } else if ("collectpic".equals(fieldKey)) {
            CollectHelper.cancelCollectClick(billNo, "cc_resourcenew", this.getView(), this.getPluginName());
        } else if ("uncollectpic".equals(fieldKey)) {
            CollectHelper.collectClick(billNo, "cc_mycontent", this.getView());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("uncollect".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            String params = messageBoxClosedEvent.getCustomVaule();
            Map map = (Map)SerializationUtils.fromJsonString((String)params, Map.class);
            operateOption.setVariableValue("contentNumber", (String)map.get("contentNumber"));
            operateOption.setVariableValue("isCollect", "false");
            operateOption.setVariableValue("isAfterConfirm", "true");
            this.getView().invokeOperation("uncollect", operateOption);
        } else if ("cancelcollect".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String params = messageBoxClosedEvent.getCustomVaule();
            Map map = (Map)SerializationUtils.fromJsonString((String)params, Map.class);
            boolean isSuccess = CollectHelper.collect((String)map.get("contentNumber"), RequestContext.get().getCurrUserId(), false);
            if (isSuccess) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6536\u85cf\u6210\u529f\u3002", (String)"MyContentPlugin_2", (String)"imsc-cc", (Object[])new Object[0]));
            }
            this.getView().invokeOperation("refresh");
        }
    }

    private void refreshResourceList(DynamicObjectCollection collection) {
        DynamicObjectCollection resourceEntry = this.getModel().getEntryEntity("resource_entry");
        resourceEntry.clear();
        for (DynamicObject content : collection) {
            DynamicObject entryRow = resourceEntry.addNew();
            entryRow.set("sourcename", content.get("sourcename"));
            entryRow.set("businessobjecttype", content.get("businessObjectType"));
            entryRow.set("billName", content.get("billName"));
            entryRow.set("dataencrypt", content.get("dataencrypt"));
        }
        this.getView().updateView("resource_entry");
    }

    private void refreshResourceList(ContentDetailModel dataMap) {
        String packStr = dataMap.getpInfoContent();
        if (StringUtils.isEmpty((String)packStr)) {
            return;
        }
        Map mapData = (Map)SerializationUtils.fromJsonString((String)packStr, Map.class);
        List contentList = (List)mapData.get("files");
        if (contentList != null) {
            DynamicObjectCollection resourceEntry = this.getModel().getEntryEntity("resource_entry");
            resourceEntry.clear();
            for (Map content : contentList) {
                this.setResourceEntry(resourceEntry, content);
            }
            this.getView().updateView("resource_entry");
        }
    }

    private void setResourceEntry(DynamicObjectCollection resourceEntry, Map<String, Object> content) {
        DynamicObject entryRow = resourceEntry.addNew();
        entryRow.set("sourcename", content.get("fileName"));
        entryRow.set("businessobjecttype", content.get("businessObjectType"));
        entryRow.set("billName", content.get("billName"));
        entryRow.set("dataencrypt", content.get("dataencrypt"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        String type = this.getView().getPageCache().get("tabSelectType");
        String number = this.getModel().getDataEntity().getString("billno");
        switch (operateKey) {
            case "collect": {
                formOperate.getOption().setVariableValue("contentNumber", number);
                formOperate.getOption().setVariableValue("isCollect", "true");
                break;
            }
            case "uncollect": {
                if (formOperate.getOption().containsVariable("isAfterConfirm")) break;
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(operateKey, (IFormPlugin)this);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"MyContentPlugin_3", (String)"imsc-cc", (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"MyContentPlugin_4", (String)"imsc-cc", (Object[])new Object[0]));
                HashMap<String, String> params = new HashMap<String, String>();
                String contentName = this.getModel().getDataEntity().getString("name");
                params.put("contentNumber", number);
                String confirmTip = String.format(ResManager.loadKDString((String)"\u4e91\u5185\u5bb9\u201c%s\u201d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u53d6\u6d88\u6536\u85cf\uff1f", (String)"MyContentPlugin_5", (String)"imsc-cc", (Object[])new Object[0]), contentName);
                this.getView().showConfirm(confirmTip, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks, btnNameMaps, SerializationUtils.toJsonString(params));
                args.setCancel(true);
                break;
            }
            case "previewfile": {
                Integer index = this.getRowIndexFromCache();
                if (index < 0) {
                    return;
                }
                this.preView(index);
                break;
            }
            case "install": {
                try {
                    if (StringUtils.isEmpty((String)number)) {
                        throw new KdXkIprmException(ResManager.loadKDString((String)"\u5185\u5bb9\u5305\u7f16\u7801\u4e3a\u7a7a\uff0c\u7a0d\u540e\u518d\u8bd5\u3002", (String)"MyContentPlugin_8", (String)"imsc-cc", (Object[])new Object[0]), 1001);
                    }
                    if (!"collecttab".equals(type)) break;
                    ContentDetailModel dataMap = this.getInfoData(number);
                    if (null == dataMap) {
                        throw new KdXkIprmException(ResManager.loadKDString((String)"\u5185\u5bb9\u5305\u8be6\u60c5\u67e5\u8be2\u4e3a\u7a7a\uff0c\u8bf7\u63d0\u4ea4\u8bc4\u4ef7\u53cd\u9988\u6216\u7a0d\u540e\u518d\u8bd5\u3002", (String)"MyContentPlugin_9", (String)"imsc-cc", (Object[])new Object[0]), 1001);
                    }
                    if (!dataMap.isMappingVersion()) {
                        args.setCancel(true);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ea7\u54c1\u7248\u672c\u4e0d\u5339\u914d\uff0c\u8bf7\u7b49\u5f85\u5347\u7ea7\u6216\u8054\u7cfb\u8fd0\u8425\u4eba\u5458\u3002", (String)"MyContentPlugin_10", (String)"imsc-cc", (Object[])new Object[0]));
                    }
                    if (dataMap.isMappingLang()) break;
                    args.setCancel(true);
                    String tip = ContentHelper.languageAuthenTips(dataMap);
                    if (StringUtils.isEmpty((String)tip)) break;
                    this.getView().showErrorNotification(tip);
                }
                catch (KdXkIprmException e) {
                    args.setCancel(true);
                    logger.error("\u52a0\u8f7d\u64cd\u4f5c|\u6821\u9a8c\u5f02\u5e38|", (Throwable)e);
                    this.getView().showErrorNotification(e.getMessage());
                }
                break;
            }
            case "score": {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("cc_resource_score");
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "callback_resource_score"));
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                ContentDetailModel detailModel = this.getResourceInfo();
                if (detailModel == null) break;
                HashMap<String, String> prams = new HashMap<String, String>(12);
                prams.put("form_key_billno", detailModel.getPkgNumber());
                formShowParameter.setCustomParams(prams);
                this.getView().showForm(formShowParameter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map data;
        boolean submitSuccess;
        Object returnData;
        String actionId = closedCallBackEvent.getActionId();
        if ("callback_resource_score".equals(actionId) && (returnData = closedCallBackEvent.getReturnData()) instanceof Map && (submitSuccess = Boolean.parseBoolean((data = (Map)returnData).get("submitSuccess").toString()))) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"MyContentPlugin_11", (String)"imsc-cc", (Object[])new Object[0]));
        }
    }

    private Integer getRowIndexFromCache() {
        String indexStr = this.getPageCache().get(INDEX_ROW_CACHE);
        Integer index = -1;
        if (StringUtils.isNotNull((String)indexStr) && !StringUtils.isBlank((String)indexStr)) {
            index = (Integer)SerializationUtils.fromJsonString((String)indexStr, Integer.class);
        }
        if (index < 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u884c\u3002", (String)"MyContentPlugin_13", (String)"imsc-cc", (Object[])new Object[0]));
            return -1;
        }
        return index;
    }

    private void preView(Integer index) {
        String sourceName = this.getModel().getValue("sourcename", index.intValue()).toString();
        if (StringUtils.isEmpty((String)sourceName) || !sourceName.endsWith(".xlsx")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u9884\u89c8xlsx\u683c\u5f0f\u7684Excel\u6587\u4ef6\u3002", (String)"MyContentPlugin_14", (String)"imsc-cc", (Object[])new Object[0]));
            return;
        }
        Boolean isDataEncrypt = (Boolean)this.getModel().getValue("dataencrypt", index.intValue());
        if (isDataEncrypt.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5185\u5bb9\u5305\u6570\u636e\u52a0\u5bc6\uff0c\u65e0\u6cd5\u9884\u89c8\u3002", (String)"MyContentPlugin_15", (String)"imsc-cc", (Object[])new Object[0]));
            return;
        }
        DataPackageInputModel model = this.getDataPackageInputModel();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("cc_excelpreview");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("tabSelectType", (Object)this.getView().getPageCache().get("tabSelectType"));
        formShowParameter.setCustomParam("c_c_i", (Object)JSONObject.toJSONString((Object)model));
        formShowParameter.setCustomParam("p_f_n", (Object)sourceName);
        this.getView().showForm(formShowParameter);
    }

    DataPackageInputModel getDataPackageInputModel() {
        String tabSelectType = this.getView().getPageCache().get("tabSelectType");
        HashMap<String, String> billNameMap = new HashMap<String, String>(2);
        String id = "";
        String name = "";
        String version = "";
        String resourceFile = "";
        try {
            if ("collecttab".equals(tabSelectType)) {
                Map mapData;
                List contentList;
                ContentDetailModel dataMap = this.getInfoData(this.getModel().getValue("billno").toString());
                if (dataMap == null) {
                    return null;
                }
                id = String.valueOf(dataMap.getPkgNumber());
                name = String.valueOf(dataMap.getPkgName());
                version = String.valueOf(dataMap.getVersion());
                String packStr = dataMap.getpInfoContent();
                if (!StringUtils.isEmpty((String)packStr) && (contentList = (List)(mapData = (Map)SerializationUtils.fromJsonString((String)packStr, Map.class)).get("files")) != null) {
                    for (Map content : contentList) {
                        billNameMap.put((String)content.get("fileName"), (String)content.get("businessObjectType"));
                    }
                }
            } else {
                id = (String)this.getModel().getValue("billno");
                name = this.getView().getPageCache().get("contentName");
                version = this.getView().getPageCache().get("contentVersion");
                DynamicObjectCollection resourceEntry = this.getModel().getEntryEntity("resource_entry");
                for (DynamicObject entryData : resourceEntry) {
                    billNameMap.put(entryData.getString("sourcename"), entryData.getString("businessobjecttype"));
                }
                resourceFile = this.getView().getPageCache().get("resourceFile");
            }
        }
        catch (KdXkIprmException e) {
            logger.error((Throwable)e);
        }
        return new DataPackageInputModel.Builder().id(id).name(name).type(tabSelectType).resourceFileUrl(resourceFile).ver(version).objInfoMap(billNameMap).builder();
    }

    public void entryRowClick(RowClickEvent evt) {
        this.getPageCache().put(INDEX_ROW_CACHE, SerializationUtils.toJsonString((Object)evt.getRow()));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key = args.getOperateKey();
        String type = this.getView().getPageCache().get("tabSelectType");
        if ("install".equals(key) && args.getOperationResult().isSuccess()) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("cc_loadpackage");
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            HashMap<String, Object> prams = new HashMap<String, Object>(4);
            if ("collecttab".equals(type)) {
                ContentDetailModel detailModel = this.getResourceInfo();
                if (detailModel == null) {
                    return;
                }
                String packStr = detailModel.getpInfoContent();
                List contentList = null;
                if (!StringUtils.isEmpty((String)packStr)) {
                    Map mapData = (Map)SerializationUtils.fromJsonString((String)packStr, Map.class);
                    contentList = (List)mapData.get("files");
                }
                prams.putAll(ResourceListProxy.getLoadParam(detailModel.getPkgName(), detailModel.getVersion(), detailModel.getPkgNumber(), contentList));
            } else {
                String billNo = (String)this.getModel().getValue("billno");
                DynamicObject oneContent = BusinessDataServiceHelper.loadSingleFromCache((String)"cc_mycontent", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
                ArrayList<Map<String, String>> contentList = new ArrayList<Map<String, String>>();
                DynamicObjectCollection resourceEntry = oneContent.getDynamicObjectCollection("resource_entry");
                for (DynamicObject item : resourceEntry) {
                    HashMap<String, String> map = new HashMap<String, String>(2);
                    map.put("fileName", item.getString("sourcename"));
                    map.put("businessObjectType", item.getString("businessobjecttype"));
                    map.put("dataencrypt", item.getString("dataencrypt"));
                    contentList.add(map);
                }
                prams.putAll(ResourceListProxy.getLoadParam(oneContent.getString("name"), oneContent.getString("version"), billNo, contentList));
                prams.put("resourcefile", this.getView().getPageCache().get("resourceFile"));
            }
            prams.put("tabSelectType", type);
            formShowParameter.setCustomParams(prams);
            this.getView().showForm(formShowParameter);
        } else if (key.equals("uncollect") || key.equals("collect")) {
            this.getView().updateView();
        }
    }

    private ContentDetailModel getResourceInfo() {
        String content = this.getPageCache().get(CONTENT_INFO_CACHE);
        if (StringUtils.isEmpty((String)content)) {
            return null;
        }
        return (ContentDetailModel)SerializationUtils.fromJsonString((String)content, ContentDetailModel.class);
    }

    private ContentDetailModel getInfoData(String number) throws KdXkIprmException {
        if (StringUtils.isEmpty((String)number)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9644\u4ef6\u8def\u5f84\u83b7\u53d6\u5931\u8d25\u3002\u201c\u5185\u5bb9\u5305\u7f16\u7801\u201d\u4e3a\u7a7a\u3002", (String)"MyContentPlugin_19", (String)"imsc-cc", (Object[])new Object[0]));
            return null;
        }
        HashMap<String, Object> header = new HashMap<String, Object>(2);
        header.put("pkgNum", number);
        BizOperationResult bizOperationResult = GcpManager.getDetail(header);
        if (bizOperationResult == null || !bizOperationResult.getSuccess()) {
            throw new KdXkIprmException(ResManager.loadKDString((String)"\u5185\u5bb9\u5305\u5df2\u4e0b\u67b6\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u3002", (String)"MyContentPlugin_0", (String)"imsc-cc", (Object[])new Object[0]), bizOperationResult == null ? 1001 : bizOperationResult.getErrorCode());
        }
        ContentDetailModel contentDetailModel = (ContentDetailModel)JSON.parseObject((String)JSON.toJSONString(bizOperationResult.getData()), ContentDetailModel.class);
        contentDetailModel.setpInfoContent(NewResourceHelper.coverPInfoContent(contentDetailModel.getpInfoContent()));
        return contentDetailModel;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
    }
}

